/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.common;

import com.sos.commons.hibernate.SOSHibernateSession;
import com.sos.js7.job.Job;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.OrderProcessStep;
import java.sql.Connection;
import js7.launcher.forjava.internal.BlockingInternalJob;

public abstract class CancelableDatabaseJob<A extends JobArguments>
extends Job<A> {
    private static final String CANCELABLE_RESOURCE_NAME_HIBERNATE = "hibernate";
    private static final String CANCELABLE_RESOURCE_NAME_SQL_CONNECTION = "sql_connection";

    public CancelableDatabaseJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void addCancelableResource(OrderProcessStep<A> step, SOSHibernateSession session) {
        step.addCancelableResource(CANCELABLE_RESOURCE_NAME_HIBERNATE, (Object)session);
    }

    public void onOrderProcessCancel(OrderProcessStep<A> step) throws Exception {
        this.cancelHibernate(step, step.getJobName());
    }

    private void cancelHibernate(OrderProcessStep<A> step, String jobName) {
        try {
            Object o = step.getCancelableResources().get(CANCELABLE_RESOURCE_NAME_HIBERNATE);
            if (o == null) {
                return;
            }
            SOSHibernateSession s = (SOSHibernateSession)o;
            boolean doRollback = false;
            if (s.getCurrentStatement() != null) {
                step.getLogger().info((Object)"[cancel/kill][hibernate]cancel statement ...");
                try {
                    s.getCurrentStatement().cancel();
                }
                catch (Throwable ex) {
                    step.getLogger().warn("[cancel/kill][hibernate][cancel statement]" + ex.toString(), ex);
                }
                doRollback = true;
            }
            Connection conn = s.getConnection();
            if (doRollback) {
                try {
                    step.getLogger().info((Object)"[cancel/kill][hibernate]connection rollback ...");
                    conn.rollback();
                }
                catch (Throwable ex) {
                    step.getLogger().warn("[cancel/kill][hibernate][connection rollback]" + ex.toString(), ex);
                }
            } else {
                step.getLogger().info((Object)"[cancel/kill][hibernate][connection rollback][skip]because the current statement is no more active");
            }
            try {
                conn.abort(Runnable::run);
            }
            catch (Throwable ex) {
                step.getLogger().warn("[cancel/kill][hibernate][connection abort]" + ex.toString(), ex);
            }
            step.getLogger().info((Object)"[cancel/kill][hibernate]close...");
            s.getFactory().close(s);
            step.getLogger().info((Object)"[cancel/kill][hibernate]completed");
        }
        catch (Throwable e) {
            step.getLogger().error(String.format("[%s][job name=%s][cancelHibernate]%s", "cancel/kill", jobName, e.toString()), e);
        }
    }

    private void cancelSQLConnection(OrderProcessStep<A> step, String jobName) {
        try {
            Object o = step.getCancelableResources().get(CANCELABLE_RESOURCE_NAME_SQL_CONNECTION);
            if (o != null) {
                step.getLogger().info((Object)"[cancel/kill]abort sql connection ...");
                ((Connection)o).abort(Runnable::run);
            }
        }
        catch (Throwable e) {
            step.getLogger().error(String.format("[%s][job name=%s][cancelSQLConnection]%s", "cancel/kill", jobName, e.toString()), e);
        }
    }
}

