/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.oracle;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.hibernate.SOSHibernate;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.JobHelper;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class PLSQLJobArguments
extends JobArguments {
    private JobArgument<Path> hibernateFile = new JobArgument("hibernate_configuration_file", false, (Object)JobHelper.getAgentHibernateFile());
    private JobArgument<String> command = new JobArgument("command", false);
    private JobArgument<String> commandScriptFile = new JobArgument("command_script_file", false);
    private JobArgument<String> variableParserRegExpr = new JobArgument("variable_parser_reg_expr", false, (Object)"^SET\\s+([^\\s]+)\\s*IS\\s+(.*)$");
    private JobArgument<String> dbPassword = new JobArgument("db_password", false, SOSArgument.DisplayMode.MASKED);
    private JobArgument<String> dbUrl = new JobArgument("db_url", false);
    private JobArgument<String> dbUser = new JobArgument("db_user", false);
    private JobArgument<String> dbDialect = new JobArgument("db_dialect", false, (Object)SOSHibernate.DEFAULT_DIALECT_ORACLE);
    private JobArgument<String> dbDriverClass = new JobArgument("db_jdbc_driverclass", false, (Object)"oracle.jdbc.driver.OracleDriver");
    private JobArgument<ResultSetAs> resultSetAs = new JobArgument("resultset_as", false);
    private JobArgument<Path> resultFile = new JobArgument("result_file", false);

    public PLSQLJobArguments() {
        super(new ASOSArguments[]{new CredentialStoreArguments()});
    }

    public Path getHibernateFile() {
        return (Path)this.hibernateFile.getValue();
    }

    public void setHibernateFile(Path hibernateFile) {
        this.hibernateFile.setValue((Object)hibernateFile);
    }

    public String getCommand() {
        return (String)this.command.getValue();
    }

    public void setCommand(String command) {
        this.command.setValue((Object)command);
    }

    public String getVariableParserRegExpr() {
        return (String)this.variableParserRegExpr.getValue();
    }

    public void setVariableParserRegExpr(String variableParserRegExpr) {
        this.variableParserRegExpr.setValue((Object)variableParserRegExpr);
    }

    public JobArgument<String> getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword.setValue((Object)dbPassword);
    }

    public JobArgument<String> getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl.setValue((Object)dbUrl);
    }

    public JobArgument<String> getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser.setValue((Object)dbUser);
    }

    public boolean useHibernateFile() {
        return SOSString.isEmpty((String)((String)this.dbUrl.getValue())) && SOSString.isEmpty((String)((String)this.dbUser.getValue()));
    }

    public String getCommandScriptFile() {
        return (String)this.commandScriptFile.getValue();
    }

    public String getCommandScriptFileContent() throws IOException {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = null;){
            stream = Files.lines(Paths.get((String)this.commandScriptFile.getValue(), new String[0]), StandardCharsets.UTF_8);
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        return contentBuilder.toString();
    }

    public void setCommandScripFile(String commandScriptFile) {
        this.commandScriptFile.setValue((Object)commandScriptFile);
    }

    public ResultSetAs getResultSetAs() {
        return (ResultSetAs)((Object)this.resultSetAs.getValue());
    }

    protected void setResultSetAs(ResultSetAs val) {
        this.resultSetAs.setValue((Object)val);
    }

    public Path getResultFile() {
        return (Path)this.resultFile.getValue();
    }

    protected void setResultFile(Path val) {
        this.resultFile.setValue((Object)val);
    }

    public void checkRequired() throws JobRequiredArgumentMissingException {
        if ((this.command.getValue() == null || ((String)this.command.getValue()).isEmpty()) && (this.commandScriptFile.getValue() == null || ((String)this.commandScriptFile.getValue()).isEmpty())) {
            throw new JobRequiredArgumentMissingException(this.command.getName() + " or " + this.commandScriptFile.getName());
        }
        if (!this.useHibernateFile()) {
            if (this.dbUrl.getValue() == null || ((String)this.dbUrl.getValue()).isEmpty()) {
                throw new JobRequiredArgumentMissingException(this.dbUrl.getName());
            }
            if ((this.dbUser.getValue() == null || ((String)this.dbUser.getValue()).isEmpty()) && this.dbPassword.getValue() != null) {
                throw new JobRequiredArgumentMissingException(this.dbUrl.getName());
            }
        } else if (((Path)this.hibernateFile.getValue()).toString().isEmpty()) {
            throw new JobRequiredArgumentMissingException(this.hibernateFile.getName() + " or " + this.dbUrl.getName() + " + username and password");
        }
        if (this.getResultSetAs() != null && this.getResultFile() == null) {
            throw new JobRequiredArgumentMissingException(this.resultFile.getName());
        }
    }

    public JobArgument<String> getDbDialect() {
        return this.dbDialect;
    }

    public void setDbDialect(JobArgument<String> dbDialect) {
        this.dbDialect = dbDialect;
    }

    public JobArgument<String> getDbDriverClass() {
        return this.dbDriverClass;
    }

    public void setDbDriverClass(JobArgument<String> dbDriverClass) {
        this.dbDriverClass = dbDriverClass;
    }

    public static enum ResultSetAs {
        CSV,
        XML,
        JSON;

    }
}

