/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.oracle;

import com.sos.commons.util.SOSPath;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.db.oracle.SQLPlusJobArguments;
import com.sos.js7.job.OrderProcessStepOutcome;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLPLUSCommandHandler {
    private static final String EXIT_CODE = "exitCode";
    private static final String SQL_ERROR = "sql_error";
    private Map<String, Object> variables = new HashMap<String, Object>();
    private final ISOSLogger logger;

    public SQLPLUSCommandHandler(Map<String, Object> variables, ISOSLogger logger) {
        this.variables.putAll(variables);
        this.logger = logger;
    }

    private void writeln(Path file, String line) throws IOException {
        line = (String)line + "\n";
        Files.write(file, ((String)line).getBytes(), StandardOpenOption.APPEND);
    }

    public void createSqlFile(SQLPlusJobArguments args, String tempFileName) throws IOException {
        Path sqlScript = Paths.get(tempFileName, new String[0]);
        if (!args.getIncludeFiles().isEmpty()) {
            String[] includeFileNames;
            for (String includeFileName : includeFileNames = args.getIncludeFiles().split(";")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Append file '%s' to script", new Object[]{includeFileName});
                }
                Path dest = Paths.get(includeFileName, new String[0]);
                SOSPath.appendFile((Path)sqlScript, (Path)dest);
            }
        }
        if (args.getCommand() != null && !args.getCommand().isEmpty()) {
            this.writeln(sqlScript, args.getCommand());
        }
        if (!args.getCommandScriptFile().isEmpty()) {
            String scriptFile = args.getCommandScriptFile();
            Path dest = Paths.get(scriptFile, new String[0]);
            SOSPath.appendFile((Path)dest, (Path)sqlScript);
        }
        String exit = "exit;";
        this.writeln(sqlScript, exit);
    }

    public String[] getVariables(SQLPlusJobArguments args, SOSCommandResult sosCommandResult, OrderProcessStepOutcome outcome, String[] stdOutStringArray) {
        int intRegExpFlags = 42;
        boolean aVariableFound = false;
        String regExp = args.getVariableParserRegExpr();
        if (!regExp.isEmpty()) {
            Pattern regExprPattern = Pattern.compile(regExp, intRegExpFlags);
            for (String string : stdOutStringArray) {
                Matcher matcher = regExprPattern.matcher(string);
                if (!matcher.matches() || matcher.group().length() <= 1) continue;
                outcome.putVariable(matcher.group(1), (Object)matcher.group(2).trim());
                aVariableFound = true;
            }
        }
        if (!aVariableFound && this.logger.isDebugEnabled()) {
            this.logger.debug("no JS-variable definitions found using reg-exp '%s'.", new Object[]{regExp});
        }
        return stdOutStringArray;
    }

    public void handleMessages(SQLPlusJobArguments args, SOSCommandResult sosCommandResult, OrderProcessStepOutcome outcome, String[] stdOutStringArray) throws Exception {
        int intRegExpFlags = 42;
        Object strCC = String.valueOf(sosCommandResult.getExitCode());
        String f = "00000";
        strCC = f.substring(0, ((String)strCC).length() - 1) + (String)strCC;
        Object sqlError = "";
        boolean ignoreSP2MsgNo = false;
        if (args.getIgnoreSp2Messages().contains("*all")) {
            ignoreSP2MsgNo = true;
        }
        boolean ignoreOraMsgNo = false;
        if (args.getIgnoreOraMessages().contains("*all")) {
            ignoreOraMsgNo = true;
        }
        Pattern errorPattern = Pattern.compile("^\\s*SP2-(\\d\\d\\d\\d):\\s*(.*)$", intRegExpFlags);
        Pattern oraPattern = Pattern.compile("^ORA-(\\d\\d\\d\\d\\d):\\s*(.*)$", intRegExpFlags);
        for (String stdoutLine : stdOutStringArray) {
            stdoutLine = stdoutLine.trim();
            Matcher matcher = errorPattern.matcher(stdoutLine);
            Matcher matcher2 = oraPattern.matcher(stdoutLine);
            if (matcher.matches() || matcher2.matches()) {
                String msgNo;
                boolean isError = false;
                if (matcher.matches() && !ignoreSP2MsgNo) {
                    msgNo = matcher.group(1).toString();
                    if (!args.getIgnoreSp2Messages().contains(msgNo)) {
                        isError = true;
                    }
                }
                if (matcher2.matches() && !ignoreOraMsgNo) {
                    msgNo = matcher2.group(1).toString();
                    if (!args.getIgnoreOraMessages().contains(msgNo)) {
                        isError = true;
                    }
                }
                if (isError) {
                    sqlError = (String)sqlError + stdoutLine;
                    this.logger.info("error found: %s", new Object[]{stdoutLine});
                    continue;
                }
                this.logger.info("Error '%s' ignored due to settings", new Object[]{stdoutLine});
                continue;
            }
            this.logger.info((Object)stdoutLine);
        }
        String stdErr = sosCommandResult.getStdErr();
        outcome.putVariable(SQL_ERROR, (Object)((String)sqlError).trim());
        if (sosCommandResult.getExitCode() == 0) {
            if (!stdErr.trim().isEmpty()) {
                sosCommandResult.setExitCode(Integer.valueOf(99));
            }
            if (!((String)sqlError).isEmpty()) {
                sosCommandResult.setExitCode(Integer.valueOf(98));
            }
        }
        outcome.putVariable(EXIT_CODE, (Object)sosCommandResult.getExitCode());
        if (sosCommandResult.getExitCode() != 0 && !args.getIgnoreOraMessages().contains((CharSequence)strCC)) {
            throw new Exception(String.format("Exit-Code set to '%1$s': %2$s", sosCommandResult.getExitCode(), ((String)sqlError).trim()));
        }
    }
}

