/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.db.oracle;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.beans.SOSTimeout;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.db.oracle.SQLPLUSCommandHandler;
import com.sos.jitl.jobs.db.oracle.SQLPlusJobArguments;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepOutcome;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import js7.launcher.forjava.internal.BlockingInternalJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLPLUSJob
extends Job<SQLPlusJobArguments> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLPLUSJob.class);

    public SQLPLUSJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<SQLPlusJobArguments> step) throws Exception {
        if (SOSString.isEmpty((String)((SQLPlusJobArguments)step.getDeclaredArguments()).getCommandScriptFile()) & SOSString.isEmpty((String)((SQLPlusJobArguments)step.getDeclaredArguments()).getCommand())) {
            throw new JobRequiredArgumentMissingException("command is empty. please check the   \"command_script_file\" or \"command\"parameter.");
        }
        this.process(step, (SQLPlusJobArguments)step.getDeclaredArguments(), (CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class));
    }

    private void process(OrderProcessStep<SQLPlusJobArguments> step, SQLPlusJobArguments args, CredentialStoreArguments csArgs) throws Exception {
        args.checkRequired();
        if (csArgs.getFile().getValue() != null) {
            CredentialStoreArguments.CredentialStoreResolver r = csArgs.newResolver();
            args.setDbUrl(r.resolve(args.getDbUrl()));
            args.setDbUser(r.resolve(args.getDbUser()));
            args.setDbPassword(r.resolve((String)args.getDbPassword().getValue()));
        }
        step.getLogger().debug((Object)("dbUrl: " + args.getDbUrl()));
        step.getLogger().debug((Object)("dbUser: " + args.getDbUser()));
        step.getLogger().debug((Object)("dbPassword: " + args.getDbPassword().getDisplayValue()));
        Map variables = step.getUndeclaredArgumentsAsNameValueMap();
        SQLPLUSCommandHandler sqlPlusCommandHandler = new SQLPLUSCommandHandler(variables, (ISOSLogger)step.getLogger());
        File tempFile = File.createTempFile("sos", ".sql");
        String tempFileName = tempFile.getAbsolutePath();
        sqlPlusCommandHandler.createSqlFile(args, tempFileName);
        SOSCommandResult sosCommandResult = null;
        if (args.getTimeout() == 0) {
            sosCommandResult = SOSShell.executeCommand((String)args.getCommandLine(tempFileName), (Charset)this.getJobEnvironment().getSystemEncoding());
        } else {
            SOSTimeout sosTimeout = new SOSTimeout((long)args.getTimeout().intValue(), TimeUnit.SECONDS);
            sosCommandResult = SOSShell.executeCommand((String)args.getCommandLine(tempFileName), (Charset)this.getJobEnvironment().getSystemEncoding(), (SOSTimeout)sosTimeout);
        }
        String conNL = System.getProperty("line.separator");
        String stdOut = sosCommandResult.getStdOut();
        step.getLogger().debug((Object)String.format("[command encoding]%s", sosCommandResult.getEncoding()));
        step.getLogger().info((Object)String.format("[stdout]%s", stdOut));
        String[] stdOutStringArray = stdOut.split(conNL);
        OrderProcessStepOutcome outcome = step.getOutcome();
        sqlPlusCommandHandler.getVariables(args, sosCommandResult, outcome, stdOutStringArray);
        sqlPlusCommandHandler.handleMessages(args, sosCommandResult, outcome, stdOutStringArray);
        try {
            Files.delete(Paths.get(tempFileName, new String[0]));
        }
        catch (IOException ioException) {
            LOGGER.warn("File " + tempFileName + " could not deleted");
        }
    }
}

