/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.examples;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.examples.InfoJobArguments;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.Job;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepOutcome;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import js7.launcher.forjava.internal.BlockingInternalJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoJob
extends Job<InfoJobArguments> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoJob.class);

    public InfoJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
        LOGGER.info("[CONSTRUCTOR]arguments=" + this.getJobEnvironment().getAllArgumentsAsNameValueMap());
    }

    public void onStart() throws Exception {
        LOGGER.info("start");
    }

    public void onStop() {
        LOGGER.info("stop");
    }

    public void processOrder(OrderProcessStep<InfoJobArguments> step) throws Exception {
        InfoJobArguments args = (InfoJobArguments)step.getDeclaredArguments();
        step.getLogger().info((Object)"----------USAGE-----------------");
        step.getLogger().info((Object)"declare and set order/step variables:");
        step.getLogger().info("     \"%s\"=INFO|DEBUG|TRACE (case insensitive)", new Object[]{args.getLogLevel().getName()});
        step.getLogger().info("     \"%s\"=... to show in the ORDER HISTORIC OUTCOME", new Object[]{args.getReturnVariables().getName()});
        step.getLogger().info("                e.g.: \"%s\"= 'myvar1_xyz__myvar2_123'", new Object[]{args.getReturnVariables().getName()});
        step.getLogger().info((Object)"                  means set 2 return variables: 1) myvar1=xyz 2)myvar2=123");
        step.getLogger().info("     \"%s\"='some value'", new Object[]{args.getStringArgument().getName()});
        step.getLogger().info("     \"%s\"='some password'", new Object[]{args.getPassword().getName()});
        step.getLogger().info("     \"%s\"='...' any shell command, e.g. dir, ls ...", new Object[]{args.getShellCommand().getName()});
        step.getLogger().info((Object)"----------Encoding-----------------");
        step.getLogger().info((Object)("[agent/getJobEnvironment][systemEncoding/Charset]" + this.getJobEnvironment().getSystemEncoding()));
        step.getLogger().info((Object)("[SOSShell][consoleEncoding/Charset]" + SOSShell.getConsoleEncoding()));
        if (SOSShell.IS_WINDOWS) {
            step.getLogger().info((Object)("[Windows][console encoding]" + SOSShell.executeCommand((String)"chcp")));
            step.getLogger().info((Object)("[Windows][console encoding]" + SOSShell.executeCommand((String)"reg.exe QUERY HKLM\\SYSTEM\\CurrentControlSet\\Control\\Nls\\CodePage /v OEMCP")));
        }
        this.printEnvs((ISOSLogger)step.getLogger());
        if (step.getLogger().isDebugEnabled()) {
            step.getLogger().debug((Object)"-----------------------------------");
            step.getLogger().debug((Object)"job DEBUG message");
        }
        if (step.getLogger().isTraceEnabled()) {
            step.getLogger().trace((Object)"-----------------------------------");
            step.getLogger().trace((Object)"job TRACE message");
        }
        step.getLogger().info((Object)"----------JOB Instance-----------------");
        step.getLogger().info((Object)("[scala][jobEnvironment.getAllArgumentsAsNameValueMap()]" + this.getJobEnvironment().getAllArgumentsAsNameValueMap()));
        step.getLogger().info((Object)"----------Workflow-----------------");
        step.getLogger().info((Object)("[java][name]" + step.getWorkflowName()));
        step.getLogger().info((Object)("[java][versionId]" + step.getWorkflowVersionId()));
        step.getLogger().info((Object)("[java][position]" + step.getWorkflowPosition()));
        step.getLogger().info((Object)"----------ORDER-----------------");
        step.getLogger().info((Object)("[java][id]" + step.getOrderId()));
        step.getLogger().info((Object)("[java][step.getOrderArgumentsAsNameValueMap]" + step.getOrderArgumentsAsNameValueMap()));
        step.getLogger().info((Object)"-CONVERTED JOB RESOURCES------------------");
        Map resources = step.getJobResourcesArgumentsAsNameDetailValueMap();
        resources.entrySet().stream().forEach(e -> {
            DetailValue v = (DetailValue)e.getValue();
            step.getLogger().info(" %s=%s (job resource=%s)", new Object[]{e.getKey(), v.getValue(), v.getSource()});
        });
        step.getLogger().info((Object)"-CONVERTED HISTORIC OUTCOME (last var values)-----------------");
        step.getLogger().info((Object)("[java][all]" + step.getLastOutcomes()));
        step.getLogger().info((Object)("[java][succeeded]" + step.getLastSucceededOutcomes()));
        step.getLogger().info((Object)("[java][failed]" + step.getLastFailedOutcomes()));
        step.getLogger().info((Object)"----------NODE/STEP-----------------");
        step.getLogger().info((Object)("[java][agentId]" + step.getAgentId()));
        step.getLogger().info((Object)("[java][name]" + step.getJobName()));
        step.getLogger().info((Object)"----------ALL CURRENT declared/not declared argumens-----------------");
        Map allcmap = step.getAllArguments();
        allcmap.entrySet().stream().forEach(e -> step.getLogger().info("[java][%s][%s=%s]%s", new Object[]{((JobArgument)e.getValue()).getType(), e.getKey(), ((JobArgument)e.getValue()).getDisplayValue(), SOSString.toString(e.getValue(), (boolean)true)}));
        step.getLogger().info((Object)"----------step.getJobResourcesEnv-----------------");
        try {
            Map m = step.getJobResourcesEnv();
            step.getLogger().info((Object)("[step.getJobResourcesEnv]" + m));
        }
        catch (Throwable e2) {
            step.getLogger().warn(String.format("[step.getJobResourcesEnv]%s", e2.toString()), e2);
        }
        if (!args.getShellCommand().isEmpty()) {
            step.getLogger().info((Object)"----------EXECUTE SHELL COMMAND-----------------");
            step.getLogger().info((Object)("  " + args.getShellCommand().getDisplayValue()));
            step.getLogger().info((Object)("  " + SOSString.toString((Object)SOSShell.executeCommand((String)((String)args.getShellCommand().getValue())))));
        }
        CredentialStoreArguments csArgs = (CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class);
        step.getLogger().info((Object)"----------CREDENTIAL STORE-----------------");
        step.getLogger().info((Object)("  file=" + csArgs.getFile()));
        CredentialStoreArguments.CredentialStoreResolver r = csArgs.newResolver();
        step.getLogger().info((Object)("  resolve cs://@title=" + r.resolve("cs://@title")));
        step.getLogger().info((Object)"----------COLLECTION ARGUMENTS -----------------");
        this.showCollectionArgument(step, args.getListBigDecimalValues());
        this.showCollectionArgument(step, args.getListBooleanValues());
        this.showCollectionArgument(step, args.getListCharsetValues());
        this.showCollectionArgument(step, args.getListEnumValues());
        this.showCollectionArgument(step, args.getListFileValues());
        this.showCollectionArgument(step, args.getListIntegerValues());
        this.showCollectionArgument(step, args.getListLongValues());
        this.showCollectionArgument(step, args.getListPathValues());
        this.showCollectionArgument(step, args.getListStringValues());
        this.showCollectionArgument(step, args.getListUriValues());
        this.showCollectionArgument(step, args.getSetIntegerValues());
        this.showCollectionArgument(step, args.getSetStringValues());
        step.getLogger().info((Object)"----------MAP ARGUMENTS -----------------");
        this.showMapArgument(step, args.getMapStringValues());
        this.showMapArgument(step, args.getMapIntegerValues());
        this.showMapArgument(step, args.getMapPathValues());
        this.showMapArgument(step, args.getMapObjectValues());
        this.showMapArgument(step, args.getMapWildcardValues());
        if (args.getPathArgument().getValue() != null) {
            step.getLogger().info((Object)"----------PATH ARGUMENT -----------------");
            this.showSingleArgument(step, args.getPathArgument());
        }
        step.getLogger().info((Object)"----------RETURN-----------------");
        if (!args.getReturnVariables().isEmpty()) {
            step.getLogger().info("[SUCCESS]set step outcome: %s", new Object[]{step.getOutcome().getVariables()});
        } else {
            OrderProcessStepOutcome outcome = step.getOutcome();
            outcome.putVariable("test", (Object)"my_test");
            outcome.putVariable("test_null_value", null);
            outcome.putVariable("test_boolean_value", (Object)true);
            outcome.putVariable("test_Boolean_value", (Object)Boolean.FALSE);
            outcome.putVariable("test_int_value", (Object)1);
            outcome.putVariable("test_Integer_value", (Object)1);
            outcome.putVariable("test_long_value", (Object)Integer.valueOf(1).longValue());
            outcome.putVariable("test_Long_value", (Object)1L);
            outcome.putVariable("test_Double_value", (Object)1.0);
            outcome.putVariable("test_BigDecimal_value", (Object)new BigDecimal(1));
            outcome.putVariable("test_Date_value", (Object)new Date());
            outcome.putVariable("test_Instant_value", (Object)Instant.now());
            outcome.putVariable("test_LocalDate_value", (Object)LocalDate.now());
            step.getLogger().info("[SUCCESS][java][step outcome]%s", new Object[]{outcome});
        }
    }

    private void showSingleArgument(OrderProcessStep<InfoJobArguments> step, JobArgument<?> a) {
        step.getLogger().info((Object)(a.getName() + "=" + a.getValue()));
        if (a.getValue() != null) {
            step.getLogger().info((Object)("  " + a.getValue().getClass()));
        }
    }

    private void showCollectionArgument(OrderProcessStep<InfoJobArguments> step, JobArgument<? extends Collection<?>> a) {
        step.getLogger().info((Object)(a.getName() + "=" + a.getValue()));
        if (a.getValue() != null) {
            step.getLogger().info((Object)("  " + ((Collection)a.getValue()).getClass()));
            for (Object o : (Collection)a.getValue()) {
                step.getLogger().info((Object)("    " + o + "(" + o.getClass() + ")"));
            }
        }
    }

    private void showMapArgument(OrderProcessStep<InfoJobArguments> step, JobArgument<? extends Map<String, ?>> a) {
        step.getLogger().info((Object)(a.getName() + "=" + a.getValue()));
        if (a.getValue() != null) {
            step.getLogger().info((Object)("  " + ((Map)a.getValue()).getClass()));
            ((Map)a.getValue()).entrySet().forEach(e -> step.getLogger().info((Object)("    " + (String)e.getKey() + "=" + e.getValue() + "(" + e.getValue().getClass() + ")")));
        }
    }

    private void printEnvs(ISOSLogger logger) {
        logger.info((Object)("----------Environment variables (" + SOSShell.OS_NAME + ")-----------------"));
        logger.info((Object)"    JS7");
        System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("JS7")).sorted(Map.Entry.comparingByKey()).forEach(e -> logger.info((Object)("        " + (String)e.getKey() + "=" + (String)e.getValue())));
        logger.info((Object)"    System");
        System.getenv().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("JS7")).sorted(Map.Entry.comparingByKey()).forEach(e -> logger.info((Object)("        " + (String)e.getKey() + "=" + (String)e.getValue())));
    }
}

