/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.examples;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.beans.SOSCommandResult;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import com.sos.commons.vfs.ssh.SSHProvider;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.jitl.jobs.ssh.SSHJobArguments;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import java.util.List;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class SSHJob
extends Job<SSHJobArguments> {
    private static final String CANCELABLE_RESOURCE_NAME_SSH_PROVIDER = "ssh_provider";

    public SSHJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<SSHJobArguments> step) throws Exception {
        SSHProviderArguments providerArgs = (SSHProviderArguments)step.getIncludedArguments(SSHProviderArguments.class);
        if (providerArgs != null) {
            providerArgs.setCredentialStore((CredentialStoreArguments)step.getIncludedArguments(CredentialStoreArguments.class));
            providerArgs.setProxy((ProxyConfigArguments)step.getIncludedArguments(ProxyConfigArguments.class));
        }
        SSHProvider provider = SSHProvider.createInstance((ISOSLogger)step.getLogger(), (SSHProviderArguments)providerArgs);
        step.addCancelableResource(CANCELABLE_RESOURCE_NAME_SSH_PROVIDER, (Object)provider);
        try {
            provider.connect();
            if (!((SSHJobArguments)step.getDeclaredArguments()).getCommand().isEmpty()) {
                this.executeCommand(provider, step);
            }
            Integer testExitCode = 0;
            if (((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue() != null) {
                step.getLogger().info((Object)("[getExitCodesToIgnore.size=]" + ((List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()).size()));
                for (Object o : (List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()) {
                    step.getLogger().info((Object)("[getExitCodesToIgnore]" + o.getClass() + "=" + o));
                }
                step.getLogger().info((Object)("[getExitCodesToIgnore.contains(" + testExitCode + ")]" + ((List)((SSHJobArguments)step.getDeclaredArguments()).getExitCodesToIgnore().getValue()).contains(testExitCode)));
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (provider != null) {
                provider.disconnect();
            }
        }
    }

    public void onOrderProcessCancel(OrderProcessStep<SSHJobArguments> step) throws Exception {
        String jobName = null;
        try {
            jobName = step.getJobName();
            Object o = step.getCancelableResources().get(CANCELABLE_RESOURCE_NAME_SSH_PROVIDER);
            if (o != null) {
                SSHProvider p = (SSHProvider)o;
                step.getLogger().info((Object)("[cancel/kill][ssh]" + p.cancelCommands()));
                p.disconnect();
            }
        }
        catch (Throwable e) {
            step.getLogger().error(String.format("[%s][job name=%s][cancelSSHProvider]%s", "cancel/kill", jobName, e.toString()), e);
        }
    }

    private void executeCommand(SSHProvider provider, OrderProcessStep<SSHJobArguments> step) {
        step.getLogger().info("[execute command]%s", new Object[]{((SSHJobArguments)step.getDeclaredArguments()).getCommand().getDisplayValue()});
        SOSCommandResult r = provider.executeCommand((String)((SSHJobArguments)step.getDeclaredArguments()).getCommand().getValue());
        step.getLogger().info("[exitCode]%s", new Object[]{r.getExitCode()});
        if (!SOSString.isEmpty((String)r.getStdOut())) {
            step.getLogger().info("[stdOut]%s", new Object[]{r.getStdOut()});
        }
        if (!SOSString.isEmpty((String)r.getStdErr())) {
            step.getLogger().info("[stdErr]%s", new Object[]{r.getStdErr()});
        }
        if (r.getException() != null) {
            step.getLogger().info("[exception]%s", new Object[]{r.getException()});
        }
    }
}

