/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.file;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.file.common.AFileOperationsJob;
import com.sos.jitl.jobs.file.common.FileOperationsCopyImpl;
import com.sos.jitl.jobs.file.common.FileOperationsJobArguments;
import com.sos.jitl.jobs.file.exception.SOSFileOperationsException;
import com.sos.js7.job.OrderProcessStep;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class CopyFileJob
extends AFileOperationsJob {
    public CopyFileJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<FileOperationsJobArguments> step) throws Exception {
        FileOperationsJobArguments args = (FileOperationsJobArguments)step.getDeclaredArguments();
        CopyFileJob.checkArguments(args);
        this.setFlags(args);
        FileOperationsCopyImpl fo = new FileOperationsCopyImpl((ISOSLogger)step.getLogger());
        String[] sourceArr = ((String)args.getSourceFile().getValue()).split(";");
        String[] targetArr = null;
        if (!args.getTargetFile().isEmpty() && sourceArr.length != (targetArr = ((String)args.getTargetFile().getValue()).split(";")).length) {
            throw new SOSFileOperationsException(String.format("length mismatch: %s=%s, %s=%s", args.getSourceFile().getName(), sourceArr.length, args.getTargetFile().getName(), targetArr.length));
        }
        String[] fileSpecsArr = ((String)args.getFileSpec().getValue()).split(";");
        boolean checkLen = sourceArr.length == fileSpecsArr.length;
        args.setFileSpec(fileSpecsArr[0]);
        int files = 0;
        for (int i = 0; i < sourceArr.length; ++i) {
            String source = sourceArr[i];
            String target = null;
            if (!args.getTargetFile().isEmpty()) {
                target = targetArr[i];
            }
            if (!args.getFileSpec().isEmpty() && checkLen) {
                args.setFileSpec(fileSpecsArr[i]);
            }
            files += this.doFileOperation(args, fo, source, target);
        }
        CopyFileJob.handleResult(step, fo.getResultList(), files > 0);
    }

    private int doFileOperation(FileOperationsJobArguments args, FileOperationsCopyImpl fo, String strSource, String strTarget) throws Exception {
        return fo.copyFileCnt(strSource, strTarget, (String)args.getFileSpec().getValue(), args.getFlags(), 2, (String)args.getReplacing().getValue(), (String)args.getReplacement().getValue(), (String)args.getMinFileAge().getValue(), (String)args.getMaxFileAge().getValue(), (String)args.getMinFileSize().getValue(), (String)args.getMaxFileSize().getValue(), (Integer)args.getSkipFirstFiles().getValue(), (Integer)args.getSkipLastFiles().getValue(), (String)args.getSortCriteria().getValue(), (String)args.getSortOrder().getValue());
    }
}

