/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.file;

import com.sos.commons.util.SOSDate;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.file.common.AFileOperationsJob;
import com.sos.jitl.jobs.file.common.FileOperationsImpl;
import com.sos.jitl.jobs.file.common.FileOperationsJobArguments;
import com.sos.jitl.jobs.file.common.FileOperationsJobFileExistsArguments;
import com.sos.jitl.jobs.file.exception.SOSFileOperationsException;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class FileExistsJob
extends Job<FileOperationsJobFileExistsArguments> {
    public FileExistsJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<FileOperationsJobFileExistsArguments> step) throws Exception {
        AFileOperationsJob.checkArguments((FileOperationsJobArguments)step.getDeclaredArguments());
        FileOperationsImpl fo = new FileOperationsImpl((ISOSLogger)step.getLogger());
        FileOperationsJobFileExistsArguments args = (FileOperationsJobFileExistsArguments)step.getDeclaredArguments();
        boolean result = fo.existsFile(new File((String)args.getSourceFile().getValue()), (String)args.getFileSpec().getValue(), (Boolean)args.getRecursive().getValue(), 2, (String)args.getMinFileAge().getValue(), (String)args.getMaxFileAge().getValue(), (String)args.getMinFileSize().getValue(), (String)args.getMaxFileSize().getValue(), (Integer)args.getSkipFirstFiles().getValue(), (Integer)args.getSkipLastFiles().getValue());
        if (result) {
            result = this.checkSteadyStateOfFiles((ISOSLogger)step.getLogger(), args, fo.getResultList());
        }
        AFileOperationsJob.handleResult(step, fo.getResultList(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSteadyStateOfFiles(ISOSLogger logger, FileOperationsJobFileExistsArguments args, List<File> files) throws Exception {
        if (files == null || files.size() == 0 || (Integer)args.getSteadyStateCount().getValue() <= 0) {
            return true;
        }
        Integer interval = (Integer)args.getSteadyStateInterval().getValue();
        if (interval == null || interval <= 0) {
            logger.debug("skip checking file(s) for steady state, interval=%ss", new Object[]{interval});
            return true;
        }
        logger.debug("checking file(s) for steady state, interval=%ss", new Object[]{interval});
        ArrayList<FileDescriptor> list = new ArrayList<FileDescriptor>();
        for (File file : files) {
            list.add(new FileDescriptor(file));
        }
        try {
            TimeUnit.SECONDS.sleep(interval.longValue());
        }
        catch (InterruptedException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        boolean result = true;
        for (int i = 0; i < (Integer)args.getSteadyStateCount().getValue(); ++i) {
            result = true;
            for (FileDescriptor fd : list) {
                File file = new File(fd.getFileName());
                if (logger.isDebugEnabled()) {
                    logger.debug("[steady state][%s][modified last=%s current=%s][file length last=%sb current=%sb]", new Object[]{file.getCanonicalPath(), SOSDate.getDateTimeAsString((long)fd.getLastModificationDate()), SOSDate.getDateTimeAsString((long)file.lastModified()), fd.getLastFileLength(), file.length()});
                }
                if (((Boolean)args.getUseFileLock().getValue()).booleanValue()) {
                    try {
                        RandomAccessFile raf = new RandomAccessFile(file, "rw");
                        FileChannel channel = raf.getChannel();
                        FileLock lock = channel.lock();
                        try {
                            lock = channel.tryLock();
                            logger.debug((Object)String.format("lock for file '%1$s' ok", file.getAbsolutePath()));
                        }
                        catch (OverlappingFileLockException e) {
                            try {
                                result = false;
                                logger.info((Object)String.format("File '%s' is open by someone else", file.getAbsolutePath()));
                            }
                            catch (Throwable throwable) {
                                lock.release();
                                logger.debug((Object)String.format("release lock for '%s'", file.getAbsolutePath()));
                                if (raf != null) {
                                    channel.close();
                                    raf.close();
                                    raf = null;
                                }
                                throw throwable;
                            }
                            lock.release();
                            logger.debug((Object)String.format("release lock for '%s'", file.getAbsolutePath()));
                            if (raf == null) break;
                            channel.close();
                            raf.close();
                            raf = null;
                            break;
                        }
                        lock.release();
                        logger.debug((Object)String.format("release lock for '%s'", file.getAbsolutePath()));
                        if (raf == null) break;
                        channel.close();
                        raf.close();
                        raf = null;
                        break;
                    }
                    catch (FileNotFoundException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (file.lastModified() != fd.getLastModificationDate() || file.length() != fd.getLastFileLength()) {
                    result = false;
                    fd.update(file);
                    fd.setSteady(false);
                    logger.info((Object)String.format("File '%s' changed during checking steady state", file.getAbsolutePath()));
                    break;
                }
                fd.setSteady(true);
            }
            if (result) break;
            try {
                TimeUnit.SECONDS.sleep(interval.intValue());
                continue;
            }
            catch (InterruptedException e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
        if (!result) {
            logger.error((Object)"not all files are steady");
            for (FileDescriptor fd : list) {
                if (fd.isSteady()) continue;
                logger.info((Object)String.format("File '%s' is not steady", fd.getFileName()));
            }
            throw new SOSFileOperationsException("not all files are steady");
        }
        return result;
    }

    private class FileDescriptor {
        private long lastModificationDate;
        private long lastFileLength;
        private String fileName;
        private boolean isSteady;

        private FileDescriptor(File file) {
            this.lastFileLength = file.length();
            this.lastModificationDate = file.lastModified();
            this.fileName = file.getAbsolutePath();
        }

        private void update(File file) {
            this.lastFileLength = file.length();
            this.lastModificationDate = file.lastModified();
        }

        private long getLastModificationDate() {
            return this.lastModificationDate;
        }

        private long getLastFileLength() {
            return this.lastFileLength;
        }

        private String getFileName() {
            return this.fileName;
        }

        private boolean isSteady() {
            return this.isSteady;
        }

        private void setSteady(boolean val) {
            this.isSteady = val;
        }
    }
}

