/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.file.common;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.file.common.AFileOperations;
import com.sos.jitl.jobs.file.exception.SOSFileOperationsException;
import java.io.File;

public class FileOperationsCopyImpl
extends AFileOperations {
    public FileOperationsCopyImpl(ISOSLogger logger) {
        super(logger);
    }

    @Override
    protected boolean handleOneFile(File sourceFile, File targetFile, boolean overwrite, boolean gracious) throws Exception {
        if (sourceFile.equals(targetFile)) {
            throw new SOSFileOperationsException(String.format("cannot copy file to itself: %s", sourceFile.getCanonicalPath()));
        }
        if (overwrite || !targetFile.exists()) {
            this.getLogger().info("copy %s to %s", new Object[]{sourceFile.getPath(), targetFile.getPath()});
            if (this.copyFile(sourceFile, targetFile, false)) {
                targetFile.setLastModified(sourceFile.lastModified());
                return true;
            }
        } else {
            if (!gracious) {
                throw new SOSFileOperationsException("file already exists: " + targetFile.getCanonicalPath());
            }
            this.getLogger().info("file already exists: %s", new Object[]{targetFile.getCanonicalPath()});
        }
        return false;
    }
}

