/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.file.common;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.file.common.AFileOperations;
import com.sos.jitl.jobs.file.exception.SOSFileOperationsException;
import java.io.File;

public class FileOperationsRenameImpl
extends AFileOperations {
    public FileOperationsRenameImpl(ISOSLogger logger) {
        super(logger);
    }

    @Override
    protected boolean handleOneFile(File sourceFile, File targetFile, boolean overwrite, boolean gracious) throws Exception {
        if (sourceFile.equals(targetFile)) {
            throw new SOSFileOperationsException(String.format("cannot rename file to itself: %s", sourceFile.getCanonicalPath()));
        }
        if (!overwrite && targetFile.exists()) {
            if (!gracious) {
                throw new SOSFileOperationsException(String.format("file already exists: %s", targetFile.getCanonicalPath()));
            }
            this.getLogger().info("file already exists: %s", new Object[]{targetFile.getCanonicalPath()});
            return false;
        }
        if (targetFile.exists() && !targetFile.delete()) {
            throw new SOSFileOperationsException(String.format("cannot overwrite %s", targetFile.getCanonicalPath()));
        }
        this.getLogger().info("rename %s to %s", new Object[]{sourceFile.getPath(), targetFile.getPath()});
        if (!sourceFile.renameTo(targetFile)) {
            boolean rc = this.copyFile(sourceFile, targetFile, false);
            if (rc) {
                rc = sourceFile.delete();
                if (!rc) {
                    rc = targetFile.delete();
                    throw new SOSFileOperationsException(String.format("cannot rename file from %s to %s", sourceFile.getCanonicalPath(), targetFile.getCanonicalPath()));
                }
            } else {
                throw new SOSFileOperationsException(String.format("cannot rename file from %s to %s", sourceFile.getCanonicalPath(), targetFile.getCanonicalPath()));
            }
        }
        return true;
    }
}

