/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.fileordervariablesjob;

import com.sos.commons.exception.SOSException;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.fileordervariablesjob.FileOrderVariablesJobArguments;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class ExecuteFileOrderVariables {
    private FileOrderVariablesJobArguments args;
    private Map<String, Object> jobArguments = new HashMap<String, Object>();
    private ISOSLogger logger;

    public ExecuteFileOrderVariables(ISOSLogger logger, Map<String, Object> jobArguments, FileOrderVariablesJobArguments args) {
        this.args = args;
        this.logger = logger;
        this.jobArguments = jobArguments;
    }

    public Map<String, Object> getVariables() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        try {
            String line;
            BufferedReader r = null;
            r = Files.newBufferedReader(Paths.get(this.args.getJs7SourceFile(), new String[0]));
            while ((line = r.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                String[] v = line.split("=");
                if (v.length < 2 && !line.contains("=")) {
                    throw new SOSException(line + " in file " + this.args.getJs7SourceFile() + " is not a valid variable assignment <name>=<value>");
                }
                String vName = v[0].trim();
                String vValue = line.substring(line.indexOf("=") + 1).trim();
                if (this.jobArguments.get(vName) == null) {
                    throw new SOSException(vName + " is not a valid variable name. Couldn't find Job argument.");
                }
                variables.put(vName, vValue);
            }
            for (Map.Entry<String, Object> entry : this.jobArguments.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                String s = (String)entry.getValue();
                if (variables.get(entry.getKey()) != null || variables.get(entry.getKey()) == "js7_source_file" || s.isEmpty()) continue;
                variables.put(entry.getKey(), entry.getValue());
            }
            return variables;
        }
        catch (Exception e) {
            this.logger.error("getVariables", (Throwable)e);
            throw e;
        }
    }
}

