/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.mail;

import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.mail.SOSMail;
import com.sos.commons.mail.SOSMailAttachment;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.mail.MailJobArguments;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MailHandler {
    private Map<String, Object> variables = new HashMap<String, Object>();
    private final ISOSLogger logger;
    private final MailJobArguments args;

    public MailHandler(MailJobArguments args, Map<String, Object> variables, ISOSLogger logger) {
        this.logger = logger;
        this.variables = variables;
        this.args = args;
    }

    public void sendMail(CredentialStoreArguments csArgs) throws Exception {
        SOSMail sosMail = null;
        try {
            File attachmentFile;
            Properties smtpProperties = new Properties();
            if (this.variables != null) {
                for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                    if (entry.getValue() == null || !entry.getKey().startsWith("mail.")) continue;
                    smtpProperties.put(entry.getKey(), entry.getValue().toString());
                }
            }
            this.putSmtpProperties(smtpProperties, "mail.smtp.host", this.args.getMailSmtpHost());
            this.putSmtpProperties(smtpProperties, "mail.smtp.port", this.args.getMailSmtpPort());
            if (this.args.getMailSmtpUser() != null && !this.args.getMailSmtpUser().isEmpty() && this.args.getMailSmtpPassword() != null && !this.args.getMailSmtpPassword().isEmpty()) {
                this.putSmtpProperties(smtpProperties, "mail.smtp.user", this.args.getMailSmtpUser());
                this.putSmtpProperties(smtpProperties, "mail.smtp.password", this.args.getMailSmtpPassword());
            }
            sosMail = new SOSMail(smtpProperties);
            sosMail.setCredentialStoreArguments(csArgs);
            sosMail.setFrom(this.args.getFrom());
            sosMail.setQueueMailOnError(false);
            if (this.args.getContentType() != null) {
                sosMail.setContentType(this.args.getContentType());
            }
            if (this.args.getEncoding() != null) {
                sosMail.setEncoding(this.args.getEncoding());
            }
            if (this.args.getCharset() != null) {
                sosMail.setCharset(this.args.getCharset());
            }
            if (this.args.getAttachmentCharset() != null) {
                sosMail.setAttachmentCharset(this.args.getAttachmentCharset());
            }
            if (this.args.getAttachmentEncoding() != null) {
                sosMail.setAttachmentEncoding(this.args.getAttachmentEncoding());
            }
            if (this.args.getAttachmentContentType() != null) {
                sosMail.setAttachmentContentType(this.args.getAttachmentContentType());
            }
            if (this.args.getFromName() != null) {
                sosMail.setFromName(this.args.getFromName());
            }
            sosMail.setSecurityProtocol(this.args.getSecurityProtocol());
            String[] recipientsTo = this.args.getTo().split(";|,");
            for (int i = 0; i < recipientsTo.length; ++i) {
                if (i == 0) {
                    sosMail.setReplyTo(recipientsTo[i].trim());
                }
                sosMail.addRecipient(recipientsTo[i].trim());
            }
            if (this.args.getReplyTo() != null) {
                sosMail.setReplyTo(this.args.getReplyTo());
            }
            if (this.args.getCc() != null) {
                sosMail.addCC(this.args.getCc());
            }
            if (this.args.getBcc() != null) {
                sosMail.addBCC(this.args.getBcc());
            }
            if (this.args.getSubject() != null) {
                sosMail.setSubject(this.args.getSubject());
            }
            if (this.args.getBody() != null) {
                sosMail.setBody(this.args.getBody());
            }
            if (this.args.getAttachments() != null) {
                for (String attachment2 : this.args.getAttachments()) {
                    attachmentFile = new File(attachment2);
                    SOSMailAttachment attachment = new SOSMailAttachment(sosMail, attachmentFile);
                    attachment.setCharset(sosMail.getAttachmentCharset());
                    attachment.setEncoding(sosMail.getAttachmentEncoding());
                    attachment.setContentType(sosMail.getAttachmentContentType());
                    sosMail.addAttachment(attachment);
                }
            }
            this.logger.info((Object)("sending mail: \n" + sosMail.dumpMessageAsString()));
            if (!sosMail.send()) {
                this.logger.info((Object)("mail server is unavailable, mail for recipient [" + this.args.getTo() + "]" + sosMail.getLastError()));
            }
            if (this.args.getCleanupAttachment().booleanValue()) {
                for (String attachment : this.args.getAttachments()) {
                    attachmentFile = new File(attachment);
                    if (!attachmentFile.exists() || !attachmentFile.canWrite()) continue;
                    attachmentFile.delete();
                }
            }
            sosMail.clearRecipients();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (sosMail == null) {
                this.logger.info((Object)e.getMessage());
            } else {
                this.logger.info((Object)(sosMail.getLastError() + ":" + e.getMessage()));
            }
            throw new Exception(e.getMessage(), e);
        }
    }

    private void putSmtpProperties(Properties smtpProperties, String key, String value) {
        if (value != null) {
            smtpProperties.put(key, value);
        }
    }
}

