/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.mail;

import com.sos.commons.exception.SOSInvalidDataException;
import com.sos.commons.mail.SOSMailReceiver;
import com.sos.commons.mail.SOSMimeMessage;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.mail.MailInboxArguments;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.FromTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;

public class MailProcessor {
    private final MailInboxArguments args;
    private final ISOSLogger logger;
    private Folder inFolder;
    private Folder targetFolder;
    private Date dateMinAge = null;

    public MailProcessor(MailInboxArguments args, ISOSLogger logger) {
        this.args = args;
        this.logger = logger;
        this.setMinAgeDate();
    }

    private void setMinAgeDate() {
        long minAge;
        if (this.args.getMinMailAge().isDirty() && (minAge = SOSDate.getTimeAsSeconds((String)((String)this.args.getMinMailAge().getValue()))) > 0L) {
            Instant now = Instant.now();
            this.dateMinAge = Date.from(now.minusSeconds(minAge));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Min. Age defined: %1$s", new Object[]{this.dateMinAge.toString()});
            }
        }
    }

    private boolean isPerformMessage(SOSMimeMessage sosMimeMessage) throws Exception {
        Date messageDate = sosMimeMessage.getSentDate();
        boolean result = true;
        if (this.dateMinAge != null && messageDate != null && this.dateMinAge.before(messageDate)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("message skipped due to date constraint: %s | %s", new Object[]{sosMimeMessage.getSubject(), messageDate.toString()});
            }
            result = false;
        } else {
            this.logger.info("processing: %s | %s", new Object[]{sosMimeMessage.getSubject(), messageDate != null ? messageDate.toString() : "unknown date"});
        }
        return result;
    }

    private void executeMessage(SOSMimeMessage sosMimeMessage) throws Exception {
        if (this.isPerformMessage(sosMimeMessage)) {
            this.performAction(sosMimeMessage);
        }
    }

    private void performAction(SOSMimeMessage message) throws IOException, MessagingException, SOSInvalidDataException, JobRequiredArgumentMissingException {
        if (((List)this.args.getAction().getValue()).contains((Object)MailInboxArguments.ActionProcess.dump)) {
            if (this.args.getMailDirectoryName().isEmpty()) {
                throw new JobRequiredArgumentMissingException("No target directory [parameter " + this.args.getMailDirectoryName().getName() + "] specified.");
            }
            this.dumpMessage(message, (String)this.args.getMailDirectoryName().getValue());
        }
        if (((List)this.args.getAction().getValue()).contains((Object)MailInboxArguments.ActionProcess.dump_attachments)) {
            if (this.args.getAttachmentDirectoryName().isEmpty()) {
                throw new JobRequiredArgumentMissingException("No target directory [parameter " + this.args.getAttachmentDirectoryName().getName() + "] specified.");
            }
            this.copyAttachmentsToFile(message);
        }
        this.handleAfterProcessEmail(message);
    }

    private void copyMailToFolder(SOSMimeMessage message) throws MessagingException, IOException, JobRequiredArgumentMissingException {
        if (this.targetFolder == null) {
            throw new JobRequiredArgumentMissingException("Parameter '" + this.args.getAfterProcessMailDirectoryName().getName() + "' is required but missing.");
        }
        ArrayList<MimeMessage> tempList = new ArrayList<MimeMessage>();
        tempList.add(message.getMessage());
        Message[] m = tempList.toArray(new Message[tempList.size()]);
        this.inFolder.copyMessages(m, this.targetFolder);
    }

    private void handleAfterProcessEmail(SOSMimeMessage message) throws MessagingException, IOException, JobRequiredArgumentMissingException {
        switch ((MailInboxArguments.ActionAfterProcess)((Object)this.args.getAfterProcessMail().getValue())) {
            case none: {
                break;
            }
            case mark_as_read: 
            case markAsRead: {
                message.setFlag(Flags.Flag.SEEN, true);
                break;
            }
            case delete: {
                this.deleteMessage(message);
                break;
            }
            case move: {
                if (((String)this.args.getAfterProcessMailDirectoryName().getValue()).isEmpty()) {
                    throw new JobRequiredArgumentMissingException("No target folder [parameter " + this.args.getAfterProcessMailDirectoryName().getName() + "] specified.");
                }
                this.copyMailToFolder(message);
                this.deleteMessage(message);
                break;
            }
            case copy: {
                if (((String)this.args.getAfterProcessMailDirectoryName().getValue()).isEmpty()) {
                    throw new JobRequiredArgumentMissingException("No target folder [parameter " + this.args.getAfterProcessMailDirectoryName().getName() + "] specified.");
                }
                this.copyMailToFolder(message);
            }
        }
    }

    private String getEmailFolderName(JobArgument<String> folder) throws JobRequiredArgumentMissingException {
        switch ((MailInboxArguments.ActionAfterProcess)((Object)this.args.getAfterProcessMail().getValue())) {
            case move: 
            case copy: {
                if (folder.isEmpty()) {
                    throw new JobRequiredArgumentMissingException("Parameter '" + folder.getName() + "' is required but missing.");
                }
                return (String)folder.getValue();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performMessagesInFolder(SOSMailReceiver mailReader, String messageFolder) throws MessagingException, JobRequiredArgumentMissingException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("reading %s", new Object[]{messageFolder});
            }
            this.inFolder = mailReader.openFolder(messageFolder, mailReader.READ_WRITE);
            String targetFolderName = this.getEmailFolderName(this.args.getAfterProcessMailDirectoryName());
            if (!targetFolderName.isEmpty()) {
                this.targetFolder = mailReader.openFolder(targetFolderName, mailReader.READ_WRITE);
            }
            int objectsInFolder = this.inFolder.getMessageCount();
            Message[] msgs = null;
            Message[] msgs2 = null;
            int maxMailsToProcess = (Integer)this.args.getMaxMailsToProcess().getValue();
            msgs = objectsInFolder > maxMailsToProcess && maxMailsToProcess > 0 ? this.inFolder.getMessages(objectsInFolder - maxMailsToProcess + 1, objectsInFolder) : this.inFolder.getMessages();
            Pattern subjectPattern = null;
            Pattern bodyPattern = null;
            if (!this.args.getMailSubjectPattern().isEmpty()) {
                subjectPattern = Pattern.compile((String)this.args.getMailSubjectPattern().getValue());
            }
            if (!this.args.getMailBodyPattern().isEmpty()) {
                bodyPattern = Pattern.compile((String)this.args.getMailBodyPattern().getValue());
            }
            if (!this.args.getMailSubjectFilter().isEmpty() && !this.args.getMailFromFilter().isEmpty()) {
                fromTerm = new FromTerm((Address)new InternetAddress((String)this.args.getMailFromFilter().getValue()));
                SubjectTerm subjectTerm = new SubjectTerm((String)this.args.getMailSubjectFilter().getValue());
                AndTerm searchTerm = new AndTerm((SearchTerm)subjectTerm, (SearchTerm)fromTerm);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("looking for subject=%s and from=%s", new Object[]{this.args.getMailSubjectFilter().getValue(), this.args.getMailFromFilter().getValue()});
                }
                msgs2 = this.inFolder.search((SearchTerm)searchTerm, msgs);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("%d messages found with subject=%s and from=%s", new Object[]{msgs2.length, this.args.getMailSubjectFilter().getValue(), this.args.getMailFromFilter().getValue()});
                }
            } else if (!this.args.getMailSubjectFilter().isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("looking for subject=%s", new Object[]{this.args.getMailSubjectFilter().getValue()});
                }
                SubjectTerm subjectTerm = new SubjectTerm((String)this.args.getMailSubjectFilter().getValue());
                msgs2 = this.inFolder.search((SearchTerm)subjectTerm, msgs);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("%d messages found with subject=%s", new Object[]{msgs2.length, this.args.getMailSubjectFilter().getValue()});
                }
            } else if (!this.args.getMailFromFilter().isEmpty()) {
                fromTerm = new FromTerm((Address)new InternetAddress((String)this.args.getMailFromFilter().getValue()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("looking for from=%s", new Object[]{this.args.getMailFromFilter().getValue()});
                }
                msgs2 = this.inFolder.search((SearchTerm)fromTerm, msgs);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("%d messages found with from=%s", new Object[]{msgs2.length, this.args.getMailFromFilter().getValue()});
                }
            } else {
                msgs2 = msgs;
                this.logger.debug("%d messages found, folder = %s", new Object[]{msgs2.length, messageFolder});
            }
            if (msgs2.length > 0) {
                int notUnreadMails = 0;
                for (Message messageElement : msgs2) {
                    if (((Boolean)this.args.getMailOnlyUnseen().getValue()).booleanValue() && messageElement.isSet(Flags.Flag.SEEN)) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("message skipped, already seen: %s", new Object[]{messageElement.getSubject()});
                        }
                        ++notUnreadMails;
                        continue;
                    }
                    try {
                        SOSMimeMessage sosMailItem = new SOSMimeMessage(messageElement, Boolean.valueOf(true));
                        if (subjectPattern != null && !subjectPattern.matcher(sosMailItem.getSubject()).find()) {
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("message skipped, subject does not match [%1$s]: %2$s", new Object[]{this.args.getMailSubjectPattern().getValue(), sosMailItem.getSubject()});
                            continue;
                        }
                        if (bodyPattern != null && !bodyPattern.matcher(sosMailItem.getPlainTextBody()).find()) {
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("message with subject %s skipped, body does not match [%s]", new Object[]{sosMailItem.getSubject(), this.args.getMailBodyPattern().getValue()});
                            continue;
                        }
                        sosMailItem.init();
                        this.executeMessage(sosMailItem);
                    }
                    catch (Exception e) {
                        this.logger.info("message '%s' skipped, exception occured: %s", new Object[]{messageElement.getSubject(), e.toString()});
                    }
                }
                if (notUnreadMails > 0 && this.logger.isDebugEnabled()) {
                    this.logger.debug("%d messages skipped because they are already read", new Object[]{notUnreadMails});
                }
            }
        }
        finally {
            mailReader.closeFolder(true);
        }
    }

    private void dumpMessage(SOSMimeMessage message, String directory) throws IOException, MessagingException {
        File messageFile = new File(directory, message.getMessageId());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("dump message. subject=%s, date=%s, file=%s: ", new Object[]{message.getSubject(), message.getSentDateAsString(), messageFile});
        }
        message.dumpMessageToFile(messageFile, true, false);
    }

    private void deleteMessage(SOSMimeMessage message) throws UnsupportedEncodingException, MessagingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("deleting message. subject=%s, date=%s", new Object[]{message.getSubject(), message.getSentDateAsString()});
        }
        message.deleteMessage();
    }

    private void copyAttachmentsToFile(SOSMimeMessage message) throws SOSInvalidDataException, IOException, MessagingException {
        String directory = (String)this.args.getAttachmentDirectoryName().getValue();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("saving attachments. subject=%s, date=%s, directory=%s: ", new Object[]{message.getSubject(), message.getSentDateAsString(), directory});
        }
        message.saveAttachments(message, (String)this.args.getAttachmentFileNamePattern().getValue(), directory, ((Boolean)this.args.getSaveBodyAsAttachment().getValue()).booleanValue()).forEach(s -> this.logger.debug("attachment file [%s] successfully saved.", new Object[]{s}));
    }
}

