/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.monitoring.classes;

import com.sos.commons.exception.SOSException;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.monitoring.classes.MonitoringCheckReturn;
import com.sos.jitl.jobs.monitoring.classes.MonitoringParameters;
import com.sos.joc.model.agent.AgentV;
import com.sos.joc.model.agent.SubagentV;
import com.sos.joc.model.controller.Controller;
import com.sos.joc.model.controller.Role;
import com.sos.joc.model.jitl.monitoring.MonitoringStatus;
import com.sos.joc.model.joc.Cockpit;
import com.sos.joc.model.joc.ControllerConnectionState;
import com.sos.joc.model.order.OrdersSummary;
import java.util.List;

public class MonitoringChecker {
    private ISOSLogger logger;
    private Integer count = 0;

    public MonitoringChecker(ISOSLogger logger) {
        this.logger = logger;
    }

    private MonitoringCheckReturn checkControllerStatus(Controller controller) {
        boolean isCluster;
        MonitoringCheckReturn monitoringCheckReturn = new MonitoringCheckReturn();
        monitoringCheckReturn.setSuccess(true);
        if (controller.getConnectionState() == null) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: empty connection status");
        } else if (controller.getConnectionState().getSeverity() != 0) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: unhealthy connection status: " + controller.getConnectionState().get_text() + ":" + controller.getConnectionState().getSeverity());
        }
        if (controller.getComponentState() == null) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: empty component status");
        } else if (controller.getComponentState().getSeverity() != 0) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: unhealthy component status: " + controller.getComponentState().get_text() + ":" + controller.getComponentState().getSeverity());
        }
        if (controller.getRole() == null) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: Controller not assigned a role");
        }
        boolean bl = isCluster = controller.getRole() != null && controller.getRole() != Role.STANDALONE;
        if (isCluster) {
            if (controller.getClusterNodeState() == null) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: empty cluster node state");
            } else if (controller.getClusterNodeState().getSeverity() != 0) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: unhealthy cluster node state " + controller.getClusterNodeState().get_text() + ":" + controller.getClusterNodeState().getSeverity());
            }
            if (!controller.getIsCoupled().booleanValue()) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-ControllerStatus: cluster not coupled");
            }
        }
        return monitoringCheckReturn;
    }

    private MonitoringCheckReturn checkAgentStatus(List<AgentV> listOfAgents) {
        MonitoringCheckReturn monitoringCheckReturn = new MonitoringCheckReturn();
        monitoringCheckReturn.setSuccess(true);
        for (AgentV agentV : listOfAgents) {
            if (agentV.getDisabled().booleanValue()) continue;
            if (agentV.getState() == null && agentV.getHealthState() == null) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-AgentStatus: empty health state");
                continue;
            }
            if (agentV.getHealthState() != null && agentV.getHealthState().getSeverity() != 0) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-AgentStatus: unhealthy Agent health status " + agentV.getHealthState().get_text() + ", severity " + agentV.getHealthState().getSeverity() + " for Agent ID " + agentV.getAgentId() + ", Agent Name " + agentV.getAgentName() + ":" + agentV.getErrorMessage());
            }
            if (agentV.getState() != null) {
                if (agentV.getState().getSeverity() == 0) continue;
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-AgentStatus: unhealthy Agent status " + agentV.getState().get_text() + ", severity " + agentV.getState().getSeverity() + " for Agent ID " + agentV.getAgentId() + ", Agent Name " + agentV.getAgentName() + ":" + agentV.getErrorMessage());
                continue;
            }
            if (agentV.getSubagents() == null || agentV.getSubagents().size() == 0) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-AgentStatus: empty agent status and could not find subagents");
                continue;
            }
            this.checkSubAgentStatus(agentV.getSubagents());
        }
        return monitoringCheckReturn;
    }

    private MonitoringCheckReturn checkSubAgentStatus(List<SubagentV> listOfSubAgents) {
        MonitoringCheckReturn monitoringCheckReturn = new MonitoringCheckReturn();
        monitoringCheckReturn.setSuccess(true);
        for (SubagentV subagentV : listOfSubAgents) {
            if (subagentV.getDisabled().booleanValue()) continue;
            if (subagentV.getState() == null) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-AgentStatus: empty subagent status");
                continue;
            }
            if (subagentV.getState().getSeverity() == 0) continue;
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-AgentStatus: unhealthy Agent status " + subagentV.getState().get_text() + ", severity " + subagentV.getState().getSeverity() + " for Agent ID " + subagentV.getAgentId() + ", Agent Name " + subagentV.getAgentName() + ":" + subagentV.getErrorMessage());
        }
        return monitoringCheckReturn;
    }

    private MonitoringCheckReturn checkOrderFailedStatus(OrdersSummary ordersSummary, MonitoringParameters monitoringParameters) {
        MonitoringCheckReturn monitoringCheckReturn = new MonitoringCheckReturn();
        monitoringCheckReturn.setSuccess(true);
        if (ordersSummary == null) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-checkOrderFailedStatus: empty OrdersSummary");
        } else if (ordersSummary.getFailed() > monitoringParameters.getMaxFailedOrders() && monitoringParameters.getMaxFailedOrders() > -1) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "checkOrderFailedStatus: unhealthy orders status " + ordersSummary.getFailed() + " failed orders ");
        }
        return monitoringCheckReturn;
    }

    private MonitoringCheckReturn checkJOCStatus(Cockpit cockpit) {
        boolean isCluster;
        MonitoringCheckReturn monitoringCheckReturn = new MonitoringCheckReturn();
        monitoringCheckReturn.setSuccess(true);
        if (cockpit.getConnectionState() == null) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-JOCStatus: empty connection status");
        } else if (cockpit.getConnectionState().getSeverity() != 0) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-JOCStatus: unhealthy connection status " + cockpit.getConnectionState().get_text() + ":" + cockpit.getConnectionState().getSeverity());
        }
        if (cockpit.getComponentState() == null) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-JOCStatus: empty component status");
        } else if (cockpit.getComponentState().getSeverity() != 0) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-JOCStatus: unhealthy component status " + cockpit.getComponentState().get_text() + ":" + cockpit.getComponentState().getSeverity());
        }
        boolean bl = isCluster = cockpit.getClusterNodeState() != null;
        if (isCluster && cockpit.getClusterNodeState().getSeverity() != 0) {
            this.count = this.count + 1;
            monitoringCheckReturn.setErrorMessage(this.logger, "check-JOCStatus: unhealthy cluster node state " + cockpit.getClusterNodeState().get_text() + ":" + cockpit.getClusterNodeState().getSeverity());
        }
        if (cockpit.getControllerConnectionStates() != null) {
            for (ControllerConnectionState controllerConnectionState : cockpit.getControllerConnectionStates()) {
                if (controllerConnectionState.getState().getSeverity() == 0) continue;
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "check-JOCStatus: unhealthy Controller connection status controller" + controllerConnectionState.getState().get_text() + " for role " + controllerConnectionState.getRole() + ":" + controllerConnectionState.getState().getSeverity());
            }
        }
        return monitoringCheckReturn;
    }

    public MonitoringCheckReturn doCheck(MonitoringStatus monitoringStatus, MonitoringParameters monitoringParameters, String from) throws SOSException {
        MonitoringCheckReturn monitoringCheckReturn = new MonitoringCheckReturn();
        monitoringCheckReturn.setSuccess(true);
        if (monitoringParameters.getMonitorFileReportDate() == null) {
            throw new SOSException("sosMonitor: monitorReportDate is null");
        }
        try {
            Object _monitoringCheckReturn;
            if (monitoringStatus.getControllerStatus() == null || monitoringStatus.getControllerStatus().getVolatileStatus() == null) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "sosMonitor: empty Controller status");
                monitoringCheckReturn.setSuccess(false);
            } else {
                _monitoringCheckReturn = new MonitoringCheckReturn();
                _monitoringCheckReturn = this.checkControllerStatus(monitoringStatus.getControllerStatus().getVolatileStatus());
                monitoringCheckReturn.setSuccess(monitoringCheckReturn.isSuccess() && ((MonitoringCheckReturn)_monitoringCheckReturn).isSuccess());
                monitoringCheckReturn.onErrorSetMessage((MonitoringCheckReturn)_monitoringCheckReturn);
            }
            if (monitoringStatus.getAgentStatus() == null || monitoringStatus.getAgentStatus().size() == 0) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "sosMonitor: empty Agent status");
                monitoringCheckReturn.setSuccess(false);
            } else {
                _monitoringCheckReturn = new MonitoringCheckReturn();
                _monitoringCheckReturn = this.checkAgentStatus(monitoringStatus.getAgentStatus());
                monitoringCheckReturn.setSuccess(monitoringCheckReturn.isSuccess() && ((MonitoringCheckReturn)_monitoringCheckReturn).isSuccess());
                monitoringCheckReturn.onErrorSetMessage((MonitoringCheckReturn)_monitoringCheckReturn);
            }
            if (monitoringStatus.getJocStatus() == null) {
                this.count = this.count + 1;
                monitoringCheckReturn.setErrorMessage(this.logger, "sosMonitor: empty JOC Cockpit status");
                monitoringCheckReturn.setSuccess(false);
            } else if (monitoringStatus.getJocStatus().getActive() != null) {
                _monitoringCheckReturn = new MonitoringCheckReturn();
                _monitoringCheckReturn = this.checkJOCStatus(monitoringStatus.getJocStatus().getActive());
                monitoringCheckReturn.setSuccess(monitoringCheckReturn.isSuccess() && ((MonitoringCheckReturn)_monitoringCheckReturn).isSuccess());
                monitoringCheckReturn.onErrorSetMessage((MonitoringCheckReturn)_monitoringCheckReturn);
            } else {
                for (Cockpit cockpit : monitoringStatus.getJocStatus().getPassive()) {
                    MonitoringCheckReturn _monitoringCheckReturn2 = new MonitoringCheckReturn();
                    _monitoringCheckReturn2 = this.checkJOCStatus(cockpit);
                    monitoringCheckReturn.setSuccess(monitoringCheckReturn.isSuccess() && _monitoringCheckReturn2.isSuccess());
                    monitoringCheckReturn.onErrorSetMessage(_monitoringCheckReturn2);
                }
            }
            _monitoringCheckReturn = new MonitoringCheckReturn();
            _monitoringCheckReturn = this.checkOrderFailedStatus(monitoringStatus.getOrderSnapshot(), monitoringParameters);
            monitoringCheckReturn.setSuccess(monitoringCheckReturn.isSuccess() && ((MonitoringCheckReturn)_monitoringCheckReturn).isSuccess());
            monitoringCheckReturn.onErrorSetMessage((MonitoringCheckReturn)_monitoringCheckReturn);
            if (from == null) {
                from = "";
            }
            if (this.count == 0) {
                monitoringCheckReturn.setSubject("JS7 Monitor: Notice from: " + from + " at: " + monitoringParameters.getMonitorSubjectReportDate());
            } else {
                monitoringCheckReturn.setSubject("JS7 Monitor: Alert from: " + from + " at: " + monitoringParameters.getMonitorSubjectReportDate());
            }
            monitoringCheckReturn.setBody(monitoringCheckReturn.getSubject());
            monitoringCheckReturn.setCount(this.count);
            return monitoringCheckReturn;
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw e;
        }
    }
}

