/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.orderstatustransition.classes;

import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.orderstatustransition.OrderStateTransitionJobArguments;
import com.sos.jitl.jobs.orderstatustransition.classes.OrderStateWebserviceExecuter;
import com.sos.joc.model.common.Folder;
import com.sos.joc.model.order.ModifyOrders;
import com.sos.joc.model.order.OrderStateText;
import com.sos.joc.model.order.OrderV;
import com.sos.joc.model.order.OrdersFilterV;
import com.sos.joc.model.order.OrdersV;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrderStateTransition {
    private static final String INPROGRESS = "INPROGRESS";
    private static final String SUSPEND = "SUSPEND";
    private static final String CONTINUE = "CONTINUE";
    private static final String CANCELLED = "CANCELLED";
    private static final String CANCEL = "CANCEL";
    private final OrderProcessStep<OrderStateTransitionJobArguments> step;
    private final OrderStateTransitionJobArguments args;
    private final Map<String, DetailValue> jobResources;

    public OrderStateTransition(OrderProcessStep<OrderStateTransitionJobArguments> step) {
        this.args = (OrderStateTransitionJobArguments)step.getDeclaredArguments();
        this.jobResources = step.getJobResourcesArgumentsAsNameDetailValueMap();
        this.step = step;
    }

    private OrdersFilterV newOrdersFilterV(String state) {
        OrdersFilterV ordersFilter = new OrdersFilterV();
        ordersFilter.setCompact(Boolean.valueOf(true));
        ordersFilter.setControllerId(this.args.getControllerId());
        ordersFilter.getStates().add(OrderStateText.fromValue((String)state));
        if (this.args.getPersistDuration() != null && OrderStateText.fromValue((String)state).equals((Object)OrderStateText.FAILED)) {
            ordersFilter.setStateDateFrom(this.args.getPersistDuration());
        }
        return ordersFilter;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws Exception {
        HashMap<String, OrdersV> resultsets = new HashMap<String, OrdersV>();
        ApiExecutor apiExecutor = new ApiExecutor(this.step);
        apiExecutor.setJobResources(this.jobResources);
        String accessToken = null;
        ArrayList listOfOrders = new ArrayList();
        try {
            ApiResponse apiResponse = apiExecutor.login();
            accessToken = apiResponse.getAccessToken();
            OrderStateWebserviceExecuter orderStateWebserviceExecuter = new OrderStateWebserviceExecuter((ISOSLogger)this.step.getLogger(), apiExecutor);
            for (String string : this.args.getStates()) {
                if (this.args.getWorkflowSearchPattern() != null && this.args.getWorkflowSearchPattern().size() > 0) {
                    for (String string2 : this.args.getWorkflowSearchPattern()) {
                        OrdersFilterV ordersFilter = this.newOrdersFilterV(string);
                        ordersFilter.setRegex(OrderStateTransition.convertGlobToRegex(string2));
                        OrdersV list = orderStateWebserviceExecuter.getOrders(ordersFilter, accessToken);
                        if (list == null) continue;
                        listOfOrders.addAll(list.getOrders());
                    }
                }
                if (this.args.getOrderSearchPatterns() != null && this.args.getOrderSearchPatterns().size() > 0) {
                    for (String string3 : this.args.getOrderSearchPatterns()) {
                        void var10_19;
                        if (!string3.startsWith("/")) {
                            String string4 = "/" + string3;
                        }
                        String[] p = var10_19.split("/");
                        Object orderName = p[p.length - 1];
                        p[p.length - 1] = orderName = "#*#*-" + (String)orderName;
                        String string5 = OrderStateTransition.convertStringArrayToString(p, "/");
                        OrdersFilterV ordersFilter = this.newOrdersFilterV(string);
                        ordersFilter.setRegex(OrderStateTransition.convertGlobToRegex(string5));
                        OrdersV list = orderStateWebserviceExecuter.getOrders(ordersFilter, accessToken);
                        if (list == null) continue;
                        listOfOrders.addAll(list.getOrders());
                    }
                }
                OrdersFilterV ordersFilter = this.newOrdersFilterV(string);
                for (String folderName : this.args.getWorkflowFolders()) {
                    Folder f = new Folder();
                    boolean recursive = false;
                    if (folderName.endsWith("/*")) {
                        if ((folderName = folderName.substring(0, folderName.length() - 2)).isEmpty()) {
                            folderName = "/";
                        }
                        recursive = true;
                    }
                    f.setFolder(folderName);
                    f.setRecursive(Boolean.valueOf(recursive));
                    ordersFilter.getFolders().add(f);
                }
                OrdersV ordersV = orderStateWebserviceExecuter.getOrders(ordersFilter, accessToken);
                if (ordersV == null) continue;
                resultsets.put(string, ordersV);
            }
            for (Map.Entry entry : resultsets.entrySet()) {
                OrdersV list = (OrdersV)entry.getValue();
                String string = (String)entry.getKey();
                ConcurrentHashMap<String, OrderV> mapOfOrders = new ConcurrentHashMap<String, OrderV>();
                for (OrderV order : list.getOrders()) {
                    mapOfOrders.put(order.getOrderId(), order);
                }
                this.step.getLogger().info((Object)(mapOfOrders.size() + " " + string.toLowerCase() + " orders found"));
                ModifyOrders modifyOrders = new ModifyOrders();
                modifyOrders.setControllerId(this.args.getControllerId());
                int count = mapOfOrders.size();
                String action = this.args.getTransition().toLowerCase();
                do {
                    for (OrderV order : mapOfOrders.values()) {
                        modifyOrders.getOrderIds().add(order.getOrderId());
                        mapOfOrders.remove(order.getOrderId());
                        if (modifyOrders.getOrderIds().size() < this.args.getBatchSize()) continue;
                        break;
                    }
                    count -= modifyOrders.getOrderIds().size();
                    this.step.getLogger().info((Object)" ");
                    switch (this.args.getTransition()) {
                        case "CANCEL": 
                        case "CANCELLED": {
                            orderStateWebserviceExecuter.cancelOrders(modifyOrders, accessToken);
                            break;
                        }
                        case "SUSPEND": {
                            if (OrderStateText.fromValue((String)string).equals((Object)OrderStateText.FAILED) || OrderStateText.fromValue((String)string).equals((Object)OrderStateText.FINISHED)) break;
                            orderStateWebserviceExecuter.suspendOrders(modifyOrders, accessToken);
                            break;
                        }
                        case "INPROGRESS": 
                        case "CONTINUE": {
                            if (OrderStateText.fromValue((String)string).equals((Object)OrderStateText.PROMPTING)) {
                                orderStateWebserviceExecuter.confirmOrders(modifyOrders, accessToken);
                                break;
                            }
                            if (!OrderStateText.fromValue((String)string).equals((Object)OrderStateText.FAILED) && !OrderStateText.fromValue((String)string).equals((Object)OrderStateText.SUSPENDED)) break;
                            orderStateWebserviceExecuter.resumeOrders(modifyOrders, accessToken);
                            break;
                        }
                    }
                    this.step.getLogger().info((Object)(modifyOrders.getOrderIds().size() + " orders " + action));
                    for (String order : modifyOrders.getOrderIds()) {
                        this.step.getLogger().info((Object)(order + " " + action));
                    }
                    modifyOrders.getOrderIds().clear();
                } while (count > 0);
            }
        }
        catch (Exception e) {
            this.step.getLogger().error((Throwable)e);
            throw e;
        }
        finally {
            if (accessToken != null) {
                apiExecutor.logout(accessToken);
            }
            apiExecutor.close();
        }
    }

    private static String convertStringArrayToString(String[] strArr, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (String str : strArr) {
            sb.append(str).append(delimiter);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static final String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

