/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.exception.JobArgumentException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class ReturnVariableUtils {
    public static void checkDuplicateReturnVariable(JsonNode returnVars) throws JobArgumentException {
        HashSet<String> seenNames = new HashSet<String>();
        for (JsonNode node : returnVars) {
            String varName;
            if (!node.hasNonNull("name") || (varName = node.get("name").asText().trim()).isEmpty() || seenNames.add(varName)) continue;
            throw new JobArgumentException("Duplicate return_variable 'name' found: " + varName);
        }
    }

    public static List<JsonNode> runJqQuery(JsonNode mergedInput, String jqQuery, Scope rootScope, String name) throws JsonQueryException, JobArgumentException {
        JsonQuery query = JsonQuery.compile((String)jqQuery, (Version)Versions.JQ_1_7);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        query.apply(rootScope, mergedInput, out::add);
        if (out.isEmpty() || out.stream().allMatch(JsonNode::isNull)) {
            throw new JobArgumentException("Error in extracting return variable " + name + " from jq Query " + jqQuery);
        }
        return out;
    }

    public static <T extends JobArguments> void writeToFile(OrderProcessStep<T> step, OrderProcessStepLogger logger, String name, String filePath, String pI, List<JsonNode> out, boolean rawOutput, ObjectMapper objectMapper) throws IOException, JobArgumentException {
        if (name.equals("returnCode")) {
            JsonNode node = out.get(0);
            if (node != null && !node.isNull()) {
                String value = node.asText();
                try {
                    int returnCode = Integer.parseInt(value);
                    step.getOutcome().setReturnCode(Integer.valueOf(returnCode));
                }
                catch (NumberFormatException e) {
                    throw new JobArgumentException("Return variable 'returnCode' cannot be set as job return code: value '" + value + "' is not numeric.");
                }
            } else {
                throw new JobArgumentException("Return variable 'returnCode' cannot be set as job's return code.");
            }
        }
        if (filePath != null) {
            File file = new File(filePath);
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            boolean append = ">>".equals(pI);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, append));){
                for (JsonNode outputNode : out) {
                    if (rawOutput && outputNode.isTextual()) {
                        writer.write(outputNode.asText());
                    } else {
                        writer.write(objectMapper.writeValueAsString((Object)outputNode));
                    }
                    writer.newLine();
                }
            }
            logger.info((Object)"Result written to file successfully.");
            step.getOutcome().getVariables().put(name, filePath);
            logger.info((Object)("Assigned return variable: " + name + " = " + filePath));
        } else if (rawOutput && out.size() == 1 && out.get(0).isTextual()) {
            String raw = out.get(0).asText();
            step.getOutcome().getVariables().put(name, raw);
            logger.info((Object)("Assigned return variable: " + name + " = " + raw));
        } else {
            JsonNode resultNode = out.size() == 1 ? out.get(0) : objectMapper.valueToTree(out);
            String resultPretty = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resultNode);
            step.getOutcome().getVariables().put(name, resultPretty);
            logger.info((Object)("Assigned return variable: " + name + " = " + resultPretty));
        }
    }

    public static <T extends JobArguments> void writeToFile(OrderProcessStep<T> step, OrderProcessStepLogger logger, String name, String filePath, String pI, String result, boolean rawOutput, ObjectMapper objectMapper) throws IOException, JobArgumentException {
        if (name.equals("returnCode")) {
            try {
                int returnCode = Integer.parseInt(result);
                step.getOutcome().setReturnCode(Integer.valueOf(returnCode));
            }
            catch (NumberFormatException e) {
                throw new JobArgumentException("Return variable 'returnCode' cannot be set as job return code: value '" + result + "' is not numeric.");
            }
        }
        if (filePath != null) {
            File file = new File(filePath);
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            boolean append = ">>".equals(pI);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, append));){
                if (rawOutput && !result.isEmpty()) {
                    writer.write(result);
                } else {
                    writer.write(objectMapper.writeValueAsString((Object)result));
                }
                writer.newLine();
            }
            logger.info((Object)"Result written to file successfully.");
            step.getOutcome().getVariables().put(name, filePath);
            logger.info((Object)("Assigned return variable: " + name + " = " + filePath));
        } else if (rawOutput && !result.isEmpty()) {
            step.getOutcome().getVariables().put(name, result);
            logger.info((Object)("Assigned return variable: " + name + " = " + result));
        } else {
            step.getOutcome().getVariables().put(name, result);
            logger.info((Object)("Assigned return variable: " + name + " = " + result));
        }
    }

    public static List<String> parseInputOptions(String inputOption) {
        ArrayList<String> options = new ArrayList<String>();
        if (inputOption == null || inputOption.trim().isEmpty()) {
            return options;
        }
        int i = 0;
        String[] tokens = inputOption.trim().split("\\s+");
        while (i < tokens.length) {
            String token = tokens[i];
            if (token.startsWith("--from-json=")) {
                if (token.contains("'")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(token);
                    ++i;
                    while (i < tokens.length && !tokens[i].endsWith("'")) {
                        sb.append(" ").append(tokens[i]);
                        ++i;
                    }
                    if (i < tokens.length) {
                        sb.append(" ").append(tokens[i]);
                        ++i;
                    }
                    options.add(sb.toString());
                    continue;
                }
                options.add(token);
                ++i;
                continue;
            }
            options.add(token);
            ++i;
        }
        return options;
    }
}

