/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.sap;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.sos.commons.exception.SOSException;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.sap.common.CommonJobArguments;
import com.sos.jitl.jobs.sap.common.Globals;
import com.sos.jitl.jobs.sap.common.HttpClient;
import com.sos.jitl.jobs.sap.common.bean.ResponseSchedule;
import com.sos.jitl.jobs.sap.common.bean.RunIds;
import com.sos.jitl.jobs.sap.common.bean.ScheduleDescription;
import com.sos.jitl.jobs.sap.common.bean.ScheduleLog;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class SAPS4HANARecoverSchedule
extends Job<CommonJobArguments> {
    public SAPS4HANARecoverSchedule(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<CommonJobArguments> step) throws Exception {
        OrderProcessStepLogger logger = step.getLogger();
        CommonJobArguments args = (CommonJobArguments)step.getDeclaredArguments();
        Predicate<Path> fileFilter = p -> p.getFileName().toString().endsWith(".json") && Files.isRegularFile(p, new LinkOption[0]);
        Set statusFiles = Files.walk(Globals.getStatusFileDirectory(args), new FileVisitOption[0]).filter(fileFilter).collect(Collectors.toSet());
        if (statusFiles.isEmpty()) {
            logger.info((Object)"Nothing to do");
        } else {
            HttpClient httpClient = new HttpClient(args, (ISOSLogger)logger);
            for (Path statusFile : statusFiles) {
                try {
                    RunIds runIds = null;
                    try {
                        runIds = (RunIds)Globals.objectMapper.readValue(Files.readAllBytes(statusFile), RunIds.class);
                    }
                    catch (Exception e) {
                        logger.warn("File '%s' is corrupt: %s", new Object[]{statusFile.getFileName().toString(), e.toString()});
                        Files.deleteIfExists(statusFile);
                    }
                    if (runIds == null) continue;
                    if (httpClient == null) {
                        httpClient = new HttpClient(args, (ISOSLogger)logger);
                    }
                    ScheduleDescription desc = Globals.parseFilename(statusFile.getFileName().toString());
                    logger.info((Object)("**************************\n...checking Schedule of " + desc.string()));
                    if (!SAPS4HANARecoverSchedule.checkSchedule(runIds, desc, httpClient, (ISOSLogger)logger)) continue;
                    Globals.cleanUpSchedule(runIds, httpClient);
                    Files.deleteIfExists(statusFile);
                }
                catch (Exception e) {
                    logger.warn(statusFile.getFileName().toString(), (Throwable)e);
                }
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        step.getOutcome().setReturnCode(Integer.valueOf(0));
    }

    private static boolean checkSchedule(RunIds runIds, ScheduleDescription desc, HttpClient httpClient, ISOSLogger logger) throws SOSException, JsonParseException, JsonMappingException, IOException {
        ScheduleLog scheduleLog = new ScheduleLog().withRunStatus("UNKNOWN");
        try {
            ResponseSchedule respSchedule = httpClient.retrieveSchedule(runIds.getJobId(), runIds.getScheduleId());
            if (respSchedule.getLogs().isEmpty()) {
                logger.warn((Object)"No run log exists. Schedule will be deleted.");
                return true;
            }
            try {
                desc = (ScheduleDescription)Globals.objectMapper.readValue(respSchedule.getDescription(), ScheduleDescription.class);
            }
            catch (Exception e) {
                logger.warn((Object)("Error at reading the Schedule's description: " + e.toString()));
            }
            scheduleLog = respSchedule.getLogs().get(0);
            if ("COMPLETED".equals(scheduleLog.getRunStatus())) {
                logger.info((Object)Globals.objectMapperPrettyPrint.writeValueAsString((Object)scheduleLog));
                return true;
            }
            if ("SCHEDULED".equals(scheduleLog.getRunStatus())) {
                logger.info("RunStatus '%s': %s", new Object[]{scheduleLog.getRunStatus(), scheduleLog.getAdditionalProperties().get("scheduledTimestamp")});
                if (respSchedule.getActive() != Boolean.TRUE) {
                    Instant now = Instant.now();
                    Long created = desc.getCreated();
                    if (created == null) {
                        logger.info((Object)"Schedule is inactive and will be deleted because no created information exists");
                        return true;
                    }
                    if (Instant.ofEpochMilli(created).plus(Duration.ofDays(1L)).isBefore(now)) {
                        logger.info((Object)"Schedule is inactive and will be deleted because it is older than one day.");
                        return true;
                    }
                    logger.info("Schedule is inactive and won't be deleted because it is younger than one day. Maybe the Order '%s' will be resummed.", new Object[]{desc.getOrderId()});
                }
            } else {
                logger.info("RunStatus '%s'", new Object[]{scheduleLog.getRunStatus()});
            }
        }
        catch (SOSBadRequestException e) {
            if (404 == e.getHttpCode()) {
                logger.warn("Schedule (jobId=%d, scheduleId=%s) is already deleted", new Object[]{runIds.getJobId(), runIds.getScheduleId()});
                return true;
            }
        }
        catch (Exception e) {
            throw new SOSException((Throwable)e);
        }
        return false;
    }
}

