/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.sap.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.sos.commons.exception.SOSException;
import com.sos.commons.httpclient.BaseHttpClient;
import com.sos.commons.httpclient.commons.HttpExecutionResult;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.httpclient.exception.SOSSSLException;
import com.sos.commons.sign.keys.keyStore.KeystoreType;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.http.HttpUtils;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.jitl.jobs.sap.common.CommonJobArguments;
import com.sos.jitl.jobs.sap.common.Globals;
import com.sos.jitl.jobs.sap.common.bean.Job;
import com.sos.jitl.jobs.sap.common.bean.ResponseJob;
import com.sos.jitl.jobs.sap.common.bean.ResponseJobs;
import com.sos.jitl.jobs.sap.common.bean.ResponseSchedule;
import com.sos.jitl.jobs.sap.common.bean.Schedule;
import com.sos.jitl.jobs.sap.common.bean.ScheduleLog;
import com.sos.js7.job.exception.JobArgumentException;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class HttpClient {
    private static final String csrfTokenHeaderKey = "X-CSRF-Token";
    private static final String sapClientQueryKey = "sap-client";
    private final ISOSLogger logger;
    private final URI uri;
    private final String sapClient;
    private BaseHttpClient client;
    private BaseHttpClient.Builder baseHttpClientBuilder;
    private String csrfToken = null;
    private List<String> cookies;

    public HttpClient(CommonJobArguments jobArgs, ISOSLogger logger) throws JobArgumentException, KeyStoreException, NoSuchAlgorithmException, CertificateException, SOSSSLException, IOException, KeyManagementException {
        this.uri = (URI)jobArgs.getUri().getValue();
        this.sapClient = (String)jobArgs.getMandant().getValue();
        this.logger = logger;
        this.initHttpClientBuilder(jobArgs);
    }

    public String fetchCSRFToken() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put(csrfTokenHeaderKey, "fetch");
        if (this.cookies != null) {
            this.addCookieHeader(requestHeaders);
        }
        URI uri = this.setUriPath();
        this.logger.info("Fetch token: GET '%s'", new Object[]{uri});
        this.createClient();
        HttpExecutionResult result = this.client.executeGET(uri, requestHeaders, HttpResponse.BodyHandlers.ofByteArray());
        String token = result.response().headers().firstValue(csrfTokenHeaderKey).orElse(null);
        int httpReplyCode = result.response().statusCode();
        if (httpReplyCode != 200) {
            String errorMessage = this.getErrorMessage(result.response());
            this.logger.warn("%d %s%s", new Object[]{httpReplyCode, HttpUtils.getReasonPhrase((int)httpReplyCode), errorMessage.isEmpty() ? "" : ": " + errorMessage});
        }
        if (token != null) {
            this.csrfToken = token;
            return token;
        }
        throw new SOSBadRequestException(httpReplyCode, "Response-Header X-CSRF-Token is missing");
    }

    public ResponseJobs retrieveJobs() throws Exception {
        return this.retrieveJobs(null, null);
    }

    public ResponseJobs retrieveJobs(Integer pageSize, Integer offset) throws Exception {
        if (pageSize == null) {
            pageSize = 10;
        }
        if (offset == null) {
            offset = 1;
        }
        HashMap<String, Object> queryParameter = new HashMap<String, Object>(2);
        queryParameter.put("pageSize", pageSize);
        queryParameter.put("offset", offset);
        URI url = this.setUriPath("scheduler/jobs", null, queryParameter);
        this.logger.info("Retrieve Jobs: GET '%s'", new Object[]{url.toString()});
        return this.getJsonObject(HTTP_METHOD.GET, url, null, ResponseJobs.class);
    }

    public ResponseJob createJob(Job body) throws Exception {
        return this.createJob(Globals.objectMapper.writeValueAsBytes((Object)body));
    }

    public <B> ResponseJob createJob(B body) throws Exception {
        if (body == null) {
            throw new JobArgumentException("Request body is missing");
        }
        URI url = this.setUriPath("scheduler/jobs");
        this.logger.info("Create Job: POST '%s'", new Object[]{url.toString()});
        return this.getJsonObject(HTTP_METHOD.POST, url, body, ResponseJob.class);
    }

    public ResponseJob retrieveJob(Long jobId, String jobName) throws Exception {
        URI url = null;
        if (jobId != null) {
            HashMap<String, Object> uriParameter = new HashMap<String, Object>(1);
            uriParameter.put("jobId", jobId);
            HashMap<String, Object> queryParameter = new HashMap<String, Object>(1);
            queryParameter.put("displaySchedules", true);
            url = this.setUriPath("scheduler/jobs/{jobId}", uriParameter, queryParameter);
        } else if (jobName != null && !jobName.isEmpty()) {
            HashMap<String, Object> queryParameter = new HashMap<String, Object>(2);
            queryParameter.put("name", jobName);
            queryParameter.put("displaySchedules", true);
            url = this.setUriPath("scheduler/jobs", null, queryParameter);
        } else {
            throw new JobArgumentException("jobId and jobName are missing");
        }
        this.logger.info("Retrieve Job: GET '%s'", new Object[]{url.toString()});
        return this.getJsonObject(HTTP_METHOD.GET, url, null, ResponseJob.class);
    }

    public boolean deleteJob(Long jobId) throws SocketException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(1);
        uriParameter.put("jobId", jobId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}", uriParameter);
        this.logger.info("Delete Job: DELETE '%s'", new Object[]{url.toString()});
        try {
            this.getJson(HTTP_METHOD.DELETE, url, null);
        }
        catch (SOSBadRequestException e) {
            if (Arrays.asList(400, 404).contains(e.getHttpCode())) {
                this.logger.info("Job '%d' already deleted", new Object[]{jobId});
                return false;
            }
            throw e;
        }
        catch (Exception e) {
            throw new SOSBadRequestException((Throwable)e);
        }
        return true;
    }

    public ResponseSchedule createSchedule(Long jobId, Schedule body) throws Exception {
        return this.createSchedule(jobId, Globals.objectMapper.writeValueAsBytes((Object)body));
    }

    public <B> ResponseSchedule createSchedule(Long jobId, B body) throws Exception {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (body == null) {
            throw new JobArgumentException("Request body is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(1);
        uriParameter.put("jobId", jobId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules", uriParameter);
        this.logger.info("Create Schedule: POST '%s'", new Object[]{url.toString()});
        return this.getJsonObject(HTTP_METHOD.POST, url, body, ResponseSchedule.class);
    }

    public ResponseSchedule retrieveSchedule(Long jobId, String scheduleId) throws Exception {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(2);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        HashMap<String, Object> queryParameter = new HashMap<String, Object>(1);
        queryParameter.put("displayLogs", true);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}", uriParameter, queryParameter);
        this.logger.info("Retrieve Schedule: GET '%s'", new Object[]{url.toString()});
        return this.getJsonObject(HTTP_METHOD.GET, url, null, ResponseSchedule.class);
    }

    public ResponseSchedule activateSchedule(Long jobId, String scheduleId) throws Exception {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(2);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}", uriParameter);
        this.logger.info("Activate Schedule: PUT '%s'", new Object[]{url.toString()});
        return this.getJsonObject(HTTP_METHOD.PUT, url, Globals.objectMapper.writeValueAsBytes((Object)new Schedule().withActive(true)), ResponseSchedule.class);
    }

    public ScheduleLog retrieveScheduleLog(Long jobId, String scheduleId, String runId) throws Exception {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        if (runId == null) {
            throw new JobArgumentException("runId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(3);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        uriParameter.put("runId", runId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}/runs/{runId}", uriParameter);
        this.logger.info("Retrieve Schedule Run Log: GET '%s'", new Object[]{url.toString()});
        return this.getJsonObject(HTTP_METHOD.GET, url, null, ScheduleLog.class);
    }

    public boolean deleteSchedule(Long jobId, String scheduleId) throws SocketException, SOSException {
        if (jobId == null) {
            throw new JobArgumentException("jobId is missing");
        }
        if (scheduleId == null) {
            throw new JobArgumentException("scheduleId is missing");
        }
        HashMap<String, Object> uriParameter = new HashMap<String, Object>(2);
        uriParameter.put("jobId", jobId);
        uriParameter.put("scheduleId", scheduleId);
        URI url = this.setUriPath("scheduler/jobs/{jobId}/schedules/{scheduleId}", uriParameter);
        this.logger.info("Delete Schedule: DELETE '%s'", new Object[]{url.toString()});
        try {
            this.getJson(HTTP_METHOD.DELETE, url, null);
        }
        catch (SOSBadRequestException e) {
            if (Arrays.asList(400, 404).contains(e.getHttpCode())) {
                this.logger.info("Schedule '%d/%s' already deleted", new Object[]{jobId, scheduleId});
                return false;
            }
            throw e;
        }
        catch (Exception e) {
            throw new SOSBadRequestException((Throwable)e);
        }
        return true;
    }

    private static KeyStore readTruststore(CommonJobArguments jobArgs) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, JobArgumentException {
        if (jobArgs.getTruststorePath().getValue() == null) {
            return null;
        }
        Path truststorePath = (Path)jobArgs.getTruststorePath().getValue();
        if (Files.exists(truststorePath, new LinkOption[0])) {
            KeyStore keyStore;
            block10: {
                KeyStore truststore = KeyStore.getInstance(((KeystoreType)jobArgs.getTruststoreType().getValue()).value());
                InputStream in = Files.newInputStream(truststorePath, new OpenOption[0]);
                try {
                    truststore.load(in, ((String)jobArgs.getTruststorePwd().getValue()).toCharArray());
                    keyStore = truststore;
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return keyStore;
        }
        throw new JobArgumentException(String.format("truststore (%1$s) not found.", truststorePath.toString()));
    }

    private URI setUriPath() {
        return this.setUriPath(null, null, null);
    }

    private URI setUriPath(String path) {
        return this.setUriPath(path, null, null);
    }

    private URI setUriPath(String path, Map<String, Object> uriParameter) {
        return this.setUriPath(path, uriParameter, null);
    }

    private URI setUriPath(String path, Map<String, Object> uriParameter, Map<String, Object> queryParameter) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.uri);
        if (path != null) {
            uriBuilder.path(path);
        }
        if (this.sapClient != null) {
            uriBuilder.queryParam(sapClientQueryKey, new Object[]{this.sapClient});
        }
        if (queryParameter != null) {
            queryParameter.forEach((k, v) -> uriBuilder.queryParam(k, new Object[]{v}));
        }
        if (uriParameter != null) {
            return uriBuilder.buildFromEncodedMap(uriParameter);
        }
        return uriBuilder.build(new Object[0]);
    }

    private <T, B> T getJsonObject(HTTP_METHOD method, URI uri, B postBody, Class<T> clazz) throws Exception {
        return this.getJsonObject(this.getJson(method, uri, postBody), clazz);
    }

    public <T, B> HttpExecutionResult<T> executeRestService(HTTP_METHOD method, URI uri, Map<String, String> requestHeaders, B body, HttpResponse.BodyHandler<T> handler) throws Exception {
        HttpExecutionResult result = null;
        switch (method) {
            case GET: {
                result = this.client.executeGET(uri, requestHeaders, handler);
                break;
            }
            case POST: {
                result = this.client.executePOST(uri, requestHeaders, this.getBodyPublisher(body), handler);
                break;
            }
            case PUT: {
                result = this.client.executePUT(uri, requestHeaders, this.getBodyPublisher(body), handler);
                break;
            }
            case DELETE: {
                result = this.client.executeDELETE(uri, requestHeaders, handler);
            }
        }
        if (result != null) {
            this.addCookies(result);
        }
        return result;
    }

    private <T> void addCookies(HttpExecutionResult<T> result) {
        List<String> set_cookie_HeaderValues = result.response().headers().allValues("set-cookie");
        if (set_cookie_HeaderValues != null) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<String>();
            }
            this.cookies.addAll(set_cookie_HeaderValues);
        }
    }

    private <B> HttpRequest.BodyPublisher getBodyPublisher(B body) {
        HttpRequest.BodyPublisher bodyPublisher = body != null ? (body instanceof String ? HttpRequest.BodyPublishers.ofString((String)body) : (body instanceof byte[] ? HttpRequest.BodyPublishers.ofByteArray((byte[])body) : HttpRequest.BodyPublishers.noBody())) : HttpRequest.BodyPublishers.noBody();
        return bodyPublisher;
    }

    private <B> byte[] getJson(HTTP_METHOD method, URI uri, B postBody) throws SOSException, Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (HTTP_METHOD.POST.equals((Object)method) || HTTP_METHOD.PUT.equals((Object)method)) {
            requestHeaders.put("Content-Type", "application/json");
        }
        requestHeaders.put("Accept", "application/json");
        if (this.csrfToken != null) {
            requestHeaders.put(csrfTokenHeaderKey, this.csrfToken);
        }
        if (this.cookies != null) {
            this.addCookieHeader(requestHeaders);
        }
        this.createClient();
        return this.getJsonFromResponse(this.executeRestService(method, uri, requestHeaders, postBody, HttpResponse.BodyHandlers.ofByteArray()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends JsonStructure, B> T getJsonStructure(byte[] jsonStr) {
        if (jsonStr == null) return null;
        try {
            StringReader reader = new StringReader(new String(jsonStr, StandardCharsets.UTF_8));
            try (JsonReader rdr = Json.createReader((Reader)reader);){
                JsonStructure jsonStructure = rdr.read();
                return (T)jsonStructure;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private <T> T getJsonObject(byte[] jsonStr, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        if (jsonStr == null) {
            return null;
        }
        return (T)Globals.objectMapper.readValue(jsonStr, clazz);
    }

    private byte[] getJsonFromResponse(HttpExecutionResult<byte[]> result) throws SOSBadRequestException {
        int httpReplyCode = result.response().statusCode();
        switch (httpReplyCode) {
            case 200: 
            case 201: {
                if (this.logger.isDebugEnabled() && result.response().body() != null) {
                    this.logger.debug("Response Body: %s", new Object[]{new String((byte[])result.response().body(), StandardCharsets.UTF_8)});
                }
                return (byte[])result.response().body();
            }
        }
        String errorMessage = this.getErrorMessage(result.response());
        throw new SOSBadRequestException(httpReplyCode, String.format("%d %s%s", httpReplyCode, HttpUtils.getReasonPhrase((int)httpReplyCode), errorMessage.isEmpty() ? "" : ": " + errorMessage));
    }

    private String getErrorMessage(HttpResponse<byte[]> response) {
        JsonObject err;
        String contentType = response.headers().firstValue("Content-Type").orElse(null);
        if (contentType != null && contentType.contains("application/json") && (err = (JsonObject)this.getJsonStructure(response.body())) != null) {
            try {
                return err.getJsonObject("error").getJsonObject("message").getString("value", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    private void initHttpClientBuilder(CommonJobArguments jobArgs) throws JobArgumentException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException {
        this.baseHttpClientBuilder = BaseHttpClient.withBuilder();
        this.baseHttpClientBuilder.withConnectTimeout(Duration.ofSeconds((Long)jobArgs.getConnectionTimeout().getValue()));
        this.baseHttpClientBuilder.withLogger(this.logger);
        KeyStore trustStore = HttpClient.readTruststore(jobArgs);
        if (trustStore != null) {
            this.baseHttpClientBuilder.withSSLContext(HttpClient.createSslContext(trustStore));
        }
        if (jobArgs.getUri().toString().startsWith("https:") && trustStore == null) {
            if (jobArgs.getTruststorePath().getValue() != null) {
                throw new JobArgumentException(String.format("truststore (%1$s) not found.", ((Path)jobArgs.getTruststorePath().getValue()).toString()));
            }
            throw new JobArgumentException("Couldn't find required truststore");
        }
        this.baseHttpClientBuilder.withAuth((String)jobArgs.getUser().getValue(), (String)jobArgs.getPwd().getValue());
    }

    public static SSLContext createSslContext(KeyStore sslTrustore) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(sslTrustore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, factory.getTrustManagers(), null);
        return sslContext;
    }

    private BaseHttpClient createClient() throws Exception {
        if (this.client == null) {
            this.client = (BaseHttpClient)this.baseHttpClientBuilder.build();
        }
        return this.client;
    }

    private void addCookieHeader(Map<String, String> headers) {
        headers.put("Cookie", String.join((CharSequence)"; ", this.cookies));
    }

    public void close() {
        if (this.client != null) {
            SOSClassUtil.closeQuietly((AutoCloseable)this.client);
            this.client = null;
        }
    }

    private static enum HTTP_METHOD {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

