/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Icon;

public interface Entry<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon> {
    public static final String STANDARD_PROPERTY_NAME_USER_NAME = "UserName";
    public static final String STANDARD_PROPERTY_NAME_PASSWORD = "Password";
    public static final String STANDARD_PROPERTY_NAME_URL = "URL";
    public static final String STANDARD_PROPERTY_NAME_TITLE = "Title";
    public static final String STANDARD_PROPERTY_NAME_NOTES = "Notes";
    public static final List<String> STANDARD_PROPERTY_NAMES = Collections.unmodifiableList(Arrays.asList("UserName", "Password", "URL", "Title", "Notes"));

    public boolean match(String var1);

    public boolean match(Matcher var1);

    public String getPath();

    public String getProperty(String var1);

    public void setProperty(String var1, String var2);

    public boolean removeProperty(String var1) throws IllegalArgumentException, UnsupportedOperationException;

    public List<String> getPropertyNames();

    public byte[] getBinaryProperty(String var1);

    public void setBinaryProperty(String var1, byte[] var2);

    public boolean removeBinaryProperty(String var1) throws UnsupportedOperationException;

    public List<String> getBinaryPropertyNames();

    @Nullable
    public G getParent();

    @NotNull
    public UUID getUuid();

    public String getUsername();

    public void setUsername(String var1);

    public boolean matchUsername(String var1);

    public String getPassword();

    public void setPassword(String var1);

    public String getUrl();

    public void setUrl(String var1);

    public boolean matchUrl(String var1);

    public String getTitle();

    public void setTitle(String var1);

    public boolean matchTitle(String var1);

    public String getNotes();

    public void setNotes(String var1);

    public boolean matchNotes(String var1);

    public I getIcon();

    public void setIcon(I var1);

    public Date getLastAccessTime();

    public Date getCreationTime();

    public boolean getExpires();

    public void setExpires(boolean var1);

    public Date getExpiryTime();

    public void setExpiryTime(Date var1) throws IllegalArgumentException;

    public Date getLastModificationTime();

    public static interface Matcher {
        public boolean matches(Entry var1);
    }
}

