/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.scriptengine.jobs;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import com.sos.commons.credentialstore.CredentialStoreArguments;
import com.sos.commons.util.SOSShell;
import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.keystore.KeyStoreArguments;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.js7.job.Job;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.JobHelper;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.exception.JobArgumentException;
import com.sos.js7.scriptengine.json.GraalJSScriptEngineOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import js7.launcher.forjava.internal.BlockingInternalJob;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;

public class JavaScriptJob
extends Job<JobArguments> {
    public static final String JS7_GRAALVM_JS_OPTION = "js7_options.graalvm.js";
    private static final String SCRIPT_ENGINE_NAME = "Graal.js";
    private static final String GRAALVM_SCRIPT_ENGINE_NAME = "js";
    private static final String BASIC_SCRIPT_RESOURCE = JavaScriptJob.class.getSimpleName() + ".js";
    private static final String FUNCTION_NAME_GET_JOB = "getJS7Job";
    private static final String JOB_METHOD_GET_DECLARED_ARGUMENTS = "getDeclaredArguments";
    private static final String JOB_METHOD_PROCESS_ORDER = "processOrder";
    private static final Map<String, String> INCLUDABLE_ARGUMENTS = Stream.of({"CREDENTIAL_STORE", CredentialStoreArguments.class.getName()}, {"PROXY", ProxyConfigArguments.class.getName()}, {"KEY_STORE", KeyStoreArguments.class.getName()}, {"SSH_PROVIDER", SSHProviderArguments.class.getName()}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
    private static volatile String BASIC_SCRIPT;
    private String script;
    private JobArguments declaredArguments;

    public JavaScriptJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
        if (jobContext != null) {
            this.script = jobContext.asScala().executable().script();
        }
    }

    public void onStart() throws Exception {
        this.setBasicScript();
        ScriptEngine engine = this.createScriptEngine();
        engine.eval(BASIC_SCRIPT + "\n" + this.script);
        Invocable invocable = (Invocable)((Object)engine);
        Object job = invocable.invokeFunction(FUNCTION_NAME_GET_JOB, this.getJobEnvironment());
        this.declaredArguments = this.getDeclaredArguments(invocable.invokeMethod(job, JOB_METHOD_GET_DECLARED_ARGUMENTS, new Object[0]));
    }

    public JobArguments onCreateJobArguments(List<JobArgumentException> exceptions, OrderProcessStep<JobArguments> step) {
        return this.declaredArguments;
    }

    public void processOrder(OrderProcessStep<JobArguments> step) throws Exception {
        ScriptEngine engine = this.createGraalJSScriptEngine(step);
        engine.eval(BASIC_SCRIPT + "\n" + this.script);
        Invocable invocable = (Invocable)((Object)engine);
        Object job = invocable.invokeFunction(FUNCTION_NAME_GET_JOB, this.getJobEnvironment());
        invocable.invokeMethod(job, JOB_METHOD_PROCESS_ORDER, step);
    }

    private JobArguments getDeclaredArguments(Object args) throws Exception {
        if (args == null) {
            return new JobArguments();
        }
        Map m = (Map)args;
        ArrayList l = new ArrayList();
        ArrayList included = new ArrayList();
        m.entrySet().stream().forEach(e -> {
            Map v;
            if (((String)e.getKey()).equals("includedArguments") && e.getValue() instanceof List) {
                List vl = (List)e.getValue();
                for (String n : vl) {
                    try {
                        included.add((ASOSArguments)Class.forName(INCLUDABLE_ARGUMENTS.get(n)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Throwable throwable) {}
                }
            } else if (e.getValue() instanceof Map && (v = (Map)e.getValue()).containsKey("name") && v.containsKey("required") && v.containsKey("defaultValue") && v.containsKey("displayMode")) {
                Object name = v.get("name");
                Object required = v.get("required");
                Object defaultValue = v.get("defaultValue");
                Object displayMode = v.get("displayMode");
                JobArgument ja = new JobArgument(name.toString(), Boolean.parseBoolean(required.toString()));
                if (defaultValue != null) {
                    ja.setDefaultValue(defaultValue);
                }
                if (displayMode != null) {
                    ja.setDisplayMode(SOSArgument.DisplayMode.valueOf((String)displayMode.toString().toUpperCase()));
                }
                ja.setIsDirty(false);
                l.add(ja);
            }
        });
        JobArguments jas = null;
        switch (included.size()) {
            case 1: {
                jas = new JobArguments(new ASOSArguments[]{(ASOSArguments)included.get(0)});
                break;
            }
            case 2: {
                jas = new JobArguments(new ASOSArguments[]{(ASOSArguments)included.get(0), (ASOSArguments)included.get(1)});
                break;
            }
            default: {
                jas = new JobArguments();
            }
        }
        jas.setDynamicArgumentFields(l);
        return jas;
    }

    private ScriptEngine createScriptEngine() throws Exception {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(SCRIPT_ENGINE_NAME);
        if (engine == null) {
            throw new Exception("ScriptEngine Graal.js not found");
        }
        Bindings bindings = engine.getBindings(100);
        bindings.put("polyglot.js.allowHostAccess", (Object)true);
        bindings.put("polyglot.js.allowHostClassLookup", (Object)true);
        bindings.put("polyglot.js.allowIO", (Object)true);
        return engine;
    }

    private ScriptEngine createGraalJSScriptEngine(OrderProcessStep<JobArguments> step) throws Exception {
        Context.Builder builder = Context.newBuilder((String[])new String[]{GRAALVM_SCRIPT_ENGINE_NAME}).allowIO(true).allowHostAccess(HostAccess.ALL).allowHostClassLookup(className -> true).allowExperimentalOptions(true);
        Map<String, String> options = this.getGraalJSScriptEngineOptions(step);
        if (options != null) {
            builder.options(options);
        }
        return GraalJSScriptEngine.create(null, (Context.Builder)builder);
    }

    private synchronized void setBasicScript() throws Exception {
        if (BASIC_SCRIPT == null) {
            BASIC_SCRIPT = this.inputStreamToString(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BASIC_SCRIPT_RESOURCE));
        }
    }

    private Map<String, String> getGraalJSScriptEngineOptions(OrderProcessStep<JobArguments> step) throws Exception {
        String p = step.getAllArgumentsAsNameValueMap().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(JS7_GRAALVM_JS_OPTION)).map(e -> e.getValue().toString()).findFirst().orElse(null);
        String method = "getGraalJSScriptEngineOptions";
        Map<String, String> options = null;
        if (SOSString.isEmpty((String)p)) {
            String jh = SOSShell.getJavaHome();
            if (SOSString.isEmpty((String)jh)) {
                if (step.getLogger().isDebugEnabled()) {
                    step.getLogger().debug((Object)String.format("[%s][java.home]is empty", method));
                }
            } else {
                Path np = null;
                try {
                    np = Paths.get(jh, new String[0]).resolve("bin").resolve("node_modules");
                    if (np.toFile().exists()) {
                        options = new HashMap<String, String>();
                        options.put("js.commonjs-require", "true");
                        options.put("js.commonjs-require-cwd", np.toString());
                        if (step.getLogger().isDebugEnabled()) {
                            step.getLogger().debug((Object)String.format("[%s]options=%s", method, options));
                        }
                    } else if (step.getLogger().isDebugEnabled()) {
                        step.getLogger().debug((Object)String.format("[%s][java.home=%s][%s]node_modules not found", method, jh, np));
                    }
                }
                catch (Throwable e2) {
                    step.getLogger().warn(String.format("[%s][java.home=%s][%s]%s", method, jh, np, e2.toString()), e2);
                }
            }
        } else {
            File f = new File(p);
            if (f.exists()) {
                GraalJSScriptEngineOptions o = (GraalJSScriptEngineOptions)JobHelper.OBJECT_MAPPER.readValue(f, GraalJSScriptEngineOptions.class);
                if (o != null && o.getOptions() != null) {
                    options = o.getOptions();
                }
                if (step.getLogger().isDebugEnabled()) {
                    step.getLogger().debug((Object)String.format("[%s][%s]options=%s", method, p, options));
                }
            } else {
                step.getLogger().warn((Object)String.format("[%s][%s=%s]file not found", method, JS7_GRAALVM_JS_OPTION, p));
            }
        }
        return options;
    }

    private String inputStreamToString(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString("UTF-8");
            return string;
        }
    }
}

