/*
 * Decompiled with CFR 0.152.
 */
package js7.agent.motor;

import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.Resource;
import cats.effect.std.Dispatcher;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.OptionIdOps$;
import cats.syntax.ParallelFoldMapAOps$;
import cats.syntax.ParallelTraversableOps1$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.ZoneId;
import javax.annotation.Nullable;
import js7.agent.configuration.AgentConfiguration;
import js7.agent.data.AgentState;
import js7.agent.motor.JobMotor;
import js7.agent.motor.JobMotor$;
import js7.agent.motor.JobMotorKeeper$;
import js7.agent.motor.JobMotorKeeper$processLimits$;
import js7.agent.motor.OrderMotor;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.io.process.ProcessSignal$SIGKILL$;
import js7.base.io.process.ProcessSignal$SIGTERM$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.monixutils.AsyncMap;
import js7.base.monixutils.AsyncMap$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.system.MBeanUtils$;
import js7.base.time.AlarmClock;
import js7.base.utils.Allocated;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.CatsUtils$syntax$RichResource$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.data.agent.AgentPath;
import js7.data.command.CancellationMode;
import js7.data.command.CancellationMode$FreshOrStarted$;
import js7.data.command.SuspensionMode;
import js7.data.command.SuspensionMode$;
import js7.data.item.VersionedItemId;
import js7.data.job.JobKey;
import js7.data.order.Order;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import js7.data.order.OrderMark;
import js7.data.order.OrderMark$Cancelling$;
import js7.data.order.OrderMark$Suspending$;
import js7.data.workflow.Workflow;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.instructions.executable.WorkflowJob;
import js7.data.workflow.position.WorkflowPosition;
import js7.subagent.director.SubagentKeeper;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.View;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.Enclosing$;
import sourcecode.Name$;

public final class JobMotorKeeper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JobMotorKeeper.class.getDeclaredField("processLimits$lzy1"));
    public final AgentPath js7$agent$motor$JobMotorKeeper$$agentPath;
    private final OrderMotor orderMotor;
    private final SubagentKeeper<AgentState> subagentKeeper;
    private final IO<AgentState> getAgentState;
    private final AgentConfiguration agentConf;
    private final AlarmClock x$6;
    private final Dispatcher<IO> x$7;
    public final AsyncMap<JobKey, Allocated<IO, JobMotor>> js7$agent$motor$JobMotorKeeper$$jobToMotor;
    private volatile Object processLimits$lzy1;

    public JobMotorKeeper(AgentPath agentPath, OrderMotor orderMotor, SubagentKeeper<AgentState> subagentKeeper, IO<AgentState> getAgentState, AgentConfiguration agentConf, AlarmClock x$6, Dispatcher<IO> x$7) {
        this.js7$agent$motor$JobMotorKeeper$$agentPath = agentPath;
        this.orderMotor = orderMotor;
        this.subagentKeeper = subagentKeeper;
        this.getAgentState = getAgentState;
        this.agentConf = agentConf;
        this.x$6 = x$6;
        this.x$7 = x$7;
        Tag evidence$1$proxy1 = Tag$.MODULE$.apply(JobKey.class, LightTypeTag$.MODULE$.parse(-228237535, "\u0004\u0000\u0001\u0013js7.data.job.JobKey\u0001\u0001", "\u0000\u0000\u0000", 30));
        Tag evidence$2$proxy1 = Tag$.MODULE$.apply(Allocated.class, LightTypeTag$.MODULE$.parse(1542746563, "\u0001\u0001\u0001\u0018js7.base.utils.Allocated\u0002\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\u0018js7.agent.motor.JobMotor\u0001\u0001\u0002\u0001", "\u0000\u0003\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0002\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0016cats.effect.IOPlatform\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001,js7.base.service.Service$.StoppableByRequest\u0001\u0002\u0003\u0000\u0000\u0018js7.base.service.Service\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001#js7.base.service.StoppableByRequest\u0001\u0001\u0004\u0000\u0001\u0018js7.agent.motor.JobMotor\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0001\u0002\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0003\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0002\u0003\u0000\u0000\u0090\u0006\u0001\u0001", 30));
        this.js7$agent$motor$JobMotorKeeper$$jobToMotor = AsyncMap$.MODULE$.empty(evidence$1$proxy1, evidence$2$proxy1);
        AsyncLock lock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.agent.motor.JobMotorKeeper#lock"));
    }

    public IO<BoxedUnit> stop() {
        return this.js7$agent$motor$JobMotorKeeper$$jobToMotor.removeAll(Enclosing$.MODULE$.apply("js7.agent.motor.JobMotorKeeper#stop")).flatMap((Function1 & Serializable)_$1 -> {
            Vector vector = (Vector)package.parallel$.MODULE$.catsSyntaxParallelFoldMapA((Object)_$1.values().toVector());
            return (IO)ParallelFoldMapAOps$.MODULE$.parFoldMapA$extension((Object)vector, (Function1 & Serializable)_$2 -> (IO)_$2.release(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForVector(), IO$.MODULE$.parallelForIO(), (Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit());
        });
    }

    public IO<BoxedUnit> startJobMotors(Workflow workflow) {
        return IO$.MODULE$.defer(() -> this.startJobMotors$$anonfun$1(workflow));
    }

    public IO<BoxedUnit> stopJobMotors(VersionedItemId<WorkflowPath> workflowId) {
        return this.js7$agent$motor$JobMotorKeeper$$jobToMotor.removeConditional((Function1<Tuple2<JobKey, Allocated<IO, JobMotor>>, Object>)(Function1 & Serializable)x$1 -> {
            JobKey jobKey = (JobKey)x$1._1();
            Allocated allocated = (Allocated)x$1._2();
            VersionedItemId<WorkflowPath> versionedItemId = jobKey.workflowId();
            VersionedItemId versionedItemId2 = workflowId;
            return !(versionedItemId != null ? !((Object)versionedItemId).equals(versionedItemId2) : versionedItemId2 != null);
        }, Enclosing$.MODULE$.apply("js7.agent.motor.JobMotorKeeper#stopJobMotors")).flatMap((Function1 & Serializable)_$6 -> {
            Vector vector = (Vector)package.parallel$.MODULE$.catsSyntaxParallelFoldMapA((Object)_$6.values().toVector());
            return (IO)ParallelFoldMapAOps$.MODULE$.parFoldMapA$extension((Object)vector, (Function1 & Serializable)_$7 -> (IO)_$7.release(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForVector(), IO$.MODULE$.parallelForIO(), (Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit());
        });
    }

    public IO<Seq<Tuple2<OrderId, Either<Problem, Fiber<IO, Throwable, OrderEvent.OrderProcessed>>>>> recoverProcessingOrders(Vector<Order<Order.Processing>> orders, AgentState agentState) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(JobMotorKeeper$.js7$agent$motor$JobMotorKeeper$$$logger, IO$.MODULE$.defer(() -> this.recoverProcessingOrders$$anonfun$1(orders, agentState)), Name$.MODULE$.apply("recoverProcessingOrders"));
    }

    public IO<BoxedUnit> onOrdersMayBeProcessable(View<Order<Order.State>> orders, AgentState agentState) {
        return (IO)ScalaUtils$syntax$.MODULE$.foldMap(((IterableOnceOps)((IterableOps)orders.flatMap((Function1 & Serializable)order -> agentState.ifOrderProcessable((Order)order))).flatMap((Function1 & Serializable)order -> agentState.maybeJobKey(order.workflowPosition()).map((Function1 & Serializable)_$12 -> {
            JobKey jobKey = (JobKey)Predef$.MODULE$.ArrowAssoc(_$12);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jobKey, order);
        }))).toVector().groupMap((Function1 & Serializable)_$13 -> (JobKey)_$13._1(), (Function1 & Serializable)_$14 -> (Order)_$14._2()), (Function1 & Serializable)x$1 -> {
            JobKey jobKey = (JobKey)x$1._1();
            Vector vector = (Vector)x$1._2();
            return this.keyToJobMotor(jobKey).enqueue((Seq<Order<Order.IsFreshOrReady>>)vector);
        }, IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
    }

    public IO<BoxedUnit> onOrderDetached(OrderId orderId, AgentState originalAgentState) {
        return (IO)ScalaUtils$syntax$.MODULE$.foldMap(originalAgentState.idToOrder().get((Object)orderId).flatMap((Function1 & Serializable)_$15 -> _$15.ifState(ClassTag$.MODULE$.apply(Order.IsFreshOrReady.class))).flatMap((Function1 & Serializable)order -> this.orderToJobMotor((Order<Order.State>)order, originalAgentState)), (Function1 & Serializable)_$16 -> _$16.remove(orderId, _$16.remove$default$2()).void(), IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
    }

    public IO<BoxedUnit> triggerAllJobs(Function0<Object> reason) {
        LazyRef lazyRef = new LazyRef();
        return Logger$package$Logger$syntax$.MODULE$.traceIO(JobMotorKeeper$.js7$agent$motor$JobMotorKeeper$$$logger, "triggerAllJobs", JobMotorKeeper.reason_$1(lazyRef, reason), this.jobMotors().flatMap((Function1 & Serializable)_$17 -> (IO)ScalaUtils$syntax$.MODULE$.foldMap(_$17, (Function1 & Serializable)_$18 -> _$18.trigger((Function0<Object>)((Function0 & Serializable)() -> JobMotorKeeper.triggerAllJobs$$anonfun$1$$anonfun$1$$anonfun$1(lazyRef, reason))), IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()))));
    }

    private IO<View<JobMotor>> jobMotors() {
        return this.js7$agent$motor$JobMotorKeeper$$jobToMotor.toMap().map((Function1 & Serializable)_$19 -> (View)_$19.values().view().map((Function1 & Serializable)_$20 -> (JobMotor)_$20.allocatedThing()));
    }

    public IO<BoxedUnit> onOrdersProcessed(Seq<OrderId> orderIds) {
        return this.getAgentState.flatMap((Function1 & Serializable)agentState -> (IO)ScalaUtils$syntax$.MODULE$.foldMap(((IterableOps)((IterableOps)orderIds.flatMap((Function1 & Serializable)key -> agentState.idToOrder().get(key))).flatMap((Function1 & Serializable)order -> agentState.maybeJobKey(order.workflowPosition()).map((Function1 & Serializable)_$21 -> {
            JobKey jobKey = (JobKey)Predef$.MODULE$.ArrowAssoc(_$21);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jobKey, (Object)order.id());
        }))).groupMap((Function1 & Serializable)_$22 -> (JobKey)_$22._1(), (Function1 & Serializable)_$23 -> (OrderId)_$23._2()), (Function1 & Serializable)x$1 -> {
            JobKey jobKey = (JobKey)x$1._1();
            Seq seq = (Seq)x$1._2();
            return (IO)ScalaUtils$syntax$.MODULE$.foldMap(this.js7$agent$motor$JobMotorKeeper$$jobToMotor.get(jobKey).map((Function1 & Serializable)_$24 -> (JobMotor)_$24.allocatedThing()), (Function1 & Serializable)jobMotor -> jobMotor.onOrdersProcessed((Iterable<OrderId>)seq), IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
        }, IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())));
    }

    public IO<BoxedUnit> maybeKillMarkedOrder(OrderId orderId) {
        return this.withCurrentOrder(orderId, (Function1<Order<Order.State>, IO<BoxedUnit>>)(Function1 & Serializable)order2 -> (IO)ScalaUtils$syntax$.MODULE$.foldMap(order2.ifState(ClassTag$.MODULE$.apply(Order.Processing.class)), (Function1 & Serializable)order -> {
            Option<OrderMark> option = order.mark();
            if (option instanceof Some) {
                CancellationMode.FreshOrStarted freshOrStarted;
                CancellationMode.FreshOrStarted freshOrStarted2;
                Option<CancellationMode.Kill> option2;
                OrderMark.Cancelling cancelling;
                OrderMark.Cancelling cancelling2;
                CancellationMode cancellationMode;
                Some some = (Some)option;
                OrderMark orderMark = (OrderMark)some.value();
                if (orderMark instanceof OrderMark.Cancelling && (cancellationMode = (cancelling2 = OrderMark$Cancelling$.MODULE$.unapply(cancelling = (OrderMark.Cancelling)orderMark))._1()) instanceof CancellationMode.FreshOrStarted && (option2 = (freshOrStarted2 = CancellationMode$FreshOrStarted$.MODULE$.unapply(freshOrStarted = (CancellationMode.FreshOrStarted)cancellationMode))._1()) instanceof Some) {
                    Some some2 = (Some)option2;
                    CancellationMode.Kill kill = (CancellationMode.Kill)some2.value();
                    return this.maybeKillOrder((Order<Order.State>)order, kill);
                }
                if (orderMark instanceof OrderMark.Suspending) {
                    OrderMark.Suspending suspending = (OrderMark.Suspending)orderMark;
                    OrderMark.Suspending suspending2 = OrderMark$Suspending$.MODULE$.unapply(suspending);
                    SuspensionMode suspensionMode = suspending2._1();
                    SuspensionMode suspensionMode2 = SuspensionMode$.MODULE$.unapply(suspensionMode);
                    boolean bl = suspensionMode2._1();
                    Option<CancellationMode.Kill> option3 = suspensionMode2._2();
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        CancellationMode.Kill mode = (CancellationMode.Kill)some3.value();
                        return this.maybeKillOrder((Order<Order.State>)order, mode);
                    }
                }
            }
            return IO$.MODULE$.unit();
        }, IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())));
    }

    public IO<BoxedUnit> maybeKillOrder(Order<Order.State> order2, CancellationMode.Kill kill) {
        return (IO)ScalaUtils$syntax$.MODULE$.foldMap(order2.ifState(ClassTag$.MODULE$.apply(Order.Processing.class)), (Function1 & Serializable)order -> IO$.MODULE$.whenA(kill.workflowPosition().forall((Function1 & Serializable)_$25 -> {
            WorkflowPosition workflowPosition = _$25;
            WorkflowPosition workflowPosition2 = order.workflowPosition();
            return !(workflowPosition != null ? !((Object)workflowPosition).equals(workflowPosition2) : workflowPosition2 != null);
        }), () -> this.maybeKillOrder$$anonfun$1$$anonfun$2(order, kill)), IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
    }

    private Option<JobMotor> orderToJobMotor(Order<Order.State> order, AgentState agentState) {
        Option option;
        Option option2 = agentState.maybeJobKey(order.workflowPosition());
        if (None$.MODULE$.equals(option2)) {
            Logger LoggerImpl_this;
            if (order.isState(ClassTag$.MODULE$.apply(Order.Processing.class)) && (LoggerImpl_this = JobMotorKeeper$.js7$agent$motor$JobMotorKeeper$$$logger).underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("{} is Processing but there is no Job for instruction at {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{order.id(), order.workflowPosition()}), Object.class));
            }
            option = None$.MODULE$;
        } else {
            Option o;
            option = o = option2;
        }
        return option.flatMap((Function1 & Serializable)jobKey -> {
            Option<Allocated<IO, JobMotor>> option = this.js7$agent$motor$JobMotorKeeper$$jobToMotor.get((JobKey)jobKey);
            if (None$.MODULE$.equals(option)) {
                Logger LoggerImpl_this = JobMotorKeeper$.js7$agent$motor$JobMotorKeeper$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("{} is Processing but no JobMotor is registered for {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{order.id(), jobKey}), Object.class));
                }
                return None$.MODULE$;
            }
            Option<Allocated<IO, JobMotor>> o = option;
            return o;
        }).map((Function1 & Serializable)_$26 -> (JobMotor)_$26.allocatedThing());
    }

    private JobMotor keyToJobMotor(JobKey jobKey) {
        Either either = Checked$.MODULE$.Ops(this.js7$agent$motor$JobMotorKeeper$$jobToMotor.checked(jobKey).map((Function1 & Serializable)_$27 -> (JobMotor)_$27.allocatedThing()));
        return (JobMotor)Checked$Ops$.MODULE$.orThrow$extension(either);
    }

    private <A> IO<BoxedUnit> withCurrentOrder(OrderId orderId, Function1<Order<Order.State>, IO<BoxedUnit>> body) {
        return this.getAgentState.flatMap((Function1 & Serializable)agentState -> (IO)ScalaUtils$syntax$.MODULE$.foldMap(agentState.idToOrder().get((Object)orderId), body, IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())));
    }

    public Resource<IO, BoxedUnit> registerMBeans() {
        Resource resource = CatsUtils$syntax$.MODULE$.RichResource(MBeanUtils$.MODULE$.registerMBean("JobMotorKeeper", IO$.MODULE$.apply(this::registerMBeans$$anonfun$1), IO$.MODULE$.asyncForIO()));
        return CatsUtils$syntax$RichResource$.MODULE$.void$extension(resource);
    }

    public final JobMotorKeeper$processLimits$ processLimits() {
        Object object = this.processLimits$lzy1;
        if (object instanceof JobMotorKeeper$processLimits$) {
            return (JobMotorKeeper$processLimits$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JobMotorKeeper$processLimits$)this.processLimits$lzyINIT1();
    }

    private Object processLimits$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.processLimits$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JobMotorKeeper$processLimits$ jobMotorKeeper$processLimits$ = null;
                    try {
                        jobMotorKeeper$processLimits$ = new JobMotorKeeper$processLimits$(this);
                        object2 = jobMotorKeeper$processLimits$ == null ? LazyVals.NullValue$.MODULE$ : jobMotorKeeper$processLimits$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.processLimits$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jobMotorKeeper$processLimits$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final IO startJobMotors$$anonfun$1(Workflow workflow$1) {
        ZoneId zoneId = ZoneId.of(workflow$1.timeZone().string());
        return (IO)ScalaUtils$syntax$.MODULE$.foldMap((IterableOnce)workflow$1.keyToJob().filter((Function1 & Serializable)_$3 -> {
            AgentPath agentPath = ((WorkflowJob)_$3._2()).agentPath();
            AgentPath agentPath2 = this.js7$agent$motor$JobMotorKeeper$$agentPath;
            return !(agentPath != null ? !((Object)agentPath).equals(agentPath2) : agentPath2 != null);
        }), (Function1 & Serializable)x$1 -> {
            JobKey jobKey = (JobKey)x$1._1();
            WorkflowJob workflowJob = (WorkflowJob)x$1._2();
            Resource resource = CatsUtils$syntax$.MODULE$.RichResource(JobMotor$.MODULE$.service(jobKey, workflowJob, this.getAgentState, this.orderMotor, this.subagentKeeper, zoneId, this.agentConf.findTimeIntervalLimit(), this.x$6, this.x$7));
            return ((IO)CatsUtils$syntax$RichResource$.MODULE$.toAllocated$extension(resource, IO$.MODULE$.asyncForIO(), UnsafeMemoizable$.MODULE$.given_UnsafeMemoizable_F(IO$.MODULE$.asyncForIO()), Tag$.MODULE$.apply(JobMotor.class, LightTypeTag$.MODULE$.parse(86089508, "\u0004\u0000\u0001\u0018js7.agent.motor.JobMotor\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001,js7.base.service.Service$.StoppableByRequest\u0001\u0002\u0003\u0000\u0000\u0018js7.base.service.Service\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001#js7.base.service.StoppableByRequest\u0001\u0001\u0004\u0000\u0001\u0018js7.agent.motor.JobMotor\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0003\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001", 30)))).flatMap((Function1 & Serializable)allocated -> this.js7$agent$motor$JobMotorKeeper$$jobToMotor.insert(jobKey, (Allocated<IO, JobMotor>)allocated, Enclosing$.MODULE$.apply("js7.agent.motor.JobMotorKeeper#startJobMotors")).map((Function1)(JProcedure1 & Serializable)_$4 -> {
                Either either = Checked$.MODULE$.Ops(_$4);
                Allocated cfr_ignored_0 = (Allocated)Checked$Ops$.MODULE$.orThrow$extension(either);
            }));
        }, IO$.MODULE$.monoidForIO((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
    }

    private final IO recoverProcessingOrders$$anonfun$1(Vector orders$1, AgentState agentState$1) {
        Vector vector = (Vector)package.parallel$.MODULE$.catsSyntaxParallelTraverse1((Object)((IterableOps)orders$1.flatMap((Function1 & Serializable)order -> this.orderToJobMotor((Order<Order.State>)order, agentState$1).map((Function1 & Serializable)_$8 -> {
            JobMotor jobMotor = (JobMotor)Predef$.MODULE$.ArrowAssoc(_$8);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jobMotor, order);
        }))).groupMap((Function1 & Serializable)_$9 -> (JobMotor)_$9._1(), (Function1 & Serializable)_$10 -> (Order)_$10._2()).toVector(), UnorderedFoldable$.MODULE$.catsTraverseForVector());
        return ((IO)ParallelTraversableOps1$.MODULE$.parTraverse$extension((Object)vector, (Function1 & Serializable)x$1 -> {
            JobMotor jobMotor = (JobMotor)x$1._1();
            Vector vector = (Vector)x$1._2();
            return this.processLimits().forceIncreaseProcessCount(vector.size()).$times$greater(jobMotor.recoverProcessingOrders((Vector<Order<Order.Processing>>)vector));
        }, UnorderedFoldable$.MODULE$.catsTraverseForVector(), IO$.MODULE$.parallelForIO())).map((Function1 & Serializable)_$11 -> (Vector)_$11.flatten(Predef$.MODULE$.$conforms()));
    }

    private static final String reason_$lzyINIT1$1(LazyRef reason_$lzy1$1, Function0 reason$1) {
        String string;
        LazyRef lazyRef = reason_$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(reason_$lzy1$1.initialized() ? reason_$lzy1$1.value() : reason_$lzy1$1.initialize((Object)reason$1.apply().toString()));
        }
        return string;
    }

    private static final String reason_$1(LazyRef reason_$lzy1$2, Function0 reason$2) {
        return (String)(reason_$lzy1$2.initialized() ? reason_$lzy1$2.value() : JobMotorKeeper.reason_$lzyINIT1$1(reason_$lzy1$2, reason$2));
    }

    private static final Object triggerAllJobs$$anonfun$1$$anonfun$1$$anonfun$1(LazyRef reason_$lzy1$5, Function0 reason$5) {
        return JobMotorKeeper.reason_$1(reason_$lzy1$5, reason$5);
    }

    private final IO maybeKillOrder$$anonfun$1$$anonfun$2(Order order$5, CancellationMode.Kill kill$2) {
        return this.subagentKeeper.killProcess(order$5.id(), kill$2.immediately() ? ProcessSignal$SIGKILL$.MODULE$ : ProcessSignal$SIGTERM$.MODULE$);
    }

    public static final /* synthetic */ int js7$agent$motor$JobMotorKeeper$$anon$1$$_$getOrderQueueLength$$anonfun$1(Allocated _$28) {
        return ((JobMotor)_$28.allocatedThing()).orderQueueLength();
    }

    public static final Integer js7$agent$motor$JobMotorKeeper$$anon$1$$_$getProcessLimit$$anonfun$1() {
        return null;
    }

    private static final /* synthetic */ Integer getProcessLimit$$anonfun$2(int x2) {
        return BoxesRunTime.boxToInteger((int)x2);
    }

    public static /* bridge */ /* synthetic */ Integer js7$agent$motor$JobMotorKeeper$$anon$1$$_$getProcessLimit$$anonfun$adapted$1(Object x2) {
        return JobMotorKeeper.getProcessLimit$$anonfun$2(BoxesRunTime.unboxToInt((Object)x2));
    }

    private final JobMotorKeeperMXBean registerMBeans$$anonfun$1() {
        return new JobMotorKeeperMXBean(this){
            private final /* synthetic */ JobMotorKeeper $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int getOrderQueueLength() {
                return BoxesRunTime.unboxToInt((Object)this.$outer.js7$agent$motor$JobMotorKeeper$$jobToMotor.unsafeToMap().values().iterator().map(JobMotorKeeper::js7$agent$motor$JobMotorKeeper$$anon$1$$_$getOrderQueueLength$$anonfun$1).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }

            public int getProcessCount() {
                return this.$outer.processLimits().processCount();
            }

            @Nullable
            public Integer getProcessLimit() {
                return (Integer)this.$outer.processLimits().processLimit().fold(JobMotorKeeper::js7$agent$motor$JobMotorKeeper$$anon$1$$_$getProcessLimit$$anonfun$1, JobMotorKeeper::js7$agent$motor$JobMotorKeeper$$anon$1$$_$getProcessLimit$$anonfun$adapted$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$agent$motor$JobMotorKeeper$$anon$1$$_$getOrderQueueLength$$anonfun$1(js7.base.utils.Allocated ), js7$agent$motor$JobMotorKeeper$$anon$1$$_$getProcessLimit$$anonfun$1(), js7$agent$motor$JobMotorKeeper$$anon$1$$_$getProcessLimit$$anonfun$adapted$1(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public static final Option js7$agent$motor$JobMotorKeeper$processLimits$$$_$processLimit$$anonfun$1() {
        block0: {
            Logger LoggerImpl_this = JobMotorKeeper$.js7$agent$motor$JobMotorKeeper$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("\u26a0\ufe0f  processLimit (own AgentRef) is still unknown, assuming processLimit = 0");
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final Option js7$agent$motor$JobMotorKeeper$processLimits$$$_$_$_$$anonfun$1() {
        Integer n = (Integer)package.option$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToInteger((int)0));
        return OptionIdOps$.MODULE$.some$extension((Object)n);
    }

    public static final /* synthetic */ boolean js7$agent$motor$JobMotorKeeper$processLimits$$$_$_$_$$anonfun$2(int processCount$1, int _$29) {
        return _$29 <= processCount$1;
    }

    public static final /* synthetic */ boolean js7$agent$motor$JobMotorKeeper$processLimits$$$_$_$_$$anonfun$3(int processCount$2, int _$30) {
        return processCount$2 < _$30;
    }

    private static final Object onProcessLimitChanged$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "unlimited";
    }

    public static final Object js7$agent$motor$JobMotorKeeper$processLimits$$$_$onProcessLimitChanged$$anonfun$1$$anonfun$1$$anonfun$1(Option newLimit$3) {
        return "Agent process limit increased to " + newLimit$3.getOrElse(JobMotorKeeper::onProcessLimitChanged$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    public static final /* synthetic */ void js7$agent$motor$JobMotorKeeper$processLimits$$$_$onProcessLimitChanged$$anonfun$1$$anonfun$2(BoxedUnit _$31) {
        package$.MODULE$.Right().apply((Object)_$31);
    }

    public static final boolean js7$agent$motor$JobMotorKeeper$processLimits$$$_$v$proxy1$1(int n$2) {
        return n$2 >= 0;
    }

    public static final String js7$agent$motor$JobMotorKeeper$processLimits$$$_$decrementProcessCount$$anonfun$1$$anonfun$1(int n$3) {
        return "JobMotorKeeper.processCount=" + n$3 + " is below zero";
    }

    public static final Option js7$agent$motor$JobMotorKeeper$processLimits$$$_$decrementProcessCount$$anonfun$1$$anonfun$2() {
        return None$.MODULE$;
    }

    private static final Tuple2 a$proxy1$1(int n$5, int limit$1) {
        return new Tuple2.mcII.sp(n$5, limit$1);
    }

    private static final Tuple2 decrementProcessCount$$anonfun$1$$anonfun$3$$anonfun$1(int n$8, int limit$3) {
        return JobMotorKeeper.a$proxy1$1(n$8, limit$3);
    }

    private static final /* synthetic */ Option decrementProcessCount$$anonfun$1$$anonfun$3(int n$4, int limit) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(n$4 + 1 == limit);
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> JobMotorKeeper.decrementProcessCount$$anonfun$1$$anonfun$3$$anonfun$1(n$4, limit));
    }

    public static /* bridge */ /* synthetic */ Option js7$agent$motor$JobMotorKeeper$processLimits$$$_$decrementProcessCount$$anonfun$1$$anonfun$adapted$1(int n$9, Object limit) {
        return JobMotorKeeper.decrementProcessCount$$anonfun$1$$anonfun$3(n$9, BoxesRunTime.unboxToInt((Object)limit));
    }

    public static final Object js7$agent$motor$JobMotorKeeper$processLimits$$$_$decrementProcessCount$$anonfun$2$$anonfun$1(int n$6, int limit$2) {
        return "processCount=" + n$6 + " got below AgentRef processLimit=" + limit$2;
    }

    public static interface JobMotorKeeperMXBean {
        public int getOrderQueueLength();

        public int getProcessCount();

        @Nullable
        public Integer getProcessLimit();
    }
}

