/*
 * Decompiled with CFR 0.152.
 */
package js7.agent.motor;

import cats.effect.IO;
import cats.effect.IO$;
import java.io.Serializable;
import js7.agent.motor.JobOrderQueue$;
import js7.agent.motor.JobOrderQueue$Entry$;
import js7.agent.motor.JobOrderQueue$LockedForRemoval$;
import js7.base.metering.CallMeter;
import js7.base.metering.CallMeterMacros$;
import js7.base.monixutils.SimpleLock;
import js7.data.order.Order;
import js7.data.order.OrderId;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class JobOrderQueue {
    private final MutableOrderQueue queue = new MutableOrderQueue();
    private final MutableOrderQueue forceAdmissionQueue = new MutableOrderQueue();
    private final SimpleLock<IO> removalLock = new SimpleLock(IO$.MODULE$.asyncForIO());

    public IO<BoxedUnit> enqueue(Seq<Order<Order.IsFreshOrReady>> orders) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.enqueue$$anonfun$1(orders);
            return BoxedUnit.UNIT;
        });
    }

    public <A> IO<A> lockForRemoval(Function1<LockedForRemoval, IO<A>> body) {
        return this.removalLock.surround((IO)body.apply((Object)JobOrderQueue$LockedForRemoval$.MODULE$));
    }

    public Order<Order.IsFreshOrReady> dequeueNextOrder(boolean onlyForcedAdmission, LockedForRemoval x$2) {
        Order<Order.IsFreshOrReady> order;
        JobOrderQueue jobOrderQueue = this;
        synchronized (jobOrderQueue) {
            Entry entry;
            if (onlyForcedAdmission) {
                Entry entry2 = this.forceAdmissionQueue.dequeueNext();
                this.queue.remove(entry2.order().id());
                entry = entry2;
            } else {
                Entry entry3 = this.queue.dequeueNext();
                this.forceAdmissionQueue.remove(entry3.order().id());
                entry = entry3;
            }
            Entry entry4 = entry;
            JobOrderQueue$.js7$agent$motor$JobOrderQueue$$$entryMeter.stopMetering(entry4.metering());
            order = entry4.order();
        }
        return order;
    }

    public IO<Object> remove(OrderId orderId, LockedForRemoval x$2) {
        return IO$.MODULE$.apply(() -> this.remove$$anonfun$1(orderId));
    }

    public boolean isEmpty(boolean onlyForcedAdmission, LockedForRemoval x$2) {
        if (onlyForcedAdmission) {
            return this.forceAdmissionQueue.isEmpty();
        }
        return this.queue.isEmpty();
    }

    public boolean isEmptyUnsafe() {
        return this.queue.isEmpty();
    }

    public int length() {
        return this.queue.length();
    }

    private final void enqueue$$anonfun$1(Seq orders$1) {
        JobOrderQueue jobOrderQueue = this;
        synchronized (jobOrderQueue) {
            orders$1.foreach((Function1)(JProcedure1 & Serializable)order -> {
                long metering = JobOrderQueue$.js7$agent$motor$JobOrderQueue$$$entryMeter.startMetering();
                if (order.forceJobAdmission()) {
                    this.forceAdmissionQueue.enqueue((Order<Order.IsFreshOrReady>)order, metering);
                }
                this.queue.enqueue((Order<Order.IsFreshOrReady>)order, metering).foreach((Function1)(JProcedure1 & Serializable)removedEntry -> JobOrderQueue$.js7$agent$motor$JobOrderQueue$$$entryMeter.stopMetering(removedEntry.metering()));
            });
        }
    }

    private static final boolean remove$$anonfun$1$$anonfun$1() {
        return false;
    }

    private final boolean remove$$anonfun$1(OrderId orderId$1) {
        boolean bl;
        JobOrderQueue jobOrderQueue = this;
        synchronized (jobOrderQueue) {
            bl = BoxesRunTime.unboxToBoolean((Object)this.queue.remove(orderId$1).fold(JobOrderQueue::remove$$anonfun$1$$anonfun$1, (Function1 & Serializable)entry -> {
                this.forceAdmissionQueue.remove(orderId$1);
                JobOrderQueue$.js7$agent$motor$JobOrderQueue$$$entryMeter.stopMetering(entry.metering());
                return true;
            }));
        }
        return bl;
    }

    public static final class Entry
    implements Product,
    Serializable {
        private final Order<Order.IsFreshOrReady> order;
        private final long metering;

        public static Entry apply(Order<Order.IsFreshOrReady> order, long l) {
            return JobOrderQueue$Entry$.MODULE$.apply(order, l);
        }

        public static Entry fromProduct(Product product) {
            return JobOrderQueue$Entry$.MODULE$.fromProduct(product);
        }

        public static Entry unapply(Entry entry) {
            return JobOrderQueue$Entry$.MODULE$.unapply(entry);
        }

        public Entry(Order<Order.IsFreshOrReady> order, long metering) {
            this.order = order;
            this.metering = metering;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)67115090);
            n = Statics.mix((int)n, (int)Statics.anyHash(this.order()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.metering()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Entry entry;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Entry)) return false;
            Entry entry2 = entry = (Entry)object;
            Order<Order.IsFreshOrReady> order = this.order();
            Order<Order.IsFreshOrReady> order2 = entry2.order();
            if (order == null) {
                if (order2 != null) {
                    return false;
                }
            } else if (!((Object)order).equals(order2)) return false;
            if (this.metering() != entry2.metering()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Entry;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Entry";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "order";
            }
            if (1 == n2) {
                return "metering";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Order<Order.IsFreshOrReady> order() {
            return this.order;
        }

        public long metering() {
            return this.metering;
        }

        public Entry copy(Order<Order.IsFreshOrReady> order, long metering) {
            return new Entry(order, metering);
        }

        public Order<Order.IsFreshOrReady> copy$default$1() {
            return this.order();
        }

        public long copy$default$2() {
            return this.metering();
        }

        public Order<Order.IsFreshOrReady> _1() {
            return this.order();
        }

        public long _2() {
            return this.metering();
        }
    }

    public static interface LockedForRemoval {
        public static int ordinal(LockedForRemoval lockedForRemoval) {
            return JobOrderQueue$LockedForRemoval$.MODULE$.ordinal(lockedForRemoval);
        }
    }

    public static final class MutableOrderQueue {
        private final ListBuffer<Entry> queue = ListBuffer$.MODULE$.empty();
        private final Set<OrderId> isQueued = (Set)Set$.MODULE$.empty();

        public Option<Entry> enqueue(Order<Order.IsFreshOrReady> order, long metering) {
            Option<Entry> option;
            MutableOrderQueue mutableOrderQueue = this;
            synchronized (mutableOrderQueue) {
                Option<Entry> result = this.remove(order.id());
                this.queue.$plus$eq((Object)JobOrderQueue$Entry$.MODULE$.apply(order, metering));
                this.isQueued.$plus$eq((Object)order.id());
                option = result;
            }
            return option;
        }

        /*
         * WARNING - void declaration
         */
        public Entry dequeueNext() {
            void var2_3;
            MutableOrderQueue mutableOrderQueue = this;
            synchronized (mutableOrderQueue) {
                void var3_2;
                Entry entry = (Entry)this.queue.remove(0);
                this.isQueued.$minus$eq((Object)entry.order().id());
                var2_3 = var3_2;
            }
            return var2_3;
        }

        public Option<Entry> remove(OrderId orderId) {
            None$ none$;
            MutableOrderQueue mutableOrderQueue = this;
            synchronized (mutableOrderQueue) {
                None$ none$2;
                if (this.isQueued.remove((Object)orderId)) {
                    CallMeter CallMeter_this = JobOrderQueue$.js7$agent$motor$JobOrderQueue$$$meterRemove;
                    none$2 = (Option)CallMeterMacros$.MODULE$.inline$meterCall$i1(CallMeter_this, () -> this.remove$$anonfun$2(orderId));
                } else {
                    none$2 = None$.MODULE$;
                }
                none$ = none$2;
            }
            return none$;
        }

        public boolean isEmpty() {
            boolean bl;
            MutableOrderQueue mutableOrderQueue = this;
            synchronized (mutableOrderQueue) {
                bl = this.queue.isEmpty();
            }
            return bl;
        }

        public int length() {
            int n;
            MutableOrderQueue mutableOrderQueue = this;
            synchronized (mutableOrderQueue) {
                n = this.queue.length();
            }
            return n;
        }

        public String toString() {
            String string;
            MutableOrderQueue mutableOrderQueue = this;
            synchronized (mutableOrderQueue) {
                string = "MutableOrderQueue(" + this.queue.size() + " orders)";
            }
            return string;
        }

        private final Option remove$$anonfun$2(OrderId orderId$3) {
            int n = this.queue.indexWhere(arg_0 -> JobOrderQueue$.js7$agent$motor$JobOrderQueue$MutableOrderQueue$$_$remove$$anonfun$2$$anonfun$1(orderId$3, arg_0));
            if (-1 == n) {
                return None$.MODULE$;
            }
            int i = n;
            return Some$.MODULE$.apply(this.queue.remove(i));
        }
    }
}

