/*
 * Decompiled with CFR 0.152.
 */
package js7.base.configutils;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.kernel.Monoid;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.Logger;
import io.circe.Json$;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import js7.base.circeutils.AnyJsonCodecs$;
import js7.base.configutils.Configs;
import js7.base.configutils.Configs$HoconStringInterpolator$;
import js7.base.configutils.Configs$RichConfig$;
import js7.base.configutils.ToHoconString;
import js7.base.convert.As;
import js7.base.generic.GenericString;
import js7.base.io.JavaResource;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Problem$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.matching.Regex;

public final class Configs$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Configs$.class.getDeclaredField("logger$lzy1"));
    private static final String InternalOriginDescription;
    private static final String SecretOriginDescription;
    private static final ConfigParseOptions Required;
    private volatile Object logger$lzy1;
    private static final Regex descriptionRegEx;
    public static final Configs$RichConfig$ RichConfig;
    private static final Monoid<Config> configMonoid;
    public static final Configs$HoconStringInterpolator$ HoconStringInterpolator;
    public static final Configs$ MODULE$;

    private Configs$() {
    }

    static {
        MODULE$ = new Configs$();
        InternalOriginDescription = "JS7";
        SecretOriginDescription = "JS7 Secret";
        Required = ConfigParseOptions.defaults().setAllowMissing(false);
        descriptionRegEx = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(": [0-9]+(-[0-9]+)?"));
        configMonoid = (Monoid)new Monoid<Config>(){
            private final Config empty;
            {
                this.empty = ConfigFactory.empty();
            }

            public Config empty() {
                return this.empty;
            }

            public Config combine(Config a, Config b) {
                return b.withFallback((ConfigMergeable)a);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Configs$.class);
    }

    public Logger js7$base$configutils$Configs$$$logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Configs$.class));
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Config configIf(boolean predicate, Function0<Config> config) {
        if (predicate) {
            return (Config)config.apply();
        }
        return ConfigFactory.empty();
    }

    public Config parseConfigIfExists(Path file, boolean secret) {
        block3: {
            if (Files.exists(file, new LinkOption[0])) {
                Logger LoggerImpl_this = this.js7$base$configutils$Configs$$$logger();
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("Reading configuration file {}", (Object)file);
                }
                ConfigParseOptions options = Required;
                if (secret) {
                    options = options.setOriginDescription(SecretOriginDescription);
                }
                return ConfigFactory.parseFile((File)file.toFile(), (ConfigParseOptions)options);
            }
            Logger LoggerImpl_this = this.js7$base$configutils$Configs$$$logger();
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block3;
            LoggerImpl_this.underlying().debug("No configuration file {}", (Object)file);
        }
        return ConfigFactory.empty();
    }

    public Config loadResource(JavaResource resource) {
        return this.loadResourceX(resource, InternalOriginDescription);
    }

    public Config loadSecretResource(JavaResource resource) {
        return this.loadResourceX(resource, SecretOriginDescription);
    }

    private Config loadResourceX(JavaResource resource, String origin) {
        Logger LoggerImpl_this = this.js7$base$configutils$Configs$$$logger();
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("Reading configuration JavaResource {}", (Object)resource);
        }
        ConfigParseOptions options = Required.setClassLoader(resource.classLoader());
        options = options.setOriginDescription(origin);
        return ConfigFactory.parseResourcesAnySyntax((String)resource.path(), (ConfigParseOptions)options);
    }

    public void logConfig(Config config) {
        ((Vector)CollectionConverters$.MODULE$.SetHasAsScala(config.entrySet()).asScala().view().toVector().sortBy((Function1 & Serializable)_$1 -> (String)_$1.getKey(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)entry -> {
            if (this.isInternal((ConfigValue)entry.getValue())) {
                Logger LoggerImpl_this = this.js7$base$configutils$Configs$$$logger();
                if (LoggerImpl_this.underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace(this.line$1((Map.Entry)entry));
                    return;
                }
                return;
            }
            Logger LoggerImpl_this = this.js7$base$configutils$Configs$$$logger();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug(this.line$1((Map.Entry)entry));
                return;
            }
        });
    }

    public String renderValue(String key, ConfigValue value) {
        StringBuilder sb = new StringBuilder(128);
        sb.$plus$plus$eq(key);
        sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'='));
        boolean secret = this.isSecret(value);
        sb.$plus$plus$eq(secret || key.endsWith("password") ? "(secret)" : value.render(ConfigRenderOptions.concise()));
        if (!secret && !this.isInternal(value)) {
            sb.$plus$plus$eq(" (");
            sb.$plus$plus$eq(value.origin().description());
            sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)')'));
        }
        return sb.toString();
    }

    private boolean isInternal(ConfigValue value) {
        String string = descriptionRegEx.replaceFirstIn((CharSequence)value.origin().description(), "");
        String string2 = InternalOriginDescription;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isSecret(ConfigValue value) {
        return value.origin().description().startsWith(SecretOriginDescription);
    }

    public final Configs.ConvertibleConfig ConvertibleConfig(Config underlying) {
        return new Configs.ConvertibleConfig(underlying);
    }

    public final Config RichConfig(Config underlying) {
        return underlying;
    }

    public Monoid<Config> configMonoid() {
        return configMonoid;
    }

    public final StringContext HoconStringInterpolator(StringContext sc) {
        return sc;
    }

    private String toHoconString(Object value2) {
        Object object;
        while (true) {
            java.lang.Iterable iterable;
            block16: {
                String string;
                Object v;
                block13: {
                    block15: {
                        block14: {
                            block12: {
                                if ((object = value2) instanceof ToHoconString) {
                                    ToHoconString toHoconString;
                                    ToHoconString v2 = toHoconString = (ToHoconString)object;
                                    return v2.toHoconString();
                                }
                                if (object instanceof FiniteDuration) {
                                    FiniteDuration finiteDuration;
                                    FiniteDuration v3 = finiteDuration = (FiniteDuration)object;
                                    return ScalaTime$RichFiniteDuration$.MODULE$.toHoconString$extension(ScalaTime$.MODULE$.RichFiniteDuration(v3));
                                }
                                if (!(object instanceof String)) break block12;
                                String string2 = (String)object;
                                break block13;
                            }
                            if (!(object instanceof GenericString)) break block14;
                            GenericString genericString = (GenericString)object;
                            break block13;
                        }
                        if (!(object instanceof Path)) break block15;
                        Path path = (Path)object;
                        break block13;
                    }
                    if (!(object instanceof File)) break block16;
                    File file = (File)object;
                }
                Object object2 = v = object;
                if (object2 instanceof GenericString) {
                    GenericString genericString;
                    GenericString o = genericString = (GenericString)object2;
                    string = o.string();
                } else {
                    Object o = object2;
                    string = o.toString();
                }
                String str = string;
                String json = Json$.MODULE$.fromString(str).toString();
                return json.substring(1, json.length() - 1);
            }
            if (object instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map v = map = (scala.collection.immutable.Map)object;
                return ((IterableOnceOps)v.view().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    return MODULE$.toHoconString(k) + ": " + MODULE$.toHoconString(v);
                })).mkString("{ ", ", ", " }");
            }
            if (object instanceof Iterable) {
                Iterable iterable2;
                Iterable v = iterable2 = (Iterable)object;
                return ((IterableOnceOps)v.view().map((Function1 & Serializable)value -> MODULE$.toHoconString(value))).mkString("[ ", ", ", " ]");
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object3;
                Object v = object3 = object;
                Object object4 = Predef$.MODULE$.genericArrayOps(v);
                return ArrayOps$.MODULE$.view$extension(object4).map((Function1 & Serializable)value -> MODULE$.toHoconString(value)).mkString("[ ", ", ", " ]");
            }
            if (object instanceof Map) {
                Map map;
                Map v = map = (Map)object;
                value2 = CollectionConverters$.MODULE$.MapHasAsScala(v).asScala();
                continue;
            }
            if (!(object instanceof java.lang.Iterable)) break;
            java.lang.Iterable v = iterable = (java.lang.Iterable)object;
            value2 = CollectionConverters$.MODULE$.IterableHasAsScala(v).asScala();
        }
        Object v = object;
        return AnyJsonCodecs$.MODULE$.anyToJson(v, AnyJsonCodecs$.MODULE$.anyToJson$default$2()).toString();
    }

    private final String line$1(Map.Entry entry$1) {
        return this.renderValue((String)entry$1.getKey(), (ConfigValue)entry$1.getValue());
    }

    public static final /* synthetic */ Object js7$base$configutils$Configs$RichConfig$$$_$seqAs$extension$$anonfun$1(As convert$1, String v) {
        return convert$1.apply(v);
    }

    public static final String js7$base$configutils$Configs$RichConfig$$$_$seqAs$extension$$anonfun$2(String path$1) {
        return path$1;
    }

    public static final String js7$base$configutils$Configs$RichConfig$$$_$checkedPath$extension$$anonfun$1(String path$3) {
        return "Missing configuration key '" + path$3 + "'";
    }

    public static final FiniteDuration js7$base$configutils$Configs$RichConfig$$$_$finiteDuration$extension$$anonfun$1(Config $this$2, String path$5) {
        return JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration($this$2.getDuration(path$5)));
    }

    private static final String nonEmptyFiniteDurations$extension$$anonfun$1$$anonfun$2(String path$7) {
        return "Config " + path$7 + " must not be an empty list";
    }

    public static final Either js7$base$configutils$Configs$RichConfig$$$_$nonEmptyFiniteDurations$extension$$anonfun$1(Config $this$3, String path$6) {
        Option option = NonEmptyList$.MODULE$.fromList(CollectionConverters$.MODULE$.ListHasAsScala($this$3.getDurationList(path$6)).asScala().toList().map((Function1 & Serializable)_$2 -> JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration((Duration)_$2))));
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> Configs$.nonEmptyFiniteDurations$extension$$anonfun$1$$anonfun$2(path$6)), Problem$.MODULE$.apply$default$2()));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            NonEmptyList nev = (NonEmptyList)some.value();
            return package$.MODULE$.Right().apply((Object)nev);
        }
        throw new MatchError((Object)option);
    }

    public static final String js7$base$configutils$Configs$RichConfig$$$_$memorySizeAsInt$extension$$anonfun$1(String path$10, BigInteger bigInteger$1) {
        return "Number is to big: " + path$10 + " = " + bigInteger$1;
    }

    public static final /* synthetic */ String js7$base$configutils$Configs$HoconStringInterpolator$$$_$_$$anonfun$1(Object value) {
        return MODULE$.toHoconString(value);
    }

    public static final /* synthetic */ String js7$base$configutils$Configs$HoconStringInterpolator$$$_$configString$extension$$anonfun$1(Object value) {
        return MODULE$.toHoconString(value);
    }
}

