/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import java.io.Serializable;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.SignerId;
import js7.base.crypt.x509.X509Algorithm;
import js7.base.crypt.x509.X509Algorithm$;
import js7.base.crypt.x509.X509Cert;
import js7.base.crypt.x509.X509Cert$;
import js7.base.crypt.x509.X509Signature;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;

public final class X509Signature$
implements Mirror.Product,
Serializable {
    private static final String TypeName;
    public static final X509Signature$ MODULE$;

    private X509Signature$() {
    }

    static {
        MODULE$ = new X509Signature$();
        TypeName = "X509";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(X509Signature$.class);
    }

    public X509Signature apply(ByteArray byteArray, X509Algorithm algorithm, Either<SignerId, X509Cert> signerIdOrCertificate) {
        return new X509Signature(byteArray, algorithm, signerIdOrCertificate);
    }

    public X509Signature unapply(X509Signature x$1) {
        return x$1;
    }

    public String TypeName() {
        return TypeName;
    }

    public Either<Problem, X509Signature> fromGenericSignature(GenericSignature signature) {
        return ByteArray$.MODULE$.fromMimeBase64(signature.signatureString()).flatMap((Function1 & Serializable)signatureBytes -> {
            Left left;
            Option<String> option = signature.algorithm();
            if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Missing X.509 signature algorithm"));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String o = (String)some.value();
                left = package$.MODULE$.Right().apply((Object)X509Algorithm$.MODULE$.apply(o));
            } else {
                throw new MatchError(option);
            }
            return left.flatMap((Function1 & Serializable)algorithm -> {
                Left left;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(signature.signerId(), signature.signerCertificate());
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SignerId signerId = (SignerId)some.value();
                    if (None$.MODULE$.equals(option2)) {
                        left = package$.MODULE$.Right().apply((Object)package$.MODULE$.Left().apply((Object)signerId));
                        return left.map((Function1 & Serializable)signerIdOrCertificate -> new X509Signature((ByteArray)signatureBytes, (X509Algorithm)algorithm, (Either<SignerId, X509Cert>)signerIdOrCertificate));
                    }
                }
                if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                    Some some = (Some)option2;
                    String cert = (String)some.value();
                    left = X509Cert$.MODULE$.fromPem(cert).map((Function1 & Serializable)value -> package$.MODULE$.Right().apply(value));
                    return left.map((Function1 & Serializable)signerIdOrCertificate -> new X509Signature((ByteArray)signatureBytes, (X509Algorithm)algorithm, (Either<SignerId, X509Cert>)signerIdOrCertificate));
                }
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("X.509 signature requires either a signerId or a signerCertificate"));
                return left.map((Function1 & Serializable)signerIdOrCertificate -> new X509Signature((ByteArray)signatureBytes, (X509Algorithm)algorithm, (Either<SignerId, X509Cert>)signerIdOrCertificate));
            });
        });
    }

    public X509Signature fromProduct(Product x$0) {
        ByteArray byteArray = (ByteArray)x$0.productElement(0);
        X509Algorithm x509Algorithm = (X509Algorithm)x$0.productElement(1);
        Either either = (Either)x$0.productElement(2);
        return new X509Signature(byteArray, x509Algorithm, (Either<SignerId, X509Cert>)either);
    }
}

