/*
 * Decompiled with CFR 0.152.
 */
package js7.base.io.file;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import js7.base.log.Logger$package$Logger$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class FileDeleter$
implements Serializable {
    private static final Logger logger;
    public static final FileDeleter$ MODULE$;

    private FileDeleter$() {
    }

    static {
        MODULE$ = new FileDeleter$();
        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FileDeleter$.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileDeleter$.class);
    }

    public boolean tryDeleteFile(Path file) {
        return this.tryDeleteFiles((Iterable<Path>)package$.MODULE$.Nil().$colon$colon((Object)file));
    }

    public boolean tryDeleteFiles(Iterable<Path> files) {
        BooleanRef allFilesDeleted = BooleanRef.create((boolean)true);
        files.foreach((Function1 & Serializable)file -> {
            Boolean bl;
            try {
                Logger LoggerImpl_this;
                Logger LoggerImpl_this2 = logger;
                if (LoggerImpl_this2.underlying().isDebugEnabled() && Files.exists(file, new LinkOption[0]) && (LoggerImpl_this = logger).underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("Delete file '{}'", file);
                }
                bl = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    allFilesDeleted$1.elem = false;
                    Logger LoggerImpl_this = logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = file;
                        Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4);
                        LoggerImpl_this.underlying().warn("Cannot delete file '{}': {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                    }
                } else {
                    throw throwable;
                }
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
        return allFilesDeleted.elem;
    }
}

