/*
 * Decompiled with CFR 0.152.
 */
package js7.base.io.https;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import js7.base.io.https.CompositeX509TrustManager$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public final class CompositeX509TrustManager
implements X509TrustManager {
    private final Seq<X509TrustManager> trustManagers;

    public static X509TrustManager apply(Seq<X509TrustManager> seq) {
        return CompositeX509TrustManager$.MODULE$.apply(seq);
    }

    public CompositeX509TrustManager(Seq<X509TrustManager> trustManagers) {
        this.trustManagers = trustManagers;
    }

    public Seq<X509TrustManager> trustManagers() {
        return this.trustManagers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
        this.tryTrustManagers((Function1)(JProcedure1 & Serializable)_$1 -> _$1.checkClientTrusted(chain, authType));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
        this.tryTrustManagers((Function1)(JProcedure1 & Serializable)_$2 -> _$2.checkServerTrusted(chain, authType));
    }

    private <A> A tryTrustManagers(Function1<X509TrustManager, A> op) {
        LazyList tries = ((LazyList)this.trustManagers().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).map((Function1 & Serializable)trustManager -> {
            Success success;
            try {
                success = Success$.MODULE$.apply(op.apply(trustManager));
            }
            catch (CertificateException e) {
                success = Failure$.MODULE$.apply((Throwable)e);
            }
            return success;
        });
        return (A)tries.collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Try x2) {
                Try try_ = x2;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object a = success.value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Try x2, Function1 function1) {
                Try try_ = x2;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object a = success.value();
                    return a;
                }
                return function1.apply((Object)x2);
            }
        }).getOrElse(() -> CompositeX509TrustManager.tryTrustManagers$$anonfun$1(tries));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])((IterableOnceOps)this.trustManagers().view().flatMap((Function1 & Serializable)_$4 -> Predef$.MODULE$.wrapRefArray((Object[])_$4.getAcceptedIssuers()))).toArray(ClassTag$.MODULE$.apply(X509Certificate.class));
    }

    private static final Object tryTrustManagers$$anonfun$1(LazyList tries$1) {
        tries$1.map((Function1 & Serializable)_$3 -> (Throwable)ScalaUtils$syntax$.MODULE$.ifFailed(_$3).get()).foreach((Function1)(JProcedure1 & Serializable)t -> {
            Logger LoggerImpl_this = CompositeX509TrustManager$.js7$base$io$https$CompositeX509TrustManager$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                LoggerImpl_this.underlying().debug(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable));
                return;
            }
        });
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }
}

