/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import js7.base.log.Logger$package$Logger$;
import js7.base.time.AdmissionPeriod;
import js7.base.time.AdmissionPeriod$;
import js7.base.time.AdmissionPeriodCalculator;
import js7.base.time.DailyPeriod;
import js7.base.time.MonthlyDatePeriod;
import js7.base.time.MonthlyLastDatePeriod;
import js7.base.time.MonthlyLastWeekdayPeriod;
import js7.base.time.MonthlyWeekdayPeriod;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDurationCompanion$;
import js7.base.time.SpecificDatePeriod;
import js7.base.time.WeekdayPeriod;
import scala.MatchError;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.DurationConverters;
import scala.jdk.DurationConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class AdmissionPeriodCalculator$
implements Serializable {
    private static final ZoneOffset NoOffset;
    public static final Duration js7$base$time$AdmissionPeriodCalculator$$$JEpsilon;
    public static final AdmissionPeriodCalculator$ MODULE$;

    private AdmissionPeriodCalculator$() {
    }

    static {
        MODULE$ = new AdmissionPeriodCalculator$();
        Logger logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(AdmissionPeriodCalculator$.class));
        NoOffset = ZoneOffset.ofTotalSeconds(0);
        js7$base$time$AdmissionPeriodCalculator$$$JEpsilon = DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(ScalaTime$RichFiniteDurationCompanion$.MODULE$.Epsilon$extension(ScalaTime$.MODULE$.RichFiniteDurationCompanion(FiniteDuration$.MODULE$))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AdmissionPeriodCalculator$.class);
    }

    public ZoneOffset NoOffset() {
        return NoOffset;
    }

    public AdmissionPeriodCalculator apply(AdmissionPeriod admissionPeriod, FiniteDuration dateOffset) {
        AdmissionPeriod admissionPeriod2 = admissionPeriod;
        if (admissionPeriod2 instanceof DailyPeriod) {
            DailyPeriod dailyPeriod;
            DailyPeriod period = dailyPeriod = (DailyPeriod)admissionPeriod2;
            return new AdmissionPeriodCalculator.DailyPeriodCalculator(period, DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(dateOffset)));
        }
        if (admissionPeriod2 instanceof WeekdayPeriod) {
            WeekdayPeriod weekdayPeriod;
            WeekdayPeriod period = weekdayPeriod = (WeekdayPeriod)admissionPeriod2;
            return new AdmissionPeriodCalculator.WeekdayPeriodCalculator(period, DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(dateOffset)));
        }
        if (admissionPeriod2 instanceof MonthlyDatePeriod) {
            MonthlyDatePeriod monthlyDatePeriod;
            MonthlyDatePeriod period = monthlyDatePeriod = (MonthlyDatePeriod)admissionPeriod2;
            return new AdmissionPeriodCalculator.MonthlyDatePeriodCalculator(period, DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(dateOffset)));
        }
        if (admissionPeriod2 instanceof MonthlyLastDatePeriod) {
            MonthlyLastDatePeriod monthlyLastDatePeriod;
            MonthlyLastDatePeriod period = monthlyLastDatePeriod = (MonthlyLastDatePeriod)admissionPeriod2;
            return new AdmissionPeriodCalculator.MonthlyLastDatePeriodCalculator(period, DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(dateOffset)));
        }
        if (admissionPeriod2 instanceof MonthlyWeekdayPeriod) {
            MonthlyWeekdayPeriod monthlyWeekdayPeriod;
            MonthlyWeekdayPeriod period = monthlyWeekdayPeriod = (MonthlyWeekdayPeriod)admissionPeriod2;
            return new AdmissionPeriodCalculator.MonthlyWeekdayPeriodCalculator(period, DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(dateOffset)));
        }
        if (admissionPeriod2 instanceof MonthlyLastWeekdayPeriod) {
            MonthlyLastWeekdayPeriod monthlyLastWeekdayPeriod;
            MonthlyLastWeekdayPeriod period = monthlyLastWeekdayPeriod = (MonthlyLastWeekdayPeriod)admissionPeriod2;
            return new AdmissionPeriodCalculator.MonthlyLastWeekdayPeriodCalculator(period, DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(dateOffset)));
        }
        if (admissionPeriod2 instanceof SpecificDatePeriod) {
            SpecificDatePeriod specificDatePeriod;
            SpecificDatePeriod period = specificDatePeriod = (SpecificDatePeriod)admissionPeriod2;
            return new AdmissionPeriodCalculator.SpecificDatePeriodCalculator(period, DurationConverters.ScalaDurationOps$.MODULE$.toJava$extension(DurationConverters$.MODULE$.ScalaDurationOps(dateOffset)));
        }
        throw new MatchError((Object)admissionPeriod2);
    }

    public long startOfWeek(LocalDateTime local) {
        return local.toEpochSecond(this.NoOffset()) - this.sinceStartOfWeek(local.toEpochSecond(this.NoOffset()));
    }

    public long sinceStartOfWeek(long secondsSinceLocalEpoch) {
        int thursday = 3;
        return (secondsSinceLocalEpoch + (long)(thursday * AdmissionPeriod$.MODULE$.DaySeconds())) % (long)AdmissionPeriod$.MODULE$.WeekSeconds();
    }

    public LocalDateTime js7$base$time$AdmissionPeriodCalculator$$$startOfMonth(LocalDateTime local) {
        return LocalDateTime.of(local.toLocalDate().withDayOfMonth(1), LocalTime.MIDNIGHT);
    }

    public LocalDateTime js7$base$time$AdmissionPeriodCalculator$$$endOfMonth(LocalDateTime local) {
        return LocalDateTime.of(local.toLocalDate().withDayOfMonth(1).plusMonths(1L).minusDays(1L), LocalTime.MIDNIGHT);
    }

    public static final LocalDateTime js7$base$time$AdmissionPeriodCalculator$SpecificDatePeriodCalculator$$_$nextCalendarPeriodStart$$anonfun$1(LocalDateTime next$1) {
        return next$1;
    }
}

