/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import cats.effect.unsafe.Scheduler;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.monixlike.SerialSyncCancelable;
import js7.base.monixlike.SerialSyncCancelable$;
import js7.base.monixlike.SyncCancelable;
import js7.base.monixlike.SyncCancelable$;
import js7.base.time.AlarmClock;
import js7.base.time.ClockChecking$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.EmptyRunnable$package$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public interface ClockChecking
extends Runnable {
    public static void $init$(ClockChecking $this) {
        $this.js7$base$time$ClockChecking$_setter_$js7$base$time$ClockChecking$$epochMilliToAlarms_$eq((SortedMap)SortedMap$.MODULE$.empty((Ordering)Ordering.Long$.MODULE$));
        $this.js7$base$time$ClockChecking$$nextMilli_$eq(Long.MAX_VALUE);
        $this.js7$base$time$ClockChecking$_setter_$js7$base$time$ClockChecking$$timer_$eq(new SerialSyncCancelable(SerialSyncCancelable$.MODULE$.$lessinit$greater$default$1()));
        $this.js7$base$time$ClockChecking$_setter_$js7$base$time$ClockChecking$$ticker_$eq(new SerialSyncCancelable(SerialSyncCancelable$.MODULE$.$lessinit$greater$default$1()));
        $this.js7$base$time$ClockChecking$$ticking_$eq(false);
        $this.js7$base$time$ClockChecking$$stopped_$eq(false);
    }

    public FiniteDuration clockCheckInterval();

    public Scheduler scheduler();

    public SortedMap<Object, Vector<Alarm>> js7$base$time$ClockChecking$$epochMilliToAlarms();

    public void js7$base$time$ClockChecking$_setter_$js7$base$time$ClockChecking$$epochMilliToAlarms_$eq(SortedMap var1);

    public long js7$base$time$ClockChecking$$nextMilli();

    public void js7$base$time$ClockChecking$$nextMilli_$eq(long var1);

    public SerialSyncCancelable js7$base$time$ClockChecking$$timer();

    public void js7$base$time$ClockChecking$_setter_$js7$base$time$ClockChecking$$timer_$eq(SerialSyncCancelable var1);

    public static long js7$base$time$ClockChecking$$tickInterval$(ClockChecking $this) {
        return $this.js7$base$time$ClockChecking$$tickInterval();
    }

    default public long js7$base$time$ClockChecking$$tickInterval() {
        return this.clockCheckInterval().toMillis();
    }

    public SerialSyncCancelable js7$base$time$ClockChecking$$ticker();

    public void js7$base$time$ClockChecking$_setter_$js7$base$time$ClockChecking$$ticker_$eq(SerialSyncCancelable var1);

    public boolean js7$base$time$ClockChecking$$ticking();

    public void js7$base$time$ClockChecking$$ticking_$eq(boolean var1);

    public boolean js7$base$time$ClockChecking$$stopped();

    public void js7$base$time$ClockChecking$$stopped_$eq(boolean var1);

    public static void stop$(ClockChecking $this) {
        $this.stop();
    }

    default public void stop() {
        this.js7$base$time$ClockChecking$$stopped_$eq(true);
        this.stopTicking();
        this.js7$base$time$ClockChecking$$ticker().cancel();
        ClockChecking clockChecking = this;
        synchronized (clockChecking) {
            ((IterableOnceOps)this.js7$base$time$ClockChecking$$epochMilliToAlarms().values().view().flatten(Predef$.MODULE$.$conforms())).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.cancel());
            this.js7$base$time$ClockChecking$$epochMilliToAlarms().clear();
        }
    }

    public static SyncCancelable scheduleOnce$(ClockChecking $this, FiniteDuration delay, Function0 label, Function0 callback) {
        return $this.scheduleOnce(delay, (Function0<String>)label, (Function0<BoxedUnit>)callback);
    }

    default public SyncCancelable scheduleOnce(FiniteDuration delay, Function0<String> label, Function0<BoxedUnit> callback) {
        return this.scheduleAt(((AlarmClock)((Object)this)).now().$plus(delay), label, callback);
    }

    public static SyncCancelable scheduleAt$(ClockChecking $this, Timestamp at, Function0 label, Function0 callback) {
        return $this.scheduleAt(at, (Function0<String>)label, (Function0<BoxedUnit>)callback);
    }

    default public SyncCancelable scheduleAt(Timestamp at, Function0<String> label, Function0<BoxedUnit> callback) {
        long milli = at.toEpochMilli();
        if (this.toMs(milli - ((AlarmClock)((Object)this)).epochMilli()).isFailure()) {
            Logger LoggerImpl_this = ClockChecking$.js7$base$time$ClockChecking$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("scheduleAt({}, {}) ignored because it is out of range", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{at, label.apply()}), Object.class));
            }
            return SyncCancelable$.MODULE$.empty();
        }
        Alarm alarm = new Alarm(this, milli, label, callback);
        ClockChecking clockChecking = this;
        synchronized (clockChecking) {
            this.js7$base$time$ClockChecking$$epochMilliToAlarms().update((Object)BoxesRunTime.boxToLong((long)milli), ((SeqOps)this.js7$base$time$ClockChecking$$epochMilliToAlarms().getOrElse((Object)BoxesRunTime.boxToLong((long)milli), ClockChecking::scheduleAt$$anonfun$1)).$colon$plus((Object)alarm));
            this.js7$base$time$ClockChecking$$scheduleNext();
        }
        return SyncCancelable$.MODULE$.apply(alarm);
    }

    public static void js7$base$time$ClockChecking$$scheduleNext$(ClockChecking $this) {
        $this.js7$base$time$ClockChecking$$scheduleNext();
    }

    default public void js7$base$time$ClockChecking$$scheduleNext() {
        if (!this.js7$base$time$ClockChecking$$stopped()) {
            Option option = this.js7$base$time$ClockChecking$$epochMilliToAlarms().headOption();
            if (None$.MODULE$.equals(option)) {
                this.stopTicking();
                this.js7$base$time$ClockChecking$$nextMilli_$eq(Long.MAX_VALUE);
                return;
            }
            if (option instanceof Some) {
                Runnable runnable;
                Some some = (Some)option;
                Tuple2 tuple2 = (Tuple2)some.value();
                long firstMilli = BoxesRunTime.unboxToLong((Object)tuple2._1());
                Vector alarms = (Vector)tuple2._2();
                long now = ((AlarmClock)((Object)this)).epochMilli();
                long delay = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(firstMilli - now), 0L);
                if (delay > this.js7$base$time$ClockChecking$$tickInterval()) {
                    this.startTicking(ScalaTime$DurationRichLong$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichLong(this.js7$base$time$ClockChecking$$tickInterval())));
                } else {
                    this.stopTicking();
                }
                SerialSyncCancelable serialSyncCancelable = this.js7$base$time$ClockChecking$$timer();
                Try<FiniteDuration> try_ = this.toMs(delay);
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    Logger LoggerImpl_this = ClockChecking$.js7$base$time$ClockChecking$$$logger;
                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                        LoggerImpl_this.underlying().error("scheduleNext: delay={}ms is out of range for FiniteDuration: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)delay), alarms.mkString(", ")}), Object.class));
                    }
                    runnable = EmptyRunnable$package$.MODULE$.emptyRunnable();
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    FiniteDuration delay2 = (FiniteDuration)success.value();
                    runnable = this.scheduler().sleep(delay2, (Runnable)this);
                } else {
                    throw new MatchError(try_);
                }
                serialSyncCancelable.set(runnable);
                this.js7$base$time$ClockChecking$$nextMilli_$eq(firstMilli);
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    private Try<FiniteDuration> toMs(long millis) {
        return Try$.MODULE$.apply(() -> ClockChecking.toMs$$anonfun$1(millis));
    }

    private void startTicking(FiniteDuration tickInterval) {
        if (!this.js7$base$time$ClockChecking$$ticking() && !this.js7$base$time$ClockChecking$$stopped()) {
            this.js7$base$time$ClockChecking$$ticking_$eq(true);
            this.js7$base$time$ClockChecking$$ticker().set(MonixLikeExtensions$.MODULE$.scheduleAtFixedRate(this.scheduler(), tickInterval, tickInterval, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.startTicking$$anonfun$1();
                return BoxedUnit.UNIT;
            }));
            return;
        }
    }

    private void stopTicking() {
        if (this.js7$base$time$ClockChecking$$ticking()) {
            this.js7$base$time$ClockChecking$$ticking_$eq(false);
            this.js7$base$time$ClockChecking$$ticker().set(SyncCancelable$.MODULE$.empty());
            return;
        }
    }

    public static void run$(ClockChecking $this) {
        $this.run();
    }

    @Override
    default public void run() {
        if (!this.js7$base$time$ClockChecking$$stopped()) {
            if (this.js7$base$time$ClockChecking$$nextMilli() <= ((AlarmClock)((Object)this)).epochMilli()) {
                Vector alarms = package$.MODULE$.Vector().empty();
                ClockChecking clockChecking = this;
                synchronized (clockChecking) {
                    while (this.js7$base$time$ClockChecking$$epochMilliToAlarms().nonEmpty() && BoxesRunTime.unboxToLong((Object)this.js7$base$time$ClockChecking$$epochMilliToAlarms().firstKey()) <= ((AlarmClock)((Object)this)).epochMilli()) {
                        alarms = (Vector)alarms.$plus$plus((IterableOnce)this.js7$base$time$ClockChecking$$epochMilliToAlarms().remove(this.js7$base$time$ClockChecking$$epochMilliToAlarms().firstKey()).get());
                    }
                }
                alarms.foreach((Function1)(JProcedure1 & Serializable)a -> a.call());
            }
            ClockChecking clockChecking = this;
            synchronized (clockChecking) {
                this.js7$base$time$ClockChecking$$scheduleNext();
            }
            return;
        }
    }

    public static String toString$(ClockChecking $this) {
        return $this.toString();
    }

    default public String toString() {
        return ((AlarmClock)((Object)this)).productPrefix() + "(" + ((AlarmClock)((Object)this)).now() + ", " + this.js7$base$time$ClockChecking$$epochMilliToAlarms().headOption().fold(ClockChecking::toString$$anonfun$1, (Function1 & Serializable)o -> "alarms=" + Timestamp$.MODULE$.ofEpochMilli(BoxesRunTime.unboxToLong((Object)o._1())).toString() + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.js7$base$time$ClockChecking$$epochMilliToAlarms().size() > 1), (Function0<String>)((Function0 & Serializable)this::toString$$anonfun$2$$anonfun$1))) + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.js7$base$time$ClockChecking$$ticking()), (Function0<String>)((Function0 & Serializable)this::toString$$anonfun$3)) + ")";
    }

    private static Vector scheduleAt$$anonfun$1() {
        return package$.MODULE$.Vector().empty();
    }

    private static FiniteDuration toMs$$anonfun$1(long millis$1) {
        return ScalaTime$DurationRichLong$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichLong(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(millis$1), 0L)));
    }

    private void startTicking$$anonfun$1() {
        this.run();
    }

    private static String toString$$anonfun$1() {
        return "no alarm";
    }

    private String toString$$anonfun$2$$anonfun$1() {
        return ", " + this.js7$base$time$ClockChecking$$epochMilliToAlarms().size() + " alarms";
    }

    private String toString$$anonfun$3() {
        return ", ticking " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.clockCheckInterval()));
    }

    public final class Alarm
    implements Runnable {
        private final long epochMilli;
        private final Function0<String> label;
        private final Function0<BoxedUnit> callback;
        private final AtomicBoolean called;
        private final /* synthetic */ ClockChecking $outer;

        public Alarm(ClockChecking $outer, long epochMilli, Function0<String> label, Function0<BoxedUnit> callback) {
            this.epochMilli = epochMilli;
            this.label = label;
            this.callback = callback;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.called = new AtomicBoolean(false);
        }

        public void call() {
            if (!this.called.getAndSet(true)) {
                try {
                    this.callback.apply$mcV$sp();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof IllegalStateException) {
                        IllegalStateException illegalStateException;
                        IllegalStateException t = illegalStateException = (IllegalStateException)throwable2;
                        String string = t.getMessage();
                        String string2 = "Dispatcher already closed";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            Logger LoggerImpl_this = ClockChecking$.js7$base$time$ClockChecking$$$logger;
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = this.toString();
                                IllegalStateException illegalStateException2 = (IllegalStateException)ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                                objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(illegalStateException2);
                                LoggerImpl_this.underlying().warn("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                            }
                        }
                    }
                    if (!(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = (Throwable)option.get();
                        Logger LoggerImpl_this = ClockChecking$.js7$base$time$ClockChecking$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                            Throwable throwable5 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                            LoggerImpl_this.underlying().error(this.toString() + ": " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4), (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable5));
                        }
                    }
                    throw throwable;
                }
                return;
            }
        }

        @Override
        public void run() {
            this.cancel();
        }

        public void cancel() {
            ClockChecking clockChecking = this.$outer;
            synchronized (clockChecking) {
                this.$outer.js7$base$time$ClockChecking$$epochMilliToAlarms().get((Object)BoxesRunTime.boxToLong((long)this.epochMilli)).foreach((Function1)(JProcedure1 & Serializable)alarms -> {
                    Vector remaining = (Vector)alarms.filterNot((Function1 & Serializable)_$2 -> _$2 == this);
                    if (remaining.nonEmpty()) {
                        this.$outer.js7$base$time$ClockChecking$$epochMilliToAlarms().update((Object)BoxesRunTime.boxToLong((long)this.epochMilli), (Object)remaining);
                        return;
                    }
                    this.$outer.js7$base$time$ClockChecking$$epochMilliToAlarms().$minus$eq((Object)BoxesRunTime.boxToLong((long)this.epochMilli));
                    this.$outer.js7$base$time$ClockChecking$$scheduleNext();
                });
            }
        }

        public String toString() {
            return "Alarm(" + Timestamp$.MODULE$.ofEpochMilli(this.epochMilli) + " " + this.label.apply() + ")";
        }

        public final /* synthetic */ ClockChecking js7$base$time$ClockChecking$Alarm$$$outer() {
            return this.$outer;
        }
    }
}

