/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import js7.base.circeutils.typed.TypedJsonCodec;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.LocalInterval;
import js7.base.time.LocalInterval$Standard$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.SchemeRestriction$;
import js7.base.time.SchemeRestriction$MonthRestriction$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public interface SchemeRestriction {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SchemeRestriction$.class.getDeclaredField("given_TypedJsonCodec_SchemeRestriction$lzy1"));

    public static TypedJsonCodec<SchemeRestriction> given_TypedJsonCodec_SchemeRestriction() {
        return SchemeRestriction$.MODULE$.given_TypedJsonCodec_SchemeRestriction();
    }

    public static Either<Problem, SchemeRestriction> months(Set<Object> set) {
        return SchemeRestriction$.MODULE$.months(set);
    }

    public static int ordinal(SchemeRestriction schemeRestriction) {
        return SchemeRestriction$.MODULE$.ordinal(schemeRestriction);
    }

    public boolean isUnrestricted(LocalDateTime var1, Duration var2);

    public LocalDateTime skipRestriction(LocalDateTime var1, Duration var2);

    public Option<LocalInterval.Standard> clipLocalInterval(LocalInterval.Standard var1, Duration var2);

    public static final class MonthRestriction
    implements SchemeRestriction,
    Product,
    Serializable {
        private final BitSet months;
        public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(SchemeRestriction$MonthRestriction$.class.getDeclaredField("given_Decoder_MonthRestriction$lzy1"));
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SchemeRestriction$MonthRestriction$.class.getDeclaredField("given_AsObject_MonthRestriction$lzy1"));

        public static Vector<String> MonthNames() {
            return SchemeRestriction$MonthRestriction$.MODULE$.MonthNames();
        }

        public static MonthRestriction fromProduct(Product product) {
            return SchemeRestriction$MonthRestriction$.MODULE$.fromProduct(product);
        }

        public static Encoder.AsObject<MonthRestriction> given_AsObject_MonthRestriction() {
            return SchemeRestriction$MonthRestriction$.MODULE$.given_AsObject_MonthRestriction();
        }

        public static Decoder<MonthRestriction> given_Decoder_MonthRestriction() {
            return SchemeRestriction$MonthRestriction$.MODULE$.given_Decoder_MonthRestriction();
        }

        public static MonthRestriction unapply(MonthRestriction monthRestriction) {
            return SchemeRestriction$MonthRestriction$.MODULE$.unapply(monthRestriction);
        }

        public MonthRestriction(BitSet months) {
            this.months = months;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1839397326, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            MonthRestriction monthRestriction;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MonthRestriction)) return false;
            MonthRestriction monthRestriction2 = monthRestriction = (MonthRestriction)object;
            BitSet bitSet = this.months();
            BitSet bitSet2 = monthRestriction2.months();
            if (bitSet != null) {
                if (!bitSet.equals(bitSet2)) return false;
                return true;
            }
            if (bitSet2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof MonthRestriction;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MonthRestriction";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "months";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BitSet months() {
            return this.months;
        }

        public Either<Problem, MonthRestriction> checked() {
            block5: {
                block4: {
                    if (!this.months().forall((Function1)((JFunction1.mcZI.sp & Serializable)SchemeRestriction$::js7$base$time$SchemeRestriction$MonthRestriction$$_$checked$$anonfun$1))) {
                        return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Month must be a number between 1 and 12"));
                    }
                    if (this.months().isEmpty()) break block4;
                    BitSet bitSet = this.months();
                    BitSet bitSet2 = SchemeRestriction$.js7$base$time$SchemeRestriction$$$AllMonths;
                    if (bitSet != null ? !bitSet.equals(bitSet2) : bitSet2 != null) break block5;
                }
                return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("MonthRestriction must contain between 1 and 11 months"));
            }
            return package$.MODULE$.Right().apply((Object)this);
        }

        @Override
        public boolean isUnrestricted(LocalDateTime local, Duration dateOffset) {
            return this.months().apply$mcZI$sp(local.minus(dateOffset).getMonthValue());
        }

        @Override
        public LocalDateTime skipRestriction(LocalDateTime local, Duration dateOffset) {
            LocalDateTime localMinusOffset = local.minus(dateOffset);
            int n = this.skippedMonths(localMinusOffset.getMonthValue(), this.skippedMonths$default$2());
            if (0 == n) {
                return local;
            }
            int n2 = n;
            return localMinusOffset.toLocalDate().withDayOfMonth(1).plusMonths(Int$.MODULE$.int2long(n2)).atStartOfDay().plus(dateOffset);
        }

        @Override
        public Option<LocalInterval.Standard> clipLocalInterval(LocalInterval.Standard localInterval, Duration dateOffset) {
            int n = this.skippedMonths(localInterval.start().getMonthValue(), this.skippedMonths$default$2());
            if (0 == n) {
                int monthOfEnd;
                int monthOfStart = localInterval.start().minus(dateOffset).getMonthValue();
                if (monthOfStart != (monthOfEnd = localInterval.end().minus(dateOffset).getMonthValue()) && !this.months().apply$mcZI$sp(monthOfEnd)) {
                    LocalDateTime end = SchemeRestriction$MonthRestriction$.MODULE$.js7$base$time$SchemeRestriction$MonthRestriction$$$startOfNextMonth(localInterval.start(), dateOffset);
                    long clippedSeconds = localInterval.end().toEpochSecond(ZoneOffset.UTC) - end.toEpochSecond(ZoneOffset.UTC);
                    if (clippedSeconds <= 0L) {
                        return Some$.MODULE$.apply((Object)localInterval);
                    }
                    FiniteDuration duration = localInterval.duration().$minus(ScalaTime$DurationRichLong$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichLong(clippedSeconds)));
                    boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration)));
                    return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.clipLocalInterval$$anonfun$1(localInterval, duration));
                }
                return Some$.MODULE$.apply((Object)localInterval);
            }
            int n2 = n;
            LocalDateTime start = SchemeRestriction$MonthRestriction$.MODULE$.js7$base$time$SchemeRestriction$MonthRestriction$$$startOfNextMonth(localInterval.start(), dateOffset);
            long skippedSeconds = start.toEpochSecond(ZoneOffset.UTC) - localInterval.start().toEpochSecond(ZoneOffset.UTC);
            FiniteDuration duration = localInterval.duration().$minus(ScalaTime$DurationRichLong$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichLong(skippedSeconds)));
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration)));
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.clipLocalInterval$$anonfun$2(start, duration));
        }

        private int skippedMonths(int month, boolean findAllowed) {
            int skipped = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(month), month + 12).indexWhere((Function1)(JFunction1.mcZI.sp & Serializable)m -> this.months().apply$mcZI$sp((m - 1) % 12 + 1) == findAllowed);
            if (skipped == -1) {
                throw new AssertionError((Object)"MonthRestriction.skipRestriction: No month");
            }
            return skipped;
        }

        private boolean skippedMonths$default$2() {
            return true;
        }

        public String toString() {
            return this.months().iterator().map(SchemeRestriction$::js7$base$time$SchemeRestriction$MonthRestriction$$_$toString$$anonfun$adapted$1).mkString("MonthRestriction(", " ", ")");
        }

        private MonthRestriction copy(BitSet months) {
            return new MonthRestriction(months);
        }

        private BitSet copy$default$1() {
            return this.months();
        }

        public BitSet _1() {
            return this.months();
        }

        private final LocalInterval.Standard a$proxy1$1(LocalInterval.Standard localInterval$1, FiniteDuration duration$1) {
            return LocalInterval$Standard$.MODULE$.apply(localInterval$1.start(), duration$1);
        }

        private final LocalInterval.Standard clipLocalInterval$$anonfun$1(LocalInterval.Standard localInterval$2, FiniteDuration duration$3) {
            return this.a$proxy1$1(localInterval$2, duration$3);
        }

        private final LocalInterval.Standard a$proxy2$1(LocalDateTime start$1, FiniteDuration duration$2) {
            return LocalInterval$Standard$.MODULE$.apply(start$1, duration$2);
        }

        private final LocalInterval.Standard clipLocalInterval$$anonfun$2(LocalDateTime start$2, FiniteDuration duration$4) {
            return this.a$proxy2$1(start$2, duration$4);
        }
    }
}

