/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import java.io.Serializable;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.TimeInterval$;
import js7.base.time.TimeInterval$Standard$;
import js7.base.time.Timestamp;
import js7.base.utils.Assertions$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.hashing.MurmurHash3$;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public interface TimeInterval {
    public static TimeInterval apply(Timestamp timestamp, FiniteDuration finiteDuration) {
        return TimeInterval$.MODULE$.apply(timestamp, finiteDuration);
    }

    public static TimeInterval fromStartAndEnd(Tuple2<Timestamp, Timestamp> tuple2) {
        return TimeInterval$.MODULE$.fromStartAndEnd(tuple2);
    }

    public static int ordinal(TimeInterval timeInterval) {
        return TimeInterval$.MODULE$.ordinal(timeInterval);
    }

    public static Option<TimeInterval> tryCombine(TimeInterval timeInterval, TimeInterval timeInterval2) {
        return TimeInterval$.MODULE$.tryCombine(timeInterval, timeInterval2);
    }

    public Timestamp start();

    public FiniteDuration duration();

    public Timestamp end();

    public boolean contains(Timestamp var1);

    public boolean startsBefore(Timestamp var1);

    public boolean endsBefore(Timestamp var1);

    public static final class Standard
    implements TimeInterval,
    Product,
    Serializable {
        private final Timestamp start;
        private final FiniteDuration duration;

        public static Standard apply(Timestamp timestamp, FiniteDuration finiteDuration) {
            return TimeInterval$Standard$.MODULE$.apply(timestamp, finiteDuration);
        }

        public static Standard fromProduct(Product product) {
            return TimeInterval$Standard$.MODULE$.fromProduct(product);
        }

        public static Standard unapply(Standard standard) {
            return TimeInterval$Standard$.MODULE$.unapply(standard);
        }

        public Standard(Timestamp start, FiniteDuration duration) {
            this.start = start;
            this.duration = duration;
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1(duration)), "!duration.isNegative"), FullName$.MODULE$.apply("js7.base.time.TimeInterval.Standard"), ScalaSourceLocation$.MODULE$.apply("TimeInterval.scala", 45));
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -414826243, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Standard standard;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Standard)) return false;
            Standard standard2 = standard = (Standard)object;
            Timestamp timestamp = this.start();
            Timestamp timestamp2 = standard2.start();
            if (timestamp == null) {
                if (timestamp2 != null) {
                    return false;
                }
            } else if (!timestamp.equals(timestamp2)) return false;
            FiniteDuration finiteDuration = this.duration();
            FiniteDuration finiteDuration2 = standard2.duration();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Standard;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Standard";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "start";
            }
            if (1 == n2) {
                return "duration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Timestamp start() {
            return this.start;
        }

        @Override
        public FiniteDuration duration() {
            return this.duration;
        }

        @Override
        public Timestamp end() {
            return this.start().$plus(this.duration());
        }

        @Override
        public boolean contains(Timestamp timestamp) {
            return this.start().$less$eq(timestamp) && !this.endsBefore(timestamp);
        }

        @Override
        public boolean startsBefore(Timestamp timestamp) {
            return this.start().$less$eq(timestamp);
        }

        @Override
        public boolean endsBefore(Timestamp timestamp) {
            return this.end().$less$eq(timestamp);
        }

        public Option<Standard> tryCombineStandard(Standard that) {
            return TimeInterval$Standard$.MODULE$.js7$base$time$TimeInterval$Standard$$$tryCombine2(this, that).orElse(() -> this.tryCombineStandard$$anonfun$1(that));
        }

        public String toString() {
            return "TimeInterval(" + this.start() + ".." + this.end() + " " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.duration())) + ")";
        }

        public Standard copy(Timestamp start, FiniteDuration duration) {
            return new Standard(start, duration);
        }

        public Timestamp copy$default$1() {
            return this.start();
        }

        public FiniteDuration copy$default$2() {
            return this.duration();
        }

        public Timestamp _1() {
            return this.start();
        }

        public FiniteDuration _2() {
            return this.duration();
        }

        public Option<Standard> inline$tryCombineStandard(Standard that) {
            return this.tryCombineStandard(that);
        }

        private final boolean v$proxy2$1(FiniteDuration duration$3) {
            return !ScalaTime$RichFiniteDuration$.MODULE$.isNegative$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$3));
        }

        private final Option tryCombineStandard$$anonfun$1(Standard that$1) {
            return TimeInterval$Standard$.MODULE$.js7$base$time$TimeInterval$Standard$$$tryCombine2(that$1, this);
        }
    }
}

