/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import cats.Show;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDurationCompanion$;
import js7.base.time.Timestamp;
import js7.base.time.package$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import scala.Function0;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class Timestamp$
implements Serializable {
    private static final Timestamp.Companion implementation;
    private static final Timestamp Epoch;
    private static final Timestamp MaxValue;
    private static final FiniteDuration Epsilon;
    private static final Show<Timestamp> TimestampShow;
    private static final Encoder<Timestamp> jsonEncoder;
    private static final Decoder<Timestamp> jsonDecoder;
    private static final Encoder<Timestamp> StringTimestampJsonEncoder;
    public static final Timestamp$ MODULE$;

    private Timestamp$() {
    }

    static {
        MODULE$ = new Timestamp$();
        implementation = package$.MODULE$.SystemTimestamp();
        Epoch = MODULE$.ofEpochMilli(0L);
        MaxValue = MODULE$.Epoch().$plus(ScalaTime$RichFiniteDurationCompanion$.MODULE$.MaxValue$extension(ScalaTime$.MODULE$.RichFiniteDurationCompanion(FiniteDuration$.MODULE$)));
        Epsilon = ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(1));
        TimestampShow = (Show & Serializable)_$1 -> _$1.show();
        jsonEncoder = MODULE$.implementation().jsonEncoder();
        jsonDecoder = MODULE$.implementation().jsonDecoder();
        StringTimestampJsonEncoder = MODULE$.implementation().StringTimestampJsonEncoder();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Timestamp$.class);
    }

    public Timestamp.Companion implementation() {
        return implementation;
    }

    public Timestamp Epoch() {
        return Epoch;
    }

    public Timestamp MaxValue() {
        return MaxValue;
    }

    public FiniteDuration Epsilon() {
        return Epsilon;
    }

    public Timestamp ofEpochSecond(long second) {
        return this.ofEpochMilli(second * 1000L);
    }

    public Timestamp ofEpochMilli(long milli) {
        return this.implementation().ofEpochMilli(milli);
    }

    public Timestamp apply(String dateTime) {
        return this.implementation().parse(dateTime);
    }

    public Either<Problem, Timestamp> checked(String dateTime) {
        Right right;
        try {
            right = scala.package$.MODULE$.Right().apply((Object)this.parse(dateTime));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                right = scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> Timestamp$.checked$$anonfun$1(t)), Problem$.MODULE$.apply$default$2()));
            }
            throw throwable;
        }
        return right;
    }

    public Timestamp parse(String dateTime) {
        return this.implementation().parse(dateTime);
    }

    public Timestamp now() {
        return this.ofEpochMilli(this.currentTimeMillis());
    }

    public final long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public Show<Timestamp> TimestampShow() {
        return TimestampShow;
    }

    public final Encoder<Timestamp> jsonEncoder() {
        return jsonEncoder;
    }

    public final Decoder<Timestamp> jsonDecoder() {
        return jsonDecoder;
    }

    public final Encoder<Timestamp> StringTimestampJsonEncoder() {
        return StringTimestampJsonEncoder;
    }

    private static final String checked$$anonfun$1(Throwable t$1) {
        Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
        return ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
    }
}

