/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Monoid;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.auth.Admission$;
import js7.base.auth.UserAndPassword;
import js7.base.auth.UserId;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.CatsExtensions$;
import js7.base.catsutils.FiberVar;
import js7.base.catsutils.SyncDeadline;
import js7.base.catsutils.SyncDeadline$;
import js7.base.configutils.Configs$;
import js7.base.configutils.Configs$RichConfig$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.generic.SecretString;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.monixutils.StreamPauseDetector$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Checked$RichCheckedF$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.problem.ProblemException;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.system.startup.Halt$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.OneTimeToken;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichF_$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.base.utils.Tests$;
import js7.base.web.HttpClient$;
import js7.base.web.Uri;
import js7.cluster.ActiveClusterNode$;
import js7.cluster.ClusterCommon;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterWatchSynchronizer;
import js7.cluster.watch.api.ClusterWatchConfirmation;
import js7.common.http.RecouplingStreamReader$;
import js7.data.Problems;
import js7.data.Problems$AckFromActiveClusterNodeProblem$;
import js7.data.Problems$ClusterCommandInapplicableProblem$;
import js7.data.Problems$ClusterModuleShuttingDownProblem$;
import js7.data.Problems$ClusterNodeIsNotActiveProblem$;
import js7.data.Problems$ClusterSettingNotUpdatable$;
import js7.data.Problems$ClusterSwitchOverButNotCoupledProblem$;
import js7.data.Problems$MissingPassiveClusterNodeHeartbeatProblem$;
import js7.data.Problems$PassiveClusterNodeUrlChangeableOnlyWhenNotCoupledProblem$;
import js7.data.cluster.ClusterCommand;
import js7.data.cluster.ClusterCommand$ClusterConfirmCoupling$;
import js7.data.cluster.ClusterCommand$ClusterCouple$;
import js7.data.cluster.ClusterCommand$ClusterPassiveDown$;
import js7.data.cluster.ClusterCommand$ClusterPrepareCoupling$;
import js7.data.cluster.ClusterCommand$ClusterRecouple$;
import js7.data.cluster.ClusterCommand$ClusterStartBackupNode$;
import js7.data.cluster.ClusterCommand$Response$Accepted$;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterEvent$ClusterActiveNodeRestarted$;
import js7.data.cluster.ClusterEvent$ClusterActiveNodeShutDown$;
import js7.data.cluster.ClusterEvent$ClusterCoupled$;
import js7.data.cluster.ClusterEvent$ClusterCouplingPrepared$;
import js7.data.cluster.ClusterEvent$ClusterPassiveLost$;
import js7.data.cluster.ClusterEvent$ClusterSettingUpdated$;
import js7.data.cluster.ClusterEvent$ClusterSwitchedOver$;
import js7.data.cluster.ClusterEvent$ClusterWatchRegistered$;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.cluster.ClusterState$HasNodes$;
import js7.data.cluster.ClusterTiming;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchProblems$ClusterPassiveLostWhileFailedOverTestingProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterStateEmptyProblem$;
import js7.data.cluster.ClusterWatchProblems$NoClusterWatchProblem$;
import js7.data.cluster.ClusterWatchingCommand;
import js7.data.event.ClusterableState;
import js7.data.event.EventId$;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.NoKeyEvent;
import js7.data.event.SnapshotableState;
import js7.data.event.Stamped;
import js7.data.event.Stamped$;
import js7.data.item.BasicItemEvent;
import js7.data.node.NodeId;
import js7.data.node.NodeName;
import js7.journal.FileJournal;
import js7.journal.Persisted;
import js7.journal.problems.Problems$JournalKilledProblem$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import sourcecode.Enclosing;
import sourcecode.Enclosing$;
import sourcecode.FullName$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ActiveClusterNode<S extends ClusterableState<S>> {
    public final FileJournal<S> js7$cluster$ActiveClusterNode$$journal;
    private final Option<UserAndPassword> passiveNodeUserAndPassword;
    private final ClusterCommon common;
    private final ClusterConf clusterConf;
    private final Function1<NodeName, Either<Problem, Option<SecretString>>> x$5;
    private final FiniteDuration keepAlive;
    private final AsyncLock clusterStateLock;
    private final AtomicBoolean isFetchingAcks;
    private final FiberVar<BoxedUnit> fetchingAcks;
    private final Deferred<IO, Try<Either<Problem, BoxedUnit>>> fetchingAcksTerminatedUnexpectedlyPromise;
    private final AtomicBoolean startingBackupNode;
    private final SetOnce<Fiber<IO, Throwable, BoxedUnit>> sendingClusterStartBackupNode;
    private volatile boolean stopAcknowledgingRequested;
    private final Deferred<IO, BoxedUnit> stopAcknowledging;
    private volatile boolean stopRequested;
    private final SetOnce<ClusterWatchSynchronizer> clusterWatchSynchronizerOnce;

    public ActiveClusterNode(FileJournal<S> journal, Option<UserAndPassword> passiveNodeUserAndPassword, ClusterCommon common, ClusterConf clusterConf, Function1<NodeName, Either<Problem, Option<SecretString>>> x$5) {
        this.js7$cluster$ActiveClusterNode$$journal = journal;
        this.passiveNodeUserAndPassword = passiveNodeUserAndPassword;
        this.common = common;
        this.clusterConf = clusterConf;
        this.x$5 = x$5;
        Either either = Checked$.MODULE$.Ops(Configs$RichConfig$.MODULE$.finiteDuration$extension(Configs$.MODULE$.RichConfig(clusterConf.config()), "js7.web.client.keep-alive"));
        this.keepAlive = (FiniteDuration)Checked$Ops$.MODULE$.orThrow$extension(either);
        this.clusterStateLock = AsyncLock$.MODULE$.apply(true, Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#clusterStateLock"));
        this.isFetchingAcks = new AtomicBoolean(false);
        this.fetchingAcks = new FiberVar();
        this.fetchingAcksTerminatedUnexpectedlyPromise = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.startingBackupNode = new AtomicBoolean(false);
        this.sendingClusterStartBackupNode = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(Fiber.class, LightTypeTag$.MODULE$.parse(1804357463, "\u0001\u0001\u0001\u0018cats.effect.kernel.Fiber\u0003\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\u0013java.lang.Throwable\u0001\u0001\u0000\u0000\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0000\u0001", "\u0000\u0004\u0001\u0001\u0001\u0018cats.effect.kernel.Fiber\u0003\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0000\u0004\u0000\u0001\u0013java.lang.Throwable\u0001\u0001\u0000\u0000\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0090\u0003\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0002\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0016cats.effect.IOPlatform\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0002\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001", 30)));
        this.stopAcknowledgingRequested = false;
        this.stopAcknowledging = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.stopRequested = false;
        this.clusterWatchSynchronizerOnce = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(ClusterWatchSynchronizer.class, LightTypeTag$.MODULE$.parse(-636438082, "\u0004\u0000\u0001$js7.cluster.ClusterWatchSynchronizer\u0001\u0001", "\u0000\u0000\u0000", 30)));
    }

    private ClusterWatchSynchronizer clusterWatchSynchronizer() {
        return this.clusterWatchSynchronizerOnce.orThrow();
    }

    public IO<Either<Problem, BoxedUnit>> start(long eventId) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, this.currentClusterState$1().$less$times(this.clusterStateLock.lock(this.js7$cluster$ActiveClusterNode$$journal.onPassiveLost().$times$greater(this.js7$cluster$ActiveClusterNode$$journal.persist((Function1 & Serializable)state -> {
            ClusterState clusterState = state.clusterState();
            if (clusterState instanceof ClusterState.Coupled) {
                ClusterState.Coupled coupled = (ClusterState.Coupled)clusterState;
                ClusterState.Coupled clusterState2 = coupled;
                if (!clusterState2.isNonEmptyActive(this.clusterConf.ownId())) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
                ClusterEvent.ClusterPassiveLost Event_this = ClusterEvent$ClusterPassiveLost$.MODULE$.apply(clusterState2.passiveId());
                return Right$.MODULE$.apply((Object)((SeqOps)new .colon.colon(new KeyedEvent<ClusterEvent.ClusterPassiveLost>(Event_this, keyedEvent$NoKey$), (List)Nil$.MODULE$)));
            }
            return Right$.MODULE$.apply((Object)scala.package$.MODULE$.Nil());
        })), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#start"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 93))).flatMap((Function1 & Serializable)initialClusterState -> {
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1((ClusterState.HasNodes)initialClusterState)), "initialClusterState.activeId == ownId"), FullName$.MODULE$.apply("js7.cluster.ActiveClusterNode.start"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 96));
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.defer(() -> this.start$$anonfun$2$$anonfun$1(initialClusterState)).both(this.awaitAcknowledgmentIfCoupled((ClusterState.HasNodes)initialClusterState, eventId)).map((Function1 & Serializable)x$1 -> {
                Either either = (Either)x$1._1();
                Either either2 = (Either)x$1._2();
                return (Either)package.monoid$.MODULE$.catsSyntaxSemigroup((Object)either, Checked$.MODULE$.checkedMonoid(Completed$package$Completed$.MODULE$.CompletedMonoid())).$bar$plus$bar((Object)either2);
            }));
            return this.clusterStateLock.lock((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$4 -> this.proceed((ClusterState)initialClusterState).as(Checked$.MODULE$.unit()), IO$.MODULE$.asyncForIO()), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#start"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 108));
        }), Name$.MODULE$.apply("start"));
    }

    private IO<Either<Problem, Completed$package$Completed$>> awaitAcknowledgmentIfCoupled(ClusterState.HasNodes initialClusterState, long eventId) {
        block6: {
            ClusterState.HasNodes hasNodes;
            block5: {
                block4: {
                    hasNodes = initialClusterState;
                    if (!(hasNodes instanceof ClusterState.Coupled)) break block4;
                    ClusterState.Coupled coupled = (ClusterState.Coupled)hasNodes;
                    break block5;
                }
                if (!(hasNodes instanceof ClusterState.ActiveShutDown)) break block6;
                ClusterState.ActiveShutDown activeShutDown = (ClusterState.ActiveShutDown)hasNodes;
            }
            Serializable clusterState = (Serializable)((Object)hasNodes);
            Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("Requesting the passive node's acknowledgement for the last recovered event ({}) ...", (Object)EventId$.MODULE$.toString(eventId));
            }
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.awaitAcknowledgement(((ClusterState.HasNodes)((Object)clusterState)).passiveUri(), eventId));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)ackEventId -> this.awaitAcknowledgmentIfCoupled$$anonfun$1(eventId, BoxesRunTime.unboxToLong((Object)ackEventId)), IO$.MODULE$.asyncForIO());
        }
        return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Completed$package$Completed$.MODULE$);
    }

    public IO<BoxedUnit> stop() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, IO$.MODULE$.defer(this::stop$$anonfun$1), Name$.MODULE$.apply("stop"));
    }

    public IO<Either<Problem, BoxedUnit>> changePassiveUri(Uri passiveUri, Option<BasicItemEvent.ItemAttachedToMe> extraEvent) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.common.requireValidLicense());
        return Logger$package$Logger$syntax$.MODULE$.debugIO(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$6 -> {
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.js7$cluster$ActiveClusterNode$$journal.aggregate().map((Function1 & Serializable)_$7 -> _$7.clusterState()).flatMap((Function1 & Serializable)x$12 -> {
                ClusterState clusterState = x$12;
                if (clusterState instanceof ClusterState.Coupled) {
                    ClusterState.Coupled coupled;
                    ClusterState.Coupled clusterState2 = coupled = (ClusterState.Coupled)clusterState;
                    Uri uri = passiveUri;
                    Uri uri2 = clusterState2.setting().passiveUri();
                    if (uri == null ? uri2 != null : !((Object)uri).equals(uri2)) {
                        return this.js7$cluster$ActiveClusterNode$$journal.onPassiveLost().$times$greater(this.persistWithoutTouchingHeartbeat(this.persistWithoutTouchingHeartbeat$default$1(), true, (Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
                            ClusterState clusterState = x$1;
                            if (clusterState instanceof ClusterState.Coupled) {
                                ClusterState.Coupled coupled;
                                ClusterState.Coupled clusterState2 = coupled = (ClusterState.Coupled)clusterState;
                                Uri uri = passiveUri;
                                Uri uri2 = clusterState2.setting().passiveUri();
                                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(uri == null ? uri2 != null : !((Object)uri).equals(uri2));
                                return Right$.MODULE$.apply(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> ActiveClusterNode.changePassiveUri$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(clusterState2)));
                            }
                            return Right$.MODULE$.apply((Object)None$.MODULE$);
                        }));
                    }
                }
                return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
            }));
            return this.clusterStateLock.lock(this.suspendHeartbeat(true, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$8 -> {
                IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.persistWithoutTouchingHeartbeat(extraEvent, this.persistWithoutTouchingHeartbeat$default$2(), (Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
                    ClusterState clusterState = x$1;
                    if (clusterState instanceof ClusterState.HasNodes) {
                        ClusterState.HasNodes hasNodes;
                        ClusterState.HasNodes clusterState2 = hasNodes = (ClusterState.HasNodes)clusterState;
                        Uri uri = passiveUri;
                        Uri uri2 = clusterState2.setting().passiveUri();
                        if (!(uri != null ? !((Object)uri).equals(uri2) : uri2 != null)) {
                            return Right$.MODULE$.apply((Object)None$.MODULE$);
                        }
                        if (clusterState2 instanceof ClusterState.Coupled) {
                            return scala.package$.MODULE$.Left().apply((Object)Problems$PassiveClusterNodeUrlChangeableOnlyWhenNotCoupledProblem$.MODULE$);
                        }
                        return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterSettingUpdated$.MODULE$.apply((Option<Uri>)Some$.MODULE$.apply((Object)passiveUri))));
                    }
                    ClusterState clusterState3 = clusterState;
                    return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterSettingNotUpdatable$.MODULE$.apply(clusterState3));
                }));
                return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    ClusterState clusterState = (ClusterState)tuple2._2();
                    Seq stampedEvents = (Seq)tuple2._1();
                    if (clusterState instanceof ClusterState.HasNodes) {
                        ClusterState.HasNodes hasNodes;
                        ClusterState.HasNodes state = hasNodes = (ClusterState.HasNodes)clusterState;
                        if (stampedEvents.nonEmpty()) {
                            return this.proceedNodesAppointed(state).as((Object)Right$.MODULE$.apply((Object)BoxedUnit.UNIT));
                        }
                    }
                    return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
                }, IO$.MODULE$.asyncForIO());
            }, IO$.MODULE$.asyncForIO()), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#changePassiveUri")), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#changePassiveUri"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 176));
        }, IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("changePassiveUri"));
    }

    public Option<BasicItemEvent.ItemAttachedToMe> changePassiveUri$default$2() {
        return None$.MODULE$;
    }

    public IO<Either<Problem, BoxedUnit>> emitClusterActiveNodeRestarted() {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.persist((Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
            ClusterState clusterState = x$1;
            if (clusterState instanceof ClusterState.ActiveShutDown) {
                ClusterState.ActiveShutDown activeShutDown = (ClusterState.ActiveShutDown)clusterState;
                return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterActiveNodeRestarted$.MODULE$));
            }
            return Right$.MODULE$.apply((Object)None$.MODULE$);
        }));
        return this.clusterStateLock.lock((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO()), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#emitClusterActiveNodeRestarted"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 183));
    }

    public IO<Either<Problem, ClusterCommand.Response>> executeCommand(ClusterCommand command) {
        ClusterCommand clusterCommand = command;
        if (clusterCommand instanceof ClusterCommand.ClusterStartBackupNode) {
            ClusterCommand.ClusterStartBackupNode clusterStartBackupNode = (ClusterCommand.ClusterStartBackupNode)clusterCommand;
            throw new AssertionError((Object)"ClusterStartBackupNode at the active node?");
        }
        if (clusterCommand instanceof ClusterCommand.ClusterConfirmCoupling) {
            ClusterCommand.ClusterConfirmCoupling clusterConfirmCoupling = (ClusterCommand.ClusterConfirmCoupling)clusterCommand;
            throw new AssertionError((Object)"ClusterConfirmCoupling at the active node?");
        }
        if (clusterCommand instanceof ClusterCommand.ClusterPrepareCoupling) {
            ClusterCommand.ClusterPrepareCoupling clusterPrepareCoupling = (ClusterCommand.ClusterPrepareCoupling)clusterCommand;
            ClusterCommand.ClusterPrepareCoupling clusterPrepareCoupling2 = ClusterCommand$ClusterPrepareCoupling$.MODULE$.unapply(clusterPrepareCoupling);
            NodeId nodeId = clusterPrepareCoupling2._1();
            NodeId nodeId2 = clusterPrepareCoupling2._2();
            OneTimeToken oneTimeToken = clusterPrepareCoupling2._3();
            NodeId activeId = nodeId;
            NodeId passiveId = nodeId2;
            ClusterCommand.ClusterPrepareCoupling command2 = clusterPrepareCoupling;
            return this.requireOwnNodeId(command2, activeId, IO$.MODULE$.defer(() -> this.executeCommand$$anonfun$1(command2, activeId, passiveId)));
        }
        if (clusterCommand instanceof ClusterCommand.ClusterCouple) {
            ClusterCommand.ClusterCouple clusterCouple = (ClusterCommand.ClusterCouple)clusterCommand;
            ClusterCommand.ClusterCouple clusterCouple2 = ClusterCommand$ClusterCouple$.MODULE$.unapply(clusterCouple);
            NodeId nodeId = clusterCouple2._1();
            NodeId nodeId3 = clusterCouple2._2();
            OneTimeToken oneTimeToken = clusterCouple2._3();
            NodeId activeId = nodeId;
            NodeId passiveId = nodeId3;
            ClusterCommand.ClusterCouple command3 = clusterCouple;
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.checkCouplingToken(command3));
            return this.requireOwnNodeId(command3, activeId, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$10 -> {
                IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.persist((Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
                    ClusterState clusterState;
                    block8: {
                        ClusterState.HasNodes clusterState2;
                        block10: {
                            block9: {
                                ClusterState.HasNodes hasNodes;
                                clusterState = x$1;
                                if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
                                    ClusterState clusterState3 = clusterState;
                                    return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterCommandInapplicableProblem$.MODULE$.apply(command3, clusterState3));
                                }
                                if (!(clusterState instanceof ClusterState.HasNodes)) break block8;
                                clusterState2 = hasNodes = (ClusterState.HasNodes)clusterState;
                                NodeId nodeId = clusterState2.activeId();
                                NodeId nodeId2 = activeId;
                                if (nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null) break block9;
                                NodeId nodeId3 = clusterState2.passiveId();
                                NodeId nodeId4 = passiveId;
                                if (!(nodeId3 == null ? nodeId4 != null : !((Object)nodeId3).equals(nodeId4))) break block10;
                            }
                            return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterCommandInapplicableProblem$.MODULE$.apply(command3, clusterState2));
                        }
                        ClusterState.HasNodes hasNodes = clusterState2;
                        if (hasNodes instanceof ClusterState.PassiveLost) {
                            ClusterState.PassiveLost passiveLost = (ClusterState.PassiveLost)hasNodes;
                            return Right$.MODULE$.apply((Object)None$.MODULE$);
                        }
                        if (hasNodes instanceof ClusterState.PreparedToBeCoupled) {
                            ClusterState.PreparedToBeCoupled preparedToBeCoupled = (ClusterState.PreparedToBeCoupled)hasNodes;
                            ClusterState.PreparedToBeCoupled s = preparedToBeCoupled;
                            if (!s.setting().clusterWatchId().isDefined()) {
                                return scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$NoClusterWatchProblem$.MODULE$);
                            }
                            return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterCoupled$.MODULE$.apply(activeId)));
                        }
                        if (hasNodes instanceof ClusterState.Coupled) {
                            ClusterState.Coupled coupled = (ClusterState.Coupled)hasNodes;
                            return Right$.MODULE$.apply((Object)None$.MODULE$);
                        }
                        ClusterState.HasNodes s = hasNodes;
                        return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterCommandInapplicableProblem$.MODULE$.apply(command3, s));
                    }
                    throw new MatchError((Object)clusterState);
                }));
                return this.clusterStateLock.lock((Function0<String>)((Function0 & Serializable)() -> ActiveClusterNode.executeCommand$$anonfun$2$$anonfun$1(command3)), (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
                    Seq seq = (Seq)x$1._1();
                    ClusterState clusterState = (ClusterState)x$1._2();
                    IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichF_(this.proceed(clusterState));
                    return ((IO)ScalaUtils$syntax$RichF_$.MODULE$.unless$extension(iO, seq.isEmpty(), (Monoid<Object>)IO$.MODULE$.monoidForIO(Completed$package$Completed$.MODULE$.CompletedMonoid()))).as((Object)Right$.MODULE$.apply((Object)ClusterCommand$Response$Accepted$.MODULE$));
                }, IO$.MODULE$.asyncForIO()), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 259));
            }, IO$.MODULE$.asyncForIO()));
        }
        if (clusterCommand instanceof ClusterCommand.ClusterRecouple) {
            ClusterCommand.ClusterRecouple clusterRecouple = (ClusterCommand.ClusterRecouple)clusterCommand;
            ClusterCommand.ClusterRecouple clusterRecouple2 = ClusterCommand$ClusterRecouple$.MODULE$.unapply(clusterRecouple);
            NodeId nodeId = clusterRecouple2._1();
            NodeId nodeId4 = clusterRecouple2._2();
            NodeId activeId = nodeId;
            NodeId passiveId = nodeId4;
            return this.requireOwnNodeId(command, activeId, this.clusterStateLock.lock((Function0<String>)((Function0 & Serializable)() -> ActiveClusterNode.executeCommand$$anonfun$3(command)), this.js7$cluster$ActiveClusterNode$$journal.onPassiveLost().$times$greater(this.persist((Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
                ClusterState clusterState = x$1;
                if (clusterState instanceof ClusterState.Coupled) {
                    ClusterState.Coupled coupled;
                    ClusterState.Coupled s = coupled = (ClusterState.Coupled)clusterState;
                    NodeId nodeId = s.activeId();
                    NodeId nodeId2 = activeId;
                    if (!(nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null)) {
                        NodeId nodeId3 = s.passiveId();
                        NodeId nodeId4 = passiveId;
                        if (!(nodeId3 != null ? !((Object)nodeId3).equals(nodeId4) : nodeId4 != null)) {
                            return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterPassiveLost$.MODULE$.apply(passiveId)));
                        }
                    }
                }
                return Right$.MODULE$.apply((Object)None$.MODULE$);
            }).map((Function1 & Serializable)_$11 -> _$11.map((Function1 & Serializable)_$12 -> ClusterCommand$Response$Accepted$.MODULE$))), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 273)));
        }
        if (clusterCommand instanceof ClusterCommand.ClusterPassiveDown) {
            ClusterCommand.ClusterPassiveDown clusterPassiveDown = (ClusterCommand.ClusterPassiveDown)clusterCommand;
            ClusterCommand.ClusterPassiveDown clusterPassiveDown2 = ClusterCommand$ClusterPassiveDown$.MODULE$.unapply(clusterPassiveDown);
            NodeId nodeId = clusterPassiveDown2._1();
            NodeId nodeId5 = clusterPassiveDown2._2();
            NodeId activeId = nodeId;
            NodeId passiveId = nodeId5;
            return this.requireOwnNodeId(command, activeId, IO$.MODULE$.defer(() -> this.executeCommand$$anonfun$6(passiveId, activeId)));
        }
        if (clusterCommand instanceof ClusterCommand.ClusterInhibitActivation) {
            ClusterCommand.ClusterInhibitActivation clusterInhibitActivation = (ClusterCommand.ClusterInhibitActivation)clusterCommand;
            throw new NotImplementedError();
        }
        throw new MatchError((Object)clusterCommand);
    }

    private <A> IO<Either<Problem, A>> requireOwnNodeId(ClusterCommand command, NodeId nodeId, IO<Either<Problem, A>> body) {
        NodeId nodeId2 = nodeId;
        NodeId nodeId3 = this.clusterConf.ownId();
        if (nodeId2 == null ? nodeId3 != null : !((Object)nodeId2).equals(nodeId3)) {
            ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(command.getClass());
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("'" + RichJavaClass_this.cachedSimpleScalaName() + "' command may only be directed to the active node"));
        }
        return body;
    }

    private IO<Either<Problem, BoxedUnit>> checkCouplingToken(ClusterCommand.ClusterCouplingCommand command) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.js7$cluster$ActiveClusterNode$$journal.aggregate().map((Function1 & Serializable)_$15 -> _$15.clusterState()).map((Function1 & Serializable)x$1 -> {
            ClusterState.HasNodes hasNodes;
            Some<ClusterSetting> some;
            ClusterState clusterState = x$1;
            if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
                ClusterState o = clusterState;
                return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterCommandInapplicableProblem$.MODULE$.apply(command, o));
            }
            if (clusterState instanceof ClusterState.HasNodes && !(some = ClusterState$HasNodes$.MODULE$.unapply(hasNodes = (ClusterState.HasNodes)clusterState)).isEmpty()) {
                ClusterSetting clusterSetting;
                ClusterSetting setting = clusterSetting = (ClusterSetting)some.get();
                return Right$.MODULE$.apply((Object)setting.passiveUri());
            }
            throw new MatchError((Object)clusterState);
        }));
        return Logger$package$Logger$syntax$.MODULE$.debugIO(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)passiveUri -> ((IO)((Resource)this.common.clusterNodeApi().apply((Object)Admission$.MODULE$.apply((Uri)passiveUri, this.passiveNodeUserAndPassword), (Object)"checkCouplingToken")).use((Function1 & Serializable)api -> api.login(true).$times$greater(HttpClient$.MODULE$.liftProblem(api.executeClusterCommand(ClusterCommand$ClusterConfirmCoupling$.MODULE$.apply(command.token())).void())), (MonadCancel)IO$.MODULE$.asyncForIO())).timeoutTo((Duration)ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$passiveNodeCouplingResponseTimeout, CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)ActiveClusterNode::checkCouplingToken$$anonfun$3$$anonfun$2), Problem$.MODULE$.apply$default$2()))).handleError((Function1 & Serializable)throwable -> {
            String msg;
            block0: {
                msg = "A passive cluster node wanted to couple but " + passiveUri + " does not respond";
                Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                if (!LoggerImpl_this.underlying().isErrorEnabled()) break block0;
                Object[] objectArray = new Object[2];
                objectArray[0] = msg;
                Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2);
                LoggerImpl_this.underlying().error("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            }
            return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> ActiveClusterNode.checkCouplingToken$$anonfun$3$$anonfun$3$$anonfun$1(msg)), Problem$.MODULE$.apply$default$2()));
        }), IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("checkCouplingToken"));
    }

    public IO<Either<Problem, BoxedUnit>> switchOver() {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.persist((Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
            ClusterState clusterState = x$1;
            if (clusterState instanceof ClusterState.Coupled) {
                ClusterState.Coupled coupled;
                ClusterState.Coupled coupled2 = coupled = (ClusterState.Coupled)clusterState;
                return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterSwitchedOver$.MODULE$.apply(coupled2.passiveId())));
            }
            ClusterState clusterState2 = clusterState;
            return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterSwitchOverButNotCoupledProblem$.MODULE$.apply(clusterState2));
        }));
        return this.clusterStateLock.lock((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
            Seq seq = (Seq)x$1._1();
            ClusterState clusterState = (ClusterState)x$1._2();
            this.stopAcknowledgingRequested = true;
            return ((IO)this.stopAcknowledging.complete((Object)BoxedUnit.UNIT)).as(Checked$.MODULE$.unit());
        }, IO$.MODULE$.asyncForIO()), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#switchOver"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 332));
    }

    public IO<Either<Problem, Completed$package$Completed$>> shutDownThisNode() {
        IO iO = (IO)Checked$.MODULE$.RichCheckedF(this.persist((Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
            ClusterState clusterState = x$1;
            if (clusterState instanceof ClusterState.Coupled) {
                ClusterState.Coupled coupled = (ClusterState.Coupled)clusterState;
                return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterActiveNodeShutDown$.MODULE$));
            }
            return Right$.MODULE$.apply((Object)None$.MODULE$);
        }));
        return Logger$package$Logger$syntax$.MODULE$.traceIOWithResult(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, this.clusterStateLock.lock(((IO)Checked$RichCheckedF$.MODULE$.recoverFromProblem$extension(iO, new Serializable(){

            public final boolean isDefinedAt(Problem x2) {
                Problem problem = x2;
                if (((Object)Problems$ClusterModuleShuttingDownProblem$.MODULE$).equals(problem) || ((Object)Problems$JournalKilledProblem$.MODULE$).equals(problem)) {
                    Mirror.Singleton problem2 = (Mirror.Singleton)problem;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Problem x2, Function1 function1) {
                Problem problem = x2;
                if (((Object)Problems$ClusterModuleShuttingDownProblem$.MODULE$).equals(problem) || ((Object)Problems$JournalKilledProblem$.MODULE$).equals(problem)) {
                    Mirror.Singleton problem2 = (Mirror.Singleton)problem;
                    Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\u26a0\ufe0f  shutDownThisNode: {}", (Object)problem2);
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x2);
            }
        }, IO$.MODULE$.asyncForIO())).as((Object)Right$.MODULE$.apply((Object)Completed$package$Completed$.MODULE$)), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#shutDownThisNode"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 353)), Name$.MODULE$.apply("shutDownThisNode"));
    }

    private IO<Completed$package$Completed$> proceed(ClusterState state) {
        ClusterState clusterState = state;
        if (clusterState instanceof ClusterState.NodesAppointed) {
            ClusterState.NodesAppointed nodesAppointed;
            ClusterState.NodesAppointed state2 = nodesAppointed = (ClusterState.NodesAppointed)clusterState;
            return this.proceedNodesAppointed(state2);
        }
        if (clusterState instanceof ClusterState.Coupled) {
            ClusterState.Coupled coupled;
            ClusterState.Coupled state3 = coupled = (ClusterState.Coupled)clusterState;
            return this.proceedCoupled(state3);
        }
        return CatsEffectExtensions$.MODULE$.inline$completedIO();
    }

    private IO<Completed$package$Completed$> proceedNodesAppointed(ClusterState.HasNodes clusterState) {
        IO iO;
        ClusterState.HasNodes hasNodes = clusterState;
        if (hasNodes instanceof ClusterState.NodesAppointed) {
            ClusterState.NodesAppointed nodesAppointed;
            ClusterState.NodesAppointed clusterState2 = nodesAppointed = (ClusterState.NodesAppointed)hasNodes;
            iO = ((IO)CatsExtensions$.MODULE$.ifFalse(IO$.MODULE$.apply(this::proceedNodesAppointed$$anonfun$1), (Function0<Object>)((Function0 & Serializable)() -> this.proceedNodesAppointed$$anonfun$2(clusterState2)), IO$.MODULE$.asyncForIO())).as((Object)Completed$package$Completed$.MODULE$);
        } else {
            iO = CatsEffectExtensions$.MODULE$.inline$completedIO();
        }
        return Logger$package$Logger$syntax$.MODULE$.traceIO(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, iO, Name$.MODULE$.apply("proceedNodesAppointed"));
    }

    private IO<BoxedUnit> startSendingClusterStartBackupNode(ClusterState.NodesAppointed clusterState) {
        return this.js7$cluster$ActiveClusterNode$$journal.eventWatch().started().$times$greater(this.js7$cluster$ActiveClusterNode$$journal.aggregate()).flatMap((Function1 & Serializable)state -> {
            Either either = Checked$.MODULE$.Ops(state.clusterNodeIdToName(clusterState.activeId()));
            Either either2 = Checked$.MODULE$.Ops(state.clusterNodeToUserId(clusterState.passiveId()));
            return this.common.tryEndlesslyToSendCommand(Admission$.MODULE$.apply(clusterState.passiveUri(), this.passiveNodeUserAndPassword), ClusterCommand$ClusterStartBackupNode$.MODULE$.apply(clusterState.setting(), this.js7$cluster$ActiveClusterNode$$journal.eventWatch().lastFileEventId(), (NodeName)Checked$Ops$.MODULE$.orThrow$extension(either), (UserId)Checked$Ops$.MODULE$.orThrow$extension(either2)));
        }).handleError((Function1)(JProcedure1 & Serializable)t -> {
            Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("Sending ClusterStartBackupNode command to backup node failed: " + t, t);
                return;
            }
        }).start().flatMap((Function1 & Serializable)fiber -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.startSendingClusterStartBackupNode$$anonfun$3$$anonfun$1((Fiber)fiber);
            return BoxedUnit.UNIT;
        }));
    }

    private IO<Completed$package$Completed$> proceedCoupled(ClusterState.Coupled state) {
        return this.startFetchAndHandleAcknowledgedEventIds(state);
    }

    private IO<Completed$package$Completed$> startFetchAndHandleAcknowledgedEventIds(ClusterState.Coupled initialState) {
        return IO$.MODULE$.defer(() -> this.startFetchAndHandleAcknowledgedEventIds$$anonfun$1(initialState));
    }

    private IO<Either<Problem, BoxedUnit>> fetchAndHandleAcknowledgedEventIds(NodeId passiveId, Uri passiveUri, ClusterTiming timing) {
        return ((IO)CatsExtensions$.MODULE$.untry(((IO)CatsExtensions$.MODULE$.tryIt(this.fetchAndHandleAcknowledgedEventIds2(passiveId, passiveUri, timing).flatMap((Function1 & Serializable)x$1 -> {
            Left left;
            Problem problem;
            Either either = x$1;
            if (either instanceof Left && (problem = (Problem)(left = (Left)either).value()) instanceof Problems.MissingPassiveClusterNodeHeartbeatProblem) {
                Problems.MissingPassiveClusterNodeHeartbeatProblem missingPassiveClusterNodeHeartbeatProblem = (Problems.MissingPassiveClusterNodeHeartbeatProblem)problem;
                Problems.MissingPassiveClusterNodeHeartbeatProblem missingPassiveClusterNodeHeartbeatProblem2 = Problems$MissingPassiveClusterNodeHeartbeatProblem$.MODULE$.unapply(missingPassiveClusterNodeHeartbeatProblem);
                NodeId nodeId = missingPassiveClusterNodeHeartbeatProblem2._1();
                FiniteDuration finiteDuration = missingPassiveClusterNodeHeartbeatProblem2._2();
                NodeId passiveId = nodeId;
                FiniteDuration duration = finiteDuration;
                Problems.MissingPassiveClusterNodeHeartbeatProblem missingHeartbeatProblem = missingPassiveClusterNodeHeartbeatProblem;
                Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("\u2757 No heartbeat from passive cluster " + passiveId + " since " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration)) + " - trying to continue as single active cluster node");
                }
                Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1(passiveId)), "passiveId != ownId"), FullName$.MODULE$.apply("js7.cluster.ActiveClusterNode.fetchAndHandleAcknowledgedEventIds"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 434));
                return this.js7$cluster$ActiveClusterNode$$journal.forPossibleFailoverByOtherNode(this.js7$cluster$ActiveClusterNode$$journal.aggregate().flatMap((Function1 & Serializable)aggregate -> {
                    ClusterState clusterState = aggregate.clusterState();
                    if (clusterState instanceof ClusterState.Coupled) {
                        ClusterState.Coupled coupled;
                        ClusterState.Coupled clusterState2 = coupled = (ClusterState.Coupled)clusterState;
                        ClusterEvent.ClusterPassiveLost passiveLost = ClusterEvent$ClusterPassiveLost$.MODULE$.apply(passiveId);
                        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.persistWithoutTouchingHeartbeat(this.persistWithoutTouchingHeartbeat$default$1(), this.persistWithoutTouchingHeartbeat$default$2(), (Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
                            ClusterState clusterState = x$1;
                            if (clusterState instanceof ClusterState.Coupled) {
                                ClusterState.Coupled coupled = (ClusterState.Coupled)clusterState;
                                return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)passiveLost));
                            }
                            return Right$.MODULE$.apply((Object)None$.MODULE$);
                        }).map((Function1 & Serializable)_$18 -> {
                            Either either = Checked$.MODULE$.Ops(_$18);
                            return Checked$Ops$.MODULE$.toCompleted$extension(either);
                        }));
                        IO iO2 = (IO)Checked$.MODULE$.RichCheckedF(this.common.ifClusterWatchAllowsActivation(this.clusterConf.ownId(), passiveLost, aggregate, (IO<Either<Problem, Object>>)this.js7$cluster$ActiveClusterNode$$journal.onPassiveLost().$times$greater((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, ActiveClusterNode::fetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$1$$anonfun$3, IO$.MODULE$.asyncForIO())), this.x$5));
                        return this.suspendHeartbeat(true, (IO)Checked$RichCheckedF$.MODULE$.recoverFromProblemWith$extension(iO2, (PartialFunction<Problem, Object>)new Serializable(this){
                            private final /* synthetic */ ActiveClusterNode $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public final boolean isDefinedAt(Problem x2) {
                                Problem problem = x2;
                                if (((Object)ClusterWatchProblems$ClusterPassiveLostWhileFailedOverTestingProblem$.MODULE$).equals(problem)) {
                                    Problem problem2 = problem;
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(Problem x2, Function1 function1) {
                                Problem problem = x2;
                                if (((Object)ClusterWatchProblems$ClusterPassiveLostWhileFailedOverTestingProblem$.MODULE$).equals(problem)) {
                                    Problem problem2 = problem;
                                    return this.$outer.js7$cluster$ActiveClusterNode$$journal.kill().as((Object)scala.package$.MODULE$.Left().apply((Object)problem2));
                                }
                                return function1.apply((Object)x2);
                            }
                        }, IO$.MODULE$.asyncForIO()), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#fetchAndHandleAcknowledgedEventIds")).map((Function1 & Serializable)_$19 -> _$19.flatMap((Function1 & Serializable)allowed -> ActiveClusterNode.fetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(missingHeartbeatProblem, BoxesRunTime.unboxToBoolean((Object)allowed))));
                    }
                    return IO$.MODULE$.pure((Object)scala.package$.MODULE$.Left().apply((Object)missingHeartbeatProblem));
                }));
            }
            Either o = either;
            return IO$.MODULE$.pure((Object)o);
        }), IO$.MODULE$.asyncForIO())).flatTap((Function1 & Serializable)tried -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.fetchAndHandleAcknowledgedEventIds$$anonfun$2$$anonfun$1((Try)tried, passiveUri);
            return BoxedUnit.UNIT;
        })), IO$.MODULE$.asyncForIO(), $less$colon$less$.MODULE$.refl())).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.fetchAndHandleAcknowledgedEventIds$$anonfun$3();
            return BoxedUnit.UNIT;
        }));
    }

    private IO<Either<Problem, BoxedUnit>> fetchAndHandleAcknowledgedEventIds2(NodeId passiveId, Uri passiveUri, ClusterTiming timing) {
        return Logger$package$Logger$syntax$.MODULE$.debugIOWithResult(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, HttpClient$.MODULE$.liftProblem(((IO)Stream$.MODULE$.resource((Resource)this.common.clusterNodeApi().apply((Object)Admission$.MODULE$.apply(passiveUri, this.passiveNodeUserAndPassword), (Object)"acknowledgements"), (MonadCancel)IO$.MODULE$.asyncForIO()).flatMap((Function1 & Serializable)api -> StreamExtensions$.MODULE$.interruptWhenF(StreamExtensions$.MODULE$.onlyNewest(StreamPauseDetector$.MODULE$.detectPauses(this.streamEventIds((ClusterNodeApi)api, timing.heartbeat().min(this.keepAlive), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)EventId$.MODULE$.Heartbeat()))).through((Function1 & Serializable)stream -> (Stream)this.clusterConf.testAckLossPropertyKey().fold(() -> ActiveClusterNode.fetchAndHandleAcknowledgedEventIds2$$anonfun$1$$anonfun$1$$anonfun$1(stream), (Function1 & Serializable)k -> {
            BooleanRef logged = BooleanRef.create((boolean)false);
            return stream.filter((Function1)(JFunction1.mcZJ.sp & Serializable)_$20 -> {
                boolean suppress = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.props().apply(k)));
                if (suppress) {
                    Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("\u274c\u274c Received acknowledgements are suppressed by js7.journal.cluster.TEST-ACK-LOSS={}", k);
                    }
                    logged$1.elem = true;
                }
                return !suppress;
            });
        })), timing.passiveLostTimeout()).filter((Function1 & Serializable)_$21 -> {
            Either either = _$21;
            Right<Nothing$, Object> right = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$RightEventIdHeartbeat;
            return either == null ? right != null : !either.equals(right);
        }), IO$.MODULE$.asyncForIO(), Eq$.MODULE$.catsKernelEqForEither(SyncDeadline$.MODULE$.given_Eq_SyncDeadline(), (Eq)Eq$.MODULE$.catsKernelInstancesForLong())), ((IO)this.stopAcknowledging.get()).$times$greater(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            ActiveClusterNode.fetchAndHandleAcknowledgedEventIds2$$anonfun$1$$anonfun$3();
            return BoxedUnit.UNIT;
        })), IO$.MODULE$.asyncForIO()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                SyncDeadline noHeartbeatSince = (SyncDeadline)left.value();
                return Stream$.MODULE$.eval(SyncDeadline$.MODULE$.usingNow((Function1 & Serializable)contextual$1 -> Problems$MissingPassiveClusterNodeHeartbeatProblem$.MODULE$.apply(passiveId, noHeartbeatSince.elapsed((SyncDeadline.Now)contextual$1)))).flatMap((Function1 & Serializable)problem -> {
                    block0: {
                        Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                        if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
                        LoggerImpl_this.underlying().debug("\ud83d\udca5 {}", problem);
                    }
                    return Stream$.MODULE$.emit(problem);
                }, NotGiven$.MODULE$.value());
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                long eventId = BoxesRunTime.unboxToLong((Object)right.value());
                return Stream$.MODULE$.exec(this.js7$cluster$ActiveClusterNode$$journal.onPassiveNodeHasAcknowledged(eventId));
            }
            throw new MatchError((Object)either);
        }, NotGiven$.MODULE$.value()), NotGiven$.MODULE$.value()).head().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).last()).map((Function1 & Serializable)_$22 -> _$22.toLeft((Function0 & Serializable)() -> {
            ActiveClusterNode.fetchAndHandleAcknowledgedEventIds2$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        }))).map((Function1 & Serializable)_$23 -> _$23.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())), Name$.MODULE$.apply("fetchAndHandleAcknowledgedEventIds2"));
    }

    private IO<Either<Problem, Object>> awaitAcknowledgement(Uri passiveUri, long eventId) {
        IO iO = (IO)((Resource)this.common.clusterNodeApi().apply((Object)Admission$.MODULE$.apply(passiveUri, this.passiveNodeUserAndPassword), (Object)"awaitAcknowledgement")).use((Function1 & Serializable)api -> HttpClient$.MODULE$.liftProblem(((IO)this.streamEventIds((ClusterNodeApi)api, this.keepAlive, this.streamEventIds$default$3()).dropWhile((Function1)(JFunction1.mcZJ.sp & Serializable)_$24 -> _$24 < eventId).head().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).last()).map((Function1 & Serializable)_$25 -> _$25.toRight(() -> ActiveClusterNode.$anonfun$1$$anonfun$2$$anonfun$1(eventId)))).map((Function1 & Serializable)_$26 -> _$26.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl())), (MonadCancel)IO$.MODULE$.asyncForIO());
        return Logger$package$Logger$syntax$.MODULE$.debugIOWithResult(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)ActiveClusterNode::awaitAcknowledgement$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)), Name$.MODULE$.apply("awaitAcknowledgement"));
    }

    private Stream<IO, Object> streamEventIds(ClusterNodeApi api, FiniteDuration heartbeat, Option<Object> returnHeartbeatAs) {
        return RecouplingStreamReader$.MODULE$.stream((Function1 & Serializable)_$27 -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)_$27))), api, this.clusterConf.recouplingStreamReader(), BoxesRunTime.boxToLong((long)-1L), (Function1 & Serializable)_$28 -> HttpClient$.MODULE$.liftProblem(api.eventIdStream(api.eventIdStream$default$1(), (Option<FiniteDuration>)Some$.MODULE$.apply((Object)heartbeat), (Option<Object>)returnHeartbeatAs, true).map((Function1 & Serializable)_$29 -> _$29.evalMapChunk((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return IO$.MODULE$.raiseError(problem.throwable());
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                long eventId = BoxesRunTime.unboxToLong((Object)right.value());
                return IO$.MODULE$.pure((Object)BoxesRunTime.boxToLong((long)eventId));
            }
            throw new MatchError((Object)either);
        }, (Applicative)IO$.MODULE$.asyncForIO()))), RecouplingStreamReader$.MODULE$.stream$default$6(), (Function0<Object>)(Function0 & Serializable)() -> this.stopRequested, Tag$.MODULE$.apply(Long.TYPE, LightTypeTag$.MODULE$.parse(1058951704, "\u0004\u0000\u0001\nscala.Long\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\nscala.Long\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)));
    }

    private Option<Object> streamEventIds$default$3() {
        return None$.MODULE$;
    }

    public IO<Either<Problem, BoxedUnit>> executeClusterWatchConfirm(ClusterWatchingCommand.ClusterWatchConfirm cmd) {
        return this.common.clusterWatchCounterpart().executeClusterWatchConfirm(cmd);
    }

    private IO<Either<Problem, BoxedUnit>> registerClusterWatchId(ClusterWatchConfirmation confirmation, boolean alreadyLocked) {
        return Logger$package$Logger$syntax$.MODULE$.traceIOWithResult(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, "registerClusterWatchId", (Function0<Object>)((Function0 & Serializable)() -> ActiveClusterNode.registerClusterWatchId$$anonfun$1(confirmation)), IO$.MODULE$.defer(() -> this.registerClusterWatchId$$anonfun$2(alreadyLocked, confirmation)));
    }

    private IO<Either<Problem, BoxedUnit>> nonLockingRegisterClusterWatchId(ClusterWatchConfirmation confirmation) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.js7$cluster$ActiveClusterNode$$journal.clusterState().flatMap((Function1 & Serializable)clusterState -> {
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> this.nonLockingRegisterClusterWatchId$$anonfun$1$$anonfun$1(clusterState, confirmation)));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$30 -> this.nonLockingRegisterClusterWatchId$$anonfun$1$$anonfun$2((ClusterState)clusterState, confirmation, BoxesRunTime.unboxToBoolean((Object)_$30)), IO$.MODULE$.asyncForIO());
        }));
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO, (Function1 & Serializable)_$33 -> this.common.clusterWatchCounterpart().onClusterWatchRegistered(confirmation.clusterWatchId()).as(Checked$.MODULE$.unit()), IO$.MODULE$.asyncForIO()));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, (Function1 & Serializable)x$1 -> {
            AbstractSeq abstractSeq = (AbstractSeq)x$1._1();
            ClusterState clusterState = (ClusterState)x$1._2();
            Seq events = (Seq)abstractSeq.map((Function1 & Serializable)_$34 -> (ClusterEvent.ClusterWatchRegistered)((KeyedEvent)_$34.value()).event());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)events, (Object)clusterState);
            ClusterState clusterState2 = (ClusterState)tuple2._2();
            SeqOps seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)tuple2._1());
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) {
                ClusterEvent.ClusterWatchRegistered clusterWatchRegistered;
                ClusterEvent.ClusterWatchRegistered event = clusterWatchRegistered = (ClusterEvent.ClusterWatchRegistered)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                if (clusterState2 instanceof ClusterState.HasNodes) {
                    ClusterState.HasNodes hasNodes;
                    ClusterState.HasNodes clusterState3 = hasNodes = (ClusterState.HasNodes)clusterState2;
                    ClusterWatchSynchronizer clusterWatchSynchronizer = this.clusterWatchSynchronizer();
                    IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(clusterWatchSynchronizer.applyEvent(event, clusterState3, event != null, clusterWatchSynchronizer.applyEvent$default$4()));
                    return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO());
                }
            }
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
            }
            Tuple2 o = tuple2;
            throw new MatchError((Object)o);
        }, IO$.MODULE$.asyncForIO());
    }

    private Either<Problem, Object> isClusterWatchRegistered(ClusterState clusterState, ClusterWatchId clusterWatchId) {
        ClusterState clusterState2 = clusterState;
        if (ClusterState$Empty$.MODULE$.equals(clusterState2)) {
            return scala.package$.MODULE$.Left().apply((Object)ClusterWatchProblems$ClusterStateEmptyProblem$.MODULE$);
        }
        if (clusterState2 instanceof ClusterState.HasNodes) {
            ClusterState.HasNodes hasNodes;
            ClusterState.HasNodes hasNodes2 = hasNodes = (ClusterState.HasNodes)clusterState2;
            NodeId nodeId = hasNodes2.activeId();
            NodeId nodeId2 = this.clusterConf.ownId();
            if (nodeId == null ? nodeId2 != null : !((Object)nodeId).equals(nodeId2)) {
                return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterNodeIsNotActiveProblem$.MODULE$);
            }
            return Right$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)hasNodes2.setting().clusterWatchId().contains((Object)clusterWatchId)));
        }
        throw new MatchError((Object)clusterState2);
    }

    public IO<Either<Problem, BoxedUnit>> onTerminatedUnexpectedly() {
        return (IO)CatsExtensions$.MODULE$.untry(this.fetchingAcksTerminatedUnexpectedlyPromise.get(), IO$.MODULE$.asyncForIO(), $less$colon$less$.MODULE$.refl());
    }

    private IO<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<ClusterEvent>>>, ClusterState>>> persist(Function1<ClusterState, Either<Problem, Option<ClusterEvent>>> toEvents) {
        return this.suspendHeartbeat(true, this.persistWithoutTouchingHeartbeat(this.persistWithoutTouchingHeartbeat$default$1(), this.persistWithoutTouchingHeartbeat$default$2(), toEvents), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#persist"));
    }

    private IO<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<ClusterEvent>>>, ClusterState>>> persistWithoutTouchingHeartbeat(Option<BasicItemEvent.ItemAttachedToMe> extraEvent, boolean dontAskClusterWatchWhenUntaught, Function1<ClusterState, Either<Problem, Option<ClusterEvent>>> toEvents) {
        return IO$.MODULE$.defer(() -> this.persistWithoutTouchingHeartbeat$$anonfun$1(toEvents, extraEvent, dontAskClusterWatchWhenUntaught));
    }

    private Option<BasicItemEvent.ItemAttachedToMe> persistWithoutTouchingHeartbeat$default$1() {
        return None$.MODULE$;
    }

    private boolean persistWithoutTouchingHeartbeat$default$2() {
        return false;
    }

    private <A> IO<Either<Problem, A>> suspendHeartbeat(boolean forEvent, IO<Either<Problem, A>> io, Enclosing enclosing) {
        return this.clusterWatchSynchronizer().suspendHeartbeat(this.js7$cluster$ActiveClusterNode$$journal.clusterState(), forEvent, io, enclosing);
    }

    private boolean suspendHeartbeat$default$1() {
        return false;
    }

    private final IO currentClusterState$1() {
        return this.js7$cluster$ActiveClusterNode$$journal.clusterState().map((Function1 & Serializable)_$1 -> (ClusterState.HasNodes)_$1);
    }

    private final boolean v$proxy1$1(ClusterState.HasNodes initialClusterState$1) {
        NodeId nodeId = initialClusterState$1.activeId();
        NodeId nodeId2 = this.clusterConf.ownId();
        return !(nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null);
    }

    private final /* synthetic */ IO start$$anonfun$2$$anonfun$1$$anonfun$1(ClusterWatchConfirmation confirmation, boolean alreadyLocked) {
        return this.registerClusterWatchId(confirmation, alreadyLocked);
    }

    private final IO start$$anonfun$2$$anonfun$1(ClusterState.HasNodes initialClusterState$2) {
        this.clusterWatchSynchronizerOnce.$colon$eq(this.common.initialClusterWatchSynchronizer(initialClusterState$2));
        return this.clusterWatchSynchronizer().start((IO<ClusterState.HasNodes>)this.currentClusterState$1(), (Function2<ClusterWatchConfirmation, Object, IO<Either<Problem, BoxedUnit>>>)(Function2 & Serializable)(confirmation, alreadyLocked) -> this.start$$anonfun$2$$anonfun$1$$anonfun$1((ClusterWatchConfirmation)confirmation, BoxesRunTime.unboxToBoolean((Object)alreadyLocked)));
    }

    private static final String awaitAcknowledgmentIfCoupled$$anonfun$1$$anonfun$1(long ackEventId$1) {
        return "Passive Cluster node most recently acknowledged " + EventId$.MODULE$.toString(ackEventId$1) + " which is NOT the expected EventId";
    }

    private final /* synthetic */ IO awaitAcknowledgmentIfCoupled$$anonfun$1(long eventId$2, long ackEventId) {
        if (ackEventId == eventId$2 || ackEventId == this.js7$cluster$ActiveClusterNode$$journal.unsafeAggregate().eventId()) {
            Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("\u2714\ufe0e Passive node acknowledged the recovered state");
            }
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Completed$package$Completed$.MODULE$);
        }
        return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> ActiveClusterNode.awaitAcknowledgmentIfCoupled$$anonfun$1$$anonfun$1(ackEventId)), Problem$.MODULE$.apply$default$2()));
    }

    private static final IO stop$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO stop$$anonfun$1() {
        this.stopRequested = true;
        this.stopAcknowledgingRequested = true;
        return ((IO)this.stopAcknowledging.complete((Object)BoxedUnit.UNIT)).$times$greater(IO$.MODULE$.both(Logger$package$Logger$syntax$.MODULE$.traceIO(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, "fetchingAcks cancel", Logger$package$Logger$syntax$.MODULE$.traceIO$default$3(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger), this.fetchingAcks.cancel()), Logger$package$Logger$syntax$.MODULE$.traceIO(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger, "clusterWatchSynchronizerOnce stop", Logger$package$Logger$syntax$.MODULE$.traceIO$default$3(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger), (IO)this.clusterWatchSynchronizerOnce.toOption().fold(ActiveClusterNode::stop$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$5 -> _$5.stop()))).void());
    }

    private static final ClusterEvent.ClusterPassiveLost a$proxy1$1(ClusterState.Coupled clusterState$1) {
        return ClusterEvent$ClusterPassiveLost$.MODULE$.apply(clusterState$1.passiveId());
    }

    private static final ClusterEvent.ClusterPassiveLost changePassiveUri$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(ClusterState.Coupled clusterState$8) {
        return ActiveClusterNode.a$proxy1$1(clusterState$8);
    }

    private static final String executeCommand$$anonfun$1$$anonfun$1(ClusterCommand.ClusterPrepareCoupling command$2) {
        return command$2.toShortString();
    }

    private final IO executeCommand$$anonfun$1(ClusterCommand.ClusterPrepareCoupling command$1, NodeId activeId$1, NodeId passiveId$1) {
        if (this.stopAcknowledgingRequested | this.stopRequested) {
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("Active cluster node is shutting down"));
        }
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.checkCouplingToken(command$1));
        return this.clusterStateLock.lock((Function0<String>)((Function0 & Serializable)() -> ActiveClusterNode.executeCommand$$anonfun$1$$anonfun$1(command$1)), (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$9 -> {
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.persist((Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
                ClusterState clusterState;
                block9: {
                    ClusterState.HasNodes hasNodes;
                    block15: {
                        ClusterState.HasNodes clusterState2;
                        block13: {
                            block14: {
                                block12: {
                                    block11: {
                                        block10: {
                                            ClusterState.HasNodes hasNodes2;
                                            clusterState = x$1;
                                            if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
                                                return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterCommandInapplicableProblem$.MODULE$.apply(command$1, ClusterState$Empty$.MODULE$));
                                            }
                                            if (!(clusterState instanceof ClusterState.HasNodes)) break block9;
                                            clusterState2 = hasNodes2 = (ClusterState.HasNodes)clusterState;
                                            NodeId nodeId = clusterState2.activeId();
                                            NodeId nodeId2 = activeId$1;
                                            if (nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null) break block10;
                                            NodeId nodeId3 = clusterState2.passiveId();
                                            NodeId nodeId4 = passiveId$1;
                                            if (!(nodeId3 == null ? nodeId4 != null : !((Object)nodeId3).equals(nodeId4))) break block11;
                                        }
                                        return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterCommandInapplicableProblem$.MODULE$.apply(command$1, clusterState2));
                                    }
                                    hasNodes = clusterState2;
                                    if (hasNodes instanceof ClusterState.IsDecoupled) {
                                        ClusterState.IsDecoupled isDecoupled = (ClusterState.IsDecoupled)hasNodes;
                                        return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterCouplingPrepared$.MODULE$.apply(activeId$1)));
                                    }
                                    if (!(hasNodes instanceof ClusterState.PreparedToBeCoupled)) break block12;
                                    ClusterState.PreparedToBeCoupled preparedToBeCoupled = (ClusterState.PreparedToBeCoupled)hasNodes;
                                    break block13;
                                }
                                if (!(hasNodes instanceof ClusterState.Coupled)) break block14;
                                ClusterState.Coupled coupled = (ClusterState.Coupled)hasNodes;
                                break block13;
                            }
                            if (!(hasNodes instanceof ClusterState.ActiveShutDown)) break block15;
                            ClusterState.ActiveShutDown activeShutDown = (ClusterState.ActiveShutDown)hasNodes;
                        }
                        Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("ClusterPrepareCoupling command ignored in clusterState={}", (Object)clusterState2);
                        }
                        return Right$.MODULE$.apply((Object)None$.MODULE$);
                    }
                    throw new MatchError((Object)hasNodes);
                }
                throw new MatchError((Object)clusterState);
            }));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
                Seq seq = (Seq)x$1._1();
                ClusterState clusterState = (ClusterState)x$1._2();
                IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichF_(this.proceed(clusterState));
                return ((IO)ScalaUtils$syntax$RichF_$.MODULE$.unless$extension(iO, seq.isEmpty(), (Monoid<Object>)IO$.MODULE$.monoidForIO(Completed$package$Completed$.MODULE$.CompletedMonoid()))).as((Object)Right$.MODULE$.apply((Object)ClusterCommand$Response$Accepted$.MODULE$));
            }, IO$.MODULE$.asyncForIO());
        }, IO$.MODULE$.asyncForIO()), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 220));
    }

    private static final String executeCommand$$anonfun$2$$anonfun$1(ClusterCommand.ClusterCouple command$6) {
        return command$6.toShortString();
    }

    private static final String executeCommand$$anonfun$3(ClusterCommand command$8) {
        return command$8.toShortString();
    }

    private final IO executeCommand$$anonfun$6(NodeId passiveId$7, NodeId activeId$7) {
        block0: {
            Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
            if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
            LoggerImpl_this.underlying().info("The passive {} is shutting down", (Object)passiveId$7);
        }
        return this.js7$cluster$ActiveClusterNode$$journal.onPassiveLost().$times$greater(this.persist((Function1<ClusterState, Either<Problem, Option<ClusterEvent>>>)(Function1 & Serializable)x$1 -> {
            ClusterState clusterState = x$1;
            if (clusterState instanceof ClusterState.Coupled) {
                ClusterState.Coupled coupled;
                ClusterState.Coupled s = coupled = (ClusterState.Coupled)clusterState;
                NodeId nodeId = s.activeId();
                NodeId nodeId2 = activeId$7;
                if (!(nodeId != null ? !((Object)nodeId).equals(nodeId2) : nodeId2 != null)) {
                    NodeId nodeId3 = s.passiveId();
                    NodeId nodeId4 = passiveId$7;
                    if (!(nodeId3 != null ? !((Object)nodeId3).equals(nodeId4) : nodeId4 != null)) {
                        return Right$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ClusterEvent$ClusterPassiveLost$.MODULE$.apply(passiveId$7)));
                    }
                }
            }
            return Right$.MODULE$.apply((Object)None$.MODULE$);
        }).map((Function1 & Serializable)_$13 -> _$13.map((Function1 & Serializable)_$14 -> ClusterCommand$Response$Accepted$.MODULE$)));
    }

    private static final String checkCouplingToken$$anonfun$3$$anonfun$2() {
        return "Passive node did not respond within " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$passiveNodeCouplingResponseTimeout));
    }

    private static final String checkCouplingToken$$anonfun$3$$anonfun$3$$anonfun$1(String msg$1) {
        return msg$1;
    }

    private final boolean proceedNodesAppointed$$anonfun$1() {
        return this.startingBackupNode.getAndSet(true);
    }

    private final IO proceedNodesAppointed$$anonfun$2(ClusterState.NodesAppointed clusterState$2) {
        return this.startSendingClusterStartBackupNode(clusterState$2);
    }

    private final void startSendingClusterStartBackupNode$$anonfun$3$$anonfun$1(Fiber fiber$1) {
        this.sendingClusterStartBackupNode.$colon$eq((Fiber<IO, Throwable, BoxedUnit>)fiber$1);
    }

    private final IO startFetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$1(ClusterState.Coupled initialState$2) {
        return this.fetchAndHandleAcknowledgedEventIds(initialState$2.passiveId(), initialState$2.passiveUri(), initialState$2.timing());
    }

    private final IO startFetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$2$$anonfun$1(Try tried$1) {
        return ((IO)this.fetchingAcksTerminatedUnexpectedlyPromise.complete((Object)tried$1)).void();
    }

    private final IO startFetchAndHandleAcknowledgedEventIds$$anonfun$1(ClusterState.Coupled initialState$1) {
        if (this.isFetchingAcks.getAndSet(true)) {
            Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("fetchAndHandleAcknowledgedEventIds: already isFetchingAcks");
            }
            return IO$.MODULE$.pure((Object)Completed$package$Completed$.MODULE$);
        }
        return CatsEffectExtensions$.MODULE$.startAndLogError(((IO)CatsExtensions$.MODULE$.tryIt(CorrelId$.MODULE$.bindNew(() -> this.startFetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$1(initialState$1), CanBindCorrelId$.MODULE$.io()), IO$.MODULE$.asyncForIO())).flatTap((Function1 & Serializable)x$1 -> {
            Left left;
            Success success;
            Either either;
            Try try_ = x$1;
            if (try_ instanceof Success && (either = (Either)(success = (Success)try_).value()) instanceof Left && (left = (Left)either).value() instanceof Problems.MissingPassiveClusterNodeHeartbeatProblem) {
                Problems.MissingPassiveClusterNodeHeartbeatProblem missingPassiveClusterNodeHeartbeatProblem = (Problems.MissingPassiveClusterNodeHeartbeatProblem)left.value();
                return IO$.MODULE$.unit();
            }
            Try tried = try_;
            return IO$.MODULE$.unlessA(this.stopAcknowledgingRequested | this.stopRequested, () -> this.startFetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$2$$anonfun$1(tried));
        }).void(), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#startFetchAndHandleAcknowledgedEventIds")).flatMap((Function1 & Serializable)fiber -> this.fetchingAcks.set((Fiber<IO, Throwable, BoxedUnit>)fiber)).as((Object)Completed$package$Completed$.MODULE$);
    }

    private final boolean v$proxy2$1(NodeId passiveId$9) {
        NodeId nodeId = passiveId$9;
        NodeId nodeId2 = this.clusterConf.ownId();
        return nodeId == null ? nodeId2 != null : !((Object)nodeId).equals(nodeId2);
    }

    private static final boolean fetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$1$$anonfun$3() {
        return true;
    }

    private static final /* synthetic */ Either fetchAndHandleAcknowledgedEventIds$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(Problems.MissingPassiveClusterNodeHeartbeatProblem missingHeartbeatProblem$3, boolean allowed) {
        if (!allowed) {
            return Checked$.MODULE$.unit();
        }
        return scala.package$.MODULE$.Left().apply((Object)missingHeartbeatProblem$3);
    }

    private final void fetchAndHandleAcknowledgedEventIds$$anonfun$2$$anonfun$1(Try tried$2, Uri passiveUri$7) {
        Try try_ = tried$2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Either either = (Either)success.value();
            if (either instanceof Right) {
                Right right = (Right)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = right.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    if (!this.stopAcknowledgingRequested && !this.stopRequested) {
                        Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error("fetchAndHandleAcknowledgedEventIds terminated unexpectedly");
                            return;
                        }
                        return;
                    }
                    return;
                }
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                if (problem instanceof Problems.MissingPassiveClusterNodeHeartbeatProblem) {
                    Problems.MissingPassiveClusterNodeHeartbeatProblem missingPassiveClusterNodeHeartbeatProblem = (Problems.MissingPassiveClusterNodeHeartbeatProblem)problem;
                    Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("\u2757 Continue as single active cluster node, without passive node");
                        return;
                    }
                    return;
                }
                if (((Object)Problems$ClusterModuleShuttingDownProblem$.MODULE$).equals(problem)) {
                    Problem problem2 = problem;
                    Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("fetchAndHandleAcknowledgedEventIds({}) failed with {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{passiveUri$7, problem2}), Object.class));
                        return;
                    }
                    return;
                }
                Problem problem3 = problem;
                Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("fetchAndHandleAcknowledgedEventIds({}) failed with {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{passiveUri$7, problem3}), Object.class));
                    return;
                }
                return;
            }
        }
        if (try_ instanceof Failure) {
            ProblemException problemException;
            ProblemException t;
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            if (throwable instanceof ProblemException && (t = (problemException = (ProblemException)throwable)).problem().is(Problems$AckFromActiveClusterNodeProblem$.MODULE$)) {
                if (Tests$.MODULE$.isTest()) {
                    throw new RuntimeException("\ud83d\udfe5 Halt suppressed for testing: " + t.problem());
                }
                throw Halt$.MODULE$.haltJava("\ud83d\udfe5 HALT because other cluster node has become active", true, Halt$.MODULE$.haltJava$default$3());
            }
            Throwable t2 = throwable;
            Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t2);
                LoggerImpl_this.underlying().error("fetchAndHandleAcknowledgedEventIds(" + passiveUri$7 + ") failed with " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2), t2);
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    private final void fetchAndHandleAcknowledgedEventIds$$anonfun$3() {
        Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("isFetchingAcks := false");
        }
        this.isFetchingAcks.set(false);
    }

    private static final Stream fetchAndHandleAcknowledgedEventIds2$$anonfun$1$$anonfun$1$$anonfun$1(Stream stream$1) {
        return stream$1;
    }

    private static final void fetchAndHandleAcknowledgedEventIds2$$anonfun$1$$anonfun$3() {
        Logger LoggerImpl_this = ActiveClusterNode$.js7$cluster$ActiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Stop fetchAndHandleAcknowledgedEventIds2 due to stopAcknowledging");
            return;
        }
    }

    private static final void fetchAndHandleAcknowledgedEventIds2$$anonfun$2$$anonfun$1() {
    }

    private static final Problem $anonfun$1$$anonfun$2$$anonfun$1(long eventId$6) {
        return Problem$.MODULE$.pure("awaitAcknowledgement(" + eventId$6 + "): Stream ended unexpectedly");
    }

    private static final String awaitAcknowledgement$$anonfun$1() {
        return "passive cluster node acknowledgement";
    }

    private static final Object registerClusterWatchId$$anonfun$1(ClusterWatchConfirmation confirmation$1) {
        return confirmation$1;
    }

    private final IO registerClusterWatchId$$anonfun$2(boolean alreadyLocked$1, ClusterWatchConfirmation confirmation$2) {
        if (alreadyLocked$1) {
            return this.nonLockingRegisterClusterWatchId(confirmation$2);
        }
        return this.clusterStateLock.lock(this.nonLockingRegisterClusterWatchId(confirmation$2), Enclosing$.MODULE$.apply("js7.cluster.ActiveClusterNode#registerClusterWatchId"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 606));
    }

    private final Either nonLockingRegisterClusterWatchId$$anonfun$1$$anonfun$1(ClusterState clusterState$4, ClusterWatchConfirmation confirmation$3) {
        return this.isClusterWatchRegistered(clusterState$4, confirmation$3.clusterWatchId());
    }

    private static final KeyedEvent nonLockingRegisterClusterWatchId$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(ClusterWatchConfirmation confirmation$8) {
        KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
        ClusterEvent.ClusterWatchRegistered Event_this = ClusterEvent$ClusterWatchRegistered$.MODULE$.apply(confirmation$8.clusterWatchId());
        return new KeyedEvent<ClusterEvent.ClusterWatchRegistered>(Event_this, keyedEvent$NoKey$);
    }

    private final /* synthetic */ IO nonLockingRegisterClusterWatchId$$anonfun$1$$anonfun$2(ClusterState clusterState$5, ClusterWatchConfirmation confirmation$5, boolean _$30) {
        if (_$30) {
            Nil$ nil$ = (Nil$)Predef$.MODULE$.ArrowAssoc((Object)scala.package$.MODULE$.Nil());
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)nil$, (Object)clusterState$5));
        }
        return this.js7$cluster$ActiveClusterNode$$journal.persistTransaction((Function1 & Serializable)aggregate -> this.isClusterWatchRegistered(aggregate.clusterState(), confirmation$5.clusterWatchId()).map((Function1 & Serializable)_$31 -> ScalaUtils$syntax$RichBoolean$.MODULE$.thenList$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!BoxesRunTime.unboxToBoolean((Object)_$31)), () -> ActiveClusterNode.nonLockingRegisterClusterWatchId$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(confirmation$5)))).map((Function1 & Serializable)_$32 -> _$32.map((Function1 & Serializable)persisted -> {
            Vector vector = (Vector)Predef$.MODULE$.ArrowAssoc(persisted.stampedKeyedEvents());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vector, (Object)((SnapshotableState)persisted.aggregate()).clusterState());
        }));
    }

    private final boolean v$proxy3$1() {
        return !this.clusterWatchSynchronizer().isHeartbeating();
    }

    private static final String persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(ClusterEvent event$1) {
        return "ClusterEvent is only allowed at the active cluster node: " + event$1;
    }

    private final boolean v$proxy4$1() {
        return !this.clusterWatchSynchronizer().isHeartbeating();
    }

    private static final IO persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$2$$anonfun$1(Persisted persisted$1) {
        ClusterState clusterState;
        block5: {
            block4: {
                Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy4$1()), "!clusterWatchSynchronizer.isHeartbeating"), FullName$.MODULE$.apply("js7.cluster.ActiveClusterNode.persistWithoutTouchingHeartbeat"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 674));
                clusterState = ((SnapshotableState)persisted$1.aggregate()).clusterState();
                if (ClusterState$Empty$.MODULE$.equals(clusterState)) break block4;
                if (!(clusterState instanceof ClusterState.NodesAppointed)) break block5;
                ClusterState.NodesAppointed nodesAppointed = (ClusterState.NodesAppointed)clusterState;
            }
            return IO$.MODULE$.unit();
        }
        if (clusterState instanceof ClusterState.HasNodes) {
            ClusterState.HasNodes hasNodes = (ClusterState.HasNodes)clusterState;
            return (IO)this.sendingClusterStartBackupNode.fold(ActiveClusterNode::persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$36 -> (IO)_$36.cancel());
        }
        throw new MatchError((Object)clusterState);
    }

    private static final Tuple2 persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(Vector clusterStampedEvents$1, ClusterState.HasNodes clusterState$7) {
        Vector vector = (Vector)Predef$.MODULE$.ArrowAssoc((Object)clusterStampedEvents$1);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vector, (Object)clusterState$7);
    }

    private final IO persistWithoutTouchingHeartbeat$$anonfun$1(Function1 toEvents$1, Option extraEvent$3, boolean dontAskClusterWatchWhenUntaught$1) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy3$1()), "!clusterWatchSynchronizer.isHeartbeating"), FullName$.MODULE$.apply("js7.cluster.ActiveClusterNode.persistWithoutTouchingHeartbeat"), ScalaSourceLocation$.MODULE$.apply("ActiveClusterNode.scala", 663));
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.js7$cluster$ActiveClusterNode$$journal.persistTransaction((Function1 & Serializable)aggregate -> ((Either)toEvents$1.apply((Object)aggregate.clusterState())).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ClusterEvent event = (ClusterEvent)some.value();
                if (!aggregate.clusterState().isEmptyOrActive(this.clusterConf.ownId())) {
                    return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> ActiveClusterNode.persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(event)), Problem$.MODULE$.apply$default$2()));
                }
            }
            Option maybeEvent = option;
            return Right$.MODULE$.apply((Object)((List)extraEvent$3.toList().$plus$plus((IterableOnce)maybeEvent)).map((Function1 & Serializable)_$35 -> {
                KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
                NoKeyEvent Event_this = _$35;
                return new KeyedEvent<NoKeyEvent>(Event_this, keyedEvent$NoKey$);
            }));
        })));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)persisted -> IO$.MODULE$.defer(() -> this.persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$2$$anonfun$1(persisted)).flatMap((Function1 & Serializable)_$37 -> {
            Vector clusterStampedEvents = (Vector)persisted.stampedKeyedEvents().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Stamped x2) {
                    Stamped stamped = x2;
                    Stamped<A> stamped2 = Stamped$.MODULE$.unapply(stamped);
                    long l = stamped2._1();
                    long l2 = stamped2._2();
                    KeyedEvent keyedEvent = (KeyedEvent)stamped2._3();
                    Tuple2<Object, E> tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
                    if (tuple2._2() instanceof ClusterEvent) {
                        ClusterEvent clusterEvent = (ClusterEvent)tuple2._2();
                        Stamped o = stamped;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Stamped x2, Function1 function1) {
                    Stamped stamped = x2;
                    Stamped<A> stamped2 = Stamped$.MODULE$.unapply(stamped);
                    long l = stamped2._1();
                    long l2 = stamped2._2();
                    KeyedEvent keyedEvent = (KeyedEvent)stamped2._3();
                    Tuple2<Object, E> tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
                    if (tuple2._2() instanceof ClusterEvent) {
                        ClusterEvent clusterEvent = (ClusterEvent)tuple2._2();
                        Stamped o = stamped;
                        return o;
                    }
                    return function1.apply((Object)x2);
                }
            });
            Vector events = (Vector)clusterStampedEvents.map((Function1 & Serializable)_$38 -> (ClusterEvent)((KeyedEvent)_$38.value()).event());
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)events, (Object)((SnapshotableState)persisted.aggregate()).clusterState());
            ClusterState clusterState = (ClusterState)tuple2._2();
            SeqOps seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)tuple2._1());
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) {
                ClusterEvent clusterEvent;
                ClusterEvent event = clusterEvent = (ClusterEvent)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                if (clusterState instanceof ClusterState.HasNodes) {
                    ClusterState.HasNodes hasNodes;
                    ClusterState.HasNodes clusterState2 = hasNodes = (ClusterState.HasNodes)clusterState;
                    IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.clusterWatchSynchronizer().applyEvent(event, clusterState2, true, dontAskClusterWatchWhenUntaught$1));
                    IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
                        Option option = x$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            ClusterWatchConfirmation confirmation = (ClusterWatchConfirmation)some.value();
                            if (clusterState2.isNonEmptyActive(this.clusterConf.ownId())) {
                                return this.registerClusterWatchId(confirmation, true);
                            }
                        }
                        return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
                    }, IO$.MODULE$.asyncForIO()));
                    return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO2, () -> ActiveClusterNode.persistWithoutTouchingHeartbeat$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(clusterStampedEvents, clusterState2), IO$.MODULE$.asyncForIO());
                }
            }
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                ClusterState clusterState3 = clusterState;
                Vector vector = (Vector)Predef$.MODULE$.ArrowAssoc((Object)clusterStampedEvents);
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vector, (Object)clusterState3));
            }
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("persistWithoutTouchingHeartbeat does not match"));
        }), IO$.MODULE$.asyncForIO());
    }
}

