/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import js7.base.log.Logger$package$Logger$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.utils.Assertions$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.data.event.JournalPosition;
import js7.journal.files.JournalFile;
import js7.journal.files.JournalFiles$;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public final class JournalTruncator$
implements Serializable {
    private static final Logger logger;
    public static final JournalTruncator$ MODULE$;

    private JournalTruncator$() {
    }

    static {
        MODULE$ = new JournalTruncator$();
        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JournalTruncator$.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JournalTruncator$.class);
    }

    public Option<Path> truncateJournal(Path journalFileBase, JournalPosition failedAt, boolean keepTruncatedRest) {
        JournalFile journalFile;
        boolean truncated = false;
        Vector lastTwoJournalFiles = JournalFiles$.MODULE$.listJournalFiles(journalFileBase).takeRight(2);
        if (((JournalFile)lastTwoJournalFiles.last()).fileEventId() == failedAt.fileEventId()) {
            journalFile = (JournalFile)lastTwoJournalFiles.last();
        } else if (IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(lastTwoJournalFiles.lengthIs(), 2) && ((JournalFile)lastTwoJournalFiles.head()).fileEventId() == failedAt.fileEventId() && ((JournalFile)lastTwoJournalFiles.last()).fileEventId() > failedAt.fileEventId()) {
            truncated = true;
            Path deleteFile = ((JournalFile)lastTwoJournalFiles.last()).file();
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("Removing journal file written after failover: {}", (Object)deleteFile.getFileName());
            }
            Files.move(deleteFile, Paths.get(deleteFile + "~DELETED-AFTER-FAILOVER", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            JournalFiles$.MODULE$.updateSymbolicLink(journalFileBase, ((JournalFile)lastTwoJournalFiles.head()).file());
            journalFile = (JournalFile)lastTwoJournalFiles.head();
        } else {
            throw package$.MODULE$.error("Failed-over node's JournalPosition does not match local journal files:" + (" " + failedAt + " <-> " + ((IterableOnceOps)lastTwoJournalFiles.map((Function1 & Serializable)_$1 -> _$1.file().getFileName())).mkString(", ")));
        }
        JournalFile journalFile2 = journalFile;
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(journalFile2, failedAt)), "journalFile.fileEventId == failedAt.fileEventId"), FullName$.MODULE$.apply("js7.cluster.JournalTruncator.truncateJournal"), ScalaSourceLocation$.MODULE$.apply("JournalTruncator.scala", 43));
        Path file = journalFile2.file();
        long fileSize = Files.size(file);
        if (fileSize != failedAt.position()) {
            if (fileSize < failedAt.position()) {
                throw package$.MODULE$.error("Journal file '" + journalFile2.file().getFileName() + " is shorter than the failed-over position " + failedAt.position());
            }
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("\u2757\ufe0fTruncating journal file at failover position " + failedAt.position() + " " + ("(" + (fileSize - failedAt.position()) + " bytes): " + journalFile2.file().getFileName()));
            }
            truncated = true;
            this.truncateFile(file, failedAt.position(), keepTruncatedRest);
        }
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(truncated);
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> JournalTruncator$.truncateJournal$$anonfun$1(file));
    }

    public void truncateFile(Path file, long position, boolean keep) {
        AutoClosing$.MODULE$.autoClosing(new RandomAccessFile(file.toFile(), "rw"), (Function1 & Serializable)f -> {
            FileChannel channel = f.getChannel();
            MODULE$.assertCutLineEnd(file, position, channel);
            if (keep) {
                MODULE$.copyTruncatedRest(file, position, channel);
            } else {
                MODULE$.logTruncatedRest(file, position, (RandomAccessFile)f);
            }
            return channel.truncate(position);
        });
    }

    private void assertCutLineEnd(Path file, long position, FileChannel in) {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        in.position(position - 1L);
        in.read(buffer);
        buffer.flip();
        if (!buffer.hasRemaining() || buffer.get() != 10) {
            throw package$.MODULE$.error("Invalid failed-over position=" + position + " in '" + file.getFileName() + " journal file");
        }
    }

    private void copyTruncatedRest(Path file, long position, FileChannel channel) {
        AutoClosing$.MODULE$.autoClosing(FileChannel.open(this.toTruncatedFilePath(file), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), (JProcedure1 & Serializable)out -> {
            channel.position(position);
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            buffer.clear();
            buffer.flip();
            boolean eof = false;
            while (!eof) {
                if (buffer.hasRemaining()) {
                    out.write(buffer);
                }
                buffer.clear();
                eof = channel.read(buffer) <= 0;
                buffer.flip();
            }
        });
    }

    private Path toTruncatedFilePath(Path file) {
        return Paths.get(file + "~TRUNCATED-AFTER-FAILOVER", new String[0]);
    }

    private void logTruncatedRest(Path file, long position, RandomAccessFile f) {
        f.seek(position);
        BooleanRef logged = BooleanRef.create((boolean)false);
        this.loop$1(f, logged, file);
    }

    private final boolean v$proxy1$1(JournalFile journalFile$1, JournalPosition failedAt$1) {
        return journalFile$1.fileEventId() == failedAt$1.fileEventId();
    }

    private static final Path truncateJournal$$anonfun$1(Path file$1) {
        return file$1;
    }

    private final void loop$1(RandomAccessFile f$1, BooleanRef logged$1, Path file$3) {
        String string;
        while ((string = f$1.readLine()) != null) {
            Logger LoggerImpl_this;
            String line = string;
            if (!logged$1.elem && (LoggerImpl_this = logger).underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("\u2757\ufe0fRecords truncated off {}:", (Object)file$3.getFileName());
            }
            logged$1.elem = true;
            Logger LoggerImpl_this2 = logger;
            if (!LoggerImpl_this2.underlying().isInfoEnabled()) continue;
            LoggerImpl_this2.underlying().info("\u2757\ufe0f{}", (Object)line);
        }
        return;
    }
}

