/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.effect.unsafe.IORuntime;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import io.circe.Encoder;
import io.circe.Json;
import io.circe.syntax.package;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import js7.base.auth.Admission$;
import js7.base.auth.UserAndPassword;
import js7.base.auth.UserAndPassword$;
import js7.base.auth.UserId;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.SyncDeadline;
import js7.base.catsutils.SyncDeadline$;
import js7.base.catsutils.SyncDeadline$Now$;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$ops$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.generic.SecretString;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.monixutils.RefCountedResource;
import js7.base.monixutils.StreamPauseDetector$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Stopwatch$;
import js7.base.utils.Assertions$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.OneTimeToken;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.base.utils.StackTraces$;
import js7.base.utils.StackTraces$StackTraceThrowable$;
import js7.base.web.HttpClient$;
import js7.base.web.Uri;
import js7.cluster.ClusterCommon;
import js7.cluster.ClusterCommon$;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterWatchSynchronizer;
import js7.cluster.PassiveClusterNode;
import js7.cluster.PassiveClusterNode$;
import js7.cluster.PassiveClusterNode$Continuation$;
import js7.cluster.PassiveClusterNode$FirstPartialFile$;
import js7.cluster.PassiveClusterNode$NextFile$;
import js7.cluster.PassiveClusterNode$NoLocalJournal$;
import js7.common.http.RecouplingStreamReader;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.data.Problems$PassiveClusterNodeResetProblem$;
import js7.data.cluster.ClusterCommand;
import js7.data.cluster.ClusterCommand$ClusterCouple$;
import js7.data.cluster.ClusterCommand$ClusterPassiveDown$;
import js7.data.cluster.ClusterCommand$ClusterPrepareCoupling$;
import js7.data.cluster.ClusterCommand$ClusterRecouple$;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterEvent$;
import js7.data.cluster.ClusterEvent$ClusterActiveNodeRestarted$;
import js7.data.cluster.ClusterEvent$ClusterCoupled$;
import js7.data.cluster.ClusterEvent$ClusterCouplingPrepared$;
import js7.data.cluster.ClusterEvent$ClusterFailedOver$;
import js7.data.cluster.ClusterEvent$ClusterResetStarted$;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.cluster.ClusterWatchProblems$ClusterFailOverWhilePassiveLostProblem$;
import js7.data.cluster.ClusterWatchProblems$NoClusterWatchProblem$;
import js7.data.cluster.ClusterWatchProblems$UntaughtClusterWatchProblem$;
import js7.data.event.ClusterableState;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalEvent;
import js7.data.event.JournalEvent$;
import js7.data.event.JournalEvent$SnapshotTaken$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalId;
import js7.data.event.JournalPosition;
import js7.data.event.JournalPosition$;
import js7.data.event.JournalSeparators$;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.NoKeyEvent$;
import js7.data.event.SnapshotableState$;
import js7.data.event.Stamped;
import js7.data.event.Stamped$;
import js7.data.node.NodeId;
import js7.data.node.NodeName;
import js7.journal.EventIdGenerator;
import js7.journal.FileJournalMXBean;
import js7.journal.data.JournalLocation$;
import js7.journal.files.JournalFiles$extensions$;
import js7.journal.log.JournalLogger;
import js7.journal.log.JournalLogger$;
import js7.journal.recover.FileSnapshotableStateRecoverer;
import js7.journal.recover.Recovered;
import js7.journal.recover.RecoveredJournalFile;
import js7.journal.recover.RecoveredJournalFile$;
import org.apache.pekko.stream.StreamTcpException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import sourcecode.Enclosing;
import sourcecode.Enclosing$;
import sourcecode.FullName$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class PassiveClusterNode<S extends ClusterableState<S>> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PassiveClusterNode.class.getDeclaredField("Continuation$lzy1"));
    private final NodeId ownId;
    public final ClusterSetting js7$cluster$PassiveClusterNode$$setting;
    public final Recovered<S> js7$cluster$PassiveClusterNode$$recovered;
    private final UserId passiveUserId;
    private final EventIdGenerator eventIdGenerator;
    private final Option<Object> initialFileEventId;
    private final boolean otherFailed;
    public final ClusterConf js7$cluster$PassiveClusterNode$$clusterConf;
    private final ClusterCommon common;
    private final FileJournalMXBean.Bean bean;
    public final ClusterableState.Companion<S> js7$cluster$PassiveClusterNode$$S;
    private final Function1<NodeName, Either<Problem, Option<SecretString>>> nodeNameToPassword;
    private final IORuntime ioRuntime;
    private final Deferred<IO, BoxedUnit> shutdown;
    private final RefCountedResource<ClusterNodeApi> activeApiCache;
    private IO<S> _currentState;
    private boolean dontActivateBecauseOtherFailedOver;
    private volatile boolean awaitingCoupledEvent;
    public volatile boolean js7$cluster$PassiveClusterNode$$stopped;
    private volatile Object Continuation$lzy1;
    public final PassiveClusterNode$NoLocalJournal$ NoLocalJournal$lzy1;
    public final PassiveClusterNode$FirstPartialFile$ FirstPartialFile$lzy1;
    public final PassiveClusterNode$NextFile$ NextFile$lzy1;

    public static <F, S extends ClusterableState<S>> Resource<F, PassiveClusterNode<S>> resource(NodeId nodeId, ClusterSetting clusterSetting, Recovered<S> recovered, NodeName nodeName, UserId userId, EventIdGenerator eventIdGenerator, Option<Object> option, boolean bl, ClusterConf clusterConf, ClusterCommon clusterCommon, Sync<F> sync, ClusterableState.Companion<S> companion, Function1<NodeName, Either<Problem, Option<SecretString>>> function1, IORuntime iORuntime) {
        return PassiveClusterNode$.MODULE$.resource(nodeId, clusterSetting, recovered, nodeName, userId, eventIdGenerator, option, bl, clusterConf, clusterCommon, sync, companion, function1, iORuntime);
    }

    public PassiveClusterNode(NodeId ownId, ClusterSetting setting, Recovered<S> recovered, NodeName activeNodeName, UserId passiveUserId, EventIdGenerator eventIdGenerator, Option<Object> initialFileEventId, boolean otherFailed, ClusterConf clusterConf, ClusterCommon common, FileJournalMXBean.Bean bean, ClusterableState.Companion<S> S, Function1<NodeName, Either<Problem, Option<SecretString>>> nodeNameToPassword, IORuntime ioRuntime) {
        this.ownId = ownId;
        this.js7$cluster$PassiveClusterNode$$setting = setting;
        this.js7$cluster$PassiveClusterNode$$recovered = recovered;
        this.passiveUserId = passiveUserId;
        this.eventIdGenerator = eventIdGenerator;
        this.initialFileEventId = initialFileEventId;
        this.otherFailed = otherFailed;
        this.js7$cluster$PassiveClusterNode$$clusterConf = clusterConf;
        this.common = common;
        this.bean = bean;
        this.js7$cluster$PassiveClusterNode$$S = S;
        this.nodeNameToPassword = nodeNameToPassword;
        this.ioRuntime = ioRuntime;
        this.NoLocalJournal$lzy1 = new PassiveClusterNode$NoLocalJournal$(this);
        this.FirstPartialFile$lzy1 = new PassiveClusterNode$FirstPartialFile$(this);
        this.NextFile$lzy1 = new PassiveClusterNode$NextFile$(this);
        this.shutdown = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)PassiveClusterNode.v$proxy1$1(setting, ownId)), "activeId != ownId && setting.passiveId == ownId"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 86));
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)PassiveClusterNode.v$proxy2$1(initialFileEventId, recovered)), "initialFileEventId.isDefined == (recovered.clusterState == ClusterState.Empty"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 87));
        Either either = Checked$.MODULE$.Ops((Either)nodeNameToPassword.apply((Object)activeNodeName));
        this.activeApiCache = new RefCountedResource((Resource)common.clusterNodeApi().apply((Object)Admission$.MODULE$.apply((Uri)setting.idToUri().apply((Object)setting.activeId()), (Option<UserAndPassword>)((Option)Checked$Ops$.MODULE$.orThrow$extension(either)).map((Function1 & Serializable)_$1 -> UserAndPassword$.MODULE$.apply(passiveUserId, (SecretString)_$1))), (Object)"Active node"), Tag$.MODULE$.apply(ClusterNodeApi.class, LightTypeTag$.MODULE$.parse(-360145444, "\u0004\u0000\u0001\u001fjs7.data.cluster.ClusterNodeApi\u0001\u0001", "\u0000\u0003\u0004\u0000\u00010js7.base.session.SessionApi$.LoginUntilReachable\u0001\u0002\u0003\u0000\u0000\u001bjs7.base.session.SessionApi\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.cluster.ClusterNodeApi\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001,js7.base.exceptions.HasIsIgnorableStackTrace\u0001\u0001\u0004\u0000\u0001/js7.base.session.SessionApi$.HasUserAndPassword\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001", 30)), Enclosing$.MODULE$.apply("js7.cluster.PassiveClusterNode#activeApiCache"));
        this._currentState = IO$.MODULE$.pure(recovered.state());
        this.dontActivateBecauseOtherFailedOver = otherFailed;
        this.awaitingCoupledEvent = false;
        this.js7$cluster$PassiveClusterNode$$stopped = false;
    }

    private Resource<IO, ClusterNodeApi> activeApiResource(Enclosing src) {
        return this.activeApiCache.resource(src);
    }

    public IO<BoxedUnit> onShutdown(boolean dontNotifyActiveNode) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger, ((IO)this.shutdown.complete((Object)BoxedUnit.UNIT)).attempt().$times$greater(IO$.MODULE$.unlessA(dontNotifyActiveNode, this::onShutdown$$anonfun$1)), Name$.MODULE$.apply("onShutdown"));
    }

    public boolean onShutdown$default$1() {
        return false;
    }

    private IO<BoxedUnit> notifyActiveNodeAboutShutdown() {
        BoxedUnit boxedUnit = (BoxedUnit)package.flatMap$.MODULE$.catsSyntaxFlatMapIdOps((Object)BoxedUnit.UNIT);
        IO untilDecoupled = Logger$package$Logger$syntax$.MODULE$.traceIO(PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger, (IO)FlatMapIdOps$.MODULE$.tailRecM$extension((Object)boxedUnit, (Function1 & Serializable)_$2 -> this._currentState.map((Function1 & Serializable)_$3 -> _$3.clusterState()).flatMap((Function1 & Serializable)x$1 -> {
            ClusterState clusterState = x$1;
            if (clusterState instanceof ClusterState.Coupled) {
                ClusterState.Coupled coupled = (ClusterState.Coupled)clusterState;
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, BoxedUnit.UNIT).delayBy((Duration)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1)));
            }
            ClusterState clusterState2 = clusterState;
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, clusterState2);
        }), (FlatMap)IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("untilDecoupled"));
        IO iO = ((IO)this.activeApiResource(Enclosing$.MODULE$.apply("js7.cluster.PassiveClusterNode#notifyActiveNodeAboutShutdown notifyActive")).use((Function1 & Serializable)api -> api.login(true).productR(api.retryIfSessionLost(api.executeClusterCommand(ClusterCommand$ClusterPassiveDown$.MODULE$.apply(this.js7$cluster$PassiveClusterNode$$setting.activeId(), this.ownId)))).void().handleError((Function1)(JProcedure1 & Serializable)throwable -> {
            Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                LoggerImpl_this.underlying().debug("ClusterCommand.ClusterPassiveDown failed: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2), (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3));
                return;
            }
        }), (MonadCancel)IO$.MODULE$.asyncForIO())).timeoutTo((Duration)this.js7$cluster$PassiveClusterNode$$clusterConf.timing().heartbeat(), IO$.MODULE$.unit());
        IO notifyActive = CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)PassiveClusterNode::$anonfun$3), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO));
        return Logger$package$Logger$syntax$.MODULE$.debugIO(PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger, IO$.MODULE$.race(untilDecoupled, notifyActive.delayBy((Duration)ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(50)))).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ClusterState clusterState = (ClusterState)left.value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    PassiveClusterNode.notifyActiveNodeAboutShutdown$$anonfun$1$$anonfun$1(clusterState);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = right.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        PassiveClusterNode.notifyActiveNodeAboutShutdown$$anonfun$1$$anonfun$2();
                        return BoxedUnit.UNIT;
                    });
                }
            }
            throw new MatchError((Object)either);
        }).as((Object)BoxedUnit.UNIT), Name$.MODULE$.apply("notifyActiveNodeAboutShutdown"));
    }

    public IO<S> state() {
        return IO$.MODULE$.defer(this::state$$anonfun$1);
    }

    public IO<Either<Problem, Recovered<S>>> run(S recoveredState) {
        return CorrelId$.MODULE$.bindNew(() -> this.run$$anonfun$1(recoveredState), CanBindCorrelId$.MODULE$.io());
    }

    private IO<BoxedUnit> backgroundNotifyActiveNodeAboutRestart(ClusterState recoveredClusterState) {
        ClusterState clusterState = recoveredClusterState;
        if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
            return IO$.MODULE$.unit();
        }
        if (clusterState instanceof ClusterState.IsDecoupled) {
            ClusterState.IsDecoupled isDecoupled = (ClusterState.IsDecoupled)clusterState;
            return this.tryEndlesslyToSendCommandInBackground((Function1<OneTimeToken, ClusterCommand>)(Function1 & Serializable)_$5 -> ClusterCommand$ClusterPrepareCoupling$.MODULE$.apply(this.js7$cluster$PassiveClusterNode$$setting.activeId(), this.ownId, (OneTimeToken)_$5));
        }
        if (clusterState instanceof ClusterState.PreparedToBeCoupled) {
            ClusterState.PreparedToBeCoupled preparedToBeCoupled = (ClusterState.PreparedToBeCoupled)clusterState;
            return this.tryEndlesslyToSendCommandInBackground((Function1<OneTimeToken, ClusterCommand>)(Function1 & Serializable)_$6 -> ClusterCommand$ClusterCouple$.MODULE$.apply(this.js7$cluster$PassiveClusterNode$$setting.activeId(), this.ownId, (OneTimeToken)_$6));
        }
        if (clusterState instanceof ClusterState.Coupled) {
            ClusterState.Coupled coupled = (ClusterState.Coupled)clusterState;
            return IO$.MODULE$.defer(this::backgroundNotifyActiveNodeAboutRestart$$anonfun$3);
        }
        throw new MatchError((Object)clusterState);
    }

    private IO<BoxedUnit> tryEndlesslyToSendCommandInBackground(Function1<OneTimeToken, ClusterCommand> toCommand) {
        return CatsEffectExtensions$.MODULE$.startAndForget(Logger$package$Logger$syntax$.MODULE$.traceIO(PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger, this.tryEndlesslyToSendCommand(toCommand).attempt().map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable throwable = (Throwable)left.value();
                Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    LoggerImpl_this.underlying().error("While notifying the active cluster node about restart of this passive node:" + (" " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2)), (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3));
                    return;
                }
                return;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = right.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Active cluster node has been notified about restart of this passive node");
                        return;
                    }
                    return;
                }
            }
            throw new MatchError((Object)either);
        }), Name$.MODULE$.apply("tryEndlesslyToSendCommandInBackground")), Enclosing$.MODULE$.apply("js7.cluster.PassiveClusterNode#tryEndlesslyToSendCommandInBackground"));
    }

    public Either<Problem, BoxedUnit> confirmCoupling(OneTimeToken token) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.common.couplingTokenProvider().confirms(token));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, PassiveClusterNode::confirmCoupling$$anonfun$1);
    }

    private void cutJournalFile(Path file, long length, long eventId) {
        if (Files.exists(file, new LinkOption[0])) {
            long garbage = Files.size(file) - length;
            if (garbage > 0L) {
                Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("Cutting incomplete data ({} bytes) at end of {} at position {}, EventId {} ", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)garbage), file.getFileName(), BoxesRunTime.boxToLong((long)length), BoxesRunTime.boxToLong((long)eventId)}), Object.class));
                }
                AutoClosing$.MODULE$.autoClosing(FileChannel.open(file, StandardOpenOption.WRITE), (Function1 & Serializable)f -> f.truncate(length));
                return;
            }
            return;
        }
    }

    private IO<BoxedUnit> tryEndlesslyToSendClusterPrepareCoupling() {
        return this.tryEndlesslyToSendCommand((Function1<OneTimeToken, ClusterCommand>)(Function1 & Serializable)_$8 -> ClusterCommand$ClusterPrepareCoupling$.MODULE$.apply(this.js7$cluster$PassiveClusterNode$$setting.activeId(), this.ownId, (OneTimeToken)_$8));
    }

    private IO<BoxedUnit> sendClusterCouple() {
        return this.tryEndlesslyToSendCommand((Function1<OneTimeToken, ClusterCommand>)(Function1 & Serializable)_$9 -> ClusterCommand$ClusterCouple$.MODULE$.apply(this.js7$cluster$PassiveClusterNode$$setting.activeId(), this.ownId, (OneTimeToken)_$9));
    }

    private IO<BoxedUnit> tryEndlesslyToSendCommand(Function1<OneTimeToken, ClusterCommand> toCommand) {
        return IO$.MODULE$.race((IO)this.shutdown.get(), this.common.tryEndlesslyToSendCommand(this.activeApiResource(Enclosing$.MODULE$.apply("js7.cluster.PassiveClusterNode#tryEndlesslyToSendCommand")), toCommand)).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = left.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        PassiveClusterNode.tryEndlesslyToSendCommand$$anonfun$1$$anonfun$1(toCommand);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = right.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return IO$.MODULE$.unit();
                }
            }
            throw new MatchError((Object)either);
        });
    }

    private IO<Either<Problem, Recovered<S>>> replicateJournalFiles(ClusterState recoveredClusterState) {
        return (IO)this.activeApiResource(Enclosing$.MODULE$.apply("js7.cluster.PassiveClusterNode#replicateJournalFiles")).use((Function1 & Serializable)activeNodeApi -> {
            Product product;
            Option<RecoveredJournalFile<S>> option = this.js7$cluster$PassiveClusterNode$$recovered.recoveredJournalFile();
            if (None$.MODULE$.equals(option)) {
                Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)PassiveClusterNode.v$proxy4$1(recoveredClusterState)), "recoveredClusterState == ClusterState.Empty"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode.start"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 269));
                product = this.NoLocalJournal().apply(BoxesRunTime.unboxToLong((Object)this.initialFileEventId.get()));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                RecoveredJournalFile recoveredJournalFile = (RecoveredJournalFile)some.value();
                product = this.FirstPartialFile().apply(recoveredJournalFile);
            } else {
                throw new MatchError(option);
            }
            Continuation.Replicatable start = product;
            Continuation.Replicatable replicatable = (Continuation.Replicatable)package.flatMap$.MODULE$.catsSyntaxFlatMapIdOps((Object)start);
            return (IO)FlatMapIdOps$.MODULE$.tailRecM$extension((Object)replicatable, (Function1 & Serializable)continuation -> this.replicateJournalFile((Continuation.Replicatable)continuation, (ClusterNodeApi)activeNodeApi, this.ioRuntime).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Problem problem = (Problem)left.value();
                    return scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Left().apply((Object)problem));
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Continuation.Replicatable replicatable = (Continuation.Replicatable)right.value();
                    Continuation.Replicatable continuation = replicatable;
                    if (this.js7$cluster$PassiveClusterNode$$shouldActivate(continuation.clusterState())) {
                        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                        if (LoggerImpl_this.underlying().isInfoEnabled()) {
                            LoggerImpl_this.underlying().info("Activating because ClusterState has become {}", (Object)continuation.clusterState());
                        }
                        return scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Right().apply(this.js7$cluster$PassiveClusterNode$$recovered.changeRecoveredJournalFile(continuation.maybeRecoveredJournalFile())));
                    }
                    Continuation.Replicatable continuation2 = replicatable;
                    return scala.package$.MODULE$.Left().apply((Object)continuation2);
                }
                throw new MatchError((Object)either);
            }), (FlatMap)IO$.MODULE$.asyncForIO());
        }, (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    private IO<Either<Problem, Continuation.Replicatable>> replicateJournalFile(Continuation.Replicatable continuation, ClusterNodeApi activeNodeApi, IORuntime ioRuntime) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger, "replicateJournalFile", (Function0<Object>)((Function0 & Serializable)() -> PassiveClusterNode.replicateJournalFile$$anonfun$1(continuation)), SyncDeadline$.MODULE$.now().flatMap((Function1 & Serializable)startedAt -> this.replicateJournalFile2(continuation, activeNodeApi, (SyncDeadline)startedAt, ioRuntime)));
    }

    private IO<Either<Problem, Continuation.Replicatable>> replicateJournalFile2(Continuation.Replicatable continuation, ClusterNodeApi activeNodeApi, SyncDeadline startedAt, IORuntime ioRuntime) {
        return IO$.MODULE$.defer(() -> this.replicateJournalFile2$$anonfun$1(continuation, ioRuntime, activeNodeApi, startedAt));
    }

    private void writeFailedOverEvent(FileChannel out, Path file, Stamped<KeyedEvent<ClusterEvent.ClusterFailedOver>> failedOverStamped, long eventNumber, Deadline since, long lastProperEventPosition) {
        this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onFailover();
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("\u2757\ufe0fFailover");
        }
        if (out.size() > lastProperEventPosition) {
            Logger LoggerImpl_this2 = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
            if (LoggerImpl_this2.underlying().isInfoEnabled()) {
                LoggerImpl_this2.underlying().info("Truncating open transaction in {}' file at position {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{file.getFileName(), BoxesRunTime.boxToLong((long)lastProperEventPosition)}), Object.class));
            }
            out.truncate(lastProperEventPosition);
        }
        JournalLogger journalLogger = JournalLogger$.MODULE$.apply(this.js7$cluster$PassiveClusterNode$$clusterConf.journalConf());
        journalLogger.logCommitted((Seq<Stamped<KeyedEvent<Event>>>)scala.package$.MODULE$.Nil().$colon$colon(failedOverStamped), eventNumber, since, "FailedOver", journalLogger.logCommitted$default$5(), journalLogger.logCommitted$default$6());
        Stamped<KeyedEvent<ClusterEvent.ClusterFailedOver>> event = failedOverStamped;
        Stamped stamped = (Stamped)io.circe.syntax.package$.MODULE$.EncoderOps(event);
        out.write(ByteBuffer.wrap((CirceUtils$RichJson$.MODULE$.compactPrint$extension(CirceUtils$.MODULE$.RichJson(package.EncoderOps$.MODULE$.asJson$extension((Object)stamped, Stamped$.MODULE$.jsonEncoder(KeyedEvent$.MODULE$.jsonEncoder(NoKeyEvent$.MODULE$.implicitSelf(), ClusterEvent$.MODULE$.jsonCodec(), (Encoder<Object>)KeyedEvent$NoKey$.MODULE$.jsonCodec()))))) + '\n').getBytes(StandardCharsets.UTF_8)));
    }

    private boolean testHeartbeatSuppressor(Tuple3<Object, ByteArray, Object> tuple) {
        Tuple3<Object, ByteArray, Object> tuple3 = tuple;
        ByteArray byteArray = JournalEvent$.MODULE$.StampedHeartbeatByteArray();
        Object object = tuple3._2();
        if (!(byteArray != null ? !((Object)byteArray).equals(object) : object != null) && BoxesRunTime.unboxToBoolean((Object)this.js7$cluster$PassiveClusterNode$$clusterConf.testHeartbeatLossPropertyKey().fold(PassiveClusterNode::testHeartbeatSuppressor$$anonfun$1, (Function1 & Serializable)k -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.props().apply(k)))))) {
            Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("TEST: Suppressing the received heartbeat");
            }
            return false;
        }
        return true;
    }

    public boolean js7$cluster$PassiveClusterNode$$shouldActivate(ClusterState clusterState) {
        return !this.dontActivateBecauseOtherFailedOver && clusterState.isNonEmptyActive(this.ownId);
    }

    private void ensureEqualState(Continuation.Replicatable continuation, S snapshot) {
        continuation.maybeRecoveredJournalFile().foreach((Function1)(JProcedure1 & Serializable)recoveredJournalFile -> {
            Object s = recoveredJournalFile.state().withEventId(snapshot.eventId());
            ClusterableState clusterableState = snapshot;
            if (s == null ? clusterableState != null : !s.equals(clusterableState)) {
                String msg = "Calculated '" + this.js7$cluster$PassiveClusterNode$$S + "' from recovered or replicated journal file " + recoveredJournalFile.fileEventId() + " does not match snapshot in next replicated journal file";
                Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error(msg);
                }
                SnapshotableState$.MODULE$.logBoth(recoveredJournalFile.state(), "recoveredJournalFile.state", snapshot, "snapshot", SnapshotableState$.MODULE$.logBoth$default$5());
                throw scala.sys.package$.MODULE$.error(msg);
            }
        });
    }

    private Stamped<KeyedEvent<ClusterEvent.ClusterFailedOver>> toStampedFailedOver(ClusterState.Coupled clusterState, JournalPosition failedAt) {
        Stamped<KeyedEvent<ClusterEvent.ClusterFailedOver>> stamped;
        block0: {
            ClusterEvent.ClusterFailedOver failedOver = ClusterEvent$ClusterFailedOver$.MODULE$.apply(clusterState.activeId(), clusterState.passiveId(), failedAt);
            KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
            ClusterEvent.ClusterFailedOver Event_this = failedOver;
            stamped = this.eventIdGenerator.stamp(new KeyedEvent<ClusterEvent.ClusterFailedOver>(Event_this, keyedEvent$NoKey$), this.eventIdGenerator.stamp$default$2());
            Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug(stamped.toString());
        }
        return stamped;
    }

    public final PassiveClusterNode$Continuation$ js7$cluster$PassiveClusterNode$$Continuation() {
        Object object = this.Continuation$lzy1;
        if (object instanceof PassiveClusterNode$Continuation$) {
            return (PassiveClusterNode$Continuation$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (PassiveClusterNode$Continuation$)this.Continuation$lzyINIT1();
    }

    private Object Continuation$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Continuation$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    PassiveClusterNode$Continuation$ passiveClusterNode$Continuation$ = null;
                    try {
                        passiveClusterNode$Continuation$ = new PassiveClusterNode$Continuation$(this);
                        object2 = passiveClusterNode$Continuation$ == null ? LazyVals.NullValue$.MODULE$ : passiveClusterNode$Continuation$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Continuation$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return passiveClusterNode$Continuation$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final PassiveClusterNode$NoLocalJournal$ NoLocalJournal() {
        return this.NoLocalJournal$lzy1;
    }

    private final PassiveClusterNode$FirstPartialFile$ FirstPartialFile() {
        return this.FirstPartialFile$lzy1;
    }

    private final PassiveClusterNode$NextFile$ NextFile() {
        return this.NextFile$lzy1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean v$proxy1$1(ClusterSetting setting$1, NodeId ownId$1) {
        NodeId nodeId = setting$1.activeId();
        NodeId nodeId2 = ownId$1;
        if (nodeId == null) {
            if (nodeId2 == null) return false;
        } else if (((Object)nodeId).equals(nodeId2)) return false;
        NodeId nodeId3 = setting$1.passiveId();
        NodeId nodeId4 = ownId$1;
        if (nodeId3 != null) {
            if (!((Object)nodeId3).equals(nodeId4)) return false;
            return true;
        }
        if (nodeId4 == null) return true;
        return false;
    }

    private static final boolean v$proxy2$1(Option initialFileEventId$1, Recovered recovered$1) {
        ClusterState clusterState = recovered$1.clusterState();
        ClusterState$Empty$ clusterState$Empty$ = ClusterState$Empty$.MODULE$;
        return initialFileEventId$1.isDefined() == !(clusterState != null ? !clusterState.equals(clusterState$Empty$) : clusterState$Empty$ != null);
    }

    private final IO onShutdown$$anonfun$1() {
        return this.notifyActiveNodeAboutShutdown();
    }

    private static final String $anonfun$3() {
        return "notifyActiveNodeAboutShutdown#noticeActive";
    }

    private static final void notifyActiveNodeAboutShutdown$$anonfun$1$$anonfun$1(ClusterState clusterState$1) {
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("notifyActiveNodeAboutShutdown: clusterState={}", (Object)clusterState$1);
            return;
        }
    }

    private static final void notifyActiveNodeAboutShutdown$$anonfun$1$$anonfun$2() {
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("notifyActiveNodeAboutShutdown: Active node has been notified about shutdown");
            return;
        }
    }

    private final IO state$$anonfun$1() {
        return this._currentState;
    }

    private final boolean v$proxy3$1() {
        return !this.js7$cluster$PassiveClusterNode$$stopped;
    }

    private final IO run$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(ClusterState recoveredClusterState$1) {
        return this.backgroundNotifyActiveNodeAboutRestart(recoveredClusterState$1);
    }

    private final void run$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4() {
        this.js7$cluster$PassiveClusterNode$$stopped = true;
    }

    private final void run$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1() {
        JournalFiles$extensions$.MODULE$.deleteJournal(this.js7$cluster$PassiveClusterNode$$recovered.journalLocation(), true);
    }

    private final IO run$$anonfun$1$$anonfun$1$$anonfun$1(ClusterableState recoveredState$3) {
        ClusterState recoveredClusterState = recoveredState$3.clusterState();
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("recoveredClusterState={}", (Object)recoveredClusterState);
        }
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy3$1()), "!stopped"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode.run"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 161));
        if (this.js7$cluster$PassiveClusterNode$$clusterConf.journalConf().deleteObsoleteFiles()) {
            this.js7$cluster$PassiveClusterNode$$recovered.recoveredJournalFile().foreach((Function1)(JProcedure1 & Serializable)f -> {
                long eventId = f.fileEventId();
                this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().releaseEvents(recoveredState$3.journalState().toReleaseEventId(eventId, (Iterable<UserId>)this.js7$cluster$PassiveClusterNode$$clusterConf.journalConf().releaseEventsUserIds()), this.ioRuntime);
            });
        }
        this.js7$cluster$PassiveClusterNode$$recovered.recoveredJournalFile().foreach((Function1)(JProcedure1 & Serializable)o -> this.cutJournalFile(o.file(), o.length(), o.eventId()));
        return IO$.MODULE$.unlessA(this.otherFailed, () -> this.run$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3(recoveredClusterState)).$times$greater(this.replicateJournalFiles(recoveredClusterState).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.run$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4();
            return BoxedUnit.UNIT;
        })).guarantee(this.activeApiCache.clear(Enclosing$.MODULE$.apply("js7.cluster.PassiveClusterNode#run"))).flatTap((Function1 & Serializable)x$1 -> {
            Left left;
            Either either = x$1;
            if (either instanceof Left && ((Object)Problems$PassiveClusterNodeResetProblem$.MODULE$).equals((left = (Left)either).value())) {
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.run$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$5$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
            }
            return IO$.MODULE$.unit();
        }));
    }

    private final IO run$$anonfun$1(ClusterableState recoveredState$1) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.common.requireValidLicense());
        return Logger$package$Logger$syntax$.MODULE$.debugIO(PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$4 -> IO$.MODULE$.defer(() -> this.run$$anonfun$1$$anonfun$1$$anonfun$1(recoveredState$1)), IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("run"));
    }

    private final IO backgroundNotifyActiveNodeAboutRestart$$anonfun$3() {
        this.awaitingCoupledEvent = true;
        return this.tryEndlesslyToSendCommandInBackground((Function1<OneTimeToken, ClusterCommand>)(Function1 & Serializable)_$7 -> ClusterCommand$ClusterRecouple$.MODULE$.apply(this.js7$cluster$PassiveClusterNode$$setting.activeId(), this.ownId));
    }

    private static final String left$proxy1$1$$anonfun$1() {
        return "Another passive cluster node wanted to couple";
    }

    private static final Problem left$proxy1$1() {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)PassiveClusterNode::left$proxy1$1$$anonfun$1), Problem$.MODULE$.apply$default$2());
    }

    private static final Problem confirmCoupling$$anonfun$1() {
        return PassiveClusterNode.left$proxy1$1();
    }

    private static final void tryEndlesslyToSendCommand$$anonfun$1$$anonfun$1(Function1 toCommand$2) {
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            ScalaUtils.syntax.RichJavaClass RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(toCommand$2.getClass());
            LoggerImpl_this.underlying().debug("\u25fc\ufe0f tryEndlesslyToSendClusterCommand({}) canceled due to shutdown", (Object)RichJavaClass_this.cachedSimpleScalaName());
            return;
        }
    }

    private static final boolean v$proxy4$1(ClusterState recoveredClusterState$3) {
        ClusterState clusterState = recoveredClusterState$3;
        ClusterState$Empty$ clusterState$Empty$ = ClusterState$Empty$.MODULE$;
        return !(clusterState != null ? !clusterState.equals(clusterState$Empty$) : clusterState$Empty$ != null);
    }

    private static final Object replicateJournalFile$$anonfun$1(Continuation.Replicatable continuation$1) {
        return BoxesRunTime.boxToLong((long)continuation$1.fileEventId());
    }

    private final void releaseEvents$1(FileSnapshotableStateRecoverer recoverer$1, IORuntime ioRuntime$3) {
        if (this.js7$cluster$PassiveClusterNode$$clusterConf.journalConf().deleteObsoleteFiles()) {
            this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().releaseEvents(recoverer$1.journalState().toReleaseEventId(this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().lastFileEventId(), (Iterable<UserId>)this.js7$cluster$PassiveClusterNode$$clusterConf.journalConf().releaseEventsUserIds()), ioRuntime$3);
            return;
        }
    }

    private static final Path $anonfun$4(Continuation.Replicatable continuation$4) {
        return continuation$4.file();
    }

    private static final boolean v$proxy5$1(Continuation.Replicatable continuation$5, Path f$1) {
        return continuation$5.fileLength() == Files.size(f$1);
    }

    private static final ClusterableState replicateJournalFile2$$anonfun$1$$anonfun$1(FileSnapshotableStateRecoverer recoverer$2) {
        return (ClusterableState)recoverer$2.result();
    }

    public static final /* synthetic */ Stream js7$cluster$PassiveClusterNode$$anon$1$$_$getStream$$anonfun$1(long position$1, Stream _$11) {
        return _$11.scan(PositionAnd$.MODULE$.apply(position$1, ByteArray$.MODULE$.empty()), (Function2 & Serializable)(s, line) -> {
            ByteArray byteArray = line;
            ByteArray byteArray2 = JournalEvent$.MODULE$.StampedHeartbeatByteArray();
            return PositionAnd$.MODULE$.apply(s.position() + (long)(!(byteArray != null ? !((Object)byteArray).equals(byteArray2) : byteArray2 != null) ? 0 : line.length()), line);
        }).drop(1L);
    }

    public static final Function1 js7$cluster$PassiveClusterNode$$_$_$$anon$superArg$1$1() {
        return (Function1 & Serializable)_$10 -> {
            Long l = (Long)package.option$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToLong((long)_$10.position()));
            return OptionIdOps$.MODULE$.some$extension((Object)l);
        };
    }

    private static final /* synthetic */ Stream $anonfun$5(ClusterNodeApi activeNodeApi$4, Continuation.Replicatable continuation$7, Throwable t) {
        block0: {
            Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
            LoggerImpl_this.underlying().debug("observeJournalFile(" + activeNodeApi$4 + ", fileEventId=" + continuation$7.fileEventId() + ", " + ("position=" + continuation$7.fileLength() + ") failed with " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable)), t);
        }
        return Stream$.MODULE$.raiseError(t, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)IO$.MODULE$.asyncForIO()));
    }

    private final /* synthetic */ Tuple3 $anonfun$6(PositionAnd positionAndLine) {
        Either either = Checked$.MODULE$.Ops(((ByteArray)positionAndLine.value()).parseJson().flatMap((Function1 & Serializable)json -> this.js7$cluster$PassiveClusterNode$$S.decodeJournalJson((Json)json)));
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)positionAndLine.position()), positionAndLine.value(), Checked$Ops$.MODULE$.orThrow$extension(either));
    }

    private final /* synthetic */ boolean $anonfun$7(Tuple3 tuple) {
        return this.testHeartbeatSuppressor((Tuple3<Object, ByteArray, Object>)tuple);
    }

    private static final RecoveredJournalFile $anonfun$9() {
        throw new IllegalStateException("Failover but nothing has been replicated");
    }

    private static final ClusterableState $anonfun$8$$anonfun$1$$anonfun$1(FileSnapshotableStateRecoverer recoverer$6) {
        return (ClusterableState)recoverer$6.result();
    }

    private final Right $anonfun$8$$anonfun$1(RecoveredJournalFile recoveredJournalFile$3, Stamped failedOverStamped$1, FileSnapshotableStateRecoverer recoverer$4, Deadline failedOverSince$1, LongRef lastProperEventPosition$2, long lastEventId$1, SetOnce replicatedFirstEventPosition$2, LongRef replicatedFileLength$3) {
        Path file = recoveredJournalFile$3.file();
        long fileSize = BoxesRunTime.unboxToLong(AutoClosing$.MODULE$.autoClosing(FileChannel.open(file, StandardOpenOption.APPEND), (Function1 & Serializable)out -> {
            this.writeFailedOverEvent((FileChannel)out, file, failedOverStamped$1, recoverer$4.totalEventCount(), failedOverSince$1, lastProperEventPosition$3.elem);
            return out.size();
        }));
        recoverer$4.startWithState(recoveredJournalFile$3.journalHeader(), lastEventId$1, recoveredJournalFile$3.nextJournalHeader().totalEventCount() + 1L, recoveredJournalFile$3.state());
        recoverer$4.put(failedOverStamped$1);
        this._currentState = IO$.MODULE$.apply(() -> PassiveClusterNode.$anonfun$8$$anonfun$1$$anonfun$1(recoverer$4));
        replicatedFirstEventPosition$2.$colon$eq(BoxesRunTime.boxToLong((long)recoveredJournalFile$3.firstEventPosition()));
        replicatedFileLength$3.elem = fileSize;
        this.bean.fileSize_$eq(fileSize);
        lastProperEventPosition$2.elem = fileSize;
        this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onFileWrittenAndEventsCommitted(PositionAnd$.MODULE$.apply(fileSize, BoxesRunTime.boxToLong((long)failedOverStamped$1.eventId())), 1);
        this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onJournalingEnded(fileSize);
        return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private final Right $anonfun$8$$anonfun$2(ObjectRef out$2, Continuation.Replicatable continuation$9, Stamped failedOverStamped$3, FileSnapshotableStateRecoverer recoverer$7, Deadline failedOverSince$3, LongRef lastProperEventPosition$4, LongRef replicatedFileLength$4) {
        long fileSize;
        this.writeFailedOverEvent((FileChannel)out$2.elem, continuation$9.file(), failedOverStamped$3, recoverer$7.totalEventCount(), failedOverSince$3, lastProperEventPosition$4.elem);
        recoverer$7.rollbackToEventSection();
        recoverer$7.put(failedOverStamped$3);
        replicatedFileLength$4.elem = fileSize = ((FileChannel)out$2.elem).size();
        this.bean.fileSize_$eq(fileSize);
        lastProperEventPosition$4.elem = fileSize;
        this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onFileWrittenAndEventsCommitted(PositionAnd$.MODULE$.apply(fileSize, BoxesRunTime.boxToLong((long)failedOverStamped$3.eventId())), 1);
        return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private static final /* synthetic */ Stream $anonfun$8$$anonfun$3(Either x$1) {
        Either either = x$1;
        if (either instanceof Left) {
            Left left = (Left)either;
            Problem problem = (Problem)left.value();
            if (problem.is(ClusterWatchProblems$ClusterFailOverWhilePassiveLostProblem$.MODULE$) || problem.is(ClusterWatchProblems$UntaughtClusterWatchProblem$.MODULE$) || problem.is(ClusterWatchProblems$NoClusterWatchProblem$.MODULE$)) {
                Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("No failover because ClusterWatch responded: {}", (Object)problem);
                }
                return Stream$.MODULE$.empty();
            }
            Throwable throwable = StackTraces$.MODULE$.StackTraceThrowable(problem.throwable());
            return Stream$.MODULE$.raiseError(StackTraces$StackTraceThrowable$.MODULE$.appendCurrentStackTrace$extension(throwable), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)IO$.MODULE$.asyncForIO()));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            boolean bl = BoxesRunTime.unboxToBoolean((Object)right.value());
            if (!bl) {
                return Stream$.MODULE$.empty();
            }
            if (bl) {
                return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
            }
        }
        throw new MatchError((Object)either);
    }

    private static final ClusterableState $anonfun$8$$anonfun$4(FileSnapshotableStateRecoverer recoverer$8) {
        return (ClusterableState)recoverer$8.result();
    }

    private static final JournalId $anonfun$12(Continuation.Replicatable continuation$11) {
        throw scala.sys.package$.MODULE$.error("Missing JournalHeader in replicated journal file '" + continuation$11.file() + "'");
    }

    private final /* synthetic */ void $anonfun$8$$anonfun$5(FileSnapshotableStateRecoverer recoverer$9, Continuation.Replicatable continuation$10, SetOnce replicatedFirstEventPosition$3, LongRef replicatedFileLength$5, BooleanRef isReplicatingHeadOfFile$2, ObjectRef out$3, SyncDeadline startedAt$3, IORuntime ioRuntime$5, long fileLength$1, Path tmpFile) {
        JournalId journalId = (JournalId)recoverer$9.fileJournalHeader().map((Function1 & Serializable)_$12 -> _$12.journalId()).getOrElse(() -> PassiveClusterNode.$anonfun$12(continuation$10));
        continuation$10.maybeJournalId().withFilter((Function1 & Serializable)o -> {
            JournalId journalId = o;
            JournalId journalId2 = journalId;
            return journalId == null ? journalId2 != null : !((Object)journalId).equals(journalId2);
        }).foreach((Function1 & Serializable)o -> {
            throw scala.sys.package$.MODULE$.error("Received JournalId '" + journalId + "' does not match expected '" + o + "'");
        });
        replicatedFirstEventPosition$3.$colon$eq(BoxesRunTime.boxToLong((long)replicatedFileLength$5.elem));
        isReplicatingHeadOfFile$2.elem = false;
        ((FileChannel)out$3.elem).close();
        Files.move(tmpFile, continuation$10.file(), StandardCopyOption.ATOMIC_MOVE);
        JournalFiles$extensions$.MODULE$.updateSymbolicLink(this.js7$cluster$PassiveClusterNode$$recovered.journalLocation(), continuation$10.file());
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Snapshot '{}' ({}) replicated - {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{continuation$10.file().getFileName(), EventId$.MODULE$.toString(continuation$10.fileEventId()), Stopwatch$.MODULE$.bytesPerSecondString(startedAt$3.elapsed(SyncDeadline$Now$.MODULE$.given_Now(ioRuntime$5)), Files.size(continuation$10.file()))}), Object.class));
        }
        out$3.elem = FileChannel.open(continuation$10.file(), StandardOpenOption.APPEND);
        this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onJournalingStarted(continuation$10.file(), journalId, PositionAnd$.MODULE$.apply(replicatedFileLength$5.elem, BoxesRunTime.boxToLong((long)continuation$10.fileEventId())), PositionAnd$.MODULE$.apply(fileLength$1, BoxesRunTime.boxToLong((long)recoverer$9.eventId())), false);
        this.releaseEvents$1(recoverer$9, ioRuntime$5);
    }

    private static final /* synthetic */ Right $anonfun$8$$anonfun$6(BoxedUnit value) {
        return scala.package$.MODULE$.Right().apply((Object)value);
    }

    private static final /* synthetic */ Right $anonfun$8$$anonfun$7(BoxedUnit value) {
        return scala.package$.MODULE$.Right().apply((Object)value);
    }

    private static final /* synthetic */ IO $anonfun$8$$anonfun$8(ClusterEvent.ClusterSwitchedOver switchedOver$1, ClusterState.HasNodes clusterState$2, ClusterWatchSynchronizer _$13) {
        return _$13.applyEvent(switchedOver$1, clusterState$2, _$13.applyEvent$default$3(), _$13.applyEvent$default$4());
    }

    private static final /* synthetic */ Either $anonfun$8$$anonfun$9(Either _$14) {
        Either either = Checked$.MODULE$.Ops(_$14);
        return Checked$Ops$.MODULE$.toUnit$extension(either);
    }

    private final boolean v$proxy6$1(NodeId activeId$1) {
        NodeId nodeId = activeId$1;
        NodeId nodeId2 = this.ownId;
        return nodeId == null ? nodeId2 != null : !((Object)nodeId).equals(nodeId2);
    }

    private static final /* synthetic */ Right $anonfun$8$$anonfun$10(BoxedUnit value) {
        return scala.package$.MODULE$.Right().apply((Object)value);
    }

    private final boolean v$proxy7$1(NodeId activeId$2) {
        NodeId nodeId = activeId$2;
        NodeId nodeId2 = this.ownId;
        return nodeId == null ? nodeId2 != null : !((Object)nodeId).equals(nodeId2);
    }

    private final boolean v$proxy8$1() {
        NodeId nodeId = this.js7$cluster$PassiveClusterNode$$setting.activeId();
        NodeId nodeId2 = this.ownId;
        return nodeId == null ? nodeId2 != null : !((Object)nodeId).equals(nodeId2);
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ Stream $anonfun$8(BooleanRef isReplicatingHeadOfFile$1, Continuation.Replicatable continuation$8, FileSnapshotableStateRecoverer recoverer$3, IORuntime ioRuntime$4, LongRef lastProperEventPosition$1, SetOnce replicatedFirstEventPosition$1, LongRef replicatedFileLength$2, ObjectRef out$1, BooleanRef _eof$2, Option maybeTmpFile$1, SyncDeadline startedAt$2, Either x$1) {
        block36: {
            block37: {
                block38: {
                    block42: {
                        block40: {
                            block41: {
                                block39: {
                                    var13_13 = x$1;
                                    if (var13_13 instanceof Left) {
                                        var14_14 = (Left)var13_13;
                                        noHeartbeatSince = (SyncDeadline)var14_14.value();
                                        aggregate = isReplicatingHeadOfFile$1.elem != false ? continuation$8.aggregate() : (ClusterableState)recoverer$3.result();
                                        var17_17 = aggregate.clusterState();
                                        if (var17_17 instanceof ClusterState.Coupled) {
                                            clusterState = var18_18 = (ClusterState.Coupled)var17_17;
                                            v0 = clusterState.passiveId();
                                            var20_20 = this.ownId;
                                            if (!(v0 != null ? v0.equals(var20_20) == false : var20_20 != null)) {
                                                if (this.awaitingCoupledEvent) {
                                                    LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                                                    if (LoggerImpl_this.underlying().isTraceEnabled()) {
                                                        LoggerImpl_this.underlying().trace("Ignoring observed pause of " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(noHeartbeatSince.elapsed(SyncDeadline$Now$.MODULE$.given_Now(ioRuntime$4)))) + " without heartbeat " + ("because cluster is coupled but nodes have not yet recoupled: clusterState=" + clusterState));
                                                    }
                                                    return Stream$.MODULE$.empty();
                                                }
                                                if (this.js7$cluster$PassiveClusterNode$$clusterConf.suppressFailover()) {
                                                    LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                                                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                                        LoggerImpl_this.underlying().warn("\u2757 No heartbeat from the currently active cluster " + this.js7$cluster$PassiveClusterNode$$setting.activeId() + " " + ("since " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(noHeartbeatSince.elapsed(SyncDeadline$Now$.MODULE$.given_Now(ioRuntime$4)))) + " - IGNORED"));
                                                    }
                                                    return Stream$.MODULE$.empty();
                                                }
                                                LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                                                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                                    LoggerImpl_this.underlying().warn("\u2757 No heartbeat from the currently active cluster " + this.js7$cluster$PassiveClusterNode$$setting.activeId() + " " + ("since " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(noHeartbeatSince.elapsed(SyncDeadline$Now$.MODULE$.given_Now(ioRuntime$4)))) + " - trying to fail-over"));
                                                }
                                                if (isReplicatingHeadOfFile$1.elem) {
                                                    recoveredJournalFile = (RecoveredJournalFile)continuation$8.maybeRecoveredJournalFile().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$9(), ()Ljs7/journal/recover/RecoveredJournalFile;)());
                                                    lastEventId = recoveredJournalFile.eventId();
                                                    this.eventIdGenerator.updateLastEventId(lastEventId);
                                                    failedOverSince = Deadline$.MODULE$.now();
                                                    failedOverStamped = this.toStampedFailedOver(clusterState, JournalPosition$.MODULE$.apply(recoveredJournalFile.fileEventId(), lastProperEventPosition$1.elem));
                                                    failedOver = failedOverStamped.value().event();
                                                    v1 = this.common.ifClusterWatchAllowsActivation(this.ownId, failedOver, aggregate, (IO<Either<Problem, Object>>)IO$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8$$anonfun$1(js7.journal.recover.RecoveredJournalFile js7.data.event.Stamped js7.journal.recover.FileSnapshotableStateRecoverer scala.concurrent.duration.Deadline scala.runtime.LongRef long js7.base.utils.SetOnce scala.runtime.LongRef ), ()Lscala/util/Right;)((PassiveClusterNode)this, (RecoveredJournalFile)recoveredJournalFile, failedOverStamped, (FileSnapshotableStateRecoverer)recoverer$3, (Deadline)failedOverSince, (LongRef)lastProperEventPosition$1, (long)lastEventId, (SetOnce)replicatedFirstEventPosition$1, (LongRef)replicatedFileLength$2)), this.nodeNameToPassword);
                                                } else {
                                                    failedOverSince = Deadline$.MODULE$.now();
                                                    failedOverStamped = this.toStampedFailedOver(clusterState, JournalPosition$.MODULE$.apply(continuation$8.fileEventId(), lastProperEventPosition$1.elem));
                                                    failedOver = failedOverStamped.value().event();
                                                    v1 = this.common.ifClusterWatchAllowsActivation(this.ownId, failedOver, aggregate, (IO<Either<Problem, Object>>)IO$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8$$anonfun$2(scala.runtime.ObjectRef js7.cluster.PassiveClusterNode$Continuation$Replicatable js7.data.event.Stamped js7.journal.recover.FileSnapshotableStateRecoverer scala.concurrent.duration.Deadline scala.runtime.LongRef scala.runtime.LongRef ), ()Lscala/util/Right;)((PassiveClusterNode)this, (ObjectRef)out$1, (Continuation.Replicatable)continuation$8, failedOverStamped, (FileSnapshotableStateRecoverer)recoverer$3, (Deadline)failedOverSince, (LongRef)lastProperEventPosition$1, (LongRef)replicatedFileLength$2)), this.nodeNameToPassword);
                                                }
                                                return Stream$.MODULE$.eval(v1).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8$$anonfun$3(scala.util.Either ), (Lscala/util/Either;)Lfs2/Stream;)(), NotGiven$.MODULE$.value());
                                            }
                                        }
                                        clusterState = var17_17;
                                        LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                                        if (LoggerImpl_this.underlying().isTraceEnabled()) {
                                            LoggerImpl_this.underlying().trace("Ignoring observed pause without heartbeat because cluster is not coupled: clusterState=" + clusterState);
                                        }
                                        return Stream$.MODULE$.empty();
                                    }
                                    if (!(var13_13 instanceof Right)) break block36;
                                    var35_34 = (Right)var13_13;
                                    var36_35 = (Tuple3)var35_34.value();
                                    var37_36 = BoxesRunTime.unboxToLong((Object)var36_35._1());
                                    var39_37 = (ByteArray)var36_35._2();
                                    v2 = JournalEvent$.MODULE$.StampedHeartbeatByteArray();
                                    var40_38 = var39_37;
                                    if (!(v2 != null ? v2.equals(var40_38) == false : var40_38 != null)) {
                                        h = var39_37;
                                        return Stream$.MODULE$.empty();
                                    }
                                    fileLength = var37_36;
                                    v3 = JournalSeparators$.MODULE$.EndOfJournalFileMarker();
                                    var44_41 = var39_37;
                                    if (!(v3 != null ? v3.equals(var44_41) == false : var44_41 != null)) {
                                        LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                                            LoggerImpl_this.underlying().debug("End of replicated journal file reached: " + (continuation$8.file().getFileName() + " eventId=" + recoverer$3.eventId() + " fileLength=" + fileLength));
                                        }
                                        _eof$2.elem = true;
                                        return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Left().apply((Object)PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$EndOfJournalFileMarker));
                                    }
                                    fileLength = var37_36;
                                    line = var39_37;
                                    journalRecord = var36_35._3();
                                    ((FileChannel)out$1.elem).write(ByteSequence$ops$.MODULE$.toAllByteSequenceOps(line, ByteArray$.MODULE$.implicitByteSequence()).toByteBuffer());
                                    if (!isReplicatingHeadOfFile$1.elem) ** GOTO lbl-1000
                                    var51_46 = journalRecord;
                                    if (!(var51_46 instanceof Stamped)) ** GOTO lbl-1000
                                    var52_47 = (Stamped)var51_46;
                                    var53_48 = Stamped$.MODULE$.unapply(var52_47);
                                    var54_49 = var53_48._1();
                                    var56_50 = var53_48._2();
                                    var58_51 = var53_48._3();
                                    if (var58_51 instanceof KeyedEvent && (var60_53 = KeyedEvent$.MODULE$.unapply(var59_52 = (KeyedEvent)var58_51))._2() == JournalEvent$SnapshotTaken$.MODULE$) {
                                        var61_54 = (JournalEvent$SnapshotTaken$)var60_53._2();
                                        v4 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v4 = false;
                                    }
                                    if (v4) {
                                        v5 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v5 = isSnapshotTaken = false;
                                    }
                                    if (isSnapshotTaken) {
                                        this.ensureEqualState(continuation$8, (ClusterableState)recoverer$3.result());
                                    }
                                    recoverer$3.put(journalRecord);
                                    if (isSnapshotTaken) {
                                        this._currentState = IO$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8$$anonfun$4(js7.journal.recover.FileSnapshotableStateRecoverer ), ()Ljs7/data/event/ClusterableState;)((FileSnapshotableStateRecoverer)recoverer$3));
                                        maybeTmpFile$1.foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$8$$anonfun$5(js7.journal.recover.FileSnapshotableStateRecoverer js7.cluster.PassiveClusterNode$Continuation$Replicatable js7.base.utils.SetOnce scala.runtime.LongRef scala.runtime.BooleanRef scala.runtime.ObjectRef js7.base.catsutils.SyncDeadline cats.effect.unsafe.IORuntime long java.nio.file.Path ), (Ljava/nio/file/Path;)V)((PassiveClusterNode)this, (FileSnapshotableStateRecoverer)recoverer$3, (Continuation.Replicatable)continuation$8, (SetOnce)replicatedFirstEventPosition$1, (LongRef)replicatedFileLength$2, (BooleanRef)isReplicatingHeadOfFile$1, (ObjectRef)out$1, (SyncDeadline)startedAt$2, (IORuntime)ioRuntime$4, (long)fileLength));
                                    }
                                    replicatedFileLength$2.elem = fileLength;
                                    this.bean.fileSize_$eq(fileLength);
                                    if (recoverer$3.isInCommittedEventsSection()) {
                                        lastProperEventPosition$1.elem = fileLength;
                                    }
                                    if (isReplicatingHeadOfFile$1.elem) {
                                        return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                                    }
                                    if (recoverer$3.isInCommittedEventsSection()) {
                                        this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onFileWritten(fileLength);
                                        var62_56 = journalRecord;
                                        if (var62_56 instanceof Stamped) {
                                            var63_57 = (Stamped)var62_56;
                                            var64_58 = Stamped$.MODULE$.unapply(var63_57);
                                            var65_59 = var64_58._1();
                                            var67_60 = var64_58._2();
                                            var69_61 = var64_58._3();
                                            eventId = var65_59;
                                            this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onEventsCommitted(PositionAnd$.MODULE$.apply(fileLength, BoxesRunTime.boxToLong((long)eventId)), 1);
                                        }
                                    }
                                    var72_63 = journalRecord;
                                    v6 = JournalSeparators$.MODULE$.Commit();
                                    var73_64 = var72_63;
                                    if (!(v6 != null ? v6.equals(var73_64) == false : var73_64 != null)) {
                                        this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onEventsCommitted(PositionAnd$.MODULE$.apply(fileLength, BoxesRunTime.boxToLong((long)recoverer$3.eventId())), 1);
                                        return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                                    }
                                    if (!(var72_63 instanceof Stamped)) break block37;
                                    var74_65 = (Stamped)var72_63;
                                    var75_66 = Stamped$.MODULE$.unapply(var74_65);
                                    var76_67 = var75_66._1();
                                    var78_68 = var75_66._2();
                                    var80_69 = var75_66._3();
                                    if (!(var80_69 instanceof KeyedEvent)) break block37;
                                    var81_70 = (KeyedEvent)var80_69;
                                    var82_71 = KeyedEvent$.MODULE$.unapply(var81_70);
                                    event = (Event)var82_71._2();
                                    this.bean.addEventCount(1);
                                    var84_73 = event;
                                    if (var84_73 instanceof JournalEvent.JournalEventsReleased) {
                                        var85_74 = (JournalEvent.JournalEventsReleased)var84_73;
                                        this.releaseEvents$1(recoverer$3, ioRuntime$4);
                                        return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                                    }
                                    if (!(var84_73 instanceof ClusterEvent)) break block38;
                                    clusterEvent = var86_75 = (ClusterEvent)var84_73;
                                    LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
                                    if (LoggerImpl_this.underlying().isInfoEnabled()) {
                                        LoggerImpl_this.underlying().info(ClusterCommon$.MODULE$.clusterEventAndStateToString(clusterEvent, recoverer$3.clusterState()));
                                    }
                                    if (!((var89_78 = clusterEvent) instanceof ClusterEvent.ClusterNodesAppointed)) break block39;
                                    var90_79 = (ClusterEvent.ClusterNodesAppointed)var89_78;
                                    break block40;
                                }
                                if (!(var89_78 instanceof ClusterEvent.ClusterPassiveLost)) break block41;
                                var91_80 = (ClusterEvent.ClusterPassiveLost)var89_78;
                                break block40;
                            }
                            if (var89_78 != ClusterEvent$ClusterActiveNodeRestarted$.MODULE$) break block42;
                            var92_81 = (ClusterEvent$ClusterActiveNodeRestarted$)var89_78;
                        }
                        return Stream$.MODULE$.eval((Object)this.tryEndlesslyToSendClusterPrepareCoupling().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8$$anonfun$6(scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/util/Right;)()));
                    }
                    if (var89_78 instanceof ClusterEvent.ClusterFailedOver) {
                        var93_82 = (ClusterEvent.ClusterFailedOver)var89_78;
                        if (!this.otherFailed && (LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger).underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error("Replicated unexpected FailedOver event");
                        }
                        this.dontActivateBecauseOtherFailedOver = false;
                        return Stream$.MODULE$.eval((Object)this.tryEndlesslyToSendClusterPrepareCoupling().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8$$anonfun$7(scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/util/Right;)()));
                    }
                    if (var89_78 instanceof ClusterEvent.ClusterSwitchedOver) {
                        switchedOver = var95_84 = (ClusterEvent.ClusterSwitchedOver)var89_78;
                        clusterState = (ClusterState.HasNodes)recoverer$3.clusterState();
                        return Stream$.MODULE$.eval((Object)this.common.clusterWatchSynchronizer(clusterState).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8$$anonfun$8(js7.data.cluster.ClusterEvent$ClusterSwitchedOver js7.data.cluster.ClusterState$HasNodes js7.cluster.ClusterWatchSynchronizer ), (Ljs7/cluster/ClusterWatchSynchronizer;)Lcats/effect/IO;)((ClusterEvent.ClusterSwitchedOver)switchedOver, (ClusterState.HasNodes)clusterState)).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8$$anonfun$9(scala.util.Either ), (Lscala/util/Either;)Lscala/util/Either;)()));
                    }
                    if (var89_78 instanceof ClusterEvent.ClusterCouplingPrepared) {
                        var98_87 = (ClusterEvent.ClusterCouplingPrepared)var89_78;
                        var99_88 = ClusterEvent$ClusterCouplingPrepared$.MODULE$.unapply(var98_87);
                        activeId = var100_89 = var99_88._1();
                        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy6$1(activeId)), "activeId != ownId"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode.replicateJournalFile2"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 604));
                        return Stream$.MODULE$.eval((Object)this.sendClusterCouple().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8$$anonfun$10(scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/util/Right;)()));
                    }
                    if (var89_78 instanceof ClusterEvent.ClusterCoupled) {
                        var102_91 = (ClusterEvent.ClusterCoupled)var89_78;
                        var103_92 = ClusterEvent$ClusterCoupled$.MODULE$.unapply(var102_91);
                        activeId = var104_93 = var103_92._1();
                        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy7$1(activeId)), "activeId != ownId"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode.replicateJournalFile2"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 610));
                        this.awaitingCoupledEvent = false;
                        this.releaseEvents$1(recoverer$3, ioRuntime$4);
                        return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                    }
                    if (ClusterEvent$ClusterResetStarted$.MODULE$.equals(var89_78)) {
                        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy8$1()), "activeId != ownId"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode.replicateJournalFile2"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 616));
                        return Stream$.MODULE$.eval((Object)IO$.MODULE$.sleep(ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1))).as((Object)scala.package$.MODULE$.Left().apply((Object)Problems$PassiveClusterNodeResetProblem$.MODULE$)));
                    }
                    return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                }
                return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
            }
            return Stream$.MODULE$.emit((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }
        throw new MatchError((Object)var13_13);
    }

    private static final /* synthetic */ boolean replicateJournalFile2$$anonfun$1$$anonfun$2(Either _$15) {
        return _$15.left().forall((Function1 & Serializable)_$16 -> _$16 != PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$EndOfJournalFileMarker);
    }

    private final /* synthetic */ boolean replicateJournalFile2$$anonfun$1$$anonfun$3(FileSnapshotableStateRecoverer recoverer$10, Either _$17) {
        return !this.js7$cluster$PassiveClusterNode$$shouldActivate(recoverer$10.clusterState());
    }

    private static final void applyOrElse$$anonfun$1(StreamTcpException t$1) {
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            StreamTcpException streamTcpException = (StreamTcpException)ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            LoggerImpl_this.underlying().debug("\u2753 Ignore error due to activation: {}", (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension((Throwable)streamTcpException));
            return;
        }
    }

    public static /* bridge */ /* synthetic */ Object js7$cluster$PassiveClusterNode$$anon$2$$_$applyOrElse$$anonfun$adapted$1(StreamTcpException t$2) {
        PassiveClusterNode.applyOrElse$$anonfun$1(t$2);
        return BoxedUnit.UNIT;
    }

    private static final /* synthetic */ Left replicateJournalFile2$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$2(Continuation.Replicatable continuation$14, FileSnapshotableStateRecoverer recoverer$14, boolean _$19) {
        if (_$19) {
            return scala.package$.MODULE$.Left().apply((Object)PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$PassiveClusterNodeShutdownProblem);
        }
        return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("JournalHeader could not be replicated " + ("fileEventId=" + continuation$14.fileEventId() + " eventId=" + recoverer$14.eventId())));
    }

    private final IO replicateJournalFile2$$anonfun$1$$anonfun$4$$anonfun$1(BooleanRef isReplicatingHeadOfFile$4, LongRef replicatedFileLength$7, FileSnapshotableStateRecoverer recoverer$13, ObjectRef out$5, LongRef lastProperEventPosition$6, Continuation.Replicatable continuation$13, SetOnce replicatedFirstEventPosition$5) {
        Logger LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("replicateJournalFile finished, " + ("isReplicatingHeadOfFile=" + isReplicatingHeadOfFile$4.elem + ", ") + ("replicatedFileLength=" + replicatedFileLength$7.elem + ", clusterState=" + recoverer$13.clusterState()));
        }
        if (!isReplicatingHeadOfFile$4.elem) {
            ((FileChannel)out$5.elem).truncate(lastProperEventPosition$6.elem);
            this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onJournalingEnded(lastProperEventPosition$6.elem);
        }
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(recoverer$13.fileJournalHeader(), recoverer$13.nextJournalHeader());
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (option instanceof Some) {
            Some some = (Some)option;
            JournalHeader header = (JournalHeader)some.value();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JournalHeader nextHeader = (JournalHeader)some2.value();
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, this.NextFile().apply(RecoveredJournalFile$.MODULE$.apply(continuation$13.file(), replicatedFileLength$7.elem, lastProperEventPosition$6.elem, header, nextHeader, BoxesRunTime.unboxToLong(replicatedFirstEventPosition$5.orThrow()), recoverer$13.result())));
            }
        }
        return ((IO)this.shutdown.tryGet()).map((Function1 & Serializable)_$18 -> _$18.isDefined()).map((Function1 & Serializable)_$19 -> PassiveClusterNode.replicateJournalFile2$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$2(continuation$13, recoverer$13, BoxesRunTime.unboxToBoolean((Object)_$19)));
    }

    private final /* synthetic */ IO replicateJournalFile2$$anonfun$1$$anonfun$4(BooleanRef isReplicatingHeadOfFile$3, LongRef replicatedFileLength$6, FileSnapshotableStateRecoverer recoverer$12, ObjectRef out$4, LongRef lastProperEventPosition$5, Continuation.Replicatable continuation$12, SetOnce replicatedFirstEventPosition$4, Option x$1) {
        Option option = x$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Problem problem = (Problem)some.value();
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, problem);
        }
        if (None$.MODULE$.equals(option)) {
            return IO$.MODULE$.defer(() -> this.replicateJournalFile2$$anonfun$1$$anonfun$4$$anonfun$1(isReplicatingHeadOfFile$3, replicatedFileLength$6, recoverer$12, out$4, lastProperEventPosition$5, continuation$12, replicatedFirstEventPosition$4));
        }
        throw new MatchError((Object)option);
    }

    private static final void replicateJournalFile2$$anonfun$1$$anonfun$5(ObjectRef out$6) {
        ((FileChannel)out$6.elem).close();
    }

    private static /* bridge */ /* synthetic */ Object replicateJournalFile2$$anonfun$1$$anonfun$adapted$1(ObjectRef out$7) {
        PassiveClusterNode.replicateJournalFile2$$anonfun$1$$anonfun$5(out$7);
        return BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private final IO replicateJournalFile2$$anonfun$1(Continuation.Replicatable continuation$3, IORuntime ioRuntime$2, ClusterNodeApi activeNodeApi$3, SyncDeadline startedAt$1) {
        block12: {
            recoverer = new FileSnapshotableStateRecoverer<S>(continuation$3.file().getFileName(), continuation$3.maybeJournalId(), this.js7$cluster$PassiveClusterNode$$S);
            var7_6 = continuation$3;
            if (!(var7_6 instanceof NoLocalJournal) || ((NoLocalJournal)var7_6).js7$cluster$PassiveClusterNode$NoLocalJournal$$$outer() != this) break block12;
            var8_7 = (NoLocalJournal)var7_6;
            ** GOTO lbl9
        }
        if (var7_6 instanceof NextFile && ((NextFile)var7_6).js7$cluster$PassiveClusterNode$NextFile$$$outer() == this) {
            var9_8 = (NextFile)var7_6;
lbl9:
            // 2 sources

            tmp = JournalLocation$.MODULE$.toTemporaryFile(continuation$3.file());
            LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Replicating snapshot into temporary journal file {}", (Object)tmp.getFileName());
            }
            v0 = Some$.MODULE$.apply((Object)tmp);
        } else if (var7_6 instanceof FirstPartialFile && ((FirstPartialFile)var7_6).js7$cluster$PassiveClusterNode$FirstPartialFile$$$outer() == this) {
            var12_11 = (FirstPartialFile)var7_6;
            v0 = None$.MODULE$;
        } else {
            throw new MatchError((Object)var7_6);
        }
        var14_13 = maybeTmpFile = v0;
        if (None$.MODULE$.equals(var14_13)) {
            v1 = FileChannel.open(continuation$3.file(), new OpenOption[]{StandardOpenOption.APPEND});
        } else if (var14_13 instanceof Some) {
            var15_14 = (Some)var14_13;
            tmp = (Path)var15_14.value();
            v1 = FileChannel.open(tmp, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        } else {
            throw new MatchError((Object)var14_13);
        }
        out = ObjectRef.create((Object)v1);
        f = (Path)maybeTmpFile.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(js7.cluster.PassiveClusterNode$Continuation$Replicatable ), ()Ljava/nio/file/Path;)((Continuation.Replicatable)continuation$3));
        LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("replicateJournalFile size({})={} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{f.getFileName(), BoxesRunTime.boxToLong((long)Files.size(f)), recoverer.clusterState()}), Object.class));
        }
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)PassiveClusterNode.v$proxy5$1(continuation$3, f)), "continuation.fileLength == size(f)"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode.replicateJournalFile2"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 332));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        isReplicatingHeadOfFile = BooleanRef.create((boolean)maybeTmpFile.isDefined());
        replicatedFirstEventPosition = SetOnce$.MODULE$.fromOption(continuation$3.firstEventPosition(), "replicatedFirstEventPosition");
        replicatedFileLength = LongRef.create((long)continuation$3.fileLength());
        this.bean.fileSize_$eq(replicatedFileLength.elem);
        lastProperEventPosition = LongRef.create((long)continuation$3.lastProperEventPosition());
        _eof = BooleanRef.create((boolean)false);
        var24_24 = continuation$3;
        if (var24_24 instanceof FirstPartialFile && ((FirstPartialFile)var24_24).js7$cluster$PassiveClusterNode$FirstPartialFile$$$outer() == this) {
            var25_25 = (FirstPartialFile)var24_24;
            var26_26 = this.FirstPartialFile().unapply(var25_25);
            recoveredJournalFile = var27_27 = var26_26._1();
            LoggerImpl_this = PassiveClusterNode$.js7$cluster$PassiveClusterNode$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("Start replicating '" + continuation$3.file().getFileName() + "' file after " + (EventId$.MODULE$.toString(recoveredJournalFile.eventId()) + ", position " + recoveredJournalFile.length()));
            }
            recoverer.startWithState(recoveredJournalFile.journalHeader(), recoveredJournalFile.eventId(), recoveredJournalFile.nextJournalHeader().totalEventCount(), recoveredJournalFile.state());
            this._currentState = IO$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, replicateJournalFile2$$anonfun$1$$anonfun$1(js7.journal.recover.FileSnapshotableStateRecoverer ), ()Ljs7/data/event/ClusterableState;)(recoverer));
            this.js7$cluster$PassiveClusterNode$$recovered.eventWatch().onJournalingStarted(continuation$3.file(), recoveredJournalFile.journalId(), PositionAnd$.MODULE$.apply(recoveredJournalFile.firstEventPosition(), BoxesRunTime.boxToLong((long)continuation$3.fileEventId())), PositionAnd$.MODULE$.apply(recoveredJournalFile.length(), BoxesRunTime.boxToLong((long)recoveredJournalFile.eventId())), false);
        }
        recouplingStreamReader = new RecouplingStreamReader<Object, PositionAnd<ByteArray>, ClusterNodeApi>(continuation$3, _eof, replicatedFileLength, this){
            private final Continuation.Replicatable continuation$6;
            private final BooleanRef _eof$1;
            private final LongRef replicatedFileLength$1;
            private final /* synthetic */ PassiveClusterNode $outer;
            {
                this.continuation$6 = continuation$15;
                this._eof$1 = _eof$3;
                this.replicatedFileLength$1 = replicatedFileLength$8;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(PassiveClusterNode.js7$cluster$PassiveClusterNode$$_$_$$anon$superArg$1$1(), $outer.js7$cluster$PassiveClusterNode$$clusterConf.recouplingStreamReader(), Tag$.MODULE$.apply(PositionAnd.class, LightTypeTag$.MODULE$.parse(1453192706, "\u0001\u0001\u0001\u001ejs7.common.jsonseq.PositionAnd\u0001\u0000\u0004\u0000\u0001\u0017js7.base.data.ByteArray\u0001\u0001\u0000\u0001", "\u0000\u0001\u0001\u0001\u0001\u001ejs7.common.jsonseq.PositionAnd\u0001\u0000\u0004\u0000\u0001\u0017js7.base.data.ByteArray\u0001\u0001\u0000\u0001\u0003\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)));
            }

            public IO getStream(ClusterNodeApi api, long position) {
                JournalPosition journalPosition = JournalPosition$.MODULE$.apply(this.continuation$6.fileEventId(), position);
                Some some = Some$.MODULE$.apply((Object)this.$outer.js7$cluster$PassiveClusterNode$$setting.timing().heartbeat());
                Some some2 = Some$.MODULE$.apply((Object)JournalEvent$.MODULE$.StampedHeartbeatByteArray());
                Option<FiniteDuration> option = api.journalStream$default$4();
                boolean bl = api.journalStream$default$6();
                return HttpClient$.MODULE$.liftProblem(api.journalStream(journalPosition, (Option<FiniteDuration>)some, (Option<ByteArray>)some2, option, true, bl).map(arg_0 -> PassiveClusterNode.js7$cluster$PassiveClusterNode$$anon$1$$_$getStream$$anonfun$1(position, arg_0)));
            }

            public boolean stopRequested() {
                return this.$outer.js7$cluster$PassiveClusterNode$$stopped;
            }

            public boolean eof(long index) {
                return this._eof$1.elem && index >= this.replicatedFileLength$1.elem;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$cluster$PassiveClusterNode$$anon$1$$_$getStream$$anonfun$1(long fs2.Stream )}, serializedLambda);
            }
        };
        var33_31 = StreamExtensions$.MODULE$.interruptWhenF(recouplingStreamReader.stream(activeNodeApi$3, BoxesRunTime.boxToLong((long)continuation$3.fileLength())), this.shutdown.get(), IO$.MODULE$.asyncForIO()).handleErrorWith((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$5(js7.data.cluster.ClusterNodeApi js7.cluster.PassiveClusterNode$Continuation$Replicatable java.lang.Throwable ), (Ljava/lang/Throwable;)Lfs2/Stream;)((ClusterNodeApi)activeNodeApi$3, (Continuation.Replicatable)continuation$3));
        var32_32 = StreamPauseDetector$.MODULE$.detectPauses(StreamExtensions$.MODULE$.mapParallelBatch(var33_31, StreamExtensions$.MODULE$.mapParallelBatch$default$2(var33_31), StreamExtensions$.MODULE$.mapParallelBatch$default$3(var33_31), StreamExtensions$.MODULE$.mapParallelBatch$default$4(var33_31), (Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$6(js7.common.jsonseq.PositionAnd ), (Ljs7/common/jsonseq/PositionAnd;)Lscala/Tuple3;)((PassiveClusterNode)this)).filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$7(scala.Tuple3 ), (Lscala/Tuple3;)Ljava/lang/Boolean;)((PassiveClusterNode)this)), this.js7$cluster$PassiveClusterNode$$setting.timing().activeLostTimeout()).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8(scala.runtime.BooleanRef js7.cluster.PassiveClusterNode$Continuation$Replicatable js7.journal.recover.FileSnapshotableStateRecoverer cats.effect.unsafe.IORuntime scala.runtime.LongRef js7.base.utils.SetOnce scala.runtime.LongRef scala.runtime.ObjectRef scala.runtime.BooleanRef scala.Option js7.base.catsutils.SyncDeadline scala.util.Either ), (Lscala/util/Either;)Lfs2/Stream;)((PassiveClusterNode)this, (BooleanRef)isReplicatingHeadOfFile, (Continuation.Replicatable)continuation$3, recoverer, (IORuntime)ioRuntime$2, (LongRef)lastProperEventPosition, replicatedFirstEventPosition, (LongRef)replicatedFileLength, (ObjectRef)out, (BooleanRef)_eof, (Option)maybeTmpFile, (SyncDeadline)startedAt$1), NotGiven$.MODULE$.value());
        var31_33 = (Stream)package.applicativeError$.MODULE$.catsSyntaxApplicativeError((Object)var32_32.takeWhile((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, replicateJournalFile2$$anonfun$1$$anonfun$2(scala.util.Either ), (Lscala/util/Either;)Ljava/lang/Boolean;)(), var32_32.takeWhile$default$2()).takeThrough((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, replicateJournalFile2$$anonfun$1$$anonfun$3(js7.journal.recover.FileSnapshotableStateRecoverer scala.util.Either ), (Lscala/util/Either;)Ljava/lang/Boolean;)((PassiveClusterNode)this, recoverer)), (ApplicativeError)Stream$.MODULE$.monadErrorInstance((ApplicativeError)IO$.MODULE$.asyncForIO()));
        return ((IO)((Stream)ApplicativeErrorOps$.MODULE$.recoverWith$extension((Object)var31_33, (PartialFunction)new Serializable(recoverer, this){
            private final FileSnapshotableStateRecoverer recoverer$11;
            private final /* synthetic */ PassiveClusterNode $outer;
            {
                this.recoverer$11 = recoverer$15;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                if (throwable instanceof StreamTcpException) {
                    StreamTcpException streamTcpException;
                    StreamTcpException t = streamTcpException = (StreamTcpException)throwable;
                    if (this.$outer.js7$cluster$PassiveClusterNode$$shouldActivate(this.recoverer$11.clusterState())) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Throwable x2, Function1 function1) {
                Throwable throwable = x2;
                if (throwable instanceof StreamTcpException) {
                    StreamTcpException streamTcpException;
                    StreamTcpException t = streamTcpException = (StreamTcpException)throwable;
                    if (this.$outer.js7$cluster$PassiveClusterNode$$shouldActivate(this.recoverer$11.clusterState())) {
                        return Stream$.MODULE$.exec((Object)IO$.MODULE$.apply(() -> PassiveClusterNode.js7$cluster$PassiveClusterNode$$anon$2$$_$applyOrElse$$anonfun$adapted$1(t)));
                    }
                }
                return function1.apply((Object)x2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$cluster$PassiveClusterNode$$anon$2$$_$applyOrElse$$anonfun$adapted$1(org.apache.pekko.stream.StreamTcpException )}, serializedLambda);
            }
        }, (ApplicativeError)Stream$.MODULE$.monadErrorInstance((ApplicativeError)IO$.MODULE$.asyncForIO()))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x2) {
                Either either = x2;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Problem problem = (Problem)left.value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x2, Function1 function1) {
                Either either = x2;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Problem problem = (Problem)left.value();
                    return problem;
                }
                return function1.apply((Object)x2);
            }
        }).head().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).last()).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, replicateJournalFile2$$anonfun$1$$anonfun$4(scala.runtime.BooleanRef scala.runtime.LongRef js7.journal.recover.FileSnapshotableStateRecoverer scala.runtime.ObjectRef scala.runtime.LongRef js7.cluster.PassiveClusterNode$Continuation$Replicatable js7.base.utils.SetOnce scala.Option ), (Lscala/Option;)Lcats/effect/IO;)((PassiveClusterNode)this, (BooleanRef)isReplicatingHeadOfFile, (LongRef)replicatedFileLength, recoverer, (ObjectRef)out, (LongRef)lastProperEventPosition, (Continuation.Replicatable)continuation$3, replicatedFirstEventPosition)).guarantee(IO$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, replicateJournalFile2$$anonfun$1$$anonfun$adapted$1(scala.runtime.ObjectRef ), ()Ljava/lang/Object;)((ObjectRef)out)));
    }

    private static final boolean testHeartbeatSuppressor$$anonfun$1() {
        return false;
    }

    public interface Continuation {
    }

    public class FirstPartialFile
    implements Continuation.Replicatable,
    Continuation.HasRecoveredJournalFile,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FirstPartialFile.class.getDeclaredField("file$lzy2"));
        private volatile Object file$lzy2;
        private final RecoveredJournalFile<S> recoveredJournalFile;
        private final /* synthetic */ PassiveClusterNode $outer;

        public FirstPartialFile(PassiveClusterNode $outer, RecoveredJournalFile<S> recoveredJournalFile) {
            this.recoveredJournalFile = recoveredJournalFile;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Continuation.Replicatable.$init$(this);
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy9$1(recoveredJournalFile)), "recoveredJournalFile.file == file"), FullName$.MODULE$.apply("js7.cluster.PassiveClusterNode.FirstPartialFile"), ScalaSourceLocation$.MODULE$.apply("PassiveClusterNode.scala", 755));
        }

        @Override
        public final Path file() {
            Object object = this.file$lzy2;
            if (object instanceof Path) {
                return (Path)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Path)this.file$lzyINIT2();
        }

        private Object file$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.file$lzy2) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Path path = null;
                        try {
                            path = Continuation.Replicatable.file$(this);
                            object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.file$lzy2;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return path;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 363608722, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            FirstPartialFile firstPartialFile;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FirstPartialFile)) return false;
            if (((FirstPartialFile)object).js7$cluster$PassiveClusterNode$FirstPartialFile$$$outer() != this.$outer) return false;
            FirstPartialFile firstPartialFile2 = firstPartialFile = (FirstPartialFile)object;
            RecoveredJournalFile recoveredJournalFile = this.recoveredJournalFile();
            RecoveredJournalFile recoveredJournalFile2 = firstPartialFile2.recoveredJournalFile();
            if (recoveredJournalFile == null) {
                if (recoveredJournalFile2 != null) {
                    return false;
                }
            } else if (!((Object)recoveredJournalFile).equals(recoveredJournalFile2)) return false;
            if (!firstPartialFile2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof FirstPartialFile;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FirstPartialFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "recoveredJournalFile";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public RecoveredJournalFile<S> recoveredJournalFile() {
            return this.recoveredJournalFile;
        }

        @Override
        public long fileLength() {
            return this.recoveredJournalFile().length();
        }

        @Override
        public long fileEventId() {
            return this.recoveredJournalFile().fileEventId();
        }

        @Override
        public Option<Object> firstEventPosition() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.recoveredJournalFile().firstEventPosition()));
        }

        @Override
        public long lastProperEventPosition() {
            return this.recoveredJournalFile().lastProperEventPosition();
        }

        public String toString() {
            return "FirstPartialFile(" + this.fileEventId() + "," + this.fileLength() + "," + this.recoveredJournalFile().eventId() + ")";
        }

        public FirstPartialFile copy(RecoveredJournalFile<S> recoveredJournalFile) {
            return new FirstPartialFile(this.$outer, recoveredJournalFile);
        }

        public RecoveredJournalFile<S> copy$default$1() {
            return this.recoveredJournalFile();
        }

        public RecoveredJournalFile<S> _1() {
            return this.recoveredJournalFile();
        }

        public final /* synthetic */ PassiveClusterNode js7$cluster$PassiveClusterNode$FirstPartialFile$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ PassiveClusterNode$Continuation$ js7$cluster$PassiveClusterNode$Continuation$Replicatable$$$outer() {
            return this.$outer.js7$cluster$PassiveClusterNode$$Continuation();
        }

        @Override
        public final /* synthetic */ PassiveClusterNode$Continuation$ js7$cluster$PassiveClusterNode$Continuation$HasRecoveredJournalFile$$$outer() {
            return this.$outer.js7$cluster$PassiveClusterNode$$Continuation();
        }

        private final boolean v$proxy9$1(RecoveredJournalFile recoveredJournalFile$4) {
            Path path = recoveredJournalFile$4.file();
            Path path2 = this.file();
            return !(path != null ? !((Object)path).equals(path2) : path2 != null);
        }
    }

    public class NextFile
    implements Continuation.Replicatable,
    Continuation.HasRecoveredJournalFile,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NextFile.class.getDeclaredField("file$lzy3"));
        private volatile Object file$lzy3;
        private final RecoveredJournalFile<S> recoveredJournalFile;
        private final /* synthetic */ PassiveClusterNode $outer;

        public NextFile(PassiveClusterNode $outer, RecoveredJournalFile<S> recoveredJournalFile) {
            this.recoveredJournalFile = recoveredJournalFile;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Continuation.Replicatable.$init$(this);
        }

        @Override
        public final Path file() {
            Object object = this.file$lzy3;
            if (object instanceof Path) {
                return (Path)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Path)this.file$lzyINIT3();
        }

        private Object file$lzyINIT3() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.file$lzy3) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Path path = null;
                        try {
                            path = Continuation.Replicatable.file$(this);
                            object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.file$lzy3;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return path;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1751450619, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            NextFile nextFile;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NextFile)) return false;
            if (((NextFile)object).js7$cluster$PassiveClusterNode$NextFile$$$outer() != this.$outer) return false;
            NextFile nextFile2 = nextFile = (NextFile)object;
            RecoveredJournalFile recoveredJournalFile = this.recoveredJournalFile();
            RecoveredJournalFile recoveredJournalFile2 = nextFile2.recoveredJournalFile();
            if (recoveredJournalFile == null) {
                if (recoveredJournalFile2 != null) {
                    return false;
                }
            } else if (!((Object)recoveredJournalFile).equals(recoveredJournalFile2)) return false;
            if (!nextFile2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof NextFile;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NextFile";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "recoveredJournalFile";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public RecoveredJournalFile<S> recoveredJournalFile() {
            return this.recoveredJournalFile;
        }

        @Override
        public long fileLength() {
            return 0L;
        }

        @Override
        public long fileEventId() {
            return this.recoveredJournalFile().eventId();
        }

        @Override
        public Option<Object> firstEventPosition() {
            return None$.MODULE$;
        }

        @Override
        public long lastProperEventPosition() {
            return this.recoveredJournalFile().lastProperEventPosition();
        }

        public String toString() {
            return "NextFile(" + this.recoveredJournalFile().eventId() + ")";
        }

        public NextFile copy(RecoveredJournalFile<S> recoveredJournalFile) {
            return new NextFile(this.$outer, recoveredJournalFile);
        }

        public RecoveredJournalFile<S> copy$default$1() {
            return this.recoveredJournalFile();
        }

        public RecoveredJournalFile<S> _1() {
            return this.recoveredJournalFile();
        }

        public final /* synthetic */ PassiveClusterNode js7$cluster$PassiveClusterNode$NextFile$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ PassiveClusterNode$Continuation$ js7$cluster$PassiveClusterNode$Continuation$Replicatable$$$outer() {
            return this.$outer.js7$cluster$PassiveClusterNode$$Continuation();
        }

        @Override
        public final /* synthetic */ PassiveClusterNode$Continuation$ js7$cluster$PassiveClusterNode$Continuation$HasRecoveredJournalFile$$$outer() {
            return this.$outer.js7$cluster$PassiveClusterNode$$Continuation();
        }
    }

    public class NoLocalJournal
    implements Continuation.Replicatable,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NoLocalJournal.class.getDeclaredField("file$lzy1"));
        private volatile Object file$lzy1;
        private final long fileEventId;
        private final /* synthetic */ PassiveClusterNode $outer;

        public NoLocalJournal(PassiveClusterNode $outer, long fileEventId) {
            this.fileEventId = fileEventId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Continuation.Replicatable.$init$(this);
        }

        @Override
        public final Path file() {
            Object object = this.file$lzy1;
            if (object instanceof Path) {
                return (Path)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Path)this.file$lzyINIT1();
        }

        private Object file$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.file$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Path path = null;
                        try {
                            path = Continuation.Replicatable.file$(this);
                            object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.file$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return path;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-1673863731);
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileEventId()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            NoLocalJournal noLocalJournal;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NoLocalJournal)) return false;
            if (((NoLocalJournal)object).js7$cluster$PassiveClusterNode$NoLocalJournal$$$outer() != this.$outer) return false;
            NoLocalJournal noLocalJournal2 = noLocalJournal = (NoLocalJournal)object;
            if (this.fileEventId() != noLocalJournal2.fileEventId()) return false;
            if (!noLocalJournal2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NoLocalJournal;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NoLocalJournal";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fileEventId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public long fileEventId() {
            return this.fileEventId;
        }

        @Override
        public S aggregate() {
            return this.$outer.js7$cluster$PassiveClusterNode$$S.empty();
        }

        @Override
        public long fileLength() {
            return 0L;
        }

        @Override
        public Option<Object> firstEventPosition() {
            return None$.MODULE$;
        }

        @Override
        public long lastProperEventPosition() {
            return -1L;
        }

        @Override
        public Option<JournalId> maybeJournalId() {
            return None$.MODULE$;
        }

        @Override
        public Option<RecoveredJournalFile<S>> maybeRecoveredJournalFile() {
            return None$.MODULE$;
        }

        public NoLocalJournal copy(long fileEventId) {
            return new NoLocalJournal(this.$outer, fileEventId);
        }

        public long copy$default$1() {
            return this.fileEventId();
        }

        public long _1() {
            return this.fileEventId();
        }

        public final /* synthetic */ PassiveClusterNode js7$cluster$PassiveClusterNode$NoLocalJournal$$$outer() {
            return this.$outer;
        }

        @Override
        public final /* synthetic */ PassiveClusterNode$Continuation$ js7$cluster$PassiveClusterNode$Continuation$Replicatable$$$outer() {
            return this.$outer.js7$cluster$PassiveClusterNode$$Continuation();
        }
    }
}

