/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.unsafe.IORuntime;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import izumi.reflect.Tag;
import java.io.Serializable;
import js7.base.auth.UserAndPassword;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.generic.SecretString;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichOption$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.base.web.Uri;
import js7.cluster.ActiveClusterNode;
import js7.cluster.ClusterCommon;
import js7.cluster.ClusterConf;
import js7.cluster.WorkingClusterNode$;
import js7.data.Problems$ClusterNodeIsNotActiveProblem$;
import js7.data.Problems$ClusterNodesAlreadyAppointed$;
import js7.data.Problems$ClusterSettingNotUpdatable$;
import js7.data.cluster.ClusterCommand;
import js7.data.cluster.ClusterEvent$ClusterNodesAppointed$;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterSetting$;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.cluster.ClusterState$HasNodes$;
import js7.data.cluster.ClusterTiming;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchingCommand;
import js7.data.event.ClusterableState;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.NoKeyEvent;
import js7.data.event.NoKeyEvent$;
import js7.data.event.SnapshotableState;
import js7.data.item.BasicItemEvent;
import js7.data.node.NodeId;
import js7.data.node.NodeName;
import js7.journal.CommitOptions$;
import js7.journal.EventIdGenerator;
import js7.journal.FileJournal;
import js7.journal.recover.Recovered;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing$;
import sourcecode.Name$;

public final class WorkingClusterNode<S extends ClusterableState<S>> {
    private final Option<NodeId> failedNodeId;
    private final FileJournal<S> journal;
    private final ClusterCommon common;
    private final ClusterConf clusterConf;
    private final ClusterableState.Companion<S> S;
    private final Function1<NodeName, Either<Problem, Option<SecretString>>> nodeNameToPassword;
    private final SetOnce<ActiveClusterNode<S>> _activeClusterNode;
    private final IO<Either<Problem, ActiveClusterNode<S>>> activeClusterNodeIO;
    private final AsyncLock appointNodesLock;

    public static <S extends ClusterableState<S>> Resource<IO, WorkingClusterNode<S>> resource(Recovered<S> recovered, ClusterCommon clusterCommon, ClusterConf clusterConf, EventIdGenerator eventIdGenerator, ClusterableState.Companion<S> companion, Tag<S> tag, Function1<NodeName, Either<Problem, Option<SecretString>>> function1, IORuntime iORuntime) {
        return WorkingClusterNode$.MODULE$.resource(recovered, clusterCommon, clusterConf, eventIdGenerator, companion, tag, function1, iORuntime);
    }

    public static <S extends ClusterableState<S>> EventIdGenerator resource$default$4() {
        return WorkingClusterNode$.MODULE$.resource$default$4();
    }

    public WorkingClusterNode(Option<NodeId> failedNodeId, FileJournal<S> journal, ClusterCommon common, ClusterConf clusterConf, ClusterableState.Companion<S> S, Function1<NodeName, Either<Problem, Option<SecretString>>> nodeNameToPassword) {
        this.failedNodeId = failedNodeId;
        this.journal = journal;
        this.common = common;
        this.clusterConf = clusterConf;
        this.S = S;
        this.nodeNameToPassword = nodeNameToPassword;
        this._activeClusterNode = SetOnce$.MODULE$.undefined((Function0<String>)((Function0 & Serializable)WorkingClusterNode::$init$$$anonfun$1), Problems$ClusterNodeIsNotActiveProblem$.MODULE$);
        this.activeClusterNodeIO = IO$.MODULE$.apply(this::$init$$$anonfun$2);
        this.appointNodesLock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.cluster.WorkingClusterNode#appointNodesLock"));
    }

    public Option<NodeId> failedNodeId() {
        return this.failedNodeId;
    }

    public FileJournal<S> journal() {
        return this.journal;
    }

    public IO<Either<Problem, BoxedUnit>> js7$cluster$WorkingClusterNode$$start(ClusterState clusterState2, long eventId) {
        return (IO)ScalaUtils$syntax$.MODULE$.foldMap(clusterState2.ifHasNodes(), (Function1 & Serializable)clusterState -> {
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.common.requireValidLicense());
            IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$1 -> this.startActiveClusterNode((ClusterState.HasNodes)clusterState, eventId), IO$.MODULE$.asyncForIO()));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, (Function1 & Serializable)_$2 -> {
                if (!this.S.callExpliclitlyAfterAggregateInitialisation()) {
                    return this.afterAggregateInitialisation();
                }
                return (IO)IO$.MODULE$.asyncForIO().pure(Semigroup$.MODULE$.catsKernelMonoidForEither((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()).empty());
            }, IO$.MODULE$.asyncForIO());
        }, IO$.MODULE$.monoidForIO(Semigroup$.MODULE$.catsKernelMonoidForEither((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())));
    }

    public IO<BoxedUnit> stop() {
        return IO$.MODULE$.defer(this::stop$$anonfun$1);
    }

    public IO<Either<Problem, BoxedUnit>> appointNodes(Map<NodeId, Uri> idToUri, NodeId activeId, Option<BasicItemEvent.ItemAttachedToMe> extraEvent) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> this.appointNodes$$anonfun$1(idToUri, activeId)));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$4 -> this.appointNodes2((ClusterSetting)_$4, extraEvent), IO$.MODULE$.asyncForIO());
    }

    public Option<BasicItemEvent.ItemAttachedToMe> appointNodes$default$3() {
        return None$.MODULE$;
    }

    public IO<Either<Problem, BoxedUnit>> afterAggregateInitialisation() {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.automaticallyAppointConfiguredBackupNode());
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$5 -> (IO)ScalaUtils$syntax$.MODULE$.foldMap(this._activeClusterNode.toOption(), (Function1 & Serializable)_$6 -> _$6.emitClusterActiveNodeRestarted(), IO$.MODULE$.monoidForIO(Semigroup$.MODULE$.catsKernelMonoidForEither((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()))), IO$.MODULE$.asyncForIO());
    }

    private IO<Either<Problem, BoxedUnit>> automaticallyAppointConfiguredBackupNode() {
        return (IO)ScalaUtils$syntax$.MODULE$.foldMap(this.clusterConf.maybeClusterSetting(), (Function1 & Serializable)setting -> this.journal().clusterState().flatMap((Function1 & Serializable)x$12 -> {
            ClusterState clusterState = x$12;
            if (clusterState instanceof ClusterState.HasNodes) {
                ClusterState.HasNodes hasNodes = (ClusterState.HasNodes)clusterState;
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxedUnit.UNIT);
            }
            if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
                return Logger$package$Logger$syntax$.MODULE$.debugIO(WorkingClusterNode$.js7$cluster$WorkingClusterNode$$$logger, this.appointNodes2((ClusterSetting)setting, this.appointNodes2$default$2()).handleError((Function1 & Serializable)t -> package$.MODULE$.Left().apply((Object)Problem$.MODULE$.fromThrowable((Throwable)t))).map((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Problem problem = (Problem)left.value();
                        if (((Object)Problems$ClusterNodesAlreadyAppointed$.MODULE$).equals(problem)) {
                            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        }
                        Problem problem2 = problem;
                        return package$.MODULE$.Left().apply((Object)problem2.withPrefix("Configured cluster node appointment failed, maybe due to failed access to ClusterWatch:"));
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = right.value();
                        if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        }
                    }
                    throw new MatchError((Object)either);
                }), Name$.MODULE$.apply("automaticallyAppointConfiguredBackupNode"));
            }
            throw new MatchError((Object)clusterState);
        }), IO$.MODULE$.monoidForIO(Semigroup$.MODULE$.catsKernelMonoidForEither((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())));
    }

    private IO<Either<Problem, BoxedUnit>> appointNodes2(ClusterSetting setting, Option<BasicItemEvent.ItemAttachedToMe> extraEvent) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(WorkingClusterNode$.js7$cluster$WorkingClusterNode$$$logger, this.appointNodesLock.lock(this.journal().clusterState().flatMap((Function1 & Serializable)x$1 -> {
            ClusterState.HasNodes hasNodes;
            Some<ClusterSetting> some;
            ClusterState clusterState = x$1;
            if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
                IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.journal().persistKeyedEvents(CommitOptions$.MODULE$.Transaction(), (IterableOnce)((List)extraEvent.toList().$colon$plus((Object)ClusterEvent$ClusterNodesAppointed$.MODULE$.apply(setting))).map((Function1 & Serializable)_$7 -> {
                    KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
                    NoKeyEvent Event_this = _$7;
                    return new KeyedEvent<NoKeyEvent>(Event_this, keyedEvent$NoKey$);
                })));
                return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)persisted -> {
                    ClusterState clusterState = ((SnapshotableState)persisted.aggregate()).clusterState();
                    if (clusterState instanceof ClusterState.HasNodes) {
                        ClusterState.HasNodes hasNodes;
                        ClusterState.HasNodes clusterState2 = hasNodes = (ClusterState.HasNodes)clusterState;
                        return this.startActiveClusterNode(clusterState2, ((SnapshotableState)persisted.aggregate()).eventId());
                    }
                    ClusterState clusterState3 = clusterState;
                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("Unexpected ClusterState " + clusterState3 + " after ClusterNodesAppointed"));
                }, IO$.MODULE$.asyncForIO());
            }
            if (clusterState instanceof ClusterState.HasNodes && !(some = ClusterState$HasNodes$.MODULE$.unapply(hasNodes = (ClusterState.HasNodes)clusterState)).isEmpty()) {
                ClusterSetting clusterSetting;
                ClusterSetting current = clusterSetting = (ClusterSetting)some.get();
                ClusterState.HasNodes clusterState2 = hasNodes;
                ClusterSetting clusterSetting2 = setting;
                None$ none$ = None$.MODULE$;
                Map<NodeId, Uri> map = current.copy$default$1();
                NodeId nodeId = current.copy$default$2();
                ClusterTiming clusterTiming = current.copy$default$3();
                ClusterSetting clusterSetting3 = current.copy(map, nodeId, clusterTiming, (Option<ClusterWatchId>)none$).withPassiveUri(setting.passiveUri());
                if (clusterSetting2 == null ? clusterSetting3 != null : !((Object)clusterSetting2).equals(clusterSetting3)) {
                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$ClusterSettingNotUpdatable$.MODULE$.apply(clusterState2));
                }
                Uri uri = setting.passiveUri();
                Uri uri2 = current.passiveUri();
                if (!(uri != null ? !((Object)uri).equals(uri2) : uri2 != null)) {
                    return (IO)extraEvent.fold(WorkingClusterNode::appointNodes2$$anonfun$1$$anonfun$3, (Function1 & Serializable)extraEvent -> {
                        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.journal().persist((KeyedEvent)NoKeyEvent$.MODULE$.toKeyedEvent(extraEvent)));
                        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO());
                    });
                }
                IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.activeClusterNodeIO);
                return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$8 -> _$8.changePassiveUri(setting.passiveUri(), extraEvent), IO$.MODULE$.asyncForIO());
            }
            throw new MatchError((Object)clusterState);
        }), Enclosing$.MODULE$.apply("js7.cluster.WorkingClusterNode#appointNodes2"), ScalaSourceLocation$.MODULE$.apply("WorkingClusterNode.scala", 120)), Name$.MODULE$.apply("appointNodes2"));
    }

    private Option<BasicItemEvent.ItemAttachedToMe> appointNodes2$default$2() {
        return None$.MODULE$;
    }

    private IO<Either<Problem, BoxedUnit>> startActiveClusterNode(ClusterState.HasNodes clusterState, long eventId) {
        NodeId passiveNodeId = clusterState.setting().other(clusterState.activeId());
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.journal().aggregate().map((Function1 & Serializable)_$9 -> _$9.clusterNodeToUserAndPassword(clusterState.activeId(), passiveNodeId, this.nodeNameToPassword)));
        return Logger$package$Logger$syntax$.MODULE$.traceIO(WorkingClusterNode$.js7$cluster$WorkingClusterNode$$$logger, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)passiveNodeUserAndPassword -> IO$.MODULE$.defer(() -> this.startActiveClusterNode$$anonfun$2$$anonfun$1(passiveNodeUserAndPassword, eventId)), IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("startActiveClusterNode"));
    }

    public IO<Either<Problem, BoxedUnit>> executeClusterWatchConfirm(ClusterWatchingCommand.ClusterWatchConfirm cmd) {
        return IO$.MODULE$.defer(() -> this.executeClusterWatchConfirm$$anonfun$1(cmd));
    }

    public IO<Either<Problem, BoxedUnit>> onTerminatedUnexpectedly() {
        return this._activeClusterNode.io().flatMap((Function1 & Serializable)_$11 -> _$11.onTerminatedUnexpectedly());
    }

    public IO<Either<Problem, BoxedUnit>> switchOver() {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.activeClusterNodeIO);
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$12 -> _$12.switchOver(), IO$.MODULE$.asyncForIO());
    }

    public IO<Either<Problem, ClusterCommand.Response>> executeCommand(ClusterCommand command) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.activeClusterNodeIO);
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$13 -> _$13.executeCommand(command), IO$.MODULE$.asyncForIO());
    }

    public IO<Either<Problem, Completed$package$Completed$>> shutDownThisNode() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(WorkingClusterNode$.js7$cluster$WorkingClusterNode$$$logger, IO$.MODULE$.defer(this::shutDownThisNode$$anonfun$1), Name$.MODULE$.apply("shutDownThisNode"));
    }

    public boolean isActive() {
        return this._activeClusterNode.isDefined();
    }

    public String toString() {
        return "WorkingClusterNode[" + this.S + "]";
    }

    private static final String $init$$$anonfun$1() {
        return "ActiveClusterNode";
    }

    private final Either $init$$$anonfun$2() {
        return this._activeClusterNode.checked();
    }

    private static final IO stop$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO stop$$anonfun$1() {
        return (IO)this._activeClusterNode.toOption().fold(WorkingClusterNode::stop$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$3 -> _$3.stop());
    }

    private final Either appointNodes$$anonfun$1(Map idToUri$2, NodeId activeId$2) {
        return ClusterSetting$.MODULE$.checked((Map<NodeId, Uri>)idToUri$2, activeId$2, this.clusterConf.timing(), (Option<ClusterWatchId>)None$.MODULE$);
    }

    private static final IO appointNodes2$$anonfun$1$$anonfun$3() {
        return IO$.MODULE$.pure(Checked$.MODULE$.unit());
    }

    private final IO startActiveClusterNode$$anonfun$2$$anonfun$1(Option passiveNodeUserAndPassword$1, long eventId$3) {
        ActiveClusterNode<S> activeClusterNode = new ActiveClusterNode<S>(this.journal(), (Option<UserAndPassword>)passiveNodeUserAndPassword$1, this.common, this.clusterConf, this.nodeNameToPassword);
        if (this._activeClusterNode.trySet(activeClusterNode)) {
            return activeClusterNode.start(eventId$3);
        }
        return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("ActiveClusterNode has already been started"));
    }

    private static final IO executeClusterWatchConfirm$$anonfun$1$$anonfun$1() {
        return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problems$ClusterNodeIsNotActiveProblem$.MODULE$);
    }

    private final IO executeClusterWatchConfirm$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm cmd$1) {
        Option option = ScalaUtils$syntax$.MODULE$.RichOption(this._activeClusterNode.toOption());
        return (IO)ScalaUtils$syntax$RichOption$.MODULE$.fold_$extension(option, WorkingClusterNode::executeClusterWatchConfirm$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$10 -> _$10.executeClusterWatchConfirm(cmd$1));
    }

    private final IO shutDownThisNode$$anonfun$1() {
        Option<ActiveClusterNode<S>> option = this._activeClusterNode.toOption();
        if (None$.MODULE$.equals(option)) {
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Completed$package$Completed$.MODULE$);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            ActiveClusterNode o = (ActiveClusterNode)some.value();
            return o.shutDownThisNode();
        }
        throw new MatchError(option);
    }
}

