/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster.watch;

import cats.ApplicativeError;
import cats.data.NonEmptyList;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.problem.Problem;
import js7.base.service.MainService;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.DelayConf;
import js7.base.utils.DelayConf$;
import js7.base.utils.Delayer$;
import js7.base.utils.ProgramTermination;
import js7.base.utils.ProgramTermination$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.web.HttpClient;
import js7.base.web.HttpClient$;
import js7.cluster.watch.ClusterWatch;
import js7.cluster.watch.ClusterWatch$;
import js7.cluster.watch.ClusterWatchConf;
import js7.cluster.watch.ClusterWatchService$;
import js7.cluster.watch.api.HttpClusterNodeApi;
import js7.common.http.PekkoHttpClient$;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchProblems;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$;
import js7.data.cluster.ClusterWatchRequest;
import js7.data.cluster.ClusterWatchRunId;
import js7.data.cluster.ClusterWatchRunId$;
import js7.data.cluster.ClusterWatchingCommand$ClusterWatchConfirm$;
import js7.data.node.NodeId;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import sourcecode.Enclosing$;

public final class ClusterWatchService
implements Service,
MainService,
StoppableByRequest,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final ClusterWatchId clusterWatchId;
    private final NonEmptyList<HttpClusterNodeApi> nodeApis;
    public final FiniteDuration js7$cluster$watch$ClusterWatchService$$keepAlive;
    private final ClusterWatch clusterWatch;
    private final ClusterWatchRunId clusterWatchRunId;
    public final DelayConf js7$cluster$watch$ClusterWatchService$$delayConf;
    private final IO<ProgramTermination> untilTerminated;

    public static Resource<IO, ClusterWatchService> programResource(ClusterWatchConf clusterWatchConf) {
        return ClusterWatchService$.MODULE$.programResource(clusterWatchConf);
    }

    public static Resource<IO, ClusterWatchService> service(ClusterWatchId clusterWatchId, Resource<IO, NonEmptyList<HttpClusterNodeApi>> resource, Config config, String string, Function1<ClusterState.HasNodes, BoxedUnit> function1, Function1<Option<ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem>, IO<BoxedUnit>> function12) {
        return ClusterWatchService$.MODULE$.service(clusterWatchId, resource, config, string, function1, function12);
    }

    public static String service$default$4() {
        return ClusterWatchService$.MODULE$.service$default$4();
    }

    public static Function1<ClusterState.HasNodes, BoxedUnit> service$default$5() {
        return ClusterWatchService$.MODULE$.service$default$5();
    }

    public static Function1<Option<ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem>, IO<BoxedUnit>> service$default$6() {
        return ClusterWatchService$.MODULE$.service$default$6();
    }

    public ClusterWatchService(ClusterWatchId clusterWatchId, NonEmptyList<HttpClusterNodeApi> nodeApis, String label, FiniteDuration keepAlive, NonEmptyList<FiniteDuration> retryDelays, Function1<ClusterState.HasNodes, BoxedUnit> onClusterStateChanged, Function1<Option<ClusterWatchProblems.ClusterNodeLossNotConfirmedProblem>, IO<BoxedUnit>> onUndecidableClusterNodeLoss) {
        this.clusterWatchId = clusterWatchId;
        this.nodeApis = nodeApis;
        this.js7$cluster$watch$ClusterWatchService$$keepAlive = keepAlive;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this.clusterWatch = new ClusterWatch(label, onClusterStateChanged, ClusterWatch$.MODULE$.$lessinit$greater$default$3(), (Function1<ClusterState.HasNodes, IO<Either<Problem, BoxedUnit>>>)(Function1 & Serializable)clusterState -> this.checkActiveIsLost((ClusterState.HasNodes)clusterState), onUndecidableClusterNodeLoss);
        this.clusterWatchRunId = ClusterWatchRunId$.MODULE$.random();
        this.js7$cluster$watch$ClusterWatchService$$delayConf = DelayConf$.MODULE$.apply(retryDelays, (FiniteDuration)retryDelays.last());
        this.untilTerminated = this.untilStopped().as((Object)ProgramTermination$.MODULE$.apply(ProgramTermination$.MODULE$.apply$default$1()));
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public ClusterWatchId clusterWatchId() {
        return this.clusterWatchId;
    }

    public ClusterWatch clusterWatch() {
        return this.clusterWatch;
    }

    public ClusterWatchRunId clusterWatchRunId() {
        return this.clusterWatchRunId;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startServiceAndLog(ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger, CatsUtils$syntax$.MODULE$.mkString(this.nodeApis, ", "), (IO)this.run());
    }

    @Override
    public IO<ProgramTermination> untilTerminated() {
        return this.untilTerminated;
    }

    private IO<BoxedUnit> run() {
        Stream stream = Stream$.MODULE$.NestedStreamOps(Stream$.MODULE$.iterable((Iterable)this.nodeApis.toList()).map((Function1 & Serializable)nodeApi -> {
            NodeServer nodeWatch = new NodeServer(this, (HttpClusterNodeApi)nodeApi);
            return nodeWatch.stream().map((Function1 & Serializable)_$1 -> {
                NodeServer nodeServer = (NodeServer)Predef$.MODULE$.ArrowAssoc((Object)nodeWatch);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)nodeServer, _$1);
            });
        }));
        return (IO)StreamExtensions$.MODULE$.interruptWhenF(Stream.NestedStreamOps$.MODULE$.parJoinUnbounded$extension(stream, (GenConcurrent)IO$.MODULE$.asyncForIO()).evalMap((Function1 & Serializable)x$1 -> {
            NodeServer nodeServer = (NodeServer)x$1._1();
            ClusterWatchRequest clusterWatchRequest = (ClusterWatchRequest)x$1._2();
            return clusterWatchRequest.correlId().bind(() -> ClusterWatchService.run$$anonfun$2$$anonfun$1(nodeServer, clusterWatchRequest), CanBindCorrelId$.MODULE$.io());
        }), this.untilStopRequested(), IO$.MODULE$.asyncForIO()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private IO<Either<Problem, BoxedUnit>> checkActiveIsLost(ClusterState.HasNodes clusterState) {
        return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
    }

    private void TEST(Throwable t) {
        Logger LoggerImpl_this = ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
            LoggerImpl_this.underlying().info(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable));
            return;
        }
    }

    public IO<Either<Problem, BoxedUnit>> manuallyConfirmNodeLoss(NodeId lostNodeId, String confirmer) {
        return this.clusterWatch().manuallyConfirmNodeLoss(lostNodeId, confirmer);
    }

    public Option<ClusterEvent.ClusterNodeLostEvent> clusterNodeLossEventToBeConfirmed(NodeId lostNodeId) {
        return this.clusterWatch().clusterNodeLossEventToBeConfirmed(lostNodeId);
    }

    public String toString() {
        return "ClusterWatchService(" + this.clusterWatchId() + ")";
    }

    public Either<Problem, ClusterState> clusterState() {
        return this.clusterWatch().clusterState();
    }

    private static final IO run$$anonfun$2$$anonfun$1(NodeServer nodeWatch$2, ClusterWatchRequest request$1) {
        return nodeWatch$2.processRequest(request$1);
    }

    public static final /* synthetic */ Stream js7$cluster$watch$ClusterWatchService$NodeServer$$_$clusterWatchRequestStream$$anonfun$4(Either _$3) {
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(_$3);
        return (Stream)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
    }

    public static final /* synthetic */ Option js7$cluster$watch$ClusterWatchService$NodeServer$$_$respond$$anonfun$1(ClusterWatch.Confirmed _$5) {
        return _$5.manualConfirmer();
    }

    public final class NodeServer {
        private final HttpClusterNodeApi nodeApi;
        private final AtomicBoolean streamFailed;
        private final /* synthetic */ ClusterWatchService $outer;

        public NodeServer(ClusterWatchService $outer, HttpClusterNodeApi nodeApi) {
            this.nodeApi = nodeApi;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.streamFailed = new AtomicBoolean(false);
        }

        public Stream<IO, ClusterWatchRequest> stream() {
            return this.streamAgainAndAgain(this.clusterWatchRequestStream());
        }

        private <A> Stream<IO, A> streamAgainAndAgain(Stream<IO, A> stream) {
            return Delayer$.MODULE$.stream(this.$outer.js7$cluster$watch$ClusterWatchService$$delayConf, IO$.MODULE$.asyncForIO(), Enclosing$.MODULE$.apply("js7.cluster.watch.ClusterWatchService#NodeServer#streamAgainAndAgain")).flatMap((Function1 & Serializable)_$2 -> stream.handleErrorWith((Function1 & Serializable)t -> {
                Logger LoggerImpl_this = ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = this.nodeApi;
                    Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
                    LoggerImpl_this.underlying().warn("\ud83d\udd34 {} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                }
                this.streamFailed.set(true);
                return Stream$.MODULE$.empty();
            }), NotGiven$.MODULE$.value());
        }

        private Stream<IO, ClusterWatchRequest> clusterWatchRequestStream() {
            return Logger$package$Logger$syntax$.MODULE$.traceStream(ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger, "clusterWatchRequestStream", (Function0<Object>)((Function0 & Serializable)this::clusterWatchRequestStream$$anonfun$1), Stream$.MODULE$.eval(this.nodeApi.retryUntilReachable(this.nodeApi.retryUntilReachable$default$1(), this::clusterWatchRequestStream$$anonfun$2)).attempt().evalMap((Function1 & Serializable)x$1 -> {
                HttpClient.HttpException httpException;
                HttpClient.HttpException t;
                Left left;
                Throwable throwable;
                Either either = x$1;
                if (either instanceof Left && (throwable = (Throwable)(left = (Left)either).value()) instanceof HttpClient.HttpException && (t = (httpException = (HttpClient.HttpException)throwable)).statusInt() == 503) {
                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, t);
                }
                Either attempted = either;
                return IO$.MODULE$.apply(() -> this.clusterWatchRequestStream$$anonfun$3$$anonfun$1(attempted));
            }).rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)IO$.MODULE$.asyncForIO())).map(ClusterWatchService::js7$cluster$watch$ClusterWatchService$NodeServer$$_$clusterWatchRequestStream$$anonfun$4).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()), IO$.MODULE$.asyncForIO());
        }

        public IO<BoxedUnit> processRequest(ClusterWatchRequest request) {
            return this.$outer.clusterWatch().processRequest(request).flatMap((Function1 & Serializable)_$4 -> this.respond(request, (Either<Problem, ClusterWatch.Confirmed>)_$4));
        }

        private IO<BoxedUnit> respond(ClusterWatchRequest request, Either<Problem, ClusterWatch.Confirmed> confirmed) {
            return HttpClient$.MODULE$.liftProblem(this.nodeApi.retryIfSessionLost(this.nodeApi.executeClusterWatchingCommand(ClusterWatchingCommand$ClusterWatchConfirm$.MODULE$.apply(request.requestId(), this.$outer.clusterWatchId(), this.$outer.clusterWatchRunId(), (Option<String>)confirmed.toOption().flatMap(ClusterWatchService::js7$cluster$watch$ClusterWatchService$NodeServer$$_$respond$$anonfun$1), (Option<Problem>)confirmed.left().toOption())).void())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Problem problem = (Problem)left.value();
                    if (((Object)ClusterWatchProblems$ClusterWatchRequestDoesNotMatchProblem$.MODULE$).equals(problem)) {
                        Problem problem2 = problem;
                        Logger LoggerImpl_this = ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger;
                        if (LoggerImpl_this.underlying().isInfoEnabled()) {
                            LoggerImpl_this.underlying().info("\u2753{} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.nodeApi, problem2}), Object.class));
                            return;
                        }
                        return;
                    }
                    Problem problem3 = problem;
                    Logger LoggerImpl_this = ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("\u2753{} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.nodeApi, problem3}), Object.class));
                        return;
                    }
                    return;
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = right.value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        return;
                    }
                }
                throw new MatchError((Object)either);
            }).handleError((Function1)(JProcedure1 & Serializable)t -> {
                Logger LoggerImpl_this = ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    LoggerImpl_this.underlying().error(this.nodeApi + " " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable2));
                    return;
                }
            });
        }

        public final /* synthetic */ ClusterWatchService js7$cluster$watch$ClusterWatchService$NodeServer$$$outer() {
            return this.$outer;
        }

        private final Object clusterWatchRequestStream$$anonfun$1() {
            return this.nodeApi;
        }

        private final IO clusterWatchRequestStream$$anonfun$2() {
            return this.nodeApi.clusterWatchRequestStream(this.$outer.clusterWatchId(), (Option<FiniteDuration>)Some$.MODULE$.apply((Object)this.$outer.js7$cluster$watch$ClusterWatchService$$keepAlive), !PekkoHttpClient$.MODULE$.logHeartbeat());
        }

        private final Either clusterWatchRequestStream$$anonfun$3$$anonfun$1(Either attempted$1) {
            block0: {
                Logger LoggerImpl_this;
                if (!attempted$1.isRight() || !this.streamFailed.getAndSet(false) || !(LoggerImpl_this = ClusterWatchService$.js7$cluster$watch$ClusterWatchService$$$logger).underlying().isInfoEnabled()) break block0;
                LoggerImpl_this.underlying().info("\ud83d\udfe2 {} is being watched again", (Object)this.nodeApi);
            }
            return HttpClient$.MODULE$.attemptedToChecked(attempted$1);
        }
    }
}

