/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster.watch.api;

import cats.effect.IO;
import cats.effect.kernel.Resource;
import fs2.Chunk$;
import fs2.Stream;
import io.circe.Decoder;
import io.circe.Decoder$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.auth.Admission;
import js7.base.auth.UserAndPassword;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.exceptions.HasIsIgnorableStackTrace;
import js7.base.problem.Problem;
import js7.base.session.HasSessionToken;
import js7.base.session.SessionApi;
import js7.base.utils.AsyncLock;
import js7.base.web.HttpClient;
import js7.base.web.HttpClient$;
import js7.base.web.Uri;
import js7.cluster.watch.api.ClusterNodeUris;
import js7.cluster.watch.api.ClusterNodeUris$;
import js7.cluster.watch.api.HttpClusterNodeApi$;
import js7.cluster.watch.api.HttpClusterNodeApi$Standard$;
import js7.data.cluster.ClusterCommand;
import js7.data.cluster.ClusterCommand$;
import js7.data.cluster.ClusterCommand$Response$;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterNodeState;
import js7.data.cluster.ClusterNodeState$;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchRequest;
import js7.data.cluster.ClusterWatchRequest$;
import js7.data.cluster.ClusterWatchingCommand;
import js7.data.cluster.ClusterWatchingCommand$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.EventRequest;
import js7.data.event.JournalPosition;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.data.event.Stamped$;
import js7.data.session.HttpSessionApi;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.util.Either;

public interface HttpClusterNodeApi
extends ClusterNodeApi,
HttpSessionApi {
    public static String UriPrefixPath() {
        return HttpClusterNodeApi$.MODULE$.UriPrefixPath();
    }

    public static Resource<IO, HttpClusterNodeApi> resource(Admission admission, HttpClient httpClient, String string, Function0<Iterator<FiniteDuration>> function0) {
        return HttpClusterNodeApi$.MODULE$.resource(admission, httpClient, string, function0);
    }

    public static Function0<Iterator<FiniteDuration>> resource$default$4() {
        return HttpClusterNodeApi$.MODULE$.resource$default$4();
    }

    public static void $init$(HttpClusterNodeApi $this) {
    }

    @Override
    public HttpClient httpClient();

    public Uri baseUri();

    public Uri prefixedUri();

    public static Uri sessionUri$(HttpClusterNodeApi $this) {
        return $this.sessionUri();
    }

    @Override
    default public Uri sessionUri() {
        return this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().session();
    }

    public static ClusterNodeUris js7$cluster$watch$api$HttpClusterNodeApi$$uris$(HttpClusterNodeApi $this) {
        return $this.js7$cluster$watch$api$HttpClusterNodeApi$$uris();
    }

    default public ClusterNodeUris js7$cluster$watch$api$HttpClusterNodeApi$$uris() {
        return ClusterNodeUris$.MODULE$.apply(this.prefixedUri());
    }

    public static IO clusterState$(HttpClusterNodeApi $this) {
        return $this.clusterState();
    }

    @Override
    default public IO<Either<Problem, ClusterState>> clusterState() {
        HttpClient httpClient = this.httpClient();
        return HttpClient$.MODULE$.liftProblem(httpClient.get(this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().clusterState(), httpClient.get$default$2(), ClusterState$.MODULE$.jsonCodec(), this.implicitSessionToken()));
    }

    public static IO clusterNodeState$(HttpClusterNodeApi $this) {
        return $this.clusterNodeState();
    }

    @Override
    default public IO<ClusterNodeState> clusterNodeState() {
        HttpClient httpClient = this.httpClient();
        return httpClient.get(this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().clusterNodeState(), httpClient.get$default$2(), ClusterNodeState$.MODULE$.jsonCodec(), this.implicitSessionToken());
    }

    public static IO eventStream$(HttpClusterNodeApi $this, EventRequest request, Option heartbeat, Option idleTimeout, Decoder kd) {
        return $this.eventStream(request, (Option<FiniteDuration>)heartbeat, (Option<FiniteDuration>)idleTimeout, kd);
    }

    default public <E extends Event> IO<Stream<IO, Stamped<KeyedEvent<E>>>> eventStream(EventRequest<E> request, Option<FiniteDuration> heartbeat, Option<FiniteDuration> idleTimeout, Decoder<KeyedEvent<E>> kd) {
        HttpClient httpClient = this.httpClient();
        Uri uri = this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().events(request, heartbeat);
        Option<ByteArray> option = httpClient.getDecodedLinesStream$default$3();
        Object object = httpClient.getDecodedLinesStream$default$5();
        boolean bl = httpClient.getDecodedLinesStream$default$6();
        return this.retryIfSessionLost(httpClient.getDecodedLinesStream(uri, true, option, idleTimeout, object, bl, Stamped$.MODULE$.jsonDecoder(kd), this.implicitSessionToken()));
    }

    public static Option eventStream$default$2$(HttpClusterNodeApi $this) {
        return $this.eventStream$default$2();
    }

    default public <E extends Event> Option<FiniteDuration> eventStream$default$2() {
        return None$.MODULE$;
    }

    public static Option eventStream$default$3$(HttpClusterNodeApi $this) {
        return $this.eventStream$default$3();
    }

    default public <E extends Event> Option<FiniteDuration> eventStream$default$3() {
        return None$.MODULE$;
    }

    public static IO eventIdStream$(HttpClusterNodeApi $this, Option timeout, Option heartbeat, Option returnHeartbeatAs, boolean dontLog) {
        return $this.eventIdStream((Option<FiniteDuration>)timeout, (Option<FiniteDuration>)heartbeat, (Option<Object>)returnHeartbeatAs, dontLog);
    }

    @Override
    default public <E extends Event> IO<Stream<IO, Either<Problem, Object>>> eventIdStream(Option<FiniteDuration> timeout, Option<FiniteDuration> heartbeat, Option<Object> returnHeartbeatAs, boolean dontLog) {
        HttpClient httpClient = this.httpClient();
        Uri uri = this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().eventIds(timeout, heartbeat);
        Option option = returnHeartbeatAs.map((Function1 & Serializable)h -> ByteArray$.MODULE$.apply(BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)h)).toString()));
        Option<FiniteDuration> option2 = httpClient.getDecodedLinesStream$default$4();
        return this.retryIfSessionLost(httpClient.getDecodedLinesStream(uri, true, (Option<ByteArray>)option, option2, BoxesRunTime.boxToInteger((int)1000), dontLog, EventId$.MODULE$.given_Codec_Checked(), this.implicitSessionToken()).map((Function1 & Serializable)_$1 -> _$1.mapChunks((Function1 & Serializable)chunk -> Chunk$.MODULE$.fromOption(chunk.last()))));
    }

    public static Option eventIdStream$default$1$(HttpClusterNodeApi $this) {
        return $this.eventIdStream$default$1();
    }

    @Override
    default public <E extends Event> Option<FiniteDuration> eventIdStream$default$1() {
        return None$.MODULE$;
    }

    public static Option eventIdStream$default$2$(HttpClusterNodeApi $this) {
        return $this.eventIdStream$default$2();
    }

    @Override
    default public <E extends Event> Option<FiniteDuration> eventIdStream$default$2() {
        return None$.MODULE$;
    }

    public static Option eventIdStream$default$3$(HttpClusterNodeApi $this) {
        return $this.eventIdStream$default$3();
    }

    @Override
    default public <E extends Event> Option<Object> eventIdStream$default$3() {
        return None$.MODULE$;
    }

    public static boolean eventIdStream$default$4$(HttpClusterNodeApi $this) {
        return $this.eventIdStream$default$4();
    }

    @Override
    default public boolean eventIdStream$default$4() {
        return false;
    }

    public static IO journalStream$(HttpClusterNodeApi $this, JournalPosition journalPosition, Option heartbeat, Option returnHeartbeatAs, Option timeout, boolean markEOF, boolean returnAck) {
        return $this.journalStream(journalPosition, (Option<FiniteDuration>)heartbeat, (Option<ByteArray>)returnHeartbeatAs, (Option<FiniteDuration>)timeout, markEOF, returnAck);
    }

    @Override
    default public IO<Stream<IO, ByteArray>> journalStream(JournalPosition journalPosition, Option<FiniteDuration> heartbeat, Option<ByteArray> returnHeartbeatAs, Option<FiniteDuration> timeout, boolean markEOF, boolean returnAck) {
        HttpClient httpClient = this.httpClient();
        return httpClient.getRawLinesStream(this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().journal(journalPosition, heartbeat, timeout, markEOF, returnAck), returnHeartbeatAs, httpClient.getRawLinesStream$default$3(), httpClient.getRawLinesStream$default$4(), this.implicitSessionToken());
    }

    public static Option journalStream$default$2$(HttpClusterNodeApi $this) {
        return $this.journalStream$default$2();
    }

    @Override
    default public Option<FiniteDuration> journalStream$default$2() {
        return None$.MODULE$;
    }

    public static Option journalStream$default$3$(HttpClusterNodeApi $this) {
        return $this.journalStream$default$3();
    }

    @Override
    default public Option<ByteArray> journalStream$default$3() {
        return None$.MODULE$;
    }

    public static Option journalStream$default$4$(HttpClusterNodeApi $this) {
        return $this.journalStream$default$4();
    }

    @Override
    default public Option<FiniteDuration> journalStream$default$4() {
        return None$.MODULE$;
    }

    public static boolean journalStream$default$5$(HttpClusterNodeApi $this) {
        return $this.journalStream$default$5();
    }

    @Override
    default public boolean journalStream$default$5() {
        return false;
    }

    public static boolean journalStream$default$6$(HttpClusterNodeApi $this) {
        return $this.journalStream$default$6();
    }

    @Override
    default public boolean journalStream$default$6() {
        return false;
    }

    private IO<Stream<IO, Object>> journalLengthStream(JournalPosition journalPosition, FiniteDuration timeout, boolean markEOF) {
        return this.journalStream(journalPosition, this.journalStream$default$2(), this.journalStream$default$3(), (Option<FiniteDuration>)Some$.MODULE$.apply((Object)timeout), markEOF, true).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(_$3.utf8String()), "\n")))));
    }

    private boolean journalLengthStream$default$3() {
        return false;
    }

    public static IO clusterWatchRequestStream$(HttpClusterNodeApi $this, ClusterWatchId clusterWatchId, Option keepAlive, boolean dontLog) {
        return $this.clusterWatchRequestStream(clusterWatchId, (Option<FiniteDuration>)keepAlive, dontLog);
    }

    @Override
    default public IO<Stream<IO, ClusterWatchRequest>> clusterWatchRequestStream(ClusterWatchId clusterWatchId, Option<FiniteDuration> keepAlive, boolean dontLog) {
        HttpClient httpClient = this.httpClient();
        Uri uri = this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().clusterWatchMessages(clusterWatchId, keepAlive);
        Option<ByteArray> option = httpClient.getDecodedLinesStream$default$3();
        Option<FiniteDuration> option2 = httpClient.getDecodedLinesStream$default$4();
        Object object = httpClient.getDecodedLinesStream$default$5();
        return this.retryIfSessionLost(httpClient.getDecodedLinesStream(uri, true, option, option2, object, dontLog, ClusterWatchRequest$.MODULE$.jsonCodec(), this.implicitSessionToken()));
    }

    public static boolean clusterWatchRequestStream$default$3$(HttpClusterNodeApi $this) {
        return $this.clusterWatchRequestStream$default$3();
    }

    @Override
    default public boolean clusterWatchRequestStream$default$3() {
        return false;
    }

    public static IO executeClusterCommand$(HttpClusterNodeApi $this, ClusterCommand cmd) {
        return $this.executeClusterCommand(cmd);
    }

    @Override
    default public IO<ClusterCommand.Response> executeClusterCommand(ClusterCommand cmd) {
        HttpClient httpClient = this.httpClient();
        return httpClient.post(this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().command(), cmd, httpClient.post$default$3(), ClusterCommand$.MODULE$.jsonCodec(), ClusterCommand$Response$.MODULE$.ResponseJsonCodec(), this.implicitSessionToken()).map((Function1 & Serializable)_$4 -> _$4);
    }

    public static IO executeClusterWatchingCommand$(HttpClusterNodeApi $this, ClusterWatchingCommand cmd) {
        return $this.executeClusterWatchingCommand(cmd);
    }

    default public IO<BoxedUnit> executeClusterWatchingCommand(ClusterWatchingCommand cmd) {
        HttpClient httpClient = this.httpClient();
        return httpClient.post(this.js7$cluster$watch$api$HttpClusterNodeApi$$uris().command(), cmd, httpClient.post$default$3(), ClusterWatchingCommand$.MODULE$.jsonCodec(), Decoder$.MODULE$.decodeUnit(), this.implicitSessionToken());
    }

    public static String toString$(HttpClusterNodeApi $this) {
        return $this.toString();
    }

    default public String toString() {
        return "HttpClusterNodeApi(" + this.prefixedUri() + ")";
    }

    public static final class Standard
    implements SessionApi,
    SessionApi.LoginUntilReachable,
    SessionApi.HasUserAndPassword,
    HasIsIgnorableStackTrace,
    HasSessionToken,
    HttpSessionApi,
    HttpClusterNodeApi {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Standard.class.getDeclaredField("js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1"));
        private AsyncLock js7$base$session$SessionApi$$tryLogoutLock;
        private AsyncLock js7$data$session$HttpSessionApi$$lock;
        private AtomicReference js7$data$session$HttpSessionApi$$sessionTokenRef;
        private volatile Object js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1;
        private final HttpClient httpClient;
        private final Function0<Iterator<FiniteDuration>> loginDelays;
        private final Uri baseUri;
        private final Uri prefixedUri;
        private final Option<UserAndPassword> userAndPassword;

        public static Function0<Iterator<FiniteDuration>> $lessinit$greater$default$4() {
            return HttpClusterNodeApi$Standard$.MODULE$.$lessinit$greater$default$4();
        }

        public Standard(Admission admission, HttpClient httpClient, String uriPrefix, Function0<Iterator<FiniteDuration>> loginDelays) {
            this.httpClient = httpClient;
            this.loginDelays = loginDelays;
            SessionApi.$init$(this);
            SessionApi.HasUserAndPassword.$init$(this);
            HttpSessionApi.$init$(this);
            HttpClusterNodeApi.$init$(this);
            this.baseUri = admission.uri();
            this.prefixedUri = admission.uri().$div(uriPrefix);
            this.userAndPassword = admission.userAndPassword();
            Statics.releaseFence();
        }

        @Override
        public AsyncLock js7$base$session$SessionApi$$tryLogoutLock() {
            return this.js7$base$session$SessionApi$$tryLogoutLock;
        }

        @Override
        public void js7$base$session$SessionApi$_setter_$js7$base$session$SessionApi$$tryLogoutLock_$eq(AsyncLock x$0) {
            this.js7$base$session$SessionApi$$tryLogoutLock = x$0;
        }

        @Override
        public void js7$base$session$SessionApi$HasUserAndPassword$_setter_$loginDelays_$eq(Function0 x$0) {
        }

        @Override
        public AsyncLock js7$data$session$HttpSessionApi$$lock() {
            return this.js7$data$session$HttpSessionApi$$lock;
        }

        public AtomicReference js7$data$session$HttpSessionApi$$sessionTokenRef() {
            return this.js7$data$session$HttpSessionApi$$sessionTokenRef;
        }

        @Override
        public void js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$lock_$eq(AsyncLock x$0) {
            this.js7$data$session$HttpSessionApi$$lock = x$0;
        }

        @Override
        public void js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$sessionTokenRef_$eq(AtomicReference x$0) {
            this.js7$data$session$HttpSessionApi$$sessionTokenRef = x$0;
        }

        @Override
        public ClusterNodeUris js7$cluster$watch$api$HttpClusterNodeApi$$uris() {
            Object object = this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1;
            if (object instanceof ClusterNodeUris) {
                return (ClusterNodeUris)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ClusterNodeUris)this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzyINIT1();
        }

        private Object js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ClusterNodeUris clusterNodeUris = null;
                        try {
                            clusterNodeUris = HttpClusterNodeApi.js7$cluster$watch$api$HttpClusterNodeApi$$uris$(this);
                            object2 = clusterNodeUris == null ? LazyVals.NullValue$.MODULE$ : clusterNodeUris;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return clusterNodeUris;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public HttpClient httpClient() {
            return this.httpClient;
        }

        @Override
        public Function0<Iterator<FiniteDuration>> loginDelays() {
            return this.loginDelays;
        }

        @Override
        public Uri baseUri() {
            return this.baseUri;
        }

        @Override
        public Uri prefixedUri() {
            return this.prefixedUri;
        }

        @Override
        public Option<UserAndPassword> userAndPassword() {
            return this.userAndPassword;
        }
    }
}

