/*
 * Decompiled with CFR 0.152.
 */
package js7.common.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import js7.common.concurrent.ParallelismCounter$;
import scala.Function0;
import scala.Function1;
import scala.Option;

public final class ParallelismCounter {
    private final AtomicInteger inParallel = new AtomicInteger();
    private volatile int _maximum = 0;
    private volatile int _total = 0;
    private final Object lock = new Object();

    public static <A> A expect(int n, Function1<ParallelismCounter, A> function1) {
        return ParallelismCounter$.MODULE$.expect(n, function1);
    }

    public static <A> A expect(int n, int n2, Function1<ParallelismCounter, A> function1) {
        return ParallelismCounter$.MODULE$.expect(n, n2, function1);
    }

    public static <A> A expect(Option<Object> option, Option<Object> option2, Function1<ParallelismCounter, A> function1) {
        return ParallelismCounter$.MODULE$.expect(option, option2, function1);
    }

    public <A> A apply(Function0<A> body) {
        this.begin();
        Object result = body.apply();
        this.end();
        return (A)result;
    }

    private void begin() {
        Object object = this.lock;
        synchronized (object) {
            int i = this.inParallel.incrementAndGet();
            this._maximum = Math.max(this._maximum, i);
            ++this._total;
        }
    }

    private void end() {
        this.inParallel.decrementAndGet();
    }

    public int maximum() {
        return this._maximum;
    }

    public int total() {
        return this._total;
    }
}

