/*
 * Decompiled with CFR 0.152.
 */
package js7.common.files;

import cats.effect.IO;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import js7.base.data.ByteSequence;
import js7.common.files.ByteSeqFileReader$;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;

public final class ByteSeqFileReader<ByteSeq>
implements AutoCloseable {
    private final Path file;
    private final ByteSequence<ByteSeq> ByteSeq;
    private final FileChannel channel;
    private final ByteBuffer buffer;

    public static int ChunkSize() {
        return ByteSeqFileReader$.MODULE$.ChunkSize();
    }

    public static Stream<IO, Object> fileStream(Path path) {
        return ByteSeqFileReader$.MODULE$.fileStream(path);
    }

    public static Stream<IO, Object> fileStream(Path path, Option<FiniteDuration> option, boolean bl) {
        return ByteSeqFileReader$.MODULE$.fileStream(path, option, bl);
    }

    public static Stream<IO, Object> growingFileStream(Path path, FiniteDuration finiteDuration, boolean bl) {
        return ByteSeqFileReader$.MODULE$.growingFileStream(path, finiteDuration, bl);
    }

    public static <ByteSeq> boolean $lessinit$greater$default$2() {
        return ByteSeqFileReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean fileStream$default$3() {
        return ByteSeqFileReader$.MODULE$.fileStream$default$3();
    }

    public static boolean growingFileStream$default$3() {
        return ByteSeqFileReader$.MODULE$.growingFileStream$default$3();
    }

    public ByteSeqFileReader(Path file, boolean fromEnd, ByteSequence<ByteSeq> ByteSeq) {
        this.file = file;
        this.ByteSeq = ByteSeq;
        this.channel = FileChannel.open(file, StandardOpenOption.READ);
        this.buffer = ByteBuffer.allocate(ByteSeqFileReader$.MODULE$.ChunkSize());
        Logger LoggerImpl_this = ByteSeqFileReader$.js7$common$files$ByteSeqFileReader$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u2198 opened {} \u2198", (Object)file);
        }
        if (fromEnd) {
            this.channel.position(this.channel.size());
        }
    }

    @Override
    public void close() {
        Logger LoggerImpl_this = ByteSeqFileReader$.js7$common$files$ByteSeqFileReader$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u2199 close {} \u2199", (Object)this.file);
        }
        this.channel.close();
    }

    public ByteSeq read() {
        this.buffer.clear();
        int n = this.channel.read(this.buffer);
        if (-1 == n) {
            return (ByteSeq)this.ByteSeq.empty();
        }
        this.buffer.flip();
        return this.ByteSeq.readByteBuffer(this.buffer);
    }
}

