/*
 * Decompiled with CFR 0.152.
 */
package js7.common.files;

import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import js7.base.utils.AutoClosing$;
import js7.common.files.DirectoryReader;
import js7.common.files.DirectoryReader$Entry$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;

public final class DirectoryReader$
implements Serializable {
    private static final int NestingLimit;
    public static final DirectoryReader$Entry$ Entry;
    public static final DirectoryReader$ MODULE$;

    private DirectoryReader$() {
    }

    static {
        MODULE$ = new DirectoryReader$();
        NestingLimit = 100;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DirectoryReader$.class);
    }

    public Seq<Path> files(Path directory, Function1<Path, Object> filter) {
        return (Seq)this.entries(directory, filter).map((Function1 & Serializable)_$2 -> _$2.file());
    }

    public Function1<Path, Object> files$default$2() {
        return (Function1 & Serializable)_$1 -> true;
    }

    public Seq<DirectoryReader.Entry> entries(Path directory, Function1<Path, Object> filter) {
        Object[] array = this.unorderedEntryArray(directory, filter);
        Arrays.parallelSort(array, DirectoryReader$Entry$.MODULE$.comparator());
        return Predef$.MODULE$.wrapRefArray(array).toVector();
    }

    public Function1<Path, Object> entries$default$2() {
        return (Function1 & Serializable)_$3 -> true;
    }

    private DirectoryReader.Entry[] unorderedEntryArray(Path directory, Function1<Path, Object> filter) {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(DirectoryReader.Entry.class));
        this.deepForEachPathAndAttributes(directory, p -> BoxesRunTime.unboxToBoolean((Object)filter.apply(p)), NestingLimit, (Function1<DirectoryReader.Entry, BoxedUnit>)(JProcedure1 & Serializable)entry -> builder.$plus$eq(entry));
        return (DirectoryReader.Entry[])builder.result();
    }

    private void deepForEachPathAndAttributes(Path rootDirectory, DirectoryStream.Filter<Path> filter, int nestingLimit, Function1<DirectoryReader.Entry, BoxedUnit> callback) {
        this.nest$1(filter, callback, rootDirectory, nestingLimit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean fileIsTouched(BasicFileAttributes a, BasicFileAttributes b) {
        if (a.isDirectory() != b.isDirectory()) return true;
        if (a.isRegularFile() != b.isRegularFile()) return true;
        if (a.isSymbolicLink() != b.isSymbolicLink()) return true;
        if (a.isOther() != b.isOther()) return true;
        FileTime fileTime = a.creationTime();
        FileTime fileTime2 = b.creationTime();
        if (fileTime == null) {
            if (fileTime2 != null) {
                return true;
            }
        } else if (!((Object)fileTime).equals(fileTime2)) return true;
        FileTime fileTime3 = a.lastModifiedTime();
        FileTime fileTime4 = b.lastModifiedTime();
        if (fileTime3 == null) {
            if (fileTime4 != null) {
                return true;
            }
        } else if (!((Object)fileTime3).equals(fileTime4)) return true;
        if (a.size() != b.size()) return true;
        if (BoxesRunTime.equals((Object)a.fileKey(), (Object)b.fileKey())) return false;
        return true;
    }

    private final void nest$1(DirectoryStream.Filter filter$2, Function1 callback$1, Path dir, int nestingLimit) {
        AutoClosing$.MODULE$.autoClosing(Files.newDirectoryStream(dir, filter$2), (JProcedure1 & Serializable)_$4 -> _$4.forEach(path -> {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (attr.isDirectory()) {
                if (nestingLimit <= 0) {
                    throw new RuntimeException("Directory hierarchy is nested too deeply: " + dir);
                }
                this.nest$1(filter$2, callback$1, (Path)path, nestingLimit - 1);
                return;
            }
            if (!path.startsWith(dir)) {
                throw package$.MODULE$.error("File path '" + path + "' does not start with '" + dir + "' ?");
            }
            callback$1.apply((Object)DirectoryReader$Entry$.MODULE$.apply((Path)path, attr));
        }));
    }
}

