/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkohttp.web.data;

import cats.data.Validated;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import js7.base.io.https.KeyStoreRef;
import js7.base.io.https.StoreRef;
import js7.base.io.https.TrustStoreRef;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.utils.Assertions$;
import js7.base.utils.CatsUtils$;
import js7.base.utils.CatsUtils$RichProblemValidated$;
import js7.base.web.Uri;
import js7.common.http.PekkoHttpUtils$;
import js7.common.http.PekkoHttpUtils$RichPekkoAsUri$;
import js7.common.internet.IP$;
import js7.common.pekkohttp.web.data.WebServerBinding$;
import js7.common.pekkohttp.web.data.WebServerBinding$Http$;
import js7.common.pekkohttp.web.data.WebServerBinding$Https$;
import js7.common.pekkohttp.web.data.WebServerPort;
import js7.common.pekkohttp.web.data.WebServerPort$Http$;
import js7.common.pekkohttp.web.data.WebServerPort$Https$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public interface WebServerBinding {
    public static Http http(int n) {
        return WebServerBinding$.MODULE$.http(n);
    }

    public static Http localhostHttp(int n) {
        return WebServerBinding$.MODULE$.localhostHttp(n);
    }

    public static int ordinal(WebServerBinding webServerBinding) {
        return WebServerBinding$.MODULE$.ordinal(webServerBinding);
    }

    public InetSocketAddress address();

    public Scheme scheme();

    public Seq<Path> requiredFiles();

    public WebServerPort toWebServerPort();

    public static String toString$(WebServerBinding $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.scheme() + "://" + package.show$.MODULE$.toShow((Object)this.address(), IP$.MODULE$.inetSocketAddressShow()).show();
    }

    public static interface HasLocalUris {
        public static void $init$(HasLocalUris $this) {
        }

        public Seq<WebServerPort> webServerPorts();

        public static Either localHttpUri$(HasLocalUris $this) {
            return $this.localHttpUri();
        }

        default public Either<Problem, Uri> localHttpUri() {
            return this.locallyUsableUri(WebServerBinding$Http$.MODULE$);
        }

        public static Either localHttpsUri$(HasLocalUris $this) {
            return $this.localHttpsUri();
        }

        default public Either<Problem, Uri> localHttpsUri() {
            return this.locallyUsableUri(WebServerBinding$Https$.MODULE$);
        }

        public static Uri localUri$(HasLocalUris $this) {
            return $this.localUri();
        }

        default public Uri localUri() {
            Either either = package.either$.MODULE$.catsSyntaxEither(this.localHttpUri());
            Validated validated = CatsUtils$.MODULE$.RichProblemValidated(EitherOps$.MODULE$.toValidated$extension(either).findValid(this::localUri$$anonfun$1, Problem$.MODULE$.problemSemigroup()));
            return (Uri)CatsUtils$RichProblemValidated$.MODULE$.orThrow$extension(validated);
        }

        private Either<Problem, Uri> locallyUsableUri(Scheme scheme) {
            Option option = Checked$.MODULE$.CheckedOption(this.webServerPorts().collectFirst((PartialFunction)new Serializable(scheme, this){
                private final Scheme scheme$1;
                private final /* synthetic */ HasLocalUris $outer;
                {
                    this.scheme$1 = scheme$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(WebServerPort x2) {
                    WebServerPort webServerPort;
                    WebServerPort o = webServerPort = x2;
                    Scheme scheme = o.scheme();
                    Scheme scheme2 = this.scheme$1;
                    return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null);
                }

                public final Object applyOrElse(WebServerPort x2, Function1 function1) {
                    WebServerPort webServerPort;
                    WebServerPort o = webServerPort = x2;
                    Scheme scheme = o.scheme();
                    Scheme scheme2 = this.scheme$1;
                    if (!(scheme != null ? !scheme.equals(scheme2) : scheme2 != null)) {
                        return this.$outer.js7$common$pekkohttp$web$data$WebServerBinding$HasLocalUris$$toLocallyUsableUri(this.scheme$1, o.address());
                    }
                    return function1.apply((Object)x2);
                }
            }));
            return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> this.locallyUsableUri$$anonfun$1(scheme)));
        }

        public static Uri js7$common$pekkohttp$web$data$WebServerBinding$HasLocalUris$$toLocallyUsableUri$(HasLocalUris $this, Scheme scheme, InetSocketAddress address) {
            return $this.js7$common$pekkohttp$web$data$WebServerBinding$HasLocalUris$$toLocallyUsableUri(scheme, address);
        }

        default public Uri js7$common$pekkohttp$web$data$WebServerBinding$HasLocalUris$$toLocallyUsableUri(Scheme scheme, InetSocketAddress address) {
            String o;
            String string;
            Scheme scheme2 = scheme;
            if (WebServerBinding$Http$.MODULE$.equals(scheme2)) {
                string = ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0.0.0.0", "127.0.0.1"}))).contains((Object)address.getAddress().getHostAddress()) ? "127.0.0.1" : address.getAddress().getHostAddress();
            } else if (WebServerBinding$Https$.MODULE$.equals(scheme2)) {
                Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1()), "InetAddress.getByName(\"localhost\").getHostAddress == \"127.0.0.1\""), FullName$.MODULE$.apply("js7.common.pekkohttp.web.data.WebServerBinding.HasLocalUris.localhost"), ScalaSourceLocation$.MODULE$.apply("WebServerBinding.scala", 105));
                string = "localhost";
            } else {
                throw new MatchError((Object)scheme2);
            }
            String localhost = string;
            String string2 = address.getAddress().getHostAddress();
            String string3 = "0.0.0.0".equals(string2) || "127.0.0.1".equals(string2) ? localhost : (o = string2);
            String host = string3;
            int port = address.getPort();
            return PekkoHttpUtils$RichPekkoAsUri$.MODULE$.asUri$extension(PekkoHttpUtils$.MODULE$.RichPekkoAsUri(Uri$.MODULE$.apply(scheme.name(), Uri.Authority$.MODULE$.apply(Uri.Host$.MODULE$.apply(host, Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), port, Uri.Authority$.MODULE$.$lessinit$greater$default$3()), Uri$.MODULE$.apply$default$3(), Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5())));
        }

        private Validated localUri$$anonfun$1() {
            Either either = package.either$.MODULE$.catsSyntaxEither(this.localHttpsUri());
            return EitherOps$.MODULE$.toValidated$extension(either);
        }

        private String locallyUsableUri$$anonfun$1$$anonfun$1(Scheme scheme$3) {
            return "No locally usable '" + scheme$3 + "' address: " + this.webServerPorts();
        }

        private Problem locallyUsableUri$$anonfun$1(Scheme scheme$2) {
            return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.locallyUsableUri$$anonfun$1$$anonfun$1(scheme$2)), Problem$.MODULE$.apply$default$2());
        }

        private boolean v$proxy1$1() {
            String string = InetAddress.getByName("localhost").getHostAddress();
            String string2 = "127.0.0.1";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
    }

    public static final class Http
    implements WebServerBinding,
    Product,
    Serializable {
        private final InetSocketAddress address;

        public static Http apply(InetSocketAddress inetSocketAddress) {
            return WebServerBinding$Http$.MODULE$.apply(inetSocketAddress);
        }

        public static Http fromProduct(Product product) {
            return WebServerBinding$Http$.MODULE$.fromProduct(product);
        }

        public static String name() {
            return WebServerBinding$Http$.MODULE$.name();
        }

        public static Http unapply(Http http) {
            return WebServerBinding$Http$.MODULE$.unapply(http);
        }

        public Http(InetSocketAddress address) {
            this.address = address;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1858646754, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Http http;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Http)) return false;
            Http http2 = http = (Http)object;
            InetSocketAddress inetSocketAddress = this.address();
            InetSocketAddress inetSocketAddress2 = http2.address();
            if (inetSocketAddress != null) {
                if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
                return true;
            }
            if (inetSocketAddress2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof Http;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Http";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public InetSocketAddress address() {
            return this.address;
        }

        @Override
        public Scheme scheme() {
            return WebServerBinding$Http$.MODULE$;
        }

        @Override
        public WebServerPort toWebServerPort() {
            return WebServerPort$Http$.MODULE$.apply(this.address());
        }

        @Override
        public Seq<Path> requiredFiles() {
            return package$.MODULE$.Nil();
        }

        public Http copy(InetSocketAddress address) {
            return new Http(address);
        }

        public InetSocketAddress copy$default$1() {
            return this.address();
        }

        public InetSocketAddress _1() {
            return this.address();
        }
    }

    public static final class Https
    implements WebServerBinding,
    Product,
    Serializable {
        private final InetSocketAddress address;
        private final KeyStoreRef keyStoreRef;
        private final Seq<TrustStoreRef> trustStoreRefs;

        public static Https apply(InetSocketAddress inetSocketAddress, KeyStoreRef keyStoreRef, Seq<TrustStoreRef> seq) {
            return WebServerBinding$Https$.MODULE$.apply(inetSocketAddress, keyStoreRef, seq);
        }

        public static Https fromProduct(Product product) {
            return WebServerBinding$Https$.MODULE$.fromProduct(product);
        }

        public static String name() {
            return WebServerBinding$Https$.MODULE$.name();
        }

        public static Https unapply(Https https) {
            return WebServerBinding$Https$.MODULE$.unapply(https);
        }

        public static Seq<TrustStoreRef> $lessinit$greater$default$3() {
            return WebServerBinding$Https$.MODULE$.$lessinit$greater$default$3();
        }

        public Https(InetSocketAddress address, KeyStoreRef keyStoreRef, Seq<TrustStoreRef> trustStoreRefs) {
            this.address = address;
            this.keyStoreRef = keyStoreRef;
            this.trustStoreRefs = trustStoreRefs;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1754312528, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Https https;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Https)) return false;
            Https https2 = https = (Https)object;
            InetSocketAddress inetSocketAddress = this.address();
            InetSocketAddress inetSocketAddress2 = https2.address();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            KeyStoreRef keyStoreRef = this.keyStoreRef();
            KeyStoreRef keyStoreRef2 = https2.keyStoreRef();
            if (keyStoreRef == null) {
                if (keyStoreRef2 != null) {
                    return false;
                }
            } else if (!((Object)keyStoreRef).equals(keyStoreRef2)) return false;
            Seq<TrustStoreRef> seq = this.trustStoreRefs();
            Seq<TrustStoreRef> seq2 = https2.trustStoreRefs();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Https;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Https";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "address";
                }
                case 1: {
                    return "keyStoreRef";
                }
                case 2: {
                    return "trustStoreRefs";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public InetSocketAddress address() {
            return this.address;
        }

        public KeyStoreRef keyStoreRef() {
            return this.keyStoreRef;
        }

        public Seq<TrustStoreRef> trustStoreRefs() {
            return this.trustStoreRefs;
        }

        @Override
        public Scheme scheme() {
            return WebServerBinding$Https$.MODULE$;
        }

        @Override
        public WebServerPort toWebServerPort() {
            return WebServerPort$Https$.MODULE$.apply(this.address());
        }

        @Override
        public Seq<Path> requiredFiles() {
            return (Seq)this.storeRefs().flatMap(WebServerBinding$::js7$common$pekkohttp$web$data$WebServerBinding$Https$$_$requiredFiles$$anonfun$1);
        }

        public Seq<StoreRef> storeRefs() {
            return (Seq)this.trustStoreRefs().$plus$colon((Object)this.keyStoreRef());
        }

        public Https copy(InetSocketAddress address, KeyStoreRef keyStoreRef, Seq<TrustStoreRef> trustStoreRefs) {
            return new Https(address, keyStoreRef, trustStoreRefs);
        }

        public InetSocketAddress copy$default$1() {
            return this.address();
        }

        public KeyStoreRef copy$default$2() {
            return this.keyStoreRef();
        }

        public Seq<TrustStoreRef> copy$default$3() {
            return this.trustStoreRefs();
        }

        public InetSocketAddress _1() {
            return this.address();
        }

        public KeyStoreRef _2() {
            return this.keyStoreRef();
        }

        public Seq<TrustStoreRef> _3() {
            return this.trustStoreRefs();
        }
    }

    public static interface Scheme {
        public String name();
    }
}

