/*
 * Decompiled with CFR 0.152.
 */
package js7.common.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.BindException;
import java.net.ServerSocket;
import js7.base.log.Logger$package$Logger$;
import js7.base.system.OperatingSystem$;
import js7.base.web.Uri;
import js7.base.web.Uri$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.process.ProcessLogger;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class FreeTcpPortFinder$
implements Serializable {
    private static final Logger logger;
    private static final Iterator<Object> freePortNumberIterator;
    public static final FreeTcpPortFinder$ MODULE$;

    private FreeTcpPortFinder$() {
    }

    static {
        int n;
        MODULE$ = new FreeTcpPortFinder$();
        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FreeTcpPortFinder$.class));
        if (OperatingSystem$.MODULE$.isMac()) {
            try {
                StringBuilder output = new StringBuilder();
                ProcessLogger processLogger = new ProcessLogger(output){
                    private final StringBuilder output$1;
                    {
                        this.output$1 = output$2;
                    }

                    public void out(Function0 s) {
                        this.output$1.append((String)s.apply());
                    }

                    public void err(Function0 s) {
                    }

                    public Object buffer(Function0 f) {
                        return f.apply();
                    }
                };
                scala.sys.process.package$.MODULE$.stringToProcess("sysctl -n net.inet.ip.portrange.first").$bang(processLogger);
                n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(output.toString()), (Function1 & Serializable)_$1 -> this.$init$$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)))));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    Logger LoggerImpl_this = logger;
                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                        LoggerImpl_this.underlying().error("firstEphemeralPort => " + t, t);
                    }
                    n = Short.MAX_VALUE;
                }
                throw throwable;
            }
        } else {
            n = Short.MAX_VALUE;
        }
        int firstEphemeralPort = n;
        Range.Inclusive availablePorts = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(20000), firstEphemeralPort - 1);
        int requiredPortCount = 1000;
        int first = availablePorts.head() + package$.MODULE$.abs(Random$.MODULE$.nextInt(availablePorts.length() - requiredPortCount));
        freePortNumberIterator = scala.package$.MODULE$.Iterator().range(first, availablePorts.last()).filter((Function1)(JFunction1.mcZI.sp & Serializable)port -> this.portIsFree(port));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FreeTcpPortFinder$.class);
    }

    public Uri findFreeLocalUri() {
        return (Uri)Uri$.MODULE$.apply("http://localhost:" + this.findFreeTcpPort());
    }

    public int findFreeTcpPort() {
        return BoxesRunTime.unboxToInt((Object)this.findFreeTcpPorts(1).head());
    }

    public List<Object> findFreeTcpPorts(int n) {
        List list;
        Iterator<Object> iterator = freePortNumberIterator;
        synchronized (iterator) {
            List result = freePortNumberIterator.take(n).toList();
            if (result.length() != n) {
                throw scala.sys.package$.MODULE$.error("Not enough free tcp ports available");
            }
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("findFreeTcpPort => " + result.mkString(", "));
            }
            list = result;
        }
        return list;
    }

    private boolean portIsFree(int port) {
        boolean bl;
        try {
            new ServerSocket(port, 1).close();
            bl = true;
        }
        catch (BindException bindException) {
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("findFreeTcpPort => {} is unavailable", (Object)BoxesRunTime.boxToInteger((int)port));
            }
            bl = false;
        }
        return bl;
    }

    private final /* synthetic */ boolean $init$$$anonfun$1(char _$1) {
        return _$1 != '\n';
    }
}

