/*
 * Decompiled with CFR 0.152.
 */
package js7.core.license;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.system.ServiceProviders$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.license.LicenseCheck;
import js7.license.LicenseCheckContext;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;

public final class LicenseChecker {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LicenseChecker.class.getDeclaredField("licenseChecks$lzy1"));
    private final LicenseCheckContext licenseCheckContext;
    private final Logger logger;
    private volatile Object licenseChecks$lzy1;

    public LicenseChecker(LicenseCheckContext licenseCheckContext) {
        this.licenseCheckContext = licenseCheckContext;
        this.logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(LicenseChecker.class));
    }

    private Seq<LicenseCheck> licenseChecks() {
        Object object = this.licenseChecks$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.licenseChecks$lzyINIT1();
    }

    private Object licenseChecks$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.licenseChecks$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Seq seq = null;
                    Seq seq2 = null;
                    try {
                        seq2 = ServiceProviders$.MODULE$.findServices((JProcedure2 & Serializable)(logLine, maybeService) -> {
                            Logger LoggerImpl_this = this.logger;
                            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                                LoggerImpl_this.underlying().debug((String)logLine.apply());
                            }
                            maybeService.foreach((Function1)(JProcedure1 & Serializable)service -> service.initialize(this.licenseCheckContext));
                        }, ClassTag$.MODULE$.apply(LicenseCheck.class));
                        seq = seq2 == null ? LazyVals.NullValue$.MODULE$ : seq2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, seq)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.licenseChecks$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, seq);
                            waiting.countDown();
                        }
                    }
                    return seq2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Either<Problem, BoxedUnit> checkLicense(String productName) {
        Left left;
        try {
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.hasLicense(this.licenseChecks(), productName));
            left = ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, () -> LicenseChecker.checkLicense$$anonfun$1(productName));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger LoggerImpl_this = this.logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    LoggerImpl_this.underlying().error(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4), t);
                }
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.fromThrowable(t));
            }
            throw throwable;
        }
        return left;
    }

    public boolean hasLicense(Seq<LicenseCheck> licenseChecks, String productName) {
        return ((IterableOnceOps)licenseChecks.view().dropWhile((Function1 & Serializable)o -> {
            boolean hasLicense = o.hasLicense(productName);
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{} hasLicense({}) => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{o.getClass().getName(), productName, BoxesRunTime.boxToBoolean((boolean)hasLicense)}), Object.class));
            }
            return !hasLicense;
        })).nonEmpty();
    }

    private static final String left$proxy1$1$$anonfun$1(String productName$2) {
        return "No license for " + productName$2;
    }

    private static final Problem left$proxy1$1(String productName$1) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> LicenseChecker.left$proxy1$1$$anonfun$1(productName$1)), Problem$.MODULE$.apply$default$2());
    }

    private static final Problem checkLicense$$anonfun$1(String productName$4) {
        return LicenseChecker.left$proxy1$1(productName$4);
    }
}

