/*
 * Decompiled with CFR 0.152.
 */
package js7.data.event;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.utils.Assertions$;
import js7.base.utils.ScalaUtils$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.Tests$;
import js7.data.event.Event;
import js7.data.event.EventCalc;
import js7.data.event.EventColl$;
import js7.data.event.EventDrivenState;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.NoKeyEvent;
import js7.data.event.TimestampedKeyedEvent$;
import scala.;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public final class EventColl<S extends EventDrivenState<S, E>, E extends Event, Ctx>
implements Product,
Serializable {
    private final S originalAggregate_;
    private final Vector<Object> timestampedKeyedEvents;
    private final S aggregate;
    private final Ctx context;

    public static <S extends EventDrivenState<S, E>, E extends Event> EventColl<S, E, BoxedUnit> apply(S s) {
        return EventColl$.MODULE$.apply(s);
    }

    public static <S extends EventDrivenState<S, E>, E extends Event, Ctx> EventColl<S, E, Ctx> apply(S s, Ctx Ctx) {
        return EventColl$.MODULE$.apply(s, Ctx);
    }

    public static <S extends EventDrivenState<S, E>, E extends Event, Ctx> Either<Problem, Vector<KeyedEvent<E>>> checkEvents(S s, Ctx Ctx, IterableOnce<KeyedEvent<E>> iterableOnce) {
        return EventColl$.MODULE$.checkEvents(s, Ctx, iterableOnce);
    }

    public static EventColl<?, ?, ?> fromProduct(Product product) {
        return EventColl$.MODULE$.fromProduct(product);
    }

    public static <S extends EventDrivenState<S, E>, E extends Event, Ctx> EventColl<S, E, Ctx> unapply(EventColl<S, E, Ctx> eventColl) {
        return EventColl$.MODULE$.unapply(eventColl);
    }

    public EventColl(S originalAggregate_, Vector<Object> timestampedKeyedEvents, S aggregate, Ctx context) {
        this.originalAggregate_ = originalAggregate_;
        this.timestampedKeyedEvents = timestampedKeyedEvents;
        this.aggregate = aggregate;
        this.context = context;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 2074948409, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        EventColl eventColl;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof EventColl)) return false;
        EventColl eventColl2 = eventColl = (EventColl)object;
        S s = this.originalAggregate_();
        S s2 = eventColl2.originalAggregate_();
        if (s == null) {
            if (s2 != null) {
                return false;
            }
        } else if (!s.equals(s2)) return false;
        Vector<Object> vector = this.timestampedKeyedEvents();
        Vector<Object> vector2 = eventColl2.timestampedKeyedEvents();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        S s3 = this.aggregate();
        S s4 = eventColl2.aggregate();
        if (s3 == null) {
            if (s4 != null) {
                return false;
            }
        } else if (!s3.equals(s4)) return false;
        if (!BoxesRunTime.equals(this.context(), eventColl2.context())) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof EventColl;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "EventColl";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "originalAggregate_";
            }
            case 1: {
                return "timestampedKeyedEvents";
            }
            case 2: {
                return "aggregate";
            }
            case 3: {
                return "context";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    private S originalAggregate_() {
        return this.originalAggregate_;
    }

    public Vector<Object> timestampedKeyedEvents() {
        return this.timestampedKeyedEvents;
    }

    public S aggregate() {
        return this.aggregate;
    }

    public Ctx context() {
        return this.context;
    }

    public <E1 extends E> Either<Problem, EventColl<S, E, Ctx>> addEvent(Object keyedEvent) {
        return this.aggregate().applyKeyedEvent(TimestampedKeyedEvent$.MODULE$.keyedEvent(keyedEvent)).map((Function1 & Serializable)updated -> this.update((Seq<Object>)package$.MODULE$.Nil().$colon$colon(keyedEvent), updated));
    }

    public Either<Problem, EventColl<S, E, Ctx>> addChecked(Either<Problem, IterableOnce<Object>> keyedEvents2) {
        return keyedEvents2.flatMap((Function1 & Serializable)keyedEvents -> this.addEvents((IterableOnce<Object>)keyedEvents));
    }

    public <K, E1 extends E> Either<Problem, EventColl<S, E, Ctx>> addWithKey(K key, Iterable<E1> events, Event.KeyCompanion<? super E1> E1, .eq.colon.eq<K, Object> ev) {
        return this.addEvents((IterableOnce<Object>)((IterableOnce)events.view().map((Function1 & Serializable)event -> KeyedEvent$.MODULE$.any(key, (Event)event))));
    }

    public <E1 extends E> Either<Problem, EventColl<S, E, Ctx>> addNoKey(Iterable<E1> events, .less.colon.less<E1, NoKeyEvent> x$2) {
        return this.addEvents((IterableOnce<Object>)((IterableOnce)events.view().map((Function1 & Serializable)event -> KeyedEvent$.MODULE$.any(KeyedEvent$NoKey$.MODULE$, (Event)event))));
    }

    public Either<Problem, EventColl<S, E, Ctx>> addEvents(IterableOnce<Object> keyedEvents) {
        Seq<Object> eventSeq = ScalaUtils$syntax$.MODULE$.toEagerSeq(keyedEvents);
        if (eventSeq.isEmpty()) {
            return package$.MODULE$.Right().apply((Object)this);
        }
        return this.aggregate().applyKeyedEvents(eventSeq.view().map((Function1 & Serializable)_$1 -> TimestampedKeyedEvent$.MODULE$.keyedEvent(_$1))).map((Function1 & Serializable)updated -> {
            Vector vector = (Vector)this.timestampedKeyedEvents().$plus$plus((IterableOnce)eventSeq);
            S s = this.copy$default$1();
            Ctx Ctx = this.copy$default$4();
            return this.copy(s, (Vector<Object>)vector, (S)updated, Ctx);
        });
    }

    public <E1 extends E, Ctx1> Either<Problem, EventColl<S, E, Ctx>> addEventCalc(EventCalc<S, E1, Ctx1> eventCalc) {
        EventCalc<S, E1, Ctx1> EventCalc_this;
        EventCalc<S, E1, Ctx1> EventCalc_this2 = EventCalc_this = eventCalc;
        EventColl<S, E, Ctx> eventColl$proxy1 = this.forward();
        EventCalc<S, E1, Ctx1> EventCalc_this3 = EventCalc_this2;
        return ((Either)EventCalc_this3.inline$function().apply(eventColl$proxy1)).flatMap((Function1 & Serializable)other -> this.addColl((EventColl<S, E, Ctx>)other));
    }

    public Either<Problem, EventColl<S, E, Ctx>> addColl(EventColl<S, E, Ctx> other) {
        EventColl<S, E, Ctx> EventColl_this;
        if (super.originalAggregate_() != this.aggregate()) {
            Problem problem = Problem$.MODULE$.pure("EventColl.addColl: coll.originalAggregate doesn't match aggregate");
            Logger LoggerImpl_this = EventColl$.js7$data$event$EventColl$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("EventColl.addColl: coll.originalAggregate doesn't match aggregate", (Throwable)new Exception(problem.toString()));
            }
            this.aggregate().emitLineStream((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)o -> {
                Logger LoggerImpl_this = EventColl$.js7$data$event$EventColl$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("aggregate={}", o);
                    return;
                }
            });
            super.originalAggregate_().emitLineStream((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)o -> {
                Logger LoggerImpl_this = EventColl$.js7$data$event$EventColl$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("other.originalAggregate={}", o);
                    return;
                }
            });
            other.aggregate().emitLineStream((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)o -> {
                Logger LoggerImpl_this = EventColl$.js7$data$event$EventColl$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("other.aggregate={}", o);
                    return;
                }
            });
            return package$.MODULE$.Left().apply((Object)problem);
        }
        return package$.MODULE$.Right().apply((Object)(!(EventColl_this = other).timestampedKeyedEvents().nonEmpty() ? this : (!this.timestampedKeyedEvents().nonEmpty() ? other : super.update((Seq<Object>)other.timestampedKeyedEvents(), other.aggregate()))));
    }

    public <A> Either<Problem, EventColl<S, E, Ctx>> iterate(IterableOnce<A> iterable, Function2<EventColl<S, E, Ctx>, A, Either<Problem, EventColl<S, E, Ctx>>> toColl) {
        EventColl coll = this;
        Iterator it = iterable.iterator();
        while (it.hasNext()) {
            Either either = (Either)toColl.apply((Object)coll, it.next());
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return package$.MODULE$.Left().apply((Object)problem);
            }
            if (either instanceof Right) {
                EventColl o;
                Right right = (Right)either;
                coll = o = (EventColl)right.value();
                continue;
            }
            throw new MatchError((Object)either);
        }
        return package$.MODULE$.Right().apply((Object)coll);
    }

    private EventColl<S, E, Ctx> update(Seq<Object> keyedEvents, S updatedAggregate) {
        if (keyedEvents.isEmpty()) {
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1((EventDrivenState)updatedAggregate)), "updatedAggregate eq aggregate"), FullName$.MODULE$.apply("js7.data.event.EventColl.update"), ScalaSourceLocation$.MODULE$.apply("EventColl.scala", 128));
            return this;
        }
        if (Tests$.MODULE$.isIntelliJIdea()) {
            // empty if block
        }
        Vector vector = (Vector)this.timestampedKeyedEvents().$plus$plus(keyedEvents);
        S s = this.copy$default$1();
        Ctx Ctx = this.copy$default$4();
        return this.copy(s, (Vector<Object>)vector, updatedAggregate, Ctx);
    }

    public void foreachLog(Function1<String, BoxedUnit> body) {
        Vector<KeyedEvent<E>> vector = this.keyedEvents();
        ScalaUtils$syntax$.MODULE$.foreachWithBracket(vector, ScalaUtils$syntax$.MODULE$.foreachWithBracket$default$2(vector), (Function2 & Serializable)(v1, v2) -> {
            body.apply((Object)("" + BoxesRunTime.unboxToChar((Object)v2) + (KeyedEvent)v1).trim());
            return BoxedUnit.UNIT;
        });
    }

    public Vector<KeyedEvent<E>> keyedEvents() {
        return (Vector)this.timestampedKeyedEvents().map((Function1 & Serializable)_$2 -> TimestampedKeyedEvent$.MODULE$.keyedEvent(_$2));
    }

    public EventColl<S, E, Ctx> forward() {
        return EventColl$.MODULE$.apply(this.aggregate(), this.context());
    }

    public <S1 extends EventDrivenState<S1, E>> Option<EventColl<S1, E, Ctx>> ifIs(ClassTag<S1> x$1) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(ScalaUtils$.MODULE$.implicitClass(x$1).isAssignableFrom(this.aggregate().getClass()));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, this::ifIs$$anonfun$1);
    }

    public <S1 extends EventDrivenState<S1, ? super E1>, E1 extends Event, Ctx1 extends Ctx> EventColl<S1, E1, Ctx> widen() {
        return this;
    }

    public String toString() {
        return "EventColl[" + this.aggregate().companion().name() + "](" + this.timestampedKeyedEvents().size() + " events)";
    }

    private <S extends EventDrivenState<S, E>, E extends Event, Ctx> EventColl<S, E, Ctx> copy(S originalAggregate_, Vector<Object> timestampedKeyedEvents, S aggregate, Ctx context) {
        return new EventColl<S, E, Ctx>(originalAggregate_, timestampedKeyedEvents, aggregate, context);
    }

    private <S extends EventDrivenState<S, E>, E extends Event, Ctx> S copy$default$1() {
        return this.originalAggregate_();
    }

    private <S extends EventDrivenState<S, E>, E extends Event, Ctx> Vector<Object> copy$default$2() {
        return this.timestampedKeyedEvents();
    }

    private <S extends EventDrivenState<S, E>, E extends Event, Ctx> S copy$default$3() {
        return this.aggregate();
    }

    private <S extends EventDrivenState<S, E>, E extends Event, Ctx> Ctx copy$default$4() {
        return this.context();
    }

    public S _1() {
        return this.originalAggregate_();
    }

    public Vector<Object> _2() {
        return this.timestampedKeyedEvents();
    }

    public S _3() {
        return this.aggregate();
    }

    public Ctx _4() {
        return this.context();
    }

    public final S inline$originalAggregate_() {
        return this.originalAggregate_();
    }

    private final boolean v$proxy1$1(EventDrivenState updatedAggregate$1) {
        return updatedAggregate$1 == this.aggregate();
    }

    private final EventColl a$proxy1$1() {
        return this;
    }

    private final EventColl ifIs$$anonfun$1() {
        return this.a$proxy1$1();
    }
}

