/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow;

import cats.Applicative;
import cats.FlatMap;
import cats.Traverse;
import cats.UnorderedFoldable$;
import cats.instances.package;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.utils.Assertions$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichOrNull$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.base.utils.typeclasses.IsEmpty$;
import js7.base.utils.typeclasses.IsEmpty$syntax$;
import js7.data.Problems$CancelStartedOrderProblem$;
import js7.data.Problems$GoOrderInapplicableProblem$;
import js7.data.agent.AgentPath;
import js7.data.command.CancellationMode;
import js7.data.command.CancellationMode$FreshOnly$;
import js7.data.command.SuspensionMode;
import js7.data.controller.ControllerState;
import js7.data.controller.ControllerStatePlanFunctions;
import js7.data.event.Event;
import js7.data.event.EventColl;
import js7.data.event.EventColl$;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$;
import js7.data.event.KeyedEvent$package$;
import js7.data.execution.workflow.OrderEventSource$;
import js7.data.execution.workflow.instructions.InstructionExecutorService;
import js7.data.item.VersionedItemId;
import js7.data.order.Order;
import js7.data.order.Order$;
import js7.data.order.Order$Cancelled$;
import js7.data.order.Order$Failed$;
import js7.data.order.Order$FailedInFork$;
import js7.data.order.Order$ProcessingKilled$;
import js7.data.order.Order$Stopped$;
import js7.data.order.Order$StoppedWhileFresh$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$OrderBroken$;
import js7.data.order.OrderEvent$OrderCancellationMarked$;
import js7.data.order.OrderEvent$OrderCancelled$;
import js7.data.order.OrderEvent$OrderCaught$;
import js7.data.order.OrderEvent$OrderDeleted$;
import js7.data.order.OrderEvent$OrderDeletionMarked$;
import js7.data.order.OrderEvent$OrderDetachable$;
import js7.data.order.OrderEvent$OrderFailed$;
import js7.data.order.OrderEvent$OrderFailedInFork$;
import js7.data.order.OrderEvent$OrderFailedIntermediate_$;
import js7.data.order.OrderEvent$OrderGoMarked$;
import js7.data.order.OrderEvent$OrderMoved$;
import js7.data.order.OrderEvent$OrderMoved$SkippedDueToWorkflowPathControl$;
import js7.data.order.OrderEvent$OrderOutcomeAdded$;
import js7.data.order.OrderEvent$OrderPromptAnswered$;
import js7.data.order.OrderEvent$OrderResumed$;
import js7.data.order.OrderEvent$OrderResumptionMarked$;
import js7.data.order.OrderEvent$OrderStopped$;
import js7.data.order.OrderEvent$OrderSuspended$;
import js7.data.order.OrderEvent$OrderSuspensionMarked$;
import js7.data.order.OrderId;
import js7.data.order.OrderMark;
import js7.data.order.OrderMark$Cancelling$;
import js7.data.order.OrderMark$Go$;
import js7.data.order.OrderMark$Resuming$;
import js7.data.order.OrderMark$Suspending$;
import js7.data.order.OrderOutcome;
import js7.data.order.OrderOutcome$Disrupted$;
import js7.data.problems.package$CannotResumeOrderProblem$;
import js7.data.problems.package$CannotSuspendOrderProblem$;
import js7.data.problems.package$UnreachableOrderPositionProblem$;
import js7.data.source.SourcePos;
import js7.data.state.StateView;
import js7.data.state.StateViewForEvents$;
import js7.data.workflow.Instruction;
import js7.data.workflow.Workflow;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.WorkflowPathControlPath$;
import js7.data.workflow.instructions.End;
import js7.data.workflow.instructions.Finish$;
import js7.data.workflow.instructions.ForkInstruction;
import js7.data.workflow.instructions.Gap$;
import js7.data.workflow.instructions.Options;
import js7.data.workflow.instructions.Options$;
import js7.data.workflow.position.BranchId;
import js7.data.workflow.position.BranchId$IsFailureBoundary$;
import js7.data.workflow.position.Position;
import js7.data.workflow.position.TryBranchId$;
import js7.data.workflow.position.WorkflowPosition;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class OrderEventSource {
    private final StateView state;
    private final InstructionExecutorService executorService;
    private Map<OrderId, Order<Order.State>> idToOrder;

    public static Either<Problem, List<OrderEvent.OrderActorEvent>> leaveBlocks(Workflow workflow, Order<Order.State> order, Function1<Option<BranchId>, List<OrderEvent.OrderActorEvent>> function1, Function1<BranchId, Object> function12) {
        return OrderEventSource$.MODULE$.leaveBlocks(workflow, order, function1, function12);
    }

    public static Either<Problem, List<OrderEvent.OrderActorEvent>> leaveBlocks(Workflow workflow, Order<Order.State> order, List<OrderEvent.OrderActorEvent> list) {
        return OrderEventSource$.MODULE$.leaveBlocks(workflow, order, list);
    }

    public OrderEventSource(StateView state, InstructionExecutorService executorService) {
        this.state = state;
        this.executorService = executorService;
        this.idToOrder = state.idToOrder();
    }

    public Seq<KeyedEvent<Object>> nextEvents(OrderId orderId) {
        return (Seq)this.idToOrder.get((Object)orderId).fold(OrderEventSource::nextEvents$$anonfun$1, (Function1 & Serializable)order -> {
            if (!this.state.weHave((Order<Order.State>)order)) {
                return package$.MODULE$.Nil();
            }
            return (Seq)IsEmpty$syntax$.MODULE$.ifEmpty(IsEmpty$syntax$.MODULE$.ifEmpty(this.maybeOrderDeleted((Order<Order.State>)order), IsEmpty$.MODULE$.inline$erasedIterableIsEmpty(), () -> this.nextEvents$$anonfun$2$$anonfun$1(order)), IsEmpty$.MODULE$.inline$erasedIterableIsEmpty(), () -> this.nextEvents$$anonfun$2$$anonfun$2(order));
        });
    }

    private Either<Problem, Seq<KeyedEvent<OrderEvent.OrderActorEvent>>> checkedNextEvents(Order<Order.State> order) {
        if (order.shouldFail()) {
            boolean bl = OrderEventSource$.MODULE$.js7$data$execution$workflow$OrderEventSource$$$isUncatchable(order.lastOutcome());
            Option<OrderOutcome.NotSucceeded> option = this.fail$default$2();
            return this.fail(order, option, bl).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)_$3 -> {
                OrderEvent.OrderActorEvent Event_this = _$3;
                return new KeyedEvent<OrderEvent.OrderActorEvent>(Event_this, order.id());
            }));
        }
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.checkedNextEvents$$anonfun$2(order));
    }

    private Either<Problem, BoxedUnit> updateIdToOrder(IterableOnce<KeyedEvent<OrderEvent.OrderActorEvent>> keyedEvents) {
        Iterator it = keyedEvents.iterator();
        if (!it.hasNext()) {
            return Checked$.MODULE$.unit();
        }
        Map map = (Map)ScalaUtils$syntax$.MODULE$.RichOrNull(this.idToOrder);
        return ScalaUtils$syntax$RichOrNull$.MODULE$.checkedCast$extension(map, ClassTag$.MODULE$.apply(Map.class)).flatMap((Function1 & Serializable)idToOrder_ -> {
            Map iToO = idToOrder_;
            Problem problem = null;
            while (it.hasNext() && problem == null) {
                KeyedEvent keyedEvent = (KeyedEvent)it.next();
                Tuple2 tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
                OrderId orderId = (OrderId)tuple2._1();
                OrderEvent.OrderActorEvent event = (OrderEvent.OrderActorEvent)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)orderId, (Object)event);
                OrderId orderId2 = (OrderId)tuple22._1();
                OrderEvent.OrderActorEvent event2 = (OrderEvent.OrderActorEvent)tuple22._2();
                MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(iToO);
                Either either = ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId2, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("OrderEventSource.scala"), Line$.MODULE$.apply(123)).flatMap((Function1 & Serializable)_$10 -> _$10.applyEvent(event2));
                if (either instanceof Left) {
                    Problem prblm;
                    Left left = (Left)either;
                    problem = prblm = (Problem)left.value();
                    continue;
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Order order = (Order)right.value();
                    iToO = (Map)iToO.updated((Object)order.id(), (Object)order);
                    continue;
                }
                throw new MatchError((Object)either);
            }
            this.idToOrder = iToO;
            return ScalaUtils$syntax$.MODULE$.toChecked(problem);
        });
    }

    private Either<Problem, Seq<KeyedEvent<OrderEvent.OrderActorEvent>>> checkEvents(Seq<KeyedEvent<OrderEvent.OrderActorEvent>> keyedEvents) {
        ObjectRef id2o = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef problem = ObjectRef.create((Object)None$.MODULE$);
        keyedEvents.withFilter((Function1 & Serializable)x$1 -> {
            KeyedEvent keyedEvent = x$1;
            Tuple2 tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
            OrderId orderId = (OrderId)tuple2._1();
            OrderEvent.OrderActorEvent event = (OrderEvent.OrderActorEvent)tuple2._2();
            return ((Option)problem$1.elem).isEmpty();
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            KeyedEvent keyedEvent = x$1;
            Tuple2 tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
            OrderId orderId = (OrderId)tuple2._1();
            OrderEvent.OrderActorEvent event = (OrderEvent.OrderActorEvent)tuple2._2();
            Either either = ((Either)((Map)id2o$1.elem).getOrElse((Object)orderId, () -> this.checkEvents$$anonfun$2$$anonfun$1(orderId))).flatMap((Function1 & Serializable)_$11 -> _$11.applyEvent(event));
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem prblm = (Problem)left.value();
                problem$2.elem = Some$.MODULE$.apply((Object)prblm);
                return;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Order order = (Order)right.value();
                OrderId orderId2 = (OrderId)Predef$.MODULE$.ArrowAssoc((Object)orderId);
                id2o$1.elem = (Map)((Map)id2o$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)orderId2, (Object)package$.MODULE$.Right().apply((Object)order)));
                return;
            }
            throw new MatchError((Object)either);
        });
        return ((Option)problem.elem).toLeft(() -> OrderEventSource.checkEvents$$anonfun$3(keyedEvents));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Seq<KeyedEvent<OrderEvent.OrderActorEvent>> invalidToEvent(Order<Order.State> order, Problem problem) {
        List list;
        if (order.isFailable()) {
            Either<Problem, List<OrderEvent.OrderActorEvent>> either = this.fail(order, (Option<OrderOutcome.NotSucceeded>)Some$.MODULE$.apply((Object)OrderOutcome$Disrupted$.MODULE$.apply(problem)), this.fail$default$3());
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem prblm = (Problem)left.value();
                Logger LoggerImpl_this = OrderEventSource$.js7$data$execution$workflow$OrderEventSource$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("WARN {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{order.id(), prblm}), Object.class));
                }
                OrderEvent.OrderOutcomeAdded orderOutcomeAdded = OrderEvent$OrderOutcomeAdded$.MODULE$.apply(OrderOutcome$Disrupted$.MODULE$.apply(problem));
                OrderEvent.OrderBroken orderBroken = OrderEvent$OrderBroken$.MODULE$.apply();
                list = ScalaUtils$syntax$RichBoolean$.MODULE$.thenList$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(order.isDetachable()), OrderEventSource::$anonfun$1).$colon$colon((Object)orderBroken).$colon$colon((Object)orderOutcomeAdded);
            } else {
                List events;
                if (!(either instanceof Right)) throw new MatchError(either);
                Right right = (Right)either;
                list = events = (List)right.value();
            }
        } else {
            OrderEvent.OrderOutcomeAdded orderOutcomeAdded = OrderEvent$OrderOutcomeAdded$.MODULE$.apply(OrderOutcome$Disrupted$.MODULE$.apply(problem));
            OrderEvent.OrderBroken orderBroken = OrderEvent$OrderBroken$.MODULE$.apply();
            list = package$.MODULE$.Nil().$colon$colon((Object)orderBroken).$colon$colon((Object)orderOutcomeAdded);
        }
        List events = list;
        return events.map((Function1 & Serializable)_$12 -> {
            OrderEvent.OrderActorEvent Event_this = _$12;
            return new KeyedEvent<OrderEvent.OrderActorEvent>(Event_this, order.id());
        });
    }

    public Either<Problem, List<OrderEvent.OrderActorEvent>> fail(Order<Order.State> order, Option<OrderOutcome.NotSucceeded> outcome, boolean uncatchable) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.state.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> this.fail((Workflow)workflow, order, outcome, uncatchable || outcome.exists((Function1 & Serializable)outcome -> OrderEventSource$.MODULE$.js7$data$execution$workflow$OrderEventSource$$$isUncatchable((OrderOutcome)outcome))));
    }

    public Option<OrderOutcome.NotSucceeded> fail$default$2() {
        return None$.MODULE$;
    }

    public boolean fail$default$3() {
        return false;
    }

    public Either<Problem, List<OrderEvent.OrderActorEvent>> fail(Workflow workflow, Order<Order.State> order, Option<OrderOutcome.NotSucceeded> outcome, boolean uncatchable) {
        List outcomeAdded = outcome.map((Function1 & Serializable)_$13 -> OrderEvent$OrderOutcomeAdded$.MODULE$.apply((OrderOutcome)_$13)).toList();
        if (this.isStopOnFailure(workflow, order.position())) {
            return package$.MODULE$.Right().apply((Object)this.js7$data$execution$workflow$OrderEventSource$$atController(OrderEventSource::fail$$anonfun$2).$colon$colon$colon(outcomeAdded));
        }
        return this.failAndLeave(workflow, order, uncatchable).map((Function1 & Serializable)events -> (List)events.$plus$plus$colon((IterableOnce)outcomeAdded));
    }

    private boolean isStopOnFailure(Workflow workflow, Position position) {
        Option<Position> option;
        while (true) {
            Position parent;
            Instruction instruction;
            if ((instruction = workflow.instruction(position)) instanceof Options) {
                Options options = (Options)instruction;
                Options options2 = Options$.MODULE$.unapply(options);
                Option<Object> option2 = options2._1();
                Workflow workflow2 = options2._2();
                Option<SourcePos> option3 = options2._3();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    boolean stopOnFailure = BoxesRunTime.unboxToBoolean((Object)some.value());
                    return stopOnFailure;
                }
            }
            if (!((option = position.parent()) instanceof Some)) break;
            Some some = (Some)option;
            position = parent = (Position)some.value();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    private Either<Problem, List<OrderEvent.OrderActorEvent>> failAndLeave(Workflow workflow, Order<Order.State> order, boolean uncatchable) {
        return OrderEventSource$.MODULE$.js7$data$execution$workflow$OrderEventSource$$$leaveBlocksThen(workflow, order, !uncatchable, OrderEventSource$.MODULE$.js7$data$execution$workflow$OrderEventSource$$$leaveBlocksThen$default$4(), (PartialFunction<Tuple2<Option<BranchId>, Position>, List<OrderEvent.OrderActorEvent>>)new Serializable(order, this){
            private final Order order$13;
            private final /* synthetic */ OrderEventSource $outer;
            {
                this.order$13 = order$47;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x2) {
                Some some;
                Option<Object> option;
                Position position;
                Option option2;
                block5: {
                    block4: {
                        Some some2;
                        Option<BranchId> option3;
                        Tuple2 tuple2 = x2;
                        option2 = (Option)tuple2._1();
                        position = (Position)tuple2._2();
                        if (None$.MODULE$.equals(option2)) break block4;
                        if (!(option2 instanceof Some) || (option3 = BranchId$IsFailureBoundary$.MODULE$.unapply((BranchId)(some2 = (Some)option2).value())).isEmpty()) break block5;
                        BranchId branchId = (BranchId)option3.get();
                    }
                    Position failPosition = position;
                    return true;
                }
                if (option2 instanceof Some && !(option = TryBranchId$.MODULE$.unapply((BranchId)(some = (Some)option2).value())).isEmpty()) {
                    int n = BoxesRunTime.unboxToInt((Object)option.get());
                    Position catchPos = position;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x2, Function1 function1) {
                Some some;
                Option<Object> option;
                Position position;
                Option option2;
                block5: {
                    block4: {
                        Some some2;
                        Option<BranchId> option3;
                        Tuple2 tuple2 = x2;
                        option2 = (Option)tuple2._1();
                        position = (Position)tuple2._2();
                        if (None$.MODULE$.equals(option2)) break block4;
                        if (!(option2 instanceof Some) || (option3 = BranchId$IsFailureBoundary$.MODULE$.unapply((BranchId)(some2 = (Some)option2).value())).isEmpty()) break block5;
                        BranchId branchId = (BranchId)option3.get();
                    }
                    Position failPosition = position;
                    return this.$outer.js7$data$execution$workflow$OrderEventSource$$atController(() -> this.applyOrElse$$anonfun$1(failPosition));
                }
                if (option2 instanceof Some && !(option = TryBranchId$.MODULE$.unapply((BranchId)(some = (Some)option2).value())).isEmpty()) {
                    int n = BoxesRunTime.unboxToInt((Object)option.get());
                    Position catchPos = position;
                    OrderEvent.OrderCaught orderCaught = OrderEvent$OrderCaught$.MODULE$.apply(catchPos);
                    return package$.MODULE$.Nil().$colon$colon((Object)orderCaught);
                }
                return function1.apply((Object)x2);
            }

            private final List applyOrElse$$anonfun$1(Position failPosition$1) {
                boolean joinIfFailed = BoxesRunTime.unboxToBoolean((Object)this.order$13.parent().flatMap((Function1 & Serializable)forkOrderId -> this.$outer.js7$data$execution$workflow$OrderEventSource$$instruction_((OrderId)forkOrderId, ClassTag$.MODULE$.apply(ForkInstruction.class)).toOption()).fold(OrderEventSource::js7$data$execution$workflow$OrderEventSource$$anon$1$$_$_$$anonfun$4, OrderEventSource::js7$data$execution$workflow$OrderEventSource$$anon$1$$_$_$$anonfun$5));
                if (joinIfFailed) {
                    OrderEvent.OrderFailedInFork orderFailedInFork = OrderEvent$OrderFailedInFork$.MODULE$.apply(failPosition$1);
                    return package$.MODULE$.Nil().$colon$colon((Object)orderFailedInFork);
                }
                OrderEvent.OrderFailed orderFailed = OrderEvent$OrderFailed$.MODULE$.apply(failPosition$1);
                return package$.MODULE$.Nil().$colon$colon((Object)orderFailed);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(js7.data.workflow.position.Position ), $anonfun$3(js7.data.order.OrderId ), js7$data$execution$workflow$OrderEventSource$$anon$1$$_$_$$anonfun$4(), js7$data$execution$workflow$OrderEventSource$$anon$1$$_$_$$anonfun$5(js7.data.workflow.instructions.ForkInstruction )}, serializedLambda);
            }
        });
    }

    private Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> joinedEvents(Order<Order.State> order) {
        if (order.parent().isDefined() && order.isDetachedOrAttached() && (order.isState(ClassTag$.MODULE$.apply(Order$FailedInFork$.class)) || order.isState(ClassTag$.MODULE$.apply(Order$Cancelled$.class)))) {
            return order.forkPosition().flatMap((Function1 & Serializable)forkPosition -> {
                VersionedItemId<WorkflowPath> versionedItemId = order.workflowId();
                return this.state.instruction_(forkPosition.$div$colon(versionedItemId), ClassTag$.MODULE$.apply(ForkInstruction.class)).flatMap((Function1 & Serializable)fork -> this.executorService.onReturnFromSubworkflow((Instruction)fork, order, this.state));
            });
        }
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
    }

    private List<Serializable> awokeEvent(Order<Order.State> order2) {
        return (List)order2.ifState(ClassTag$.MODULE$.apply(Order.IsDelayingRetry.class)).flatMap((Function1 & Serializable)order -> {
            Either<Problem, List<Serializable>> either = Order$.MODULE$.awokeEventsIfRipe((Order<Order.IsDelayingRetry>)order, this.executorService.clock().now());
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                Logger LoggerImpl_this = OrderEventSource$.js7$data$execution$workflow$OrderEventSource$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("awokeEvent: {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{order.id(), problem}), Object.class));
                }
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                List events = (List)right.value();
                return Some$.MODULE$.apply((Object)events);
            }
            throw new MatchError(either);
        }).getOrElse(OrderEventSource::awokeEvent$$anonfun$2);
    }

    public Either<Problem, Seq<KeyedEvent<Object>>> orderDeletionEvent(Order<Order.State> order) {
        Vector<KeyedEvent<Serializable>> events = this.maybeOrderDeleted(order.copy(order.copy$default$1(), order.copy$default$2(), order.copy$default$3(), order.copy$default$4(), order.copy$default$5(), order.copy$default$6(), order.copy$default$7(), order.copy$default$8(), order.copy$default$9(), order.copy$default$10(), order.copy$default$11(), order.copy$default$12(), order.copy$default$13(), order.copy$default$14(), true, order.copy$default$16(), order.copy$default$17(), order.copy$default$18(), order.copy$default$19()));
        if (events.nonEmpty()) {
            return package$.MODULE$.Right().apply(events);
        }
        return order.markDeletion().map((Function1 & Serializable)event -> {
            OrderEvent$OrderDeletionMarked$ Event_this = event;
            KeyedEvent<OrderEvent$OrderDeletionMarked$> keyedEvent = new KeyedEvent<OrderEvent$OrderDeletionMarked$>(Event_this, order.id());
            return package$.MODULE$.Nil().$colon$colon(keyedEvent);
        });
    }

    private Vector<KeyedEvent<Serializable>> maybeOrderDeleted(Order<Order.State> order) {
        return (Vector)order.maybeDeleted().fold(OrderEventSource::maybeOrderDeleted$$anonfun$1, (Function1 & Serializable)orderDeleted -> {
            StateView stateView = this.state;
            if (stateView instanceof ControllerState) {
                ControllerState controllerState;
                ControllerState controllerState2 = controllerState = (ControllerState)stateView;
                Function1 & Serializable body$proxy1 = (Function1 & Serializable)coll2 -> {
                    EventColl EventColl_this = coll2;
                    OrderEvent$OrderDeleted$ Event_this = orderDeleted;
                    KeyedEvent<OrderEvent$OrderDeleted$> keyedEvent$proxy1 = new KeyedEvent<OrderEvent$OrderDeleted$>(Event_this, order.id());
                    return EventColl_this.addEvent(keyedEvent$proxy1).flatMap((Function1 & Serializable)coll -> coll.addChecked(((ControllerStatePlanFunctions)coll.aggregate()).maybePlanFinished(order.planId(), this.executorService.clock().now())));
                };
                Either either = Checked$.MODULE$.Ops(EventColl$.MODULE$.keyedEvents(controllerState2, body$proxy1));
                return (Vector)Checked$Ops$.MODULE$.onProblemHandle$extension(either, (Function1 & Serializable)problem -> {
                    block0: {
                        Logger LoggerImpl_this = OrderEventSource$.js7$data$execution$workflow$OrderEventSource$$$logger;
                        if (!LoggerImpl_this.underlying().isErrorEnabled()) break block0;
                        LoggerImpl_this.underlying().error("maybeOrderDeleted: {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{order.id(), problem}), Object.class));
                    }
                    return package$.MODULE$.Vector().empty();
                });
            }
            return package$.MODULE$.Vector().empty();
        });
    }

    private List<KeyedEvent<OrderEvent.OrderActorEvent>> orderMarkKeyedEvent(Order<Order.State> order) {
        return this.orderMarkEvent(order).map((Function1 & Serializable)_$15 -> {
            OrderEvent.OrderActorEvent Event_this = _$15;
            return new KeyedEvent<OrderEvent.OrderActorEvent>(Event_this, order.id());
        });
    }

    private List<OrderEvent.OrderActorEvent> orderMarkEvent(Order<Order.State> order) {
        return order.mark().toList().flatMap((Function1 & Serializable)x$1 -> {
            OrderMark orderMark = x$1;
            if (orderMark instanceof OrderMark.Cancelling) {
                CancellationMode cancellationMode;
                OrderMark.Cancelling cancelling = (OrderMark.Cancelling)orderMark;
                OrderMark.Cancelling cancelling2 = OrderMark$Cancelling$.MODULE$.unapply(cancelling);
                CancellationMode mode = cancellationMode = cancelling2._1();
                return this.tryCancel(order, mode);
            }
            if (orderMark instanceof OrderMark.Suspending) {
                SuspensionMode suspensionMode;
                OrderMark.Suspending suspending = (OrderMark.Suspending)orderMark;
                OrderMark.Suspending suspending2 = OrderMark$Suspending$.MODULE$.unapply(suspending);
                SuspensionMode mode = suspensionMode = suspending2._1();
                return this.trySuspendNow(order, mode);
            }
            if (orderMark instanceof OrderMark.Resuming) {
                OrderMark.Resuming resuming = (OrderMark.Resuming)orderMark;
                OrderMark.Resuming resuming2 = OrderMark$Resuming$.MODULE$.unapply(resuming);
                Option<Position> option = resuming2._1();
                Seq<OrderEvent.OrderResumed.HistoryOperation> seq = resuming2._2();
                boolean bl = resuming2._3();
                boolean bl2 = resuming2._4();
                Option<Position> position = option;
                Seq<OrderEvent.OrderResumed.HistoryOperation> historyOperations = seq;
                boolean asSucceeded = bl;
                boolean restartKilledJob = bl2;
                return this.tryResume(order, position, historyOperations, asSucceeded, restartKilledJob).toList();
            }
            if (orderMark instanceof OrderMark.Go) {
                OrderMark.Go go = (OrderMark.Go)orderMark;
                OrderMark.Go go2 = OrderMark$Go$.MODULE$.unapply(go);
                Position position = go2._1();
                return package$.MODULE$.Nil();
            }
            throw new MatchError((Object)orderMark);
        });
    }

    public Either<Problem, List<OrderEvent.OrderActorEvent>> markOrder(OrderId orderId, OrderMark mark) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.markOrder$$anonfun$1(mark, orderId));
    }

    public Either<Problem, List<OrderEvent.OrderActorEvent>> cancel(OrderId orderId, CancellationMode mode) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.cancel$$anonfun$1(orderId, mode));
    }

    private List<OrderEvent.OrderActorEvent> tryCancel(Order<Order.State> order, CancellationMode mode) {
        if (this.isOrderCancelable(order, mode)) {
            return this.js7$data$execution$workflow$OrderEventSource$$atController(() -> this.tryCancel$$anonfun$1(order));
        }
        return package$.MODULE$.Nil();
    }

    private boolean isOrderCancelable(Order<Order.State> order, CancellationMode mode) {
        return this.state.weHave(order) && order.isCancelable(mode) && (!order.isStarted() || !(this.instruction(order.workflowPosition()) instanceof End) || this.state.isSuspendedOrStopped(order) || order.isState(ClassTag$.MODULE$.apply(Order.Broken.class)));
    }

    public Either<Problem, List<Object>> suspend(OrderId orderId, SuspensionMode mode) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.suspend$$anonfun$1(orderId, mode));
    }

    private List<Mirror.Singleton> trySuspendNow(Order<Order.State> order, SuspensionMode mode) {
        Nil$ maybeReset;
        Nil$ nil$ = maybeReset = mode.resetState() ? order.resetState() : package$.MODULE$.Nil();
        if (this.state.weHave(order) && order.isDetachedOrDetachable() && order.applyEvents((Iterable<OrderEvent.OrderCoreEvent>)maybeReset).exists((Function1 & Serializable)_$16 -> _$16.isSuspendibleNow())) {
            return this.js7$data$execution$workflow$OrderEventSource$$atController(() -> OrderEventSource.trySuspendNow$$anonfun$2((List)maybeReset));
        }
        return package$.MODULE$.Nil();
    }

    public Either<Problem, List<OrderEvent.OrderActorEvent>> go(OrderId orderId, Position position) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.idToOrder);
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("OrderEventSource.scala"), Line$.MODULE$.apply(371)).flatMap((Function1 & Serializable)order -> {
            if (!order.isGoCommandable(position)) {
                return package$.MODULE$.Left().apply((Object)Problems$GoOrderInapplicableProblem$.MODULE$.apply(order.id()));
            }
            if (this.state.weHave((Order<Order.State>)order)) {
                return order.go();
            }
            if (order.isAttached()) {
                OrderEvent.OrderGoMarked orderGoMarked = OrderEvent$OrderGoMarked$.MODULE$.apply(position);
                return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil().$colon$colon((Object)orderGoMarked));
            }
            return package$.MODULE$.Left().apply((Object)Problems$GoOrderInapplicableProblem$.MODULE$.apply(order.id()));
        });
    }

    public Either<Problem, List<Serializable>> resume(OrderId orderId, Option<Position> position, Seq<OrderEvent.OrderResumed.HistoryOperation> historyOperations, boolean asSucceeded, Option<Object> restartKilledJob) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.resume$$anonfun$1(orderId, position, historyOperations, restartKilledJob, asSucceeded));
    }

    private <E extends OrderEvent.OrderCoreEvent> Either<Problem, List<E>> withOrder(OrderId orderId, Function1<Order<Order.State>, Either<Problem, List<E>>> body) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.idToOrder);
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("OrderEventSource.scala"), Line$.MODULE$.apply(452)).flatMap((Function1 & Serializable)order -> ((Either)body.apply(order)).flatMap((Function1 & Serializable)events -> {
            Either either = ScalaUtils$syntax$.MODULE$.RichEither(order.applyEvents((Iterable<OrderEvent.OrderCoreEvent>)events));
            return ScalaUtils$syntax$RichEither$.MODULE$.rightAs$extension(either, () -> OrderEventSource.withOrder$$anonfun$1$$anonfun$1$$anonfun$1(events));
        }));
    }

    private Option<OrderEvent.OrderResumed> tryResume(Order<Order.State> order, Option<Position> position, Seq<OrderEvent.OrderResumed.HistoryOperation> historyOperations, boolean asSucceeded, boolean restartKilledJob) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.state.weHave(order) && order.isResumableNow());
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> OrderEventSource.tryResume$$anonfun$1(position, historyOperations, asSucceeded, restartKilledJob));
    }

    public Either<Problem, Seq<KeyedEvent<OrderEvent.OrderCoreEvent>>> answerPrompt(OrderId orderId) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.answerPrompt$$anonfun$1(orderId));
    }

    public Either<Problem, Option<AgentPath>> nextAgent(Order<Order.State> order) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.nextAgent$$anonfun$1(order));
    }

    private Either<Problem, List<OrderEvent.OrderMoved>> applyMoveInstructions(Order<Order.State> order, OrderEvent.OrderMoved orderMoved) {
        return this.applyMoveInstructions(order, (Option<OrderEvent.OrderMoved>)Some$.MODULE$.apply((Object)orderMoved)).map((Function1 & Serializable)_$23 -> _$23.toList());
    }

    public Either<Problem, Vector<OrderEvent.OrderMoved>> applyMoveInstructions(Order<Order.State> order2, Option<OrderEvent.OrderMoved> firstMove) {
        Option<OrderEvent.OrderMoved> option = firstMove;
        if (None$.MODULE$.equals(option)) {
            return this.loop$1(order2, package$.MODULE$.Vector().empty());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            OrderEvent.OrderMoved move = (OrderEvent.OrderMoved)some.value();
            return order2.applyEvent(move).flatMap((Function1 & Serializable)order -> this.loop$1((Order)order, (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OrderEvent.OrderMoved[]{move}))));
        }
        throw new MatchError(option);
    }

    public Option<OrderEvent.OrderMoved> applyMoveInstructions$default$2() {
        return None$.MODULE$;
    }

    private Either<Problem, Option<OrderEvent.OrderMoved>> nextMove(Order<Order.State> order) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.state.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> {
            if (workflow.isOrderAtStopPosition(order)) {
                return package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            Option<OrderEvent.OrderMoved> option = this.ifSkippedDueToWorkflowPathControlThenMove(order);
            if (option instanceof Some) {
                Some some = (Some)option;
                OrderEvent.OrderMoved orderMoved = (OrderEvent.OrderMoved)some.value();
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)orderMoved));
            }
            if (None$.MODULE$.equals(option)) {
                return this.executorService.nextMove(workflow.instruction(order.position()), order, this.state);
            }
            throw new MatchError(option);
        });
    }

    private Option<OrderEvent.OrderMoved> ifSkippedDueToWorkflowPathControlThenMove(Order<Order.State> order) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(order.isSkippable(this.executorService.clock().now()) && this.isSkippedDueToWorkflowPathControl(order));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> OrderEventSource.ifSkippedDueToWorkflowPathControlThenMove$$anonfun$1(order));
    }

    private boolean isSkippedDueToWorkflowPathControl(Order<Order.State> order) {
        return !order.isState(ClassTag$.MODULE$.apply(Order.BetweenCycles.class)) && this.state.pathToWorkflowPathControl().get((Object)WorkflowPathControlPath$.MODULE$.apply(order.workflowPath())).exists((Function1 & Serializable)control -> this.state.workflowPositionToLabel(order.workflowPosition()).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).exists((Function1 & Serializable)elem -> control.skip().contains(elem)));
    }

    public <A extends Instruction> Either<Problem, A> js7$data$execution$workflow$OrderEventSource$$instruction_(OrderId orderId, ClassTag<A> evidence$1) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.idToOrder);
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("OrderEventSource.scala"), Line$.MODULE$.apply(561)).flatMap((Function1 & Serializable)order -> this.instruction_(order.workflowPosition(), evidence$1));
    }

    private <A extends Instruction> Either<Problem, A> instruction_(WorkflowPosition workflowPosition, ClassTag<A> evidence$1) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.state.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> workflow.instruction_(workflowPosition.position(), evidence$1));
    }

    private Instruction instruction(WorkflowPosition workflowPosition) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.state.idToWorkflow());
        Either either = ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30)));
        if (either instanceof Left) {
            Left left = (Left)either;
            Logger LoggerImpl_this = OrderEventSource$.js7$data$execution$workflow$OrderEventSource$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("Missing {}", workflowPosition.workflowId());
            }
            return Gap$.MODULE$.empty();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Workflow workflow = (Workflow)right.value();
            return workflow.instruction(workflowPosition.position());
        }
        throw new MatchError(either);
    }

    public <E extends OrderEvent.OrderActorEvent> List<OrderEvent.OrderActorEvent> js7$data$execution$workflow$OrderEventSource$$atController(Function0<List<E>> events) {
        return StateViewForEvents$.MODULE$.atController(this.state, events);
    }

    private static final Seq nextEvents$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private final AbstractSeq nextEvents$$anonfun$2$$anonfun$1(Order order$1) {
        return this.orderMarkKeyedEvent(order$1);
    }

    private static final List nextEvents$$anonfun$2$$anonfun$2$$anonfun$1() {
        OrderEvent$OrderSuspended$ orderEvent$OrderSuspended$ = OrderEvent$OrderSuspended$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)orderEvent$OrderSuspended$);
    }

    private final Seq nextEvents$$anonfun$2$$anonfun$2(Order order$2) {
        if (order$2.isState(ClassTag$.MODULE$.apply(Order.Broken.class))) {
            return package$.MODULE$.Nil();
        }
        if (order$2.isSuspendedOrStopped()) {
            return package$.MODULE$.Nil();
        }
        if (this.state.isOrderAtBreakpoint(order$2)) {
            return this.js7$data$execution$workflow$OrderEventSource$$atController(OrderEventSource::nextEvents$$anonfun$2$$anonfun$2$$anonfun$1).map((Function1 & Serializable)_$1 -> {
                Mirror.Singleton Event_this = _$1;
                return new KeyedEvent<Event>((Event)Event_this, order$2.id());
            });
        }
        if (this.state.isWorkflowSuspended(order$2.workflowPath())) {
            return package$.MODULE$.Nil();
        }
        Either<Problem, Seq<KeyedEvent<OrderEvent.OrderActorEvent>>> either = this.checkedNextEvents(order$2);
        if (either instanceof Left) {
            Left left = (Left)either;
            Problem problem = (Problem)left.value();
            return this.invalidToEvent(order$2, problem);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq keyedEvents = (Seq)right.value();
            return keyedEvents;
        }
        throw new MatchError(either);
    }

    private final Either checkedNextEvents$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(List maybeLast$1, List first$1) {
        return ((Either)package.flatMap$.MODULE$.toFlatMapOps(package.traverse$.MODULE$.toTraverseOps((Object)maybeLast$1, (Traverse)package.list$.MODULE$.catsStdInstancesForList()).flatTraverse((Function1 & Serializable)x$1 -> {
            KeyedEvent keyedEvent = x$1;
            Tuple2 tuple2 = KeyedEvent$package$.MODULE$.$less$minus$colon().unapply(keyedEvent);
            OrderId orderId = (OrderId)tuple2._1();
            OrderEvent.OrderActorEvent orderActorEvent = (OrderEvent.OrderActorEvent)tuple2._2();
            OrderId orderId2 = orderId;
            if (orderActorEvent instanceof OrderEvent.OrderMoved) {
                OrderEvent.OrderMoved orderMoved;
                OrderEvent.OrderMoved moved = orderMoved = (OrderEvent.OrderMoved)orderActorEvent;
                return this.applyMoveInstructions((Order<Order.State>)((Order)this.idToOrder.apply((Object)orderId2)), moved).map((Function1 & Serializable)_$5 -> _$5.map((Function1 & Serializable)_$6 -> {
                    OrderEvent.OrderMoved Event_this = _$6;
                    return new KeyedEvent<OrderEvent.OrderMoved>(Event_this, orderId2);
                }));
            }
            OrderId orderId3 = orderId;
            if (orderActorEvent instanceof OrderEvent.OrderFailedIntermediate_) {
                Option<OrderOutcome.NotSucceeded> option;
                OrderEvent.OrderFailedIntermediate_ orderFailedIntermediate_ = (OrderEvent.OrderFailedIntermediate_)orderActorEvent;
                OrderEvent.OrderFailedIntermediate_ orderFailedIntermediate_2 = OrderEvent$OrderFailedIntermediate_$.MODULE$.unapply(orderFailedIntermediate_);
                Option<OrderOutcome.NotSucceeded> outcome = option = orderFailedIntermediate_2._1();
                return this.fail((Order)this.idToOrder.apply((Object)orderId3), outcome, this.fail$default$3()).map((Function1 & Serializable)_$7 -> _$7.map((Function1 & Serializable)_$8 -> {
                    OrderEvent.OrderActorEvent Event_this = _$8;
                    return new KeyedEvent<OrderEvent.OrderActorEvent>(Event_this, orderId3);
                }));
            }
            KeyedEvent o = keyedEvent;
            return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil().$colon$colon((Object)o));
        }, (Applicative)package.either$.MODULE$.catsStdInstancesForEither(), (FlatMap)package.list$.MODULE$.catsStdInstancesForList()), (FlatMap)package.either$.MODULE$.catsStdInstancesForEither()).flatTap((Function1 & Serializable)keyedEvents -> this.updateIdToOrder((IterableOnce<KeyedEvent<OrderEvent.OrderActorEvent>>)keyedEvents))).map((Function1 & Serializable)_$9 -> _$9.$colon$colon$colon(first$1));
    }

    private final Either checkedNextEvents$$anonfun$2$$anonfun$2(Order order$9) {
        return this.joinedEvents(order$9).flatMap((Function1 & Serializable)events2 -> {
            if (events2.nonEmpty()) {
                return package$.MODULE$.Right().apply(events2);
            }
            if (this.state.isOrderAtStopPosition(order$9)) {
                return this.executorService.finishExecutor().toEvents(Finish$.MODULE$.apply(Finish$.MODULE$.$lessinit$greater$default$1(), Finish$.MODULE$.$lessinit$greater$default$2()), (Order<Order.State>)order$9, this.state);
            }
            Option<OrderEvent.OrderMoved> option = this.ifSkippedDueToWorkflowPathControlThenMove(order$9);
            if (option instanceof Some) {
                OrderEvent.OrderMoved orderMoved;
                Some some = (Some)option;
                OrderEvent.OrderMoved Event_this = orderMoved = (OrderEvent.OrderMoved)some.value();
                KeyedEvent<OrderEvent.OrderMoved> keyedEvent = new KeyedEvent<OrderEvent.OrderMoved>(Event_this, order$9.id());
                return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil().$colon$colon(keyedEvent));
            }
            if (None$.MODULE$.equals(option)) {
                return this.executorService.toEvents(this.instruction(order$9.workflowPosition()), order$9, this.state).flatMap((Function1 & Serializable)events -> {
                    Tuple2 tuple2;
                    Tuple2 $1$;
                    Tuple2 tuple22 = $1$ = (tuple2 = events.splitAt(events.length() - 1));
                    List first = (List)tuple22._1();
                    List maybeLast = (List)tuple22._2();
                    Either either = (Either)package.flatMap$.MODULE$.catsSyntaxFlatMapOps(this.updateIdToOrder((IterableOnce<KeyedEvent<OrderEvent.OrderActorEvent>>)first), (FlatMap)package.either$.MODULE$.catsStdInstancesForEither());
                    return (Either)FlatMapOps$.MODULE$.$greater$greater$extension((Object)either, () -> this.checkedNextEvents$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(maybeLast, first), (FlatMap)package.either$.MODULE$.catsStdInstancesForEither());
                });
            }
            throw new MatchError(option);
        });
    }

    private final Either checkedNextEvents$$anonfun$2(Order order$6) {
        return ((Either)IsEmpty$syntax$.MODULE$.ifNonEmpty(this.awokeEvent(order$6), IsEmpty$.MODULE$.inline$erasedIterableIsEmpty()).map((Function1 & Serializable)events -> package$.MODULE$.Right().apply((Object)events.map((Function1 & Serializable)_$4 -> {
            Serializable Event_this = _$4;
            return new KeyedEvent<Event>((Event)((Object)Event_this), order$6.id());
        }))).getOrElse(() -> this.checkedNextEvents$$anonfun$2$$anonfun$2(order$6))).flatMap((Function1 & Serializable)keyedEvents -> this.checkEvents((Seq<KeyedEvent<OrderEvent.OrderActorEvent>>)keyedEvents));
    }

    private final Either checkEvents$$anonfun$2$$anonfun$1(OrderId orderId$5) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.state.idToOrder());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId$5, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("OrderEventSource.scala"), Line$.MODULE$.apply(133));
    }

    private static final Seq checkEvents$$anonfun$3(Seq keyedEvents$1) {
        return keyedEvents$1;
    }

    private static final OrderEvent$OrderDetachable$ $anonfun$1() {
        return OrderEvent$OrderDetachable$.MODULE$;
    }

    private static final List fail$$anonfun$2() {
        OrderEvent$OrderStopped$ orderEvent$OrderStopped$ = OrderEvent$OrderStopped$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)orderEvent$OrderStopped$);
    }

    public static final boolean js7$data$execution$workflow$OrderEventSource$$anon$1$$_$_$$anonfun$4() {
        return false;
    }

    public static final /* synthetic */ boolean js7$data$execution$workflow$OrderEventSource$$anon$1$$_$_$$anonfun$5(ForkInstruction _$14) {
        return _$14.joinIfFailed();
    }

    private static final List awokeEvent$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final Vector maybeOrderDeleted$$anonfun$1() {
        return package$.MODULE$.Vector().empty();
    }

    private final boolean v$proxy1$1() {
        return this.state.isAgent();
    }

    private final Either markOrder$$anonfun$1(OrderMark mark$1, OrderId orderId$6) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1()), "isAgent"), FullName$.MODULE$.apply("js7.data.execution.workflow.OrderEventSource.markOrder"), ScalaSourceLocation$.MODULE$.apply("OrderEventSource.scala", 284));
        OrderMark orderMark = mark$1;
        if (orderMark instanceof OrderMark.Cancelling) {
            CancellationMode cancellationMode;
            OrderMark.Cancelling cancelling = (OrderMark.Cancelling)orderMark;
            OrderMark.Cancelling cancelling2 = OrderMark$Cancelling$.MODULE$.unapply(cancelling);
            CancellationMode mode = cancellationMode = cancelling2._1();
            return this.cancel(orderId$6, mode);
        }
        if (orderMark instanceof OrderMark.Suspending) {
            SuspensionMode suspensionMode;
            OrderMark.Suspending suspending = (OrderMark.Suspending)orderMark;
            OrderMark.Suspending suspending2 = OrderMark$Suspending$.MODULE$.unapply(suspending);
            SuspensionMode mode = suspensionMode = suspending2._1();
            return this.suspend(orderId$6, mode);
        }
        if (orderMark instanceof OrderMark.Resuming) {
            OrderMark.Resuming resuming = (OrderMark.Resuming)orderMark;
            OrderMark.Resuming resuming2 = OrderMark$Resuming$.MODULE$.unapply(resuming);
            Option<Position> option = resuming2._1();
            Seq<OrderEvent.OrderResumed.HistoryOperation> seq = resuming2._2();
            boolean bl = resuming2._3();
            boolean bl2 = resuming2._4();
            Option<Position> position = option;
            Seq<OrderEvent.OrderResumed.HistoryOperation> historicOutcomes = seq;
            boolean asSucceeded = bl;
            boolean restartKilledJob = bl2;
            return this.resume(orderId$6, position, historicOutcomes, asSucceeded, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)restartKilledJob)));
        }
        if (orderMark instanceof OrderMark.Go) {
            Position position;
            OrderMark.Go go = (OrderMark.Go)orderMark;
            OrderMark.Go go2 = OrderMark$Go$.MODULE$.unapply(go);
            Position position2 = position = go2._1();
            return this.go(orderId$6, position2);
        }
        throw new MatchError((Object)orderMark);
    }

    private static final OrderEvent.OrderCancellationMarked cancel$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(CancellationMode mode$4) {
        return OrderEvent$OrderCancellationMarked$.MODULE$.apply(mode$4);
    }

    private static final List cancel$$anonfun$1$$anonfun$1$$anonfun$1(Order order$23, CancellationMode mode$3) {
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenList$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!order$23.isState(ClassTag$.MODULE$.apply(Order.IsTerminated.class)) && !order$23.isState(ClassTag$.MODULE$.apply(Order$ProcessingKilled$.class)) && !order$23.mark().contains((Object)OrderMark$Cancelling$.MODULE$.apply(mode$3))), () -> OrderEventSource.cancel$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(mode$3));
    }

    private final Either cancel$$anonfun$1(OrderId orderId$7, CancellationMode mode$1) {
        return this.withOrder(orderId$7, (Function1 & Serializable)order -> {
            CancellationMode cancellationMode = mode$1;
            CancellationMode$FreshOnly$ cancellationMode$FreshOnly$ = CancellationMode$FreshOnly$.MODULE$;
            if (!(cancellationMode != null ? !cancellationMode.equals(cancellationMode$FreshOnly$) : cancellationMode$FreshOnly$ != null) && order.isStarted()) {
                return package$.MODULE$.Left().apply((Object)Problems$CancelStartedOrderProblem$.MODULE$.apply(orderId$7));
            }
            return package$.MODULE$.Right().apply(IsEmpty$syntax$.MODULE$.ifNonEmpty(this.tryCancel((Order<Order.State>)order, mode$1), IsEmpty$.MODULE$.inline$erasedIterableIsEmpty()).getOrElse(() -> OrderEventSource.cancel$$anonfun$1$$anonfun$1$$anonfun$1(order, mode$1)));
        });
    }

    private final List tryCancel$$anonfun$1(Order order$24) {
        Workflow workflow = (Workflow)this.state.idToWorkflow().apply(order$24.workflowId());
        OrderEvent$OrderCancelled$ orderEvent$OrderCancelled$ = OrderEvent$OrderCancelled$.MODULE$;
        Either either = Checked$.MODULE$.Ops(OrderEventSource$.MODULE$.leaveBlocks(workflow, order$24, (List<OrderEvent.OrderActorEvent>)package$.MODULE$.Nil().$colon$colon((Object)orderEvent$OrderCancelled$)));
        return (List)Checked$Ops$.MODULE$.orThrow$extension(either);
    }

    private static final List suspend$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(List marked$1) {
        return marked$1;
    }

    private final List suspend$$anonfun$1$$anonfun$1$$anonfun$1(Order order$25, SuspensionMode mode$7) {
        if (order$25.mark().contains((Object)OrderMark$Suspending$.MODULE$.apply(mode$7))) {
            return package$.MODULE$.Nil();
        }
        OrderEvent.OrderSuspensionMarked orderSuspensionMarked = OrderEvent$OrderSuspensionMarked$.MODULE$.apply(mode$7);
        List marked = package$.MODULE$.Nil().$colon$colon((Object)orderSuspensionMarked);
        if (order$25.isDetachable()) {
            return this.js7$data$execution$workflow$OrderEventSource$$atController(() -> OrderEventSource.suspend$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(marked));
        }
        return marked;
    }

    private final Either suspend$$anonfun$1(OrderId orderId$9, SuspensionMode mode$5) {
        return this.withOrder(orderId$9, (Function1 & Serializable)order -> {
            if (!order.isSuspendible()) {
                return package$.MODULE$.Left().apply((Object)package$CannotSuspendOrderProblem$.MODULE$);
            }
            return package$.MODULE$.Right().apply(order.isSuspended() && !order.isResuming() ? package$.MODULE$.Nil() : IsEmpty$syntax$.MODULE$.ifEmpty(this.trySuspendNow((Order<Order.State>)order, mode$5), IsEmpty$.MODULE$.inline$erasedIterableIsEmpty(), () -> this.suspend$$anonfun$1$$anonfun$1$$anonfun$1(order, mode$5)));
        });
    }

    private static final List trySuspendNow$$anonfun$2(List maybeReset$1) {
        OrderEvent$OrderSuspended$ orderEvent$OrderSuspended$ = OrderEvent$OrderSuspended$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)orderEvent$OrderSuspended$).$colon$colon$colon(maybeReset$1);
    }

    private final Either checkedWorkflow$lzyINIT1$1(LazyRef checkedWorkflow$lzy1$1, Order order$26) {
        Either either;
        LazyRef lazyRef = checkedWorkflow$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (checkedWorkflow$lzy1$1.initialized()) {
                object = checkedWorkflow$lzy1$1.value();
            } else {
                PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.state.idToWorkflow());
                object = checkedWorkflow$lzy1$1.initialize(ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order$26.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))));
            }
            either = (Either)object;
        }
        return either;
    }

    private final Either checkedWorkflow$1(LazyRef checkedWorkflow$lzy1$2, Order order$27) {
        return (Either)(checkedWorkflow$lzy1$2.initialized() ? checkedWorkflow$lzy1$2.value() : this.checkedWorkflow$lzyINIT1$1(checkedWorkflow$lzy1$2, order$27));
    }

    private static final Either $anonfun$7() {
        return Checked$.MODULE$.unit();
    }

    private static final package$UnreachableOrderPositionProblem$ $anonfun$8$$anonfun$1$$anonfun$1() {
        return package$UnreachableOrderPositionProblem$.MODULE$;
    }

    private static final Position $anonfun$9$$anonfun$2$$anonfun$1(Position pos$1) {
        return pos$1;
    }

    private final boolean $anonfun$11(Order order$31) {
        return order$31.lastOutcome() instanceof OrderOutcome.Killed && this.state.workflowJob(order$31.workflowPosition()).exists((Function1 & Serializable)_$21 -> _$21.isRestartable());
    }

    private static final Serializable $anonfun$12(Option position$6, Seq historyOperations$5, boolean asSucceeded$4, boolean restart$1) {
        return OrderEvent$OrderResumptionMarked$.MODULE$.apply((Option<Position>)position$6, (Seq<OrderEvent.OrderResumed.HistoryOperation>)historyOperations$5, asSucceeded$4, restart$1);
    }

    private final Either resume$$anonfun$1(OrderId orderId$10, Option position$2, Seq historyOperations$1, Option restartKilledJob$1, boolean asSucceeded$1) {
        return this.withOrder(orderId$10, (Function1 & Serializable)order -> {
            LazyRef lazyRef = new LazyRef();
            Either checkPosition = (Either)position$2.fold(OrderEventSource::$anonfun$7, (Function1 & Serializable)position -> this.checkedWorkflow$1(lazyRef, (Order)order).flatMap((Function1 & Serializable)workflow -> {
                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(workflow.isMoveable(order.position(), (Position)position));
                return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, OrderEventSource::$anonfun$8$$anonfun$1$$anonfun$1);
            }));
            Either checkHistoricPositions = this.checkedWorkflow$1(lazyRef, (Order)order).flatMap((Function1 & Serializable)workflow -> (Either)package.traverse$.MODULE$.toTraverseOps(historyOperations$1.flatMap((Function1 & Serializable)_$17 -> _$17.positions()), UnorderedFoldable$.MODULE$.catsTraverseForSeq()).traverse((Function1 & Serializable)pos -> {
                Either either = ScalaUtils$syntax$.MODULE$.RichEither(workflow.checkPosition((Position)pos));
                return ScalaUtils$syntax$RichEither$.MODULE$.rightAs$extension(either, () -> OrderEventSource.$anonfun$9$$anonfun$2$$anonfun$1(pos));
            }, (Applicative)package.either$.MODULE$.catsStdInstancesForEither()));
            return checkPosition.flatMap((Function1 & Serializable)_$18 -> checkHistoricPositions).flatMap((Function1 & Serializable)_$19 -> {
                Option<OrderMark> option;
                block13: {
                    boolean okay;
                    block12: {
                        Some some;
                        option = order.mark();
                        if (option instanceof Some) {
                            Some some2 = (Some)option;
                            OrderMark orderMark = (OrderMark)some2.value();
                            if (orderMark instanceof OrderMark.Cancelling) {
                                OrderMark.Cancelling cancelling = (OrderMark.Cancelling)orderMark;
                                return package$.MODULE$.Left().apply((Object)package$CannotResumeOrderProblem$.MODULE$);
                            }
                            if (orderMark instanceof OrderMark.Resuming) {
                                OrderMark.Resuming resuming = (OrderMark.Resuming)orderMark;
                                OrderMark.Resuming resuming2 = OrderMark$Resuming$.MODULE$.unapply(resuming);
                                Option<Position> option2 = resuming2._1();
                                Seq<OrderEvent.OrderResumed.HistoryOperation> seq = resuming2._2();
                                boolean bl = resuming2._3();
                                boolean bl2 = resuming2._4();
                                Option option3 = position$2;
                                Option<Position> option4 = option2;
                                if (!(option3 != null ? !option3.equals(option4) : option4 != null)) {
                                    Seq seq2 = historyOperations$1;
                                    Seq<OrderEvent.OrderResumed.HistoryOperation> seq3 = seq;
                                    if (!(seq2 != null ? !seq2.equals(seq3) : seq3 != null)) {
                                        boolean asSucceeded = bl;
                                        boolean restartKilledJob = bl2;
                                        return package$.MODULE$.Right().apply((Object)this.tryResume((Order<Order.State>)order, (Option<Position>)position$2, (Seq<OrderEvent.OrderResumed.HistoryOperation>)historyOperations$1, asSucceeded, restartKilledJob).toList());
                                    }
                                }
                                return package$.MODULE$.Left().apply((Object)package$CannotResumeOrderProblem$.MODULE$);
                            }
                            if (orderMark instanceof OrderMark.Go) {
                                OrderMark.Go go = (OrderMark.Go)orderMark;
                                OrderMark.Go go2 = OrderMark$Go$.MODULE$.unapply(go);
                                Position position = go2._1();
                                return package$.MODULE$.Left().apply((Object)package$CannotResumeOrderProblem$.MODULE$);
                            }
                            if (orderMark instanceof OrderMark.Suspending) {
                                OrderMark.Suspending suspending = (OrderMark.Suspending)orderMark;
                                OrderMark.Suspending suspending2 = OrderMark$Suspending$.MODULE$.unapply(suspending);
                                SuspensionMode suspensionMode = suspending2._1();
                                if (position$2.isDefined() || historyOperations$1.nonEmpty()) {
                                    return package$.MODULE$.Left().apply((Object)package$CannotResumeOrderProblem$.MODULE$);
                                }
                            }
                        }
                        if (None$.MODULE$.equals(option)) break block12;
                        if (!(option instanceof Some) || !((some = (Some)option).value() instanceof OrderMark.Suspending)) break block13;
                        OrderMark.Suspending suspending = (OrderMark.Suspending)some.value();
                        OrderMark.Suspending suspending3 = OrderMark$Suspending$.MODULE$.unapply(suspending);
                        SuspensionMode suspensionMode = suspending3._1();
                    }
                    boolean bl = okay = order.isSuspended() || order.mark().exists((Function1 & Serializable)_$20 -> _$20 instanceof OrderMark.Suspending) || order.isDetached() && (order.isState(ClassTag$.MODULE$.apply(Order$Failed$.class)) || order.isState(ClassTag$.MODULE$.apply(Order$Stopped$.class)) || order.isState(ClassTag$.MODULE$.apply(Order$StoppedWhileFresh$.class)));
                    if (!okay) {
                        return package$.MODULE$.Left().apply((Object)package$CannotResumeOrderProblem$.MODULE$);
                    }
                    boolean restart = BoxesRunTime.unboxToBoolean((Object)restartKilledJob$1.getOrElse(() -> this.$anonfun$11(order)));
                    Serializable serializable = (Serializable)this.tryResume((Order<Order.State>)order, (Option<Position>)position$2, (Seq<OrderEvent.OrderResumed.HistoryOperation>)historyOperations$1, asSucceeded$1, restart).getOrElse(() -> OrderEventSource.$anonfun$12(position$2, historyOperations$1, asSucceeded$1, restart));
                    return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil().$colon$colon((Object)serializable));
                }
                throw new MatchError(option);
            });
        });
    }

    private static final List withOrder$$anonfun$1$$anonfun$1$$anonfun$1(List events$1) {
        return events$1;
    }

    private static final OrderEvent.OrderResumed a$proxy1$1(Option position$7, Seq historyOperations$6, boolean asSucceeded$5, boolean restartKilledJob$4) {
        return OrderEvent$OrderResumed$.MODULE$.apply((Option<Position>)position$7, (Seq<OrderEvent.OrderResumed.HistoryOperation>)historyOperations$6, asSucceeded$5, restartKilledJob$4);
    }

    private static final OrderEvent.OrderResumed tryResume$$anonfun$1(Option position$8, Seq historyOperations$7, boolean asSucceeded$6, boolean restartKilledJob$5) {
        return OrderEventSource.a$proxy1$1(position$8, historyOperations$7, asSucceeded$6, restartKilledJob$5);
    }

    private final Either answerPrompt$$anonfun$1(OrderId orderId$11) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.idToOrder);
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId$11, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("OrderEventSource.scala"), Line$.MODULE$.apply(470)).flatMap((Function1 & Serializable)order -> order.checkedState(ClassTag$.MODULE$.apply(Order.Prompting.class)).map((Function1 & Serializable)x$1 -> {
            Order order = x$1;
            OrderEvent.OrderPromptAnswered Event_this = OrderEvent$OrderPromptAnswered$.MODULE$.apply();
            OrderEvent.OrderMoved Event_this2 = OrderEvent$OrderMoved$.MODULE$.apply(order.position().increment(), OrderEvent$OrderMoved$.MODULE$.$lessinit$greater$default$2());
            return (Seq)((SeqOps)new .colon.colon(new KeyedEvent<OrderEvent.OrderPromptAnswered>(Event_this, orderId$11), (List)new .colon.colon(new KeyedEvent<OrderEvent.OrderMoved>(Event_this2, orderId$11), (List)Nil$.MODULE$)));
        }));
    }

    private static final Position nextAgent$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Order order$37) {
        return order$37.position();
    }

    private final Either nextAgent$$anonfun$1(Order order$34) {
        return this.applyMoveInstructions((Order<Order.State>)order$34, this.applyMoveInstructions$default$2()).map((Function1 & Serializable)moves -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.state.idToWorkflow());
            return ScalaUtils$syntax$RichPartialFunction$.MODULE$.get$extension(partialFunction, order$34.workflowId()).flatMap((Function1 & Serializable)workflow -> workflow.agentPath((Position)moves.lastOption().fold(() -> OrderEventSource.nextAgent$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(order$34), (Function1 & Serializable)_$22 -> _$22.to())));
        });
    }

    private final String loop$1$$anonfun$2(Order order$38, Vector visited$1) {
        return order$38.id() + " is in a workflow loop: " + ((IterableOnceOps)((StrictOptimizedIterableOps)visited$1.reverse()).map((Function1 & Serializable)moved -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.state.idToWorkflow());
            String string = ScalaUtils$syntax$.MODULE$.RichString((String)ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order$38.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)_$25 -> _$25.labeledInstruction(moved.to())).fold((Function1 & Serializable)_$26 -> _$26.toString(), (Function1 & Serializable)_$27 -> _$27.toString()));
            return moved.toString() + " " + ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 50, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
        })).mkString(" --> ");
    }

    private final Either loop$1(Order order2, Vector visited) {
        if (this.state.isOrderAtBreakpoint(order2)) {
            return package$.MODULE$.Right().apply((Object)visited);
        }
        Either<Problem, Option<OrderEvent.OrderMoved>> either = this.nextMove(order2);
        if (either instanceof Left) {
            Left left = (Left)either;
            Problem problem = (Problem)left.value();
            return package$.MODULE$.Left().apply((Object)problem);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Option option = (Option)right.value();
            if (option instanceof Some) {
                Some some = (Some)option;
                OrderEvent.OrderMoved orderMoved = (OrderEvent.OrderMoved)some.value();
                if (visited.exists((Function1 & Serializable)_$24 -> {
                    Position position = _$24.to();
                    Position position2 = orderMoved.to();
                    return !(position != null ? !((Object)position).equals(position2) : position2 != null);
                })) {
                    return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.loop$1$$anonfun$2(order2, visited)), Problem$.MODULE$.apply$default$2()));
                }
                return order2.applyEvent(orderMoved).flatMap((Function1 & Serializable)order -> this.loop$1((Order)order, orderMoved.reason().isEmpty() && visited.lastOption().exists((Function1 & Serializable)_$28 -> _$28.reason().isEmpty()) ? visited.updated(visited.length() - 1, (Object)orderMoved) : (Vector)visited.$colon$plus((Object)orderMoved)));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Right().apply((Object)visited);
            }
        }
        throw new MatchError(either);
    }

    private static final OrderEvent.OrderMoved a$proxy2$1(Order order$41) {
        return OrderEvent$OrderMoved$.MODULE$.apply(order$41.position().increment(), (Option<OrderEvent.OrderMoved.Reason>)Some$.MODULE$.apply((Object)OrderEvent$OrderMoved$SkippedDueToWorkflowPathControl$.MODULE$));
    }

    private static final OrderEvent.OrderMoved ifSkippedDueToWorkflowPathControlThenMove$$anonfun$1(Order order$48) {
        return OrderEventSource.a$proxy2$1(order$48);
    }
}

