/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.effect.std.Dispatcher;
import java.io.Serializable;
import java.time.ZoneId;
import js7.base.time.AdmissionTimeScheme;
import js7.base.time.AdmissionTimeSchemeForJavaTime$;
import js7.base.time.AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$;
import js7.base.time.AlarmClock;
import js7.base.time.TimeInterval;
import js7.base.time.TimeInterval$Always$;
import js7.base.time.TimeInterval$Never$;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.data.execution.workflow.instructions.ExecuteExecutor$;
import js7.data.job.JobKey;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import sourcecode.Enclosing$;

public final class AdmissionTimeSwitch {
    private final AdmissionTimeScheme admissionTimeScheme;
    private final FiniteDuration findTimeIntervalLimit;
    private final ZoneId zone;
    private final Function1<Option<TimeInterval>, IO<BoxedUnit>> onSwitch;
    private final Dispatcher<IO> dispatcher;
    private final AlarmClock clock;
    private final String label;
    private volatile Option<Timestamp> _nextTime;
    private final Ref<IO, IO<BoxedUnit>> cancelSchedule;

    public AdmissionTimeSwitch(AdmissionTimeScheme admissionTimeScheme, FiniteDuration findTimeIntervalLimit, ZoneId zone, JobKey jobKey, Function1<Option<TimeInterval>, IO<BoxedUnit>> onSwitch, Dispatcher<IO> dispatcher, AlarmClock clock) {
        this.admissionTimeScheme = admissionTimeScheme;
        this.findTimeIntervalLimit = findTimeIntervalLimit;
        this.zone = zone;
        this.onSwitch = onSwitch;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.label = "AdmissionTimeSwitch(" + jobKey + ")";
        this._nextTime = None$.MODULE$;
        this.cancelSchedule = package$.MODULE$.Ref().unsafe((Object)IO$.MODULE$.unit(), (Sync)IO$.MODULE$.asyncForIO());
    }

    private final ZoneId given_ZoneId() {
        return this.zone;
    }

    public Option<Timestamp> nextTime() {
        return this._nextTime;
    }

    public IO<BoxedUnit> cancelDelay() {
        return IO$.MODULE$.defer(this::cancelDelay$$anonfun$1);
    }

    public IO<Option<TimeInterval>> updateAndCheck(IO<BoxedUnit> onAdmissionStart) {
        return this.clock.lockIO((Function1 & Serializable)now -> {
            Option<TimeInterval> option = this.findCurrentTimeInterval((Timestamp)now);
            if (None$.MODULE$.equals(option)) {
                return ((IO)this.cancelSchedule.getAndSet((Object)IO$.MODULE$.unit())).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).as((Object)None$.MODULE$);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                TimeInterval interval = (TimeInterval)some.value();
                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(interval.contains((Timestamp)now));
                return IO$.MODULE$.unlessA(this._nextTime.contains((Object)interval.start()), () -> this.updateAndCheck$$anonfun$1$$anonfun$1(interval, now, onAdmissionStart)).as(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> AdmissionTimeSwitch.updateAndCheck$$anonfun$1$$anonfun$2(interval)));
            }
            throw new MatchError(option);
        }, Enclosing$.MODULE$.apply("js7.data.execution.workflow.instructions.AdmissionTimeSwitch#updateAndCheck"));
    }

    public Option<TimeInterval> findCurrentTimeInterval(Timestamp now) {
        return AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$.MODULE$.findLongTimeInterval$extension(AdmissionTimeSchemeForJavaTime$.MODULE$.RichAdmissionTimeScheme(this.admissionTimeScheme), now, this.findTimeIntervalLimit, ExecuteExecutor$.MODULE$.noDateOffset(), this.given_ZoneId());
    }

    public String toString() {
        return this.label;
    }

    private final IO cancelDelay$$anonfun$1() {
        this._nextTime = None$.MODULE$;
        return ((IO)this.cancelSchedule.get()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final TimeInterval updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$1(TimeInterval interval$2) {
        return interval$2;
    }

    private final String updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.label;
    }

    private final IO updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(IO onAdmissionStart$4) {
        this._nextTime = None$.MODULE$;
        return onAdmissionStart$4;
    }

    private final IO updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$2(TimeInterval interval$3, IO onAdmissionStart$2) {
        this._nextTime = Some$.MODULE$.apply((Object)interval$3.start());
        return this.clock.scheduleIOAt(interval$3.start(), (Function0<String>)((Function0 & Serializable)this::updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1), (IO<BoxedUnit>)IO$.MODULE$.defer(() -> this.updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(onAdmissionStart$2)), this.dispatcher).flatMap((Function1 & Serializable)cancel -> ((IO)this.cancelSchedule.getAndSet(cancel)).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private final IO updateAndCheck$$anonfun$1$$anonfun$1(TimeInterval interval$1, Timestamp now$1, IO onAdmissionStart$1) {
        TimeInterval timeInterval = interval$1;
        TimeInterval$Never$ timeInterval$Never$ = TimeInterval$Never$.MODULE$;
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(timeInterval == null ? timeInterval$Never$ != null : !timeInterval.equals(timeInterval$Never$));
        return ((IO)this.onSwitch.apply(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> AdmissionTimeSwitch.updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$1(interval$1)))).$times$greater(IO$.MODULE$.whenA(now$1.$less(interval$1.start()), () -> this.updateAndCheck$$anonfun$1$$anonfun$1$$anonfun$2(interval$1, onAdmissionStart$1)));
    }

    private static final TimeInterval a$proxy1$1(TimeInterval interval$4) {
        TimeInterval timeInterval = interval$4;
        if (timeInterval instanceof TimeInterval.Standard) {
            TimeInterval.Standard standard;
            TimeInterval.Standard o = standard = (TimeInterval.Standard)timeInterval;
            return o;
        }
        if (timeInterval == TimeInterval$Always$.MODULE$) {
            TimeInterval$Always$ timeInterval$Always$;
            TimeInterval$Always$ o = timeInterval$Always$ = (TimeInterval$Always$)timeInterval;
            return o;
        }
        if (timeInterval == TimeInterval$Never$.MODULE$) {
            TimeInterval$Never$ timeInterval$Never$;
            TimeInterval$Never$ o = timeInterval$Never$ = (TimeInterval$Never$)timeInterval;
            throw new AssertionError((Object)("NonEmptyTimeInterval expected, but not: " + o));
        }
        throw new MatchError((Object)timeInterval);
    }

    private static final TimeInterval updateAndCheck$$anonfun$1$$anonfun$2(TimeInterval interval$5) {
        return AdmissionTimeSwitch.a$proxy1$1(interval$5);
    }
}

