/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import js7.base.problem.Problem;
import js7.base.time.AdmissionTimeSchemeForJavaTime$;
import js7.base.time.AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$;
import js7.base.time.JavaTimestamp;
import js7.base.time.JavaTimestamp$;
import js7.base.time.JavaTimestamp$specific$;
import js7.base.time.JavaTimestamp$specific$RichJavaTimestamp$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.TimeInterval;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichSeq$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$Do$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$Do$ChangeCycleState$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$Do$StartCycle$;
import js7.data.execution.workflow.instructions.ScheduleSimulator;
import js7.data.order.CycleState;
import js7.data.workflow.instructions.Schedule;
import js7.data.workflow.instructions.Schedule$Continuous$;
import js7.data.workflow.instructions.Schedule$Ticking$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqView;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import sourcecode.FileName$;
import sourcecode.Line$;

public final class ScheduleCalculator
implements ScheduleSimulator {
    private final Schedule schedule;
    private final ZoneId zone;
    private final FiniteDuration dateOffset;
    private final boolean onlyOnePeriod;

    public static ScheduleCalculator apply(Schedule schedule, ZoneId zoneId, FiniteDuration finiteDuration, boolean bl) {
        return ScheduleCalculator$.MODULE$.apply(schedule, zoneId, finiteDuration, bl);
    }

    public static Either<Problem, ScheduleCalculator> checked(Schedule schedule, ZoneId zoneId, FiniteDuration finiteDuration, boolean bl) {
        return ScheduleCalculator$.MODULE$.checked(schedule, zoneId, finiteDuration, bl);
    }

    public static boolean apply$default$4() {
        return ScheduleCalculator$.MODULE$.apply$default$4();
    }

    public static boolean checked$default$4() {
        return ScheduleCalculator$.MODULE$.checked$default$4();
    }

    public ScheduleCalculator(Schedule schedule, ZoneId zone, FiniteDuration dateOffset, boolean onlyOnePeriod) {
        this.schedule = schedule;
        this.zone = zone;
        this.dateOffset = dateOffset;
        this.onlyOnePeriod = onlyOnePeriod;
    }

    private final ZoneId given_ZoneId() {
        return this.zone;
    }

    public Option<CycleState> nextCycleState(CycleState cycleState, Timestamp now) {
        return this.nextCycle(now, cycleState).flatMap((Function1 & Serializable)x$1 -> {
            int n = BoxesRunTime.unboxToInt((Object)x$1._1());
            int n2 = BoxesRunTime.unboxToInt((Object)x$1._2());
            Timestamp timestamp = (Timestamp)x$1._3();
            boolean periodChanges = !cycleState.isInitial() && (n != cycleState.schemeIndex() || n2 != cycleState.periodIndex());
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(!this.onlyOnePeriod || !periodChanges);
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> ScheduleCalculator.nextCycleState$$anonfun$1$$anonfun$1(periodChanges, cycleState, n, n2, timestamp));
        });
    }

    public Either<Problem, Do> onNextCycleIsDue(CycleState cycleState, Timestamp now) {
        Seq seq = ScalaUtils$syntax$.MODULE$.RichSeq(this.schedule.schemes());
        return ScalaUtils$syntax$RichSeq$.MODULE$.checked$extension(seq, cycleState.schemeIndex(), FileName$.MODULE$.apply("ScheduleCalculator.scala"), Line$.MODULE$.apply(42)).map((Function1 & Serializable)scheme -> {
            FiniteDuration finiteDuration;
            Schedule.Repeat repeat = scheme.repeat();
            if (repeat instanceof Schedule.Ticking) {
                FiniteDuration finiteDuration2;
                Schedule.Ticking ticking = (Schedule.Ticking)repeat;
                Schedule.Ticking ticking2 = Schedule$Ticking$.MODULE$.unapply(ticking);
                FiniteDuration tickDuration = finiteDuration2 = ticking2._1();
                long skippedTicks = now.$minus(cycleState.next()).toMillis() / tickDuration.toMillis();
                finiteDuration = package.LongMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.LongMult(RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(skippedTicks), 0L)), tickDuration);
            } else {
                finiteDuration = ScalaTime$.MODULE$.ZeroDuration();
            }
            FiniteDuration skipped = finiteDuration;
            Timestamp next = cycleState.next().$plus(skipped);
            if (now.$less(next)) {
                return ScheduleCalculator$Do$.KeepWaiting;
            }
            if (AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$.MODULE$.isPermitted$extension(AdmissionTimeSchemeForJavaTime$.MODULE$.RichAdmissionTimeScheme(scheme.admissionTimeScheme()), now, this.dateOffset, this.given_ZoneId())) {
                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(skipped)));
                return ScheduleCalculator$Do$StartCycle$.MODULE$.apply(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> ScheduleCalculator.onNextCycleIsDue$$anonfun$1$$anonfun$1(skipped)));
            }
            Option<CycleState> option = this.nextCycleState(cycleState, now);
            if (None$.MODULE$.equals(option)) {
                return ScheduleCalculator$Do$.EndCycling;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                CycleState cs = (CycleState)some.value();
                return ScheduleCalculator$Do$ChangeCycleState$.MODULE$.apply(cs);
            }
            throw new MatchError(option);
        });
    }

    private Option<Tuple3<Object, Object, Timestamp>> nextCycle(Timestamp now, CycleState cycleState) {
        return ((IterableOnceOps)((IterableOps)this.schedule.schemes().view().zipWithIndex()).flatMap((Function1 & Serializable)x$12 -> {
            Schedule.Scheme scheme = (Schedule.Scheme)x$12._1();
            int n = BoxesRunTime.unboxToInt((Object)x$12._2());
            return (IterableOnce)AdmissionTimeSchemeForJavaTime$RichAdmissionTimeScheme$.MODULE$.findTimeIntervals$extension(AdmissionTimeSchemeForJavaTime$.MODULE$.RichAdmissionTimeScheme(scheme.admissionTimeScheme()), now, cycleState.end(), this.dateOffset, this.given_ZoneId()).flatMap((Function1 & Serializable)x$1 -> {
                Option option;
                int n = BoxesRunTime.unboxToInt((Object)x$1._1());
                TimeInterval timeInterval = (TimeInterval)x$1._2();
                Timestamp lastScheduledCycleStart = cycleState.next().max(timeInterval.start());
                Timestamp end = cycleState.end().min(timeInterval.end());
                boolean isFirst = n != cycleState.schemeIndex() || n != cycleState.periodIndex();
                Schedule.Repeat repeat = scheme.repeat();
                if (repeat instanceof Schedule.Periodic) {
                    Schedule.Periodic periodic;
                    Schedule.Periodic periodic2 = periodic = (Schedule.Periodic)repeat;
                    option = this.nextPeriod(periodic2, lastScheduledCycleStart, now, isFirst, end);
                } else if (repeat instanceof Schedule.Ticking) {
                    FiniteDuration finiteDuration;
                    Schedule.Ticking ticking = (Schedule.Ticking)repeat;
                    Schedule.Ticking ticking2 = Schedule$Ticking$.MODULE$.unapply(ticking);
                    FiniteDuration tickDuration = finiteDuration = ticking2._1();
                    long ticks = now.$minus(lastScheduledCycleStart).toMillis() / tickDuration.toMillis();
                    option = Some$.MODULE$.apply((Object)(ticks > 0L ? lastScheduledCycleStart.$plus(package.LongMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.LongMult(ticks), tickDuration)) : lastScheduledCycleStart.$plus(tickDuration.$times(Int$.MODULE$.int2long(ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!isFirst)))))));
                } else if (repeat instanceof Schedule.Continuous) {
                    Schedule.Continuous continuous = (Schedule.Continuous)repeat;
                    Schedule.Continuous continuous2 = Schedule$Continuous$.MODULE$.unapply(continuous);
                    FiniteDuration finiteDuration = continuous2._1();
                    Option<Object> option2 = continuous2._2();
                    FiniteDuration pause = finiteDuration;
                    Option<Object> limit = option2;
                    int index = isFirst ? 0 : cycleState.index();
                    option = ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(limit.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> index < _$1)), () -> ScheduleCalculator.nextCycle$$anonfun$1$$anonfun$1$$anonfun$2(now, timeInterval, pause, isFirst));
                } else {
                    throw new MatchError((Object)repeat);
                }
                return option.filter((Function1 & Serializable)_$2 -> _$2.$less(end)).map((Function1 & Serializable)next -> Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n), next));
            });
        })).minByOption((Function1 & Serializable)x$1 -> {
            int n = BoxesRunTime.unboxToInt((Object)x$1._1());
            int n2 = BoxesRunTime.unboxToInt((Object)x$1._2());
            Timestamp timestamp = (Timestamp)x$1._3();
            return timestamp;
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private Option<Timestamp> nextPeriod(Schedule.Periodic periodic, Timestamp last, Timestamp now, boolean isFirst, Timestamp end) {
        SeqView scheduleMillis = periodic.offsets().view().map((Function1 & Serializable)_$5 -> _$5.toMillis());
        long p = periodic.period().toMillis();
        long localMilli = JavaTimestamp$specific$RichJavaTimestamp$.MODULE$.toZonedDateTime$extension(JavaTimestamp$specific$.MODULE$.RichJavaTimestamp(last), this.given_ZoneId()).toLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli();
        long localPeriodStart = localMilli / p * p;
        long localMilliOfPeriod = localMilli % p;
        Vector nextTimestamps = package$.MODULE$.Iterator().from(0).flatMap((Function1 & Serializable)i -> scheduleMillis.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$6 -> _$6 + (long)i * p$1)).filter((Function1)(JFunction1.mcZJ.sp & Serializable)t -> {
            if (isFirst) {
                return t >= localMilliOfPeriod;
            }
            return t > localMilliOfPeriod;
        }).map((Function1 & Serializable)nextMilli -> this.$anonfun$4(localPeriodStart, BoxesRunTime.unboxToLong((Object)nextMilli))).takeWhile((Function1 & Serializable)_$7 -> _$7.$less(end)).toVector();
        return ((IterableOnceOps)nextTimestamps.view().filter((Function1 & Serializable)_$8 -> _$8.$less$eq(now))).maxOption(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).orElse(() -> ScheduleCalculator.nextPeriod$$anonfun$2(nextTimestamps));
    }

    private static final CycleState a$proxy1$1(boolean periodChanges$1, CycleState cycleState$3, int schemeIndex$1, int periodIndex$1, Timestamp next$1) {
        int n = periodChanges$1 ? 1 : cycleState$3.index() + 1;
        Timestamp timestamp = cycleState$3.copy$default$1();
        return cycleState$3.copy(timestamp, schemeIndex$1, periodIndex$1, n, next$1);
    }

    private static final CycleState nextCycleState$$anonfun$1$$anonfun$1(boolean periodChanges$2, CycleState cycleState$7, int schemeIndex$4, int periodIndex$3, Timestamp next$2) {
        return ScheduleCalculator.a$proxy1$1(periodChanges$2, cycleState$7, schemeIndex$4, periodIndex$3, next$2);
    }

    private static final FiniteDuration onNextCycleIsDue$$anonfun$1$$anonfun$1(FiniteDuration skipped$2) {
        return skipped$2;
    }

    private static final Timestamp nextCycle$$anonfun$1$$anonfun$1$$anonfun$2(Timestamp now$4, TimeInterval interval$1, FiniteDuration pause$1, boolean isFirst$1) {
        Timestamp next = now$4.max(interval$1.start()).$plus(pause$1.$times(Int$.MODULE$.int2long(ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(!isFirst$1)))));
        if (next.$less$eq(now$4)) {
            return Timestamp$.MODULE$.Epoch();
        }
        return next;
    }

    private final /* synthetic */ JavaTimestamp $anonfun$4(long localPeriodStart$1, long nextMilli) {
        long localEpochMilli = localPeriodStart$1 + nextMilli;
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(localEpochMilli / 1000L, (int)(localEpochMilli % 1000L), ZoneOffset.UTC);
        return JavaTimestamp$.MODULE$.ofInstant(localDateTime.atZone(this.zone).toInstant());
    }

    private static final Option nextPeriod$$anonfun$2(Vector nextTimestamps$1) {
        return nextTimestamps$1.minOption(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public static abstract class Do
    implements Product,
    Enum {
        public static Do fromOrdinal(int n) {
            return ScheduleCalculator$Do$.MODULE$.fromOrdinal(n);
        }
    }
}

