/*
 * Decompiled with CFR 0.152.
 */
package js7.journal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import js7.base.time.SystemWallClock;
import js7.base.time.WallClock;
import js7.base.time.WallClock$;
import js7.data.event.EventId$;
import js7.data.event.Stamped;
import js7.journal.EventIdGenerator$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.AbstractIterator;
import scala.runtime.BoxesRunTime;

public final class EventIdGenerator
extends AbstractIterator<Object> {
    private final WallClock clock;
    private final AtomicLong lastResult;
    private final Function0<Option<Object>> defaultTimestampMilli;

    public static EventIdGenerator withFixedClock(long l) {
        return EventIdGenerator$.MODULE$.withFixedClock(l);
    }

    public static long $lessinit$greater$default$2() {
        return EventIdGenerator$.MODULE$.$lessinit$greater$default$2();
    }

    public EventIdGenerator(WallClock clock, long after) {
        Function0 & Serializable intersect;
        this.clock = clock;
        this.lastResult = new AtomicLong(after);
        WallClock wallClock = clock;
        if (wallClock instanceof SystemWallClock) {
            SystemWallClock systemWallClock = (SystemWallClock)wallClock;
            intersect = (Function0 & Serializable)() -> None$.MODULE$;
        } else {
            intersect = (Function0 & Serializable)() -> Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)clock.epochMilli()));
        }
        this.defaultTimestampMilli = intersect;
    }

    public EventIdGenerator() {
        this(WallClock$.MODULE$, EventIdGenerator$.MODULE$.$lessinit$greater$default$2());
    }

    public long lastUsedEventId() {
        return this.lastResult.get();
    }

    public void updateLastEventId(long newEventId) {
        while (true) {
            long last = this.lastResult.get();
            if (newEventId < last) {
                return;
            }
            if (!this.lastResult.compareAndSet(last, newEventId)) continue;
            return;
        }
    }

    public boolean hasNext() {
        return true;
    }

    public long next() {
        long nowId;
        long nextId;
        long last;
        do {
            nowId = this.clock.epochMilli() * (long)EventId$.MODULE$.IdsPerMillisecond();
        } while (!this.lastResult.compareAndSet(last, nextId = (last = this.lastResult.get()) < nowId ? nowId : last + 1L));
        return nextId;
    }

    public <A> Stamped<A> stamp(A a, Option<Object> timestampMillis) {
        return this.stampWith(a, this.next(), (Option<Object>)timestampMillis.orElse(this.defaultTimestampMilli));
    }

    public <A> Option<Object> stamp$default$2() {
        return None$.MODULE$;
    }

    private <A> Stamped<A> stampWith(A a, long eventId, Option<Object> timestampMillis) {
        long ts = BoxesRunTime.unboxToLong((Object)timestampMillis.getOrElse(() -> EventIdGenerator.$anonfun$1(eventId)));
        return new Stamped<A>(eventId, ts, a);
    }

    public String toString() {
        return "EventIdGenerator(" + this.lastResult.get() + ")";
    }

    private static final long $anonfun$1(long eventId$1) {
        return EventId$.MODULE$.toEpochMilli(eventId$1);
    }
}

