/*
 * Decompiled with CFR 0.152.
 */
package js7.journal;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Resource;
import cats.effect.std.Semaphore;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.stream.IncreasingNumberSync;
import js7.base.time.Timestamp;
import js7.base.time.WallClock;
import js7.base.utils.Assertions$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.BinarySearch$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.CloseableIterator;
import js7.base.utils.CloseableIterator$;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.Tests$;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalId;
import js7.data.event.JournalId$;
import js7.data.event.JournalInfo;
import js7.data.event.JournalInfo$;
import js7.data.event.JournalPosition;
import js7.data.event.JournaledState;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.data.event.TimeCtx$;
import js7.data.event.TimestampedKeyedEvent$;
import js7.journal.EventIdGenerator;
import js7.journal.Journal;
import js7.journal.MemoryJournal$;
import js7.journal.MemoryJournal$EventQueue$;
import js7.journal.Persist;
import js7.journal.Persisted;
import js7.journal.Persisted$;
import js7.journal.log.JournalLogger;
import js7.journal.watch.EventWatch;
import js7.journal.watch.RealEventWatch;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import sourcecode.Enclosing$;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public final class MemoryJournal<S extends JournaledState<S>>
implements Journal<S>,
Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final int size;
    private final String waitingFor;
    private final EventIdGenerator eventIdGenerator;
    private final WallClock clock;
    private final Semaphore<IO> semaphore;
    private final JournaledState.Companion<S> S;
    private final JournalId journalId;
    private final AsyncLock aggregateLock;
    private final AsyncLock queueLock;
    public volatile EventQueue js7$journal$MemoryJournal$$queue;
    private volatile S _aggregate;
    private volatile boolean eventWatchStopped;
    private long _eventCount;
    private final JournalLogger journalLogger;
    private final IO<BoxedUnit> whenNoFailoverByOtherNode;
    private final RealEventWatch eventWatch;
    public final MemoryJournal$EventQueue$ EventQueue$lzy1;

    public static <S extends JournaledState<S>> Resource<IO, MemoryJournal<S>> resource(S s, int n, String string, Set<String> set, EventIdGenerator eventIdGenerator, JournaledState.Companion<S> companion) {
        return MemoryJournal$.MODULE$.resource(s, n, string, set, eventIdGenerator, companion);
    }

    public static <S extends JournaledState<S>> String resource$default$3() {
        return MemoryJournal$.MODULE$.resource$default$3();
    }

    public static <S extends JournaledState<S>> Set<String> resource$default$4() {
        return MemoryJournal$.MODULE$.resource$default$4();
    }

    public static <S extends JournaledState<S>> EventIdGenerator resource$default$5() {
        return MemoryJournal$.MODULE$.resource$default$5();
    }

    public MemoryJournal(S initial, int size, String waitingFor, Set<String> infoLogEvents, EventIdGenerator eventIdGenerator, WallClock clock, Semaphore<IO> semaphore, JournaledState.Companion<S> S) {
        this.size = size;
        this.waitingFor = waitingFor;
        this.eventIdGenerator = eventIdGenerator;
        this.clock = clock;
        this.semaphore = semaphore;
        this.S = S;
        this.EventQueue$lzy1 = new MemoryJournal$EventQueue$(this);
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this.journalId = JournalId$.MODULE$.random();
        this.aggregateLock = AsyncLock$.MODULE$.dontLog();
        this.queueLock = AsyncLock$.MODULE$.dontLog();
        this.js7$journal$MemoryJournal$$queue = this.EventQueue().apply(EventId$.MODULE$.BeforeFirst(), EventId$.MODULE$.BeforeFirst(), (Vector<Stamped<KeyedEvent<Event>>>)package$.MODULE$.Vector().empty());
        this._aggregate = initial;
        this.eventWatchStopped = false;
        this._eventCount = 0L;
        this.journalLogger = new JournalLogger("memory", infoLogEvents, true);
        this.whenNoFailoverByOtherNode = IO$.MODULE$.unit();
        this.eventWatch = new EventWatch(this){
            public static final long OFFSET$0;
            private IO started;
            private volatile Object js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
            private final boolean isActiveNode;
            private final /* synthetic */ MemoryJournal $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                EventWatch.$init$(this);
                RealEventWatch.$init$(this);
                this.isActiveNode = true;
                Statics.releaseFence();
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1"));
            }

            public IO started() {
                return this.started;
            }

            public void js7$journal$watch$EventWatch$_setter_$started_$eq(IO x$0) {
                this.started = x$0;
            }

            public IncreasingNumberSync js7$journal$watch$RealEventWatch$$committedEventIdSync() {
                Object object = this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
                if (object instanceof IncreasingNumberSync) {
                    return (IncreasingNumberSync)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (IncreasingNumberSync)this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzyINIT1();
            }

            private Object js7$journal$watch$RealEventWatch$$committedEventIdSync$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            IncreasingNumberSync increasingNumberSync = null;
                            try {
                                increasingNumberSync = RealEventWatch.js7$journal$watch$RealEventWatch$$committedEventIdSync$(this);
                                object2 = increasingNumberSync == null ? LazyVals.NullValue$.MODULE$ : increasingNumberSync;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$watch$RealEventWatch$$committedEventIdSync$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return increasingNumberSync;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public boolean isActiveNode() {
                return this.isActiveNode;
            }

            public Option eventsAfter(long after) {
                return this.$outer.js7$journal$MemoryJournal$$eventsAfter_(after).map(MemoryJournal::js7$journal$MemoryJournal$$anon$1$$_$eventsAfter$$anonfun$1);
            }

            public JournalInfo journalInfo() {
                EventQueue q = this.$outer.js7$journal$MemoryJournal$$queue;
                return JournalInfo$.MODULE$.apply(q.lastEventId(), q.tornEventId(), (Seq<JournalPosition>)package$.MODULE$.Nil());
            }

            public long tornEventId() {
                return this.$outer.js7$journal$MemoryJournal$$queue.tornEventId();
            }

            public String toString() {
                return "MemoryJournal.EventWatch";
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$journal$MemoryJournal$$anon$1$$_$eventsAfter$$anonfun$1(scala.collection.Iterator )}, serializedLambda);
            }
        };
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public int size() {
        return this.size;
    }

    public JournaledState.Companion<S> S() {
        return this.S;
    }

    @Override
    public JournalId journalId() {
        return this.journalId;
    }

    @Override
    public boolean isHalted() {
        return false;
    }

    public boolean isEmpty() {
        return this.js7$journal$MemoryJournal$$queue.events().isEmpty();
    }

    @Override
    public IO<BoxedUnit> whenNoFailoverByOtherNode() {
        return this.whenNoFailoverByOtherNode;
    }

    @Override
    public RealEventWatch eventWatch() {
        return this.eventWatch;
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService(this.untilStopRequested());
    }

    @Override
    public IO<S> aggregate() {
        return IO$.MODULE$.apply(this::aggregate$$anonfun$1);
    }

    @Override
    public S unsafeAggregate() {
        return this._aggregate;
    }

    @Override
    public S unsafeUncommittedAggregate() {
        return this._aggregate;
    }

    @Override
    public <E extends Event> IO<Either<Problem, Persisted<S, E>>> persist_(Persist<S, E> persist) {
        return this.aggregateLock.lock(IO$.MODULE$.defer(() -> this.persist_$$anonfun$1(persist)), Enclosing$.MODULE$.apply("js7.journal.MemoryJournal#persist_"), ScalaSourceLocation$.MODULE$.apply("MemoryJournal.scala", 107));
    }

    private <E extends Event> IO<BoxedUnit> enqueue(Seq<Stamped<KeyedEvent<E>>> stampedEvents, S aggregate) {
        return IO$.MODULE$.whenA(stampedEvents.nonEmpty(), () -> this.enqueue$$anonfun$1(stampedEvents, aggregate));
    }

    private void log(long eventNumber, Seq<Stamped<KeyedEvent<Event>>> stampedEvents, Deadline since) {
        ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(ClusterState$Empty$.MODULE$.getClass());
        this.journalLogger.logCommitted(stampedEvents, eventNumber, since, RichJavaClass_this.cachedSimpleScalaName(), this.journalLogger.logCommitted$default$5(), this.journalLogger.logCommitted$default$6());
    }

    public IO<Either<Problem, BoxedUnit>> releaseEvents(long untilEventId) {
        return this.queueLock.lock(IO$.MODULE$.defer(() -> this.releaseEvents$$anonfun$1(untilEventId)), Enclosing$.MODULE$.apply("js7.journal.MemoryJournal#releaseEvents"), ScalaSourceLocation$.MODULE$.apply("MemoryJournal.scala", 158));
    }

    public Option<Iterator<Stamped<KeyedEvent<Event>>>> js7$journal$MemoryJournal$$eventsAfter_(long after) {
        Tuple2<Object, Object> tuple2;
        Tuple2<Object, Object> $4$;
        EventQueue q = this.js7$journal$MemoryJournal$$queue;
        if (after < q.tornEventId()) {
            return None$.MODULE$;
        }
        Tuple2<Object, Object> tuple22 = $4$ = (tuple2 = q.search(after));
        int index = tuple22._1$mcI$sp();
        boolean found = tuple22._2$mcZ$sp();
        if (!found && after != q.tornEventId()) {
            return None$.MODULE$;
        }
        if (this.eventWatchStopped) {
            return Some$.MODULE$.apply((Object)package$.MODULE$.Iterator().empty());
        }
        return Some$.MODULE$.apply((Object)q.events().drop(index + ScalaUtils$syntax$RichBoolean$.MODULE$.toInt$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(found))).iterator());
    }

    public void suppressLogging(boolean suppress) {
        this.journalLogger.suppress(suppress);
    }

    public void stopEventWatch() {
        this.eventWatchStopped = true;
    }

    public int queueLength() {
        return this.js7$journal$MemoryJournal$$queue.events().size();
    }

    public IO<Object> semaphoreCount() {
        return ((IO)this.semaphore.count()).flatTap((Function1 & Serializable)n -> this.semaphoreCount$$anonfun$1(BoxesRunTime.unboxToLong((Object)n)));
    }

    private final MemoryJournal$EventQueue$ EventQueue() {
        return this.EventQueue$lzy1;
    }

    public static final /* synthetic */ CloseableIterator js7$journal$MemoryJournal$$anon$1$$_$eventsAfter$$anonfun$1(Iterator baseIterator) {
        return CloseableIterator$.MODULE$.fromIterator(baseIterator);
    }

    private final JournaledState aggregate$$anonfun$1() {
        return this._aggregate;
    }

    private final Timestamp persist_$$anonfun$1$$anonfun$1() {
        return this.clock.now();
    }

    private final String persist_$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1() {
        return this.waitingFor;
    }

    private final IO persist_$$anonfun$1(Persist persist$1) {
        S aggregate = this._aggregate;
        return (IO)package.traverse$.MODULE$.toTraverseOps(Predef$.MODULE$.locally((Object)persist$1.eventCalc().calculate(aggregate, TimeCtx$.MODULE$.apply((Function0<Timestamp>)((Function0 & Serializable)this::persist_$$anonfun$1$$anonfun$1))).flatMap((Function1 & Serializable)coll -> aggregate.applyKeyedEvents(coll.keyedEvents()).map((Function1 & Serializable)updated -> {
            Vector stampedEvents = (Vector)coll.timestampedKeyedEvents().map((Function1 & Serializable)o -> this.eventIdGenerator.stamp(TimestampedKeyedEvent$.MODULE$.keyedEvent(o), TimestampedKeyedEvent$.MODULE$.maybeMillisSinceEpoch(o)));
            int acq = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(stampedEvents.length()), this.size());
            IO iO = (IO)this.semaphore.acquireN(Int$.MODULE$.int2long(acq));
            return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)this::persist_$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)).$times$greater(this.enqueue((Seq)stampedEvents, (S)updated)).as(Persisted$.MODULE$.apply(aggregate, stampedEvents, updated));
        }))), UnorderedFoldable$.MODULE$.catsTraverseForEither()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.asyncForIO());
    }

    private final void enqueue$$anonfun$1$$anonfun$1(Seq stampedEvents$2, JournaledState aggregate$4, Deadline since$1) {
        EventQueue q = this.js7$journal$MemoryJournal$$queue;
        long eventId = ((Stamped)stampedEvents$2.last()).eventId();
        EventQueue eventQueue = q;
        Vector vector = (Vector)q.events().$plus$plus((IterableOnce)stampedEvents$2);
        long l = eventQueue.copy$default$1();
        q = eventQueue.copy(l, eventId, (Vector<Stamped<KeyedEvent<Event>>>)vector);
        this._aggregate = aggregate$4.withEventId(eventId);
        this.log(this._eventCount + 1L, (Seq<Stamped<KeyedEvent<Event>>>)stampedEvents$2, since$1);
        this._eventCount += (long)stampedEvents$2.length();
        this.eventWatch().onEventsCommitted(eventId);
        this.js7$journal$MemoryJournal$$queue = q;
    }

    private final IO enqueue$$anonfun$1(Seq stampedEvents$1, JournaledState aggregate$3) {
        Deadline since = Deadline$.MODULE$.now();
        return this.queueLock.lock(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.enqueue$$anonfun$1$$anonfun$1(stampedEvents$1, aggregate$3, since);
            return BoxedUnit.UNIT;
        }), Enclosing$.MODULE$.apply("js7.journal.MemoryJournal#enqueue"), ScalaSourceLocation$.MODULE$.apply("MemoryJournal.scala", 123));
    }

    private static final boolean v$proxy1$1(long available$1) {
        return available$1 >= 0L;
    }

    private static final boolean releaseEvents$$anonfun$1$$anonfun$2() {
        return Tests$.MODULE$.isTest() && false;
    }

    private final void releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(long cnt$1) {
        if (cnt$1 > (long)this.size()) {
            String msg = "MemoryJournal: Semaphore is greater than queue size: " + cnt$1 + " > " + this.size() + " ";
            Logger LoggerImpl_this = MemoryJournal$.js7$journal$MemoryJournal$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error(msg);
            }
            throw new IllegalStateException(msg);
        }
    }

    private final /* synthetic */ IO releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1(long cnt) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(cnt);
            return BoxedUnit.UNIT;
        });
    }

    private final IO releaseEvents$$anonfun$1(long untilEventId$1) {
        Tuple2<Object, Object> tuple2;
        Tuple2<Object, Object> $2$;
        EventQueue q = this.js7$journal$MemoryJournal$$queue;
        if (untilEventId$1 == q.tornEventId()) {
            return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
        }
        Tuple2<Object, Object> tuple22 = $2$ = (tuple2 = this.js7$journal$MemoryJournal$$queue.search(untilEventId$1));
        int index = tuple22._1$mcI$sp();
        boolean found = tuple22._2$mcZ$sp();
        if (!found) {
            return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("Unknown EventId: " + EventId$.MODULE$.toString(untilEventId$1)));
        }
        int n = index + 1;
        Vector vector = q.events().drop(n);
        long l = q.copy$default$2();
        this.js7$journal$MemoryJournal$$queue = q.copy(untilEventId$1, l, (Vector<Stamped<KeyedEvent<Event>>>)vector);
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichAny(((IO)this.semaphore.releaseN(Int$.MODULE$.int2long(n))).$times$greater(((IO)this.semaphore.available()).map((Function1)(JFunction1.mcVJ.sp & Serializable)available -> Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)MemoryJournal.v$proxy1$1(available)), "available >= 0"), FullName$.MODULE$.apply("js7.journal.MemoryJournal.releaseEvents"), ScalaSourceLocation$.MODULE$.apply("MemoryJournal.scala", 151)))));
        return ((IO)ScalaUtils$syntax$RichAny$.MODULE$.pipeIf$extension(iO, (Function0<Object>)((Function0 & Serializable)MemoryJournal::releaseEvents$$anonfun$1$$anonfun$2), (Function1 & Serializable)_$1 -> _$1.$less$times(((IO)this.semaphore.count()).flatTap((Function1 & Serializable)cnt -> this.releaseEvents$$anonfun$1$$anonfun$3$$anonfun$1(BoxesRunTime.unboxToLong((Object)cnt)))))).as(Checked$.MODULE$.unit());
    }

    private final boolean v$proxy2$1(long n$2) {
        return n$2 <= (long)this.size();
    }

    private final void semaphoreCount$$anonfun$1$$anonfun$1(long n$1) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1(n$1)), "n <= size"), FullName$.MODULE$.apply("js7.journal.MemoryJournal.semaphoreCount"), ScalaSourceLocation$.MODULE$.apply("MemoryJournal.scala", 187));
    }

    private final /* synthetic */ IO semaphoreCount$$anonfun$1(long n) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.semaphoreCount$$anonfun$1$$anonfun$1(n);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long js7$journal$MemoryJournal$EventQueue$$_$search$$anonfun$1(Stamped _$2) {
        return _$2.eventId();
    }

    public class EventQueue
    implements Product,
    Serializable {
        private final long tornEventId;
        private final long lastEventId;
        private final Vector<Stamped<KeyedEvent<Event>>> events;
        private final /* synthetic */ MemoryJournal $outer;

        public EventQueue(MemoryJournal $outer, long tornEventId, long lastEventId, Vector<Stamped<KeyedEvent<Event>>> events) {
            this.tornEventId = tornEventId;
            this.lastEventId = lastEventId;
            this.events = events;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-1330044233);
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.tornEventId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastEventId()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.events()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            EventQueue eventQueue;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EventQueue)) return false;
            if (((EventQueue)object).js7$journal$MemoryJournal$EventQueue$$$outer() != this.$outer) return false;
            EventQueue eventQueue2 = eventQueue = (EventQueue)object;
            if (this.tornEventId() != eventQueue2.tornEventId()) return false;
            if (this.lastEventId() != eventQueue2.lastEventId()) return false;
            Vector<Stamped<KeyedEvent<Event>>> vector = this.events();
            Vector<Stamped<KeyedEvent<Event>>> vector2 = eventQueue2.events();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!eventQueue2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EventQueue;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "EventQueue";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "tornEventId";
                }
                case 1: {
                    return "lastEventId";
                }
                case 2: {
                    return "events";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long tornEventId() {
            return this.tornEventId;
        }

        public long lastEventId() {
            return this.lastEventId;
        }

        public Vector<Stamped<KeyedEvent<Event>>> events() {
            return this.events;
        }

        public Tuple2<Object, Object> search(long after) {
            return BinarySearch$.MODULE$.binarySearch(this.events(), MemoryJournal::js7$journal$MemoryJournal$EventQueue$$_$search$$anonfun$1, BoxesRunTime.boxToLong((long)after), Ordering.Long$.MODULE$);
        }

        public EventQueue copy(long tornEventId, long lastEventId, Vector<Stamped<KeyedEvent<Event>>> events) {
            return new EventQueue(this.$outer, tornEventId, lastEventId, events);
        }

        public long copy$default$1() {
            return this.tornEventId();
        }

        public long copy$default$2() {
            return this.lastEventId();
        }

        public Vector<Stamped<KeyedEvent<Event>>> copy$default$3() {
            return this.events();
        }

        public long _1() {
            return this.tornEventId();
        }

        public long _2() {
            return this.lastEventId();
        }

        public Vector<Stamped<KeyedEvent<Event>>> _3() {
            return this.events();
        }

        public final /* synthetic */ MemoryJournal js7$journal$MemoryJournal$EventQueue$$$outer() {
            return this.$outer;
        }
    }
}

