/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.configuration;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import js7.base.auth.UserId;
import js7.base.auth.UserId$;
import js7.base.configutils.Configs$;
import js7.base.configutils.Configs$RichConfig$;
import js7.base.convert.As;
import js7.base.convert.As$;
import js7.base.convert.As$StringAsBoolean$;
import js7.base.log.Logger$package$Logger$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.utils.Tests$;
import js7.journal.configuration.JournalConf;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;

public final class JournalConf$
implements Mirror.Product,
Serializable {
    private static final Logger logger;
    private static final String slowCheckStateKey;
    public static final JournalConf$ MODULE$;

    private JournalConf$() {
    }

    static {
        MODULE$ = new JournalConf$();
        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JournalConf$.class));
        slowCheckStateKey = "js7.journal.slow-check-state";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JournalConf$.class);
    }

    public JournalConf apply(boolean syncOnCommit, Option<FiniteDuration> simulateSync, FiniteDuration delay, int concurrentPersistLimit, FiniteDuration snapshotPeriod, long fileSizeLimit, long snapshotSizeEstimateEventThreshold, Seq<FiniteDuration> ackWarnDurations, Seq<FiniteDuration> persistWarnDurations, boolean deleteObsoleteFiles, Set<UserId> releaseEventsUserIds, boolean slowCheckState, Set<String> infoLogEvents) {
        return new JournalConf(syncOnCommit, simulateSync, delay, concurrentPersistLimit, snapshotPeriod, fileSizeLimit, snapshotSizeEstimateEventThreshold, ackWarnDurations, persistWarnDurations, deleteObsoleteFiles, releaseEventsUserIds, slowCheckState, infoLogEvents);
    }

    public JournalConf unapply(JournalConf x$1) {
        return x$1;
    }

    public Set<UserId> $lessinit$greater$default$11() {
        return Predef$.MODULE$.Set().empty();
    }

    public boolean $lessinit$greater$default$12() {
        return false;
    }

    public Set<String> $lessinit$greater$default$13() {
        return Predef$.MODULE$.Set().empty();
    }

    public JournalConf fromConfig(Config config) {
        Logger LoggerImpl_this;
        LazyRef lazyRef = new LazyRef();
        boolean syncOnCommit = config.getBoolean("js7.journal.sync");
        FiniteDuration delay = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.journal.delay")));
        boolean slowCheckState = BoxesRunTime.unboxToBoolean((Object)Configs$.MODULE$.ConvertibleConfig(config).optionAs(slowCheckStateKey, (As)As$StringAsBoolean$.MODULE$).getOrElse(JournalConf$::$anonfun$1));
        if (slowCheckState && (LoggerImpl_this = logger).underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("\ud83d\udc0c Slowing down due to {} = true", (Object)slowCheckStateKey);
        }
        return new JournalConf(syncOnCommit, (Option<FiniteDuration>)Configs$RichConfig$.MODULE$.durationOption$extension(Configs$.MODULE$.RichConfig(config), "js7.journal.simulate-sync").map((Function1 & Serializable)_$1 -> JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration((Duration)_$1))), (syncOnCommit ? this.syncDelay$1(lazyRef, config).max(delay) : delay).min(ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1))), BoxesRunTime.unboxToInt((Object)Configs$.MODULE$.ConvertibleConfig(config).as("js7.journal.concurrent-persist-limit", (As)As$.MODULE$.StringAsInt())), JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.journal.snapshot.period"))), BoxesRunTime.unboxToLong((Object)Configs$.MODULE$.ConvertibleConfig(config).as("js7.journal.snapshot.when-bigger-than", (As)As$.MODULE$.StringAsByteCountWithDecimalPrefix())), BoxesRunTime.unboxToLong((Object)Configs$.MODULE$.ConvertibleConfig(config).as("js7.journal.snapshot.estimate-event-threshold", (As)As$.MODULE$.StringAsByteCountWithDecimalPrefix())), (Seq<FiniteDuration>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(config.getDurationList("js7.journal.log.ack-warn-durations")).asScala().toSeq().map((Function1 & Serializable)_$2 -> JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration((Duration)_$2)))), (Seq<FiniteDuration>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(config.getDurationList("js7.journal.persist-warn-durations")).asScala().toSeq().map((Function1 & Serializable)_$3 -> JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration((Duration)_$3)))), config.getBoolean("js7.journal.remove-obsolete-files"), (Set<UserId>)Configs$RichConfig$.MODULE$.seqAs$extension(Configs$.MODULE$.RichConfig(config), "js7.journal.users-allowed-to-release-events", UserId$.MODULE$.GenericStringAsString()).toSet(), slowCheckState, (Set<String>)Configs$RichConfig$.MODULE$.seqAs$extension(Configs$.MODULE$.RichConfig(config), "js7.journal.log.info-events", As$.MODULE$.StringAsString()).toSet());
    }

    public JournalConf fromProduct(Product x$0) {
        boolean bl = BoxesRunTime.unboxToBoolean((Object)x$0.productElement(0));
        Option option = (Option)x$0.productElement(1);
        FiniteDuration finiteDuration = (FiniteDuration)x$0.productElement(2);
        int n = BoxesRunTime.unboxToInt((Object)x$0.productElement(3));
        FiniteDuration finiteDuration2 = (FiniteDuration)x$0.productElement(4);
        long l = BoxesRunTime.unboxToLong((Object)x$0.productElement(5));
        long l2 = BoxesRunTime.unboxToLong((Object)x$0.productElement(6));
        Seq seq = (Seq)x$0.productElement(7);
        Seq seq2 = (Seq)x$0.productElement(8);
        boolean bl2 = BoxesRunTime.unboxToBoolean((Object)x$0.productElement(9));
        Set set = (Set)x$0.productElement(10);
        boolean bl3 = BoxesRunTime.unboxToBoolean((Object)x$0.productElement(11));
        Set set2 = (Set)x$0.productElement(12);
        return new JournalConf(bl, (Option<FiniteDuration>)option, finiteDuration, n, finiteDuration2, l, l2, (Seq<FiniteDuration>)seq, (Seq<FiniteDuration>)seq2, bl2, (Set<UserId>)set, bl3, (Set<String>)set2);
    }

    private final FiniteDuration syncDelay$lzyINIT1$1(LazyRef syncDelay$lzy1$1, Config config$1) {
        FiniteDuration finiteDuration;
        LazyRef lazyRef = syncDelay$lzy1$1;
        synchronized (lazyRef) {
            finiteDuration = (FiniteDuration)(syncDelay$lzy1$1.initialized() ? syncDelay$lzy1$1.value() : syncDelay$lzy1$1.initialize((Object)JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config$1.getDuration("js7.journal.sync-delay")))));
        }
        return finiteDuration;
    }

    private final FiniteDuration syncDelay$1(LazyRef syncDelay$lzy1$2, Config config$2) {
        return (FiniteDuration)(syncDelay$lzy1$2.initialized() ? syncDelay$lzy1$2.value() : this.syncDelay$lzyINIT1$1(syncDelay$lzy1$2, config$2));
    }

    private static final boolean $anonfun$1() {
        return Tests$.MODULE$.isStrict();
    }
}

